/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.crosswire.common.util.NetUtil;

public abstract class OSType
implements Serializable {
    public static final OSType MAC;
    public static final OSType WIN32;
    public static final OSType DEFAULT;
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final OSType[] VALUES;
    private static final String WIN32_USER_DATA_AREA = "Application Data";
    private static final String MAC_USER_DATA_AREA = "Library/Application Support";
    private static OSType osType;
    private static final long serialVersionUID = -3196320305857293885L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OSType(String name) {
        this.name = name;
    }

    public abstract URI getUserArea();

    public abstract URI getUserAreaFolder(String var1, String var2);

    public static URI getUserHome() {
        return NetUtil.getURI(new File(System.getProperty("user.home")));
    }

    public int toInteger() {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!this.equals(VALUES[i])) continue;
            return i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public static OSType getOSType() {
        return osType;
    }

    public static OSType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            OSType o = VALUES[i];
            if (!name.startsWith(o.name)) continue;
            return o;
        }
        return DEFAULT;
    }

    public static OSType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !OSType.class.desiredAssertionStatus();
        MAC = new OSType("Mac"){
            private static final long serialVersionUID = -1575982665011980783L;

            public URI getUserArea() {
                return NetUtil.lengthenURI(1.getUserHome(), OSType.MAC_USER_DATA_AREA);
            }

            public URI getUserAreaFolder(String hiddenFolderName, String visibleFolderName) {
                return NetUtil.lengthenURI(this.getUserArea(), visibleFolderName);
            }
        };
        WIN32 = new OSType("Win"){
            private static final long serialVersionUID = 2448098399487879399L;

            public URI getUserArea() {
                return NetUtil.lengthenURI(2.getUserHome(), OSType.WIN32_USER_DATA_AREA);
            }

            public URI getUserAreaFolder(String hiddenFolderName, String visibleFolderName) {
                return NetUtil.lengthenURI(this.getUserArea(), visibleFolderName);
            }
        };
        DEFAULT = new OSType("*nix"){
            private static final long serialVersionUID = 8260119208395182688L;

            public URI getUserArea() {
                return 3.getUserHome();
            }

            public URI getUserAreaFolder(String hiddenFolderName, String visibleFolderName) {
                return NetUtil.lengthenURI(this.getUserArea(), hiddenFolderName);
            }
        };
        VALUES = new OSType[]{MAC, WIN32, DEFAULT};
        osType = OSType.fromString(System.getProperty("os.name"));
    }
}

