/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.Msg;
import org.crosswire.common.util.ResourceUtil;

public final class PluginUtil {
    public static final String EXTENSION_PLUGIN = ".plugin";
    private static final String DEFAULT = "default";
    private static final Logger log = Logger.getLogger(PluginUtil.class);

    private PluginUtil() {
    }

    public static Class[] getImplementors(Class clazz) {
        try {
            ArrayList<Class> matches = new ArrayList<Class>();
            Properties props = PluginUtil.getPlugin(clazz);
            Iterator<Object> it = props.values().iterator();
            while (it.hasNext()) {
                try {
                    String name = (String)it.next();
                    Class impl = ClassUtil.forName(name);
                    if (clazz.isAssignableFrom(impl)) {
                        matches.add(impl);
                        continue;
                    }
                    log.warn("Class " + impl.getName() + " does not implement " + clazz.getName() + ". Ignoring.");
                }
                catch (ClassNotFoundException ex) {
                    log.warn("Failed to add class to list: " + clazz.getName(), ex);
                }
            }
            log.debug("Found " + matches.size() + " implementors of " + clazz.getName());
            return matches.toArray(new Class[matches.size()]);
        }
        catch (IOException ex) {
            log.error("Failed to get any classes.", ex);
            return new Class[0];
        }
    }

    public static Map getImplementorsMap(Class clazz) {
        HashMap<String, Class> matches = new HashMap<String, Class>();
        try {
            Properties props = PluginUtil.getPlugin(clazz);
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                try {
                    String key = (String)it.next();
                    String value = props.getProperty(key);
                    Class impl = ClassUtil.forName(value);
                    if (clazz.isAssignableFrom(impl)) {
                        matches.put(key, impl);
                        continue;
                    }
                    log.warn("Class " + impl.getName() + " does not implement " + clazz.getName() + ". Ignoring.");
                }
                catch (ClassNotFoundException ex) {
                    log.warn("Failed to add class to list: " + clazz.getName(), ex);
                }
            }
            log.debug("Found " + matches.size() + " implementors of " + clazz.getName());
        }
        catch (IOException ex) {
            log.error("Failed to get any classes.", ex);
        }
        return matches;
    }

    public static Class getImplementor(Class clazz) throws IOException, ClassNotFoundException, ClassCastException {
        Properties props = PluginUtil.getPlugin(clazz);
        String name = props.getProperty(DEFAULT);
        Class impl = ClassUtil.forName(name);
        if (!clazz.isAssignableFrom(impl)) {
            throw new ClassCastException(Msg.NOT_ASSIGNABLE.toString(new Object[]{impl.getName(), clazz.getName()}));
        }
        return impl;
    }

    public static Object getImplementation(Class clazz) throws MalformedURLException, ClassCastException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return PluginUtil.getImplementor(clazz).newInstance();
    }

    public static Properties getPlugin(Class clazz) throws IOException {
        String subject = ClassUtil.getShortClassName(clazz);
        try {
            String lookup = subject + EXTENSION_PLUGIN;
            InputStream in = ResourceUtil.getResourceAsStream(clazz, lookup);
            Properties prop = new Properties();
            prop.load(in);
            return prop;
        }
        catch (MissingResourceException e) {
            return new Properties();
        }
    }
}

