/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.crosswire.common.util.Filter;
import org.crosswire.common.util.SortedListSet;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.Msg;

public class BookSet
extends SortedListSet {
    private static final long serialVersionUID = 3258688806185154867L;

    public BookSet() {
    }

    public BookSet(Collection books) {
        super(books);
    }

    public Set getGroups() {
        TreeSet results = new TreeSet();
        Iterator bookIter = this.iterator();
        while (bookIter.hasNext()) {
            Book book = (Book)bookIter.next();
            results.addAll(book.getProperties().keySet());
        }
        return results;
    }

    public Set getGroup(String key) {
        TreeSet<String> results = new TreeSet<String>();
        Iterator bookIter = this.iterator();
        while (bookIter.hasNext()) {
            Book book = (Book)bookIter.next();
            Object property = book.getProperties().get(key);
            String propertyValue = property == null ? Msg.BOOK_METADATA_SET_OTHER.toString() : property.toString();
            results.add(propertyValue);
        }
        return results;
    }

    public BookSet filter(String key, String value) {
        return (BookSet)this.filter(new GroupFilter(key, value));
    }

    private static final class GroupFilter
    implements Filter {
        private String key;
        private String value;

        public GroupFilter(String aKey, String aValue) {
            this.key = aKey;
            this.value = aValue;
        }

        public boolean test(Object obj) {
            Book book = (Book)obj;
            return book.getProperties().get(this.key) == this.value;
        }
    }
}

