/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.Msg;
import org.jdom.Element;

public class Strongs {
    public static final int HEBREW = 0;
    public static final int GREEK = 1;
    public static final int PARSING = 2;
    public static final int GREEK_MAX = 5624;
    public static final int HEBREW_MAX = 8674;
    private int type;
    private int number;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Strongs(String desc) throws BookException {
        desc = desc.trim();
        try {
            if (desc.charAt(0) == '<') {
                if (desc.charAt(desc.length() - 1) != '>') {
                    throw new BookException((MsgBase)Msg.STRONGS_ERROR_PARSE, new Object[]{desc});
                }
                if (desc.charAt(1) == '0') {
                    this.set(0, Integer.parseInt(desc.substring(2, desc.length() - 1)));
                } else {
                    this.set(1, Integer.parseInt(desc.substring(1, desc.length() - 1)));
                }
            } else if (desc.charAt(0) == '(') {
                if (desc.charAt(desc.length() - 1) != ')') {
                    throw new BookException((MsgBase)Msg.STRONGS_ERROR_PARSE, new Object[]{desc});
                }
                this.set(2, Integer.parseInt(desc.substring(1, desc.length() - 1)));
            }
            throw new BookException((MsgBase)Msg.STRONGS_ERROR_PARSE, new Object[]{desc});
        }
        catch (NumberFormatException ex) {
            throw new BookException((MsgBase)Msg.STRONGS_ERROR_NUMBER, new Object[]{desc});
        }
    }

    public Strongs(int type, int number) throws BookException {
        this.set(type, number);
    }

    public Strongs(Element w) throws BookException {
        String lemma = w.getAttributeValue("lemma");
        int colonpos = lemma.indexOf(":");
        if (colonpos != -1) {
            lemma = lemma.substring(colonpos + 1);
        }
        int newtype = -1;
        if (lemma.charAt(0) == 'H') {
            newtype = 0;
            lemma = lemma.substring(1);
        } else if (lemma.charAt(0) == 'G') {
            newtype = 1;
            lemma = lemma.substring(1);
        } else {
            newtype = 2;
        }
        int newnum = Integer.parseInt(lemma);
        this.set(newtype, newnum);
    }

    public String getOLBName() {
        switch (this.type) {
            case 1: {
                return "<" + this.number + '>';
            }
            case 0: {
                return "<0" + this.number + '>';
            }
            case 2: {
                return "(" + this.number + ')';
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(this.type);
        }
        return "!Error!";
    }

    public String getDescription() {
        switch (this.type) {
            case 1: {
                return Msg.STRONGS_GREEK.toString() + this.number;
            }
            case 0: {
                return Msg.STRONGS_HEBREW.toString() + this.number;
            }
            case 2: {
                return Msg.STRONGS_PARSING.toString() + this.number;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(this.type);
        }
        return "!Error!";
    }

    public String toString() {
        return this.getOLBName();
    }

    public int getType() {
        return this.type;
    }

    public int getNumber() {
        return 0;
    }

    public boolean isGreek() {
        return this.type == 1;
    }

    public boolean isHebrew() {
        return this.type == 0;
    }

    public boolean isParsing() {
        return this.type == 2;
    }

    private void set(int type, int number) throws BookException {
        this.type = type;
        this.number = number;
        switch (type) {
            case 0: {
                if (number <= 8674 && number >= 1) break;
                throw new BookException((MsgBase)Msg.STRONGS_ERROR_HEBREW, new Object[]{new Integer(8674), new Integer(number)});
            }
            case 1: {
                if (number <= 5624 && number >= 1) break;
                throw new BookException((MsgBase)Msg.STRONGS_ERROR_GREEK, new Object[]{new Integer(5624), new Integer(number)});
            }
            case 2: {
                if (number >= 1) break;
                throw new BookException((MsgBase)Msg.STRONGS_ERROR_PARSING, new Object[]{new Integer(number)});
            }
            default: {
                throw new BookException((MsgBase)Msg.STRONGS_ERROR_TYPE, new Object[]{new Integer(number)});
            }
        }
    }

    static {
        $assertionsDisabled = !Strongs.class.desiredAssertionStatus();
    }
}

