/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.crosswire.jsword.book.BookType;

public class ConfigEntryType
implements Serializable {
    public static final ConfigEntryType ABOUT = new ConfigEntryType("About"){
        private static final long serialVersionUID = 3258416110121334073L;

        public boolean allowsContinuation() {
            return true;
        }

        public boolean allowsRTF() {
            return true;
        }
    };
    public static final ConfigEntryType BLOCK_COUNT = new ConfigEntryType("BlockCount"){
        private Integer defaultValue = new Integer(200);
        private static final long serialVersionUID = 3978711675019212341L;

        public boolean isAllowed(String aValue) {
            try {
                Integer.parseInt(aValue);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public Object getDefault() {
            return this.defaultValue;
        }
    };
    public static final ConfigEntryType BLOCK_TYPE = new ConfigEntryType("BlockType"){
        private final Set choices = new HashSet<String>(Arrays.asList("BOOK", "CHAPTER", "VERSE"));
        private static final long serialVersionUID = 3763101864299935031L;

        public boolean isAllowed(String value) {
            return this.choices.contains(this.filter(value));
        }

        public String filter(String value) {
            return value.toUpperCase();
        }

        protected boolean hasChoices() {
            return true;
        }

        public Object getDefault() {
            return "CHAPTER";
        }
    };
    public static final ConfigEntryType CATEGORY = new ConfigEntryType("Category"){
        private final Set choices = new HashSet<String>(Arrays.asList("Daily Devotional", "Glossaries", "Cults / Unorthodox / Questionable Material", "Essays"));
        private static final long serialVersionUID = 3258412850174571569L;

        public boolean isAllowed(String value) {
            return this.choices.contains(value);
        }

        protected boolean hasChoices() {
            return true;
        }
    };
    public static final ConfigEntryType CIPHER_KEY = new ConfigEntryType("CipherKey");
    public static final ConfigEntryType COMPRESS_TYPE = new ConfigEntryType("CompressType"){
        private final Set choices = new HashSet<String>(Arrays.asList("LZSS", "ZIP"));
        private static final long serialVersionUID = 3256726182190920496L;

        public boolean isAllowed(String value) {
            return this.choices.contains(this.filter(value));
        }

        public String filter(String value) {
            return value.toUpperCase();
        }

        protected boolean hasChoices() {
            return true;
        }

        public Object getDefault() {
            return "LZSS";
        }
    };
    public static final ConfigEntryType COPYRIGHT = new ConfigEntryType("Copyright"){
        private static final long serialVersionUID = 3256441412957517110L;

        public boolean allowsContinuation() {
            return true;
        }
    };
    public static final ConfigEntryType COPYRIGHT_CONTACT_ADDRESS = new ConfigEntryType("CopyrightContactAddress"){
        private static final long serialVersionUID = 3256721784077365556L;

        public boolean allowsContinuation() {
            return true;
        }

        public boolean allowsRTF() {
            return true;
        }
    };
    public static final ConfigEntryType COPYRIGHT_CONTACT_EMAIL = new ConfigEntryType("CopyrightContactEmail");
    public static final ConfigEntryType COPYRIGHT_CONTACT_NAME = new ConfigEntryType("CopyrightContactName"){
        private static final long serialVersionUID = 3257001060181620787L;

        public boolean allowsContinuation() {
            return true;
        }

        public boolean allowsRTF() {
            return true;
        }
    };
    public static final ConfigEntryType COPYRIGHT_DATE = new ConfigEntryType("CopyrightDate"){
        private Pattern validDatePattern = Pattern.compile("\\d{4}(\\s*-\\s*\\d{4})?(\\s*,\\s*\\d{4}(\\s*-\\s*\\d{4})?)*");
        private static final long serialVersionUID = 3258126977217935671L;

        public boolean isAllowed(String value) {
            return this.validDatePattern.matcher(value).matches();
        }
    };
    public static final ConfigEntryType COPYRIGHT_HOLDER = new ConfigEntryType("CopyrightHolder");
    public static final ConfigEntryType COPYRIGHT_NOTES = new ConfigEntryType("CopyrightNotes"){
        private static final long serialVersionUID = 3906926794258199608L;

        public boolean allowsContinuation() {
            return true;
        }

        public boolean allowsRTF() {
            return true;
        }
    };
    public static final ConfigEntryType DATA_PATH = new ConfigEntryType("DataPath"){
        private static final long serialVersionUID = 3546926870244309296L;

        public boolean isAllowed(String value) {
            return true;
        }
    };
    public static final ConfigEntryType DESCRIPTION = new ConfigEntryType("Description");
    public static final ConfigEntryType DIRECTION = new ConfigEntryType("Direction"){
        private final Set choices = new HashSet<String>(Arrays.asList("LtoR", "RtoL", "bidi"));
        private static final long serialVersionUID = 3257283651765940536L;

        public boolean isAllowed(String value) {
            return this.choices.contains(value);
        }

        protected boolean hasChoices() {
            return true;
        }

        public Object getDefault() {
            return ConfigEntryType.DIRECTION_LTOR;
        }
    };
    public static final ConfigEntryType DISPLAY_LEVEL = new ConfigEntryType("DisplayLevel"){
        private static final long serialVersionUID = 3979274654953451830L;

        public boolean isAllowed(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final ConfigEntryType DISTRIBUTION_LICENSE = new ConfigEntryType("DistributionLicense"){
        private final Set choices = new HashSet<String>(Arrays.asList("Public Domain", "Copyrighted; Free non-commercial distribution", "Copyrighted; Permission to distribute granted to CrossWire", "Copyrighted"));
        private static final long serialVersionUID = 3257289110669505585L;

        public boolean isAllowed(String value) {
            return this.choices.contains(value);
        }

        protected boolean hasChoices() {
            return true;
        }

        public Object getDefault() {
            return "Public Domain";
        }
    };
    public static final ConfigEntryType DISTRIBUTION_NOTES = new ConfigEntryType("DistributionNotes"){
        private static final long serialVersionUID = 3257005453916518196L;

        public boolean allowsContinuation() {
            return true;
        }
    };
    public static final ConfigEntryType DISTRIBUTION_SOURCE = new ConfigEntryType("DistributionSource"){
        private static final long serialVersionUID = 3763093051127904307L;

        public boolean allowsContinuation() {
            return true;
        }
    };
    public static final ConfigEntryType ENCODING = new ConfigEntryType("Encoding"){
        private final Set choices = new HashSet<String>(Arrays.asList("Latin-1", "UTF-8"));
        private static final long serialVersionUID = 3761121643874891315L;

        public boolean isAllowed(String value) {
            return this.choices.contains(value);
        }

        protected boolean hasChoices() {
            return true;
        }

        public Object getDefault() {
            return "Latin-1";
        }
    };
    public static final ConfigEntryType GLOBAL_OPTION_FILTER = new ConfigEntryType("GlobalOptionFilter"){
        private final Set choices = new HashSet<String>(Arrays.asList("GBFStrongs", "GBFFootnotes", "GBFScripref", "GBFMorph", "GBFHeadings", "GBFRedLetterWords", "ThMLStrongs", "ThMLFootnotes", "ThMLScripref", "ThMLMorph", "ThMLHeadings", "ThMLVariants", "ThMLLemma", "UTF8Cantillation", "UTF8GreekAccents", "UTF8HebrewPoints", "OSISStrongs", "OSISFootnotes", "OSISScripref", "OSISMorph", "OSISHeadings", "OSISRedLetterWords"));
        private static final long serialVersionUID = 3258417209599931960L;

        public boolean isAllowed(String value) {
            return this.choices.contains(value);
        }

        protected boolean hasChoices() {
            return true;
        }

        public boolean mayRepeat() {
            return true;
        }
    };
    public static final ConfigEntryType GLOSSARY_FROM = new ConfigEntryType("GlossaryFrom");
    public static final ConfigEntryType GLOSSARY_TO = new ConfigEntryType("GlossaryTo");
    public static final ConfigEntryType HISTORY = new ConfigEntryType("History"){
        private static final long serialVersionUID = 3979272443195830835L;

        public boolean mayRepeat() {
            return true;
        }

        public boolean reportDetails() {
            return false;
        }
    };
    public static final ConfigEntryType INSTALL_SIZE = new ConfigEntryType("InstallSize"){
        private static final long serialVersionUID = 3256720680388408370L;

        public boolean isAllowed(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final ConfigEntryType FEATURE = new ConfigEntryType("Feature"){
        private final Set choices = new HashSet<String>(Arrays.asList("StrongsNumbers", "GreekDef", "HebrewDef", "GreekParse", "HebrewParse", "DailyDevotion", "Glossary"));
        private static final long serialVersionUID = 3833181424051172401L;

        public boolean isAllowed(String value) {
            return this.choices.contains(value);
        }

        protected boolean hasChoices() {
            return true;
        }

        public boolean mayRepeat() {
            return true;
        }
    };
    public static final ConfigEntryType FONT = new ConfigEntryType("Font");
    public static final ConfigEntryType LANG = new ConfigEntryType("Lang"){
        private static final long serialVersionUID = 3257008752317379897L;

        public Object getDefault() {
            return "en";
        }
    };
    public static final ConfigEntryType LCSH = new ConfigEntryType("LCSH");
    public static final ConfigEntryType MOD_DRV = new ConfigEntryType("ModDrv"){
        private final Set choices = new HashSet<String>(Arrays.asList("RawText", "zText", "RawCom", "zCom", "HREFCom", "RawFiles", "RawLD", "RawLD4", "zLD", "RawGenBook"));
        private static final long serialVersionUID = 3617569405685412913L;

        public boolean isAllowed(String value) {
            return this.choices.contains(value);
        }

        protected boolean hasChoices() {
            return true;
        }
    };
    public static final ConfigEntryType MINIMUM_VERSION = new ConfigEntryType("MinimumVersion"){
        private static final long serialVersionUID = 0x3838333833383038L;

        public Object getDefault() {
            return "1.5.1a";
        }
    };
    public static final ConfigEntryType OBSOLETES = new ConfigEntryType("Obsoletes"){
        private static final long serialVersionUID = 3258412850157400372L;

        public boolean mayRepeat() {
            return true;
        }

        public boolean reportDetails() {
            return false;
        }
    };
    public static final ConfigEntryType SOURCE_TYPE = new ConfigEntryType("SourceType"){
        private final String[] choiceArray = new String[]{"Plaintext", "GBF", "ThML", "OSIS"};
        private final Set choices = new HashSet<String>(Arrays.asList(this.choiceArray));
        private static final long serialVersionUID = 3834025853343774774L;

        public boolean isAllowed(String value) {
            return this.choices.contains(this.filter(value));
        }

        public String filter(String value) {
            for (int i = 0; i < this.choiceArray.length; ++i) {
                if (!this.choiceArray[i].equalsIgnoreCase(value)) continue;
                return this.choiceArray[i];
            }
            return value;
        }

        protected boolean hasChoices() {
            return true;
        }

        public Object getDefault() {
            return "Plaintext";
        }
    };
    public static final ConfigEntryType SWORD_VERSION_DATE = new ConfigEntryType("SwordVersionDate"){
        private Pattern validDatePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
        private static final long serialVersionUID = 3618697504682948150L;

        public boolean isAllowed(String value) {
            return this.validDatePattern.matcher(value).matches();
        }
    };
    public static final ConfigEntryType TEXT_SOURCE = new ConfigEntryType("TextSource"){
        private static final long serialVersionUID = 3258126968594772272L;

        public boolean allowsContinuation() {
            return true;
        }
    };
    public static final ConfigEntryType VERSION = new ConfigEntryType("Version"){
        private static final long serialVersionUID = 3256443616242055221L;

        public boolean isAllowed(String aValue) {
            try {
                Float.parseFloat(aValue);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public Object getDefault() {
            return "1.0";
        }
    };
    public static final ConfigEntryType OSIS_Q_TO_TICK = new ConfigEntryType("OSISqToTick"){
        private static final long serialVersionUID = 3258412850174373936L;

        public boolean isAllowed(String aValue) {
            return aValue != null && (aValue.equalsIgnoreCase("true") || aValue.equalsIgnoreCase("false"));
        }

        public Object getDefault() {
            return Boolean.TRUE;
        }
    };
    public static final ConfigEntryType INITIALS = new ConfigEntryType("Initials"){
        private static final long serialVersionUID = 3257009838994108467L;

        public boolean isSynthetic() {
            return true;
        }
    };
    public static final ConfigEntryType KEY = new ConfigEntryType("Key"){
        private static final long serialVersionUID = 3544671776240908087L;

        public boolean isSynthetic() {
            return true;
        }

        public Object getDefault() {
            return BookType.OTHER.toString();
        }
    };
    public static final ConfigEntryType LANGUAGE = new ConfigEntryType("Language"){
        private static final long serialVersionUID = 3834029147533226546L;

        public boolean isSynthetic() {
            return true;
        }
    };
    public static final ConfigEntryType LANGUAGE_FROM = new ConfigEntryType("LanguageFrom"){
        private static final long serialVersionUID = 3905243407495214134L;

        public boolean isSynthetic() {
            return true;
        }
    };
    public static final ConfigEntryType LANGUAGE_TO = new ConfigEntryType("LanguageTo"){
        private static final long serialVersionUID = 3257850961078007856L;

        public boolean isSynthetic() {
            return true;
        }
    };
    public static final ConfigEntryType SHORT_PROMO = new ConfigEntryType("ShortPromo");
    public static final ConfigEntryType SHORT_COPYRIGHT = new ConfigEntryType("ShortCopyright");
    public static final String DIRECTION_LTOR = "LtoR";
    public static final String DIRECTION_RTOL = "RtoL";
    public static final String DIRECTION_BIDI = "bidi";
    private String name;
    private static final long serialVersionUID = 3258125873411273014L;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final ConfigEntryType[] VALUES;

    protected ConfigEntryType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAllowed(String value) {
        return value != null;
    }

    public String filter(String value) {
        return value;
    }

    public boolean allowsRTF() {
        return false;
    }

    public boolean allowsContinuation() {
        return false;
    }

    public boolean mayRepeat() {
        return false;
    }

    public boolean reportDetails() {
        return true;
    }

    protected boolean hasChoices() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public Object getDefault() {
        return null;
    }

    public static ConfigEntryType fromString(String name) {
        if (name != null) {
            if (name.startsWith(HISTORY.toString())) {
                return HISTORY;
            }
            for (int i = 0; i < VALUES.length; ++i) {
                ConfigEntryType o = VALUES[i];
                if (!name.equals(o.name)) continue;
                return o;
            }
        }
        return null;
    }

    public static ConfigEntryType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        VALUES = new ConfigEntryType[]{ABOUT, BLOCK_COUNT, BLOCK_TYPE, CATEGORY, CIPHER_KEY, COMPRESS_TYPE, COPYRIGHT, COPYRIGHT_CONTACT_ADDRESS, COPYRIGHT_CONTACT_EMAIL, COPYRIGHT_CONTACT_NAME, COPYRIGHT_DATE, COPYRIGHT_HOLDER, COPYRIGHT_NOTES, DATA_PATH, DESCRIPTION, DIRECTION, DISPLAY_LEVEL, DISTRIBUTION_LICENSE, DISTRIBUTION_NOTES, DISTRIBUTION_SOURCE, ENCODING, GLOBAL_OPTION_FILTER, GLOSSARY_FROM, GLOSSARY_TO, HISTORY, INSTALL_SIZE, FEATURE, FONT, LANG, LCSH, MOD_DRV, MINIMUM_VERSION, OBSOLETES, SOURCE_TYPE, SWORD_VERSION_DATE, TEXT_SOURCE, VERSION, OSIS_Q_TO_TICK, INITIALS, KEY, LANGUAGE, LANGUAGE_FROM, LANGUAGE_TO, SHORT_PROMO, SHORT_COPYRIGHT};
    }
}

