/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.Serializable;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookType;
import org.crosswire.jsword.book.sword.Backend;
import org.crosswire.jsword.book.sword.CompressionType;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.RawBackend;
import org.crosswire.jsword.book.sword.RawLDBackend;
import org.crosswire.jsword.book.sword.SwordBook;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordDictionary;
import org.crosswire.jsword.book.sword.ZLDBackend;

public abstract class ModuleType
implements Serializable {
    public static final ModuleType RAW_TEXT = new ModuleType("RawText", BookType.BIBLE){
        private static final long serialVersionUID = 3544385920414529336L;

        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        protected Backend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return new RawBackend(sbmd, rootPath);
        }
    };
    public static final ModuleType Z_TEXT = new ModuleType("zText", BookType.BIBLE){
        private static final long serialVersionUID = 3257846571620906039L;

        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        protected Backend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return 2.getCompressedBackend(sbmd, rootPath);
        }

        protected boolean isBackendSupported(SwordBookMetaData sbmd) {
            return 2.isCompressedBackendSupported(sbmd);
        }
    };
    public static final ModuleType RAW_COM = new ModuleType("RawCom", BookType.COMMENTARY){
        private static final long serialVersionUID = 3258129141898294837L;

        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        protected Backend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return new RawBackend(sbmd, rootPath);
        }
    };
    public static final ModuleType Z_COM = new ModuleType("zCom", BookType.COMMENTARY){
        private static final long serialVersionUID = 3257569516166002487L;

        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        protected Backend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return 4.getCompressedBackend(sbmd, rootPath);
        }

        protected boolean isBackendSupported(SwordBookMetaData sbmd) {
            return 4.isCompressedBackendSupported(sbmd);
        }
    };
    public static final ModuleType HREF_COM = new ModuleType("HREFCom", BookType.COMMENTARY){
        private static final long serialVersionUID = 3256439209706338354L;

        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        protected Backend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return new RawBackend(sbmd, rootPath);
        }
    };
    public static final ModuleType RAW_FILES = new ModuleType("RawFiles", BookType.COMMENTARY){
        private static final long serialVersionUID = 3256446901875325236L;

        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        protected Backend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return new RawBackend(sbmd, rootPath);
        }
    };
    public static final ModuleType RAW_LD = new ModuleType("RawLD", BookType.DICTIONARY){
        private static final long serialVersionUID = 3257290240195442745L;

        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordDictionary(sbmd, backend);
        }

        protected Backend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return new RawLDBackend(sbmd, rootPath, 2);
        }
    };
    public static final ModuleType RAW_LD4 = new ModuleType("RawLD4", BookType.DICTIONARY){
        private static final long serialVersionUID = 3689067356945331762L;

        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordDictionary(sbmd, backend);
        }

        protected Backend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return new RawLDBackend(sbmd, rootPath, 4);
        }
    };
    public static final ModuleType Z_LD = new ModuleType("zLD", BookType.DICTIONARY){
        private static final long serialVersionUID = 3691037673259414067L;

        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordDictionary(sbmd, backend);
        }

        protected Backend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return new ZLDBackend(sbmd, rootPath);
        }

        protected boolean isBackendSupported(SwordBookMetaData sbmd) {
            return false;
        }
    };
    public static final ModuleType RAW_GEN_BOOK = new ModuleType("RawGenBook", null){
        private static final long serialVersionUID = 3257290218703892528L;

        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        protected Backend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return new RawBackend(sbmd, rootPath);
        }
    };
    private String name;
    private BookType type;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final ModuleType[] VALUES;

    public ModuleType(String name, BookType type) {
        this.name = name;
        this.type = type;
    }

    public static ModuleType getModuleType(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            ModuleType mod = VALUES[i];
            if (!mod.name.equalsIgnoreCase(name)) continue;
            return mod;
        }
        throw new IllegalArgumentException(Msg.UNDEFINED_MODULE.toString(name));
    }

    public BookType getBookType() {
        return this.type;
    }

    public boolean isSupported(SwordBookMetaData sbmd) {
        return this.type != null && this.isBackendSupported(sbmd);
    }

    protected boolean isBackendSupported(SwordBookMetaData sbmd) {
        return sbmd != null;
    }

    public Book createBook(SwordBookMetaData sbmd, File progdir) throws BookException {
        Backend backend = this.getBackend(sbmd, progdir);
        Book book = this.getBook(sbmd, backend);
        return book;
    }

    protected abstract Book getBook(SwordBookMetaData var1, Backend var2);

    protected abstract Backend getBackend(SwordBookMetaData var1, File var2) throws BookException;

    protected static Backend getCompressedBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
        String cStr = sbmd.getProperty(ConfigEntryType.COMPRESS_TYPE);
        if (cStr != null) {
            return CompressionType.fromString(cStr).getBackend(sbmd, rootPath);
        }
        throw new BookException((MsgBase)Msg.COMPRESSION_UNSUPPORTED, new Object[]{cStr});
    }

    protected static boolean isCompressedBackendSupported(SwordBookMetaData sbmd) {
        String cStr = sbmd.getProperty(ConfigEntryType.COMPRESS_TYPE);
        if (cStr != null) {
            return CompressionType.fromString(cStr).isSupported();
        }
        return false;
    }

    public static ModuleType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            ModuleType mod = VALUES[i];
            if (!mod.name.equalsIgnoreCase(name)) continue;
            return mod;
        }
        throw new ClassCastException(Msg.UNDEFINED_DATATYPE.toString(name));
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        VALUES = new ModuleType[]{RAW_TEXT, Z_TEXT, RAW_COM, Z_COM, RAW_COM, HREF_COM, RAW_FILES, RAW_LD, RAW_LD4, Z_LD, RAW_GEN_BOOK};
    }
}

