/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.Serializable;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.Msg;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;

public abstract class RestrictionType
implements Serializable {
    public static final RestrictionType NONE;
    public static final RestrictionType BOOK;
    public static final RestrictionType CHAPTER;
    private static RestrictionType defaultBlurRestriction;
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final RestrictionType[] VALUES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract boolean isSameScope(Verse var1, Verse var2);

    public abstract VerseRange blur(VerseRange var1, int var2, int var3);

    public abstract VerseRange blur(Verse var1, int var2, int var3);

    public abstract VerseRange toRange(Verse var1, int var2);

    public RestrictionType(String name) {
        this.name = name;
    }

    public int toInteger() {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!this.equals(VALUES[i])) continue;
            return i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public static RestrictionType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            RestrictionType o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static RestrictionType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static void setBlurRestriction(int value) {
        defaultBlurRestriction = RestrictionType.fromInteger(value);
    }

    public static int getBlurRestriction() {
        return defaultBlurRestriction.toInteger();
    }

    public static RestrictionType getDefaultBlurRestriction() {
        return defaultBlurRestriction;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !RestrictionType.class.desiredAssertionStatus();
        NONE = new RestrictionType("NONE"){
            private static final long serialVersionUID = 3905246714754643248L;

            public boolean isSameScope(Verse start, Verse end) {
                return true;
            }

            public VerseRange blur(VerseRange range, int blurDown, int blurUp) {
                Verse start = range.getStart().subtract(blurDown);
                Verse end = range.getEnd().add(blurUp);
                return new VerseRange(start, end);
            }

            public VerseRange blur(Verse verse, int blurDown, int blurUp) {
                Verse start = verse.subtract(blurDown);
                Verse end = verse.add(blurUp);
                return new VerseRange(start, end);
            }

            public VerseRange toRange(Verse verse, int count) {
                Verse end = verse;
                if (count > 1) {
                    end = verse.add(count - 1);
                }
                return new VerseRange(verse, end);
            }
        };
        BOOK = new RestrictionType("BOOK"){
            private static final long serialVersionUID = 3978142166633820472L;

            public boolean isSameScope(Verse start, Verse end) {
                return start.isSameBook(end);
            }

            public VerseRange blur(VerseRange range, int blurDown, int blurUp) {
                throw new IllegalArgumentException(Msg.RANGE_BLURBOOK.toString());
            }

            public VerseRange blur(Verse verse, int blurDown, int blurUp) {
                throw new IllegalArgumentException(Msg.RANGE_BLURBOOK.toString());
            }

            public VerseRange toRange(Verse verse, int count) {
                throw new IllegalArgumentException(Msg.RANGE_BLURBOOK.toString());
            }
        };
        defaultBlurRestriction = CHAPTER = new RestrictionType("CHAPTER"){
            private static final long serialVersionUID = 3257284751327768626L;
            static final /* synthetic */ boolean $assertionsDisabled;

            public boolean isSameScope(Verse start, Verse end) {
                return start.isSameChapter(end);
            }

            public VerseRange blur(VerseRange range, int blurDown, int blurUp) {
                try {
                    int startBook = range.getStart().getBook();
                    int startChapter = range.getStart().getChapter();
                    int startVerse = range.getStart().getVerse() - blurDown;
                    int endBook = range.getEnd().getBook();
                    int endChapter = range.getEnd().getChapter();
                    int endVerse = range.getEnd().getVerse() + blurUp;
                    startVerse = Math.max(startVerse, 1);
                    endVerse = Math.min(endVerse, BibleInfo.versesInChapter(endBook, endChapter));
                    Verse start = new Verse(startBook, startChapter, startVerse);
                    Verse end = new Verse(endBook, endChapter, endVerse);
                    return new VerseRange(start, end);
                }
                catch (NoSuchVerseException ex) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)ex);
                    }
                    return null;
                }
            }

            public VerseRange blur(Verse verse, int blurDown, int blurUp) {
                try {
                    int verseNumber = verse.getVerse();
                    int down = verseNumber - Math.max(verseNumber - blurDown, 1);
                    Verse start = verse;
                    if (down > 0) {
                        start = verse.subtract(down);
                    }
                    int bookNumber = verse.getBook();
                    int chapterNumber = verse.getChapter();
                    int up = Math.min(verseNumber + blurUp, BibleInfo.versesInChapter(bookNumber, chapterNumber)) - verseNumber;
                    Verse end = verse;
                    if (up > 0) {
                        end = verse.add(up);
                    }
                    return new VerseRange(start, end);
                }
                catch (NoSuchVerseException ex) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)ex);
                    }
                    return null;
                }
            }

            public VerseRange toRange(Verse verse, int count) {
                Verse end = verse.add(count - 1);
                return new VerseRange(verse, end);
            }

            static {
                $assertionsDisabled = !(class$org$crosswire$jsword$passage$RestrictionType == null ? (class$org$crosswire$jsword$passage$RestrictionType = RestrictionType.class$("org.crosswire.jsword.passage.RestrictionType")) : class$org$crosswire$jsword$passage$RestrictionType).desiredAssertionStatus();
            }
        };
        VALUES = new RestrictionType[]{NONE, BOOK, CHAPTER};
    }
}

