/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import org.crosswire.bibledesktop.book.BibleViewPane;
import org.crosswire.bibledesktop.book.DictionaryPane;
import org.crosswire.bibledesktop.desktop.DesktopActions;
import org.crosswire.bibledesktop.desktop.Msg;
import org.crosswire.bibledesktop.desktop.Splash;
import org.crosswire.bibledesktop.desktop.StatusBar;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.URLEvent;
import org.crosswire.bibledesktop.display.URLEventListener;
import org.crosswire.bibledesktop.util.ConfigurableSwingConverter;
import org.crosswire.common.config.ChoiceFactory;
import org.crosswire.common.config.Config;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.swing.CatchingThreadGroup;
import org.crosswire.common.swing.ExceptionPane;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.LookAndFeelUtil;
import org.crosswire.common.swing.desktop.LayoutType;
import org.crosswire.common.swing.desktop.TDIViewLayout;
import org.crosswire.common.swing.desktop.ToolBar;
import org.crosswire.common.swing.desktop.ViewGenerator;
import org.crosswire.common.swing.desktop.ViewManager;
import org.crosswire.common.swing.desktop.event.ViewEvent;
import org.crosswire.common.swing.desktop.event.ViewEventListener;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.LucidRuntimeException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.Defaults;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.util.ConverterFactory;
import org.crosswire.jsword.util.Project;
import org.jdom.Document;

public class Desktop
extends JFrame
implements URLEventListener,
ViewEventListener,
ViewGenerator {
    private boolean hasRefBooks;
    private static final String SPLASH_PROPS = "splash";
    private static final String BIBLE_PROTOCOL = "bible";
    private static final String DICTIONARY_PROTOCOL = "dict";
    private static final String GREEK_DEF_PROTOCOL = "gdef";
    private static final String HEBREW_DEF_PROTOCOL = "hdef";
    private static final String GREEK_MORPH_PROTOCOL = "gmorph";
    private static final String HEBREW_MORPH_PROTOCOL = "hmorph";
    private static final String COMMENTARY_PROTOCOL = "comment";
    private static final String EMPTY_STRING = "";
    private static final String CONFIG_KEY = "config";
    private static final String DESKTOP_KEY = "desktop";
    private static final String CONV_KEY = "converters";
    private static final String CSWING_KEY = "cswing-styles";
    private Config config;
    private static Dimension defaultSize = new Dimension(1280, 960);
    protected static final Logger log = Logger.getLogger((Class)Desktop.class);
    protected DesktopActions actions;
    private static final ImageIcon ICON_APP = GuiUtil.getIcon((String)"images/icon16.png");
    private ViewManager views;
    private JPanel corePanel;
    private ToolBar pnlTbar;
    private StatusBar barStatus;
    private DictionaryPane reference;
    private JSplitPane sptBooks;
    private static final long serialVersionUID = 3977014029116191800L;

    public static void main(String[] args) {
        try {
            CatchingThreadGroup group = new CatchingThreadGroup("BibleDesktopUIGroup");
            Thread t = new Thread((ThreadGroup)group, "BibleDesktopUIThread"){

                public void run() {
                    ExceptionPane.setHelpDeskListener((boolean)true);
                    LookAndFeelUtil.initialize();
                    Desktop desktop = new Desktop();
                    GuiUtil.setSize((Window)desktop, (Dimension)Desktop.getDefaultSize());
                    GuiUtil.centerWindow((Window)desktop);
                    desktop.show();
                    desktop.toFront();
                    desktop.setVisible(true);
                }
            };
            t.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ExceptionPane.showExceptionDialog(null, (Throwable)ex);
        }
    }

    public Desktop() {
        int reply;
        Project project = Project.instance();
        this.generateConfig();
        BooksListener cbl = new BooksListener(){

            public void bookAdded(BooksEvent ev) {
                Desktop.this.generateConfig();
            }

            public void bookRemoved(BooksEvent ev) {
                Desktop.this.generateConfig();
            }
        };
        Books.installed().addBooksListener(cbl);
        JOptionPane.setRootFrame(this);
        Reporter.grabAWTExecptions((boolean)true);
        URL predicturl = project.getWritablePropertiesURL(SPLASH_PROPS);
        Splash splash = new Splash();
        Job startJob = JobManager.createJob((String)Msg.STARTUP_TITLE.toString(), (URL)predicturl, (boolean)true);
        splash.pack();
        this.actions = new DesktopActions(this);
        startJob.setProgress(Msg.STARTUP_CONFIG.toString());
        startJob.setProgress(Msg.STARTUP_GENERATE.toString());
        this.createComponents();
        this.debug();
        this.init();
        this.refreshBooks();
        startJob.setProgress(Msg.STARTUP_GENERAL_CONFIG.toString());
        startJob.done();
        splash.close();
        List bibles = Books.installed().getBooks(BookFilters.getBibles());
        if (bibles.size() == 0 && (reply = JOptionPane.showConfirmDialog(this, (Object)Msg.NO_BIBLES_MESSAGE, Msg.NO_BIBLES_TITLE.toString(), 2, 3)) == 0) {
            this.actions.doBooks();
        }
    }

    private void debug() {
    }

    private void createComponents() {
        this.barStatus = new StatusBar();
        this.pnlTbar = new ToolBar((JFrame)this);
        this.reference = new DictionaryPane();
        this.sptBooks = new FixedSplitPane();
        this.views = new ViewManager((ViewGenerator)this);
        this.views.addViewEventListener((ViewEventListener)this);
    }

    private void init() {
        JMenu menuFile = new JMenu(this.actions.getAction("File"));
        menuFile.add(this.views.getContextAction("NewTab")).addMouseListener(this.barStatus);
        menuFile.add(this.actions.getAction("Open")).addMouseListener(this.barStatus);
        menuFile.addSeparator();
        menuFile.add(this.views.getContextAction("CloseView")).addMouseListener(this.barStatus);
        menuFile.add(this.views.getContextAction("ClearView")).addMouseListener(this.barStatus);
        menuFile.add(this.views.getContextAction("CloseOtherViews")).addMouseListener(this.barStatus);
        menuFile.add(this.views.getContextAction("CloseAllViews")).addMouseListener(this.barStatus);
        menuFile.addSeparator();
        menuFile.add(this.actions.getAction("Save")).addMouseListener(this.barStatus);
        menuFile.add(this.actions.getAction("SaveAs")).addMouseListener(this.barStatus);
        menuFile.add(this.actions.getAction("SaveAll")).addMouseListener(this.barStatus);
        menuFile.addSeparator();
        menuFile.add(this.actions.getAction("Exit")).addMouseListener(this.barStatus);
        menuFile.setToolTipText(null);
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.views.getContextAction("NewTab")).addMouseListener(this.barStatus);
        popup.add(this.views.getContextAction("CloseView")).addMouseListener(this.barStatus);
        popup.add(this.views.getContextAction("ClearView")).addMouseListener(this.barStatus);
        popup.add(this.views.getContextAction("CloseOtherViews")).addMouseListener(this.barStatus);
        popup.add(this.views.getContextAction("CloseAllViews")).addMouseListener(this.barStatus);
        popup.addSeparator();
        popup.add(this.actions.getAction("Open")).addMouseListener(this.barStatus);
        popup.add(this.actions.getAction("Save")).addMouseListener(this.barStatus);
        popup.add(this.actions.getAction("SaveAs")).addMouseListener(this.barStatus);
        popup.add(this.actions.getAction("SaveAll")).addMouseListener(this.barStatus);
        TDIViewLayout tdi = (TDIViewLayout)LayoutType.TDI.getLayout();
        tdi.addPopup(popup);
        JMenu menuEdit = new JMenu(this.actions.getAction("Edit"));
        menuEdit.add(this.actions.getAction("Copy")).addMouseListener(this.barStatus);
        menuEdit.setToolTipText(null);
        JMenu menuView = new JMenu(this.actions.getAction("View"));
        JCheckBoxMenuItem toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.STRONGS_NUMBERS.getName()));
        toggle.setSelected(XSLTProperty.STRONGS_NUMBERS.getDefault());
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.START_VERSE_ON_NEWLINE.getName()));
        toggle.setSelected(XSLTProperty.START_VERSE_ON_NEWLINE.getDefault());
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.VERSE_NUMBERS.getName()));
        toggle.setSelected(XSLTProperty.VERSE_NUMBERS.getDefault());
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.TINY_VERSE_NUMBERS.getName()));
        toggle.setSelected(XSLTProperty.TINY_VERSE_NUMBERS.getDefault());
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.NOTES.getName()));
        toggle.setSelected(XSLTProperty.NOTES.getDefault());
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.XREF.getName()));
        toggle.setSelected(XSLTProperty.XREF.getDefault());
        menuView.add(toggle).addMouseListener(this.barStatus);
        menuView.addSeparator();
        menuView.add(this.views.getTdiView()).addMouseListener(this.barStatus);
        menuView.add(this.views.getMdiView()).addMouseListener(this.barStatus);
        menuView.addSeparator();
        menuView.add(this.pnlTbar.getShowToggle()).addMouseListener(this.barStatus);
        menuView.add(this.pnlTbar.getTextToggle()).addMouseListener(this.barStatus);
        menuView.add(this.pnlTbar.getIconSizeToggle()).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction("ToolTipToggle"));
        toggle.setSelected(true);
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction("StatusToggle"));
        toggle.setSelected(true);
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction("SidebarToggle"));
        toggle.setSelected(true);
        menuView.add(toggle).addMouseListener(this.barStatus);
        menuView.addSeparator();
        menuView.add(this.actions.getAction("ViewSource")).addMouseListener(this.barStatus);
        menuView.setToolTipText(null);
        JMenu menuTools = new JMenu(this.actions.getAction("Tools"));
        menuTools.add(this.actions.getAction("Books")).addMouseListener(this.barStatus);
        menuTools.add(this.actions.getAction("Options")).addMouseListener(this.barStatus);
        menuTools.setToolTipText(null);
        JMenu menuHelp = new JMenu(this.actions.getAction("Help"));
        menuHelp.add(this.actions.getAction("Contents")).addMouseListener(this.barStatus);
        menuHelp.addSeparator();
        menuHelp.add(this.actions.getAction("About")).addMouseListener(this.barStatus);
        menuHelp.setToolTipText(null);
        JMenuBar barMenu = new JMenuBar();
        barMenu.add(menuFile);
        barMenu.add(menuEdit);
        barMenu.add(menuView);
        barMenu.add(menuTools);
        barMenu.add(menuTools);
        barMenu.add(menuHelp);
        this.pnlTbar.setRollover(true);
        this.pnlTbar.setFloatable(true);
        this.pnlTbar.add(this.views.getContextAction("NewTab")).addMouseListener(this.barStatus);
        this.pnlTbar.add(this.actions.getAction("Open")).addMouseListener(this.barStatus);
        this.pnlTbar.add(this.actions.getAction("Save")).addMouseListener(this.barStatus);
        this.pnlTbar.addSeparator();
        this.pnlTbar.add(this.actions.getAction("Copy")).addMouseListener(this.barStatus);
        this.pnlTbar.addSeparator();
        this.pnlTbar.add(this.actions.getAction("Contents")).addMouseListener(this.barStatus);
        this.pnlTbar.add(this.actions.getAction("About")).addMouseListener(this.barStatus);
        this.reference.addURLEventListener(this);
        this.sptBooks.setOrientation(1);
        this.sptBooks.setRightComponent(this.reference);
        this.sptBooks.setLeftComponent(this.views.getDesktop());
        this.sptBooks.setResizeWeight(0.8);
        this.sptBooks.setDividerSize(7);
        this.sptBooks.setOpaque(true);
        this.sptBooks.setBorder(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent ev) {
                Desktop.this.actions.getAction("Exit").actionPerformed(new ActionEvent(this, 0, Desktop.EMPTY_STRING));
            }
        });
        this.setDefaultCloseOperation(2);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.pnlTbar, "North");
        this.corePanel = new JPanel(new BorderLayout());
        this.corePanel.add((Component)this.barStatus, "South");
        this.corePanel.add((Component)this.sptBooks, "Center");
        contentPane.add((Component)this.corePanel, "Center");
        this.setJMenuBar(barMenu);
        this.setIconImage(ICON_APP.getImage());
        this.setEnabled(true);
        this.setTitle(Msg.getApplicationTitle());
    }

    public ViewManager getViews() {
        return this.views;
    }

    public Component createView() {
        BibleViewPane view = new BibleViewPane();
        BookDataDisplay display = view.getPassagePane().getBookDataDisplay();
        display.addURLEventListener(this);
        display.addURLEventListener(this.barStatus);
        return view;
    }

    public void viewRemoved(ViewEvent event) {
        BibleViewPane view = (BibleViewPane)event.getSource();
        BookDataDisplay display = view.getPassagePane().getBookDataDisplay();
        display.removeURLEventListener(this);
        display.removeURLEventListener(this.barStatus);
    }

    public void activateURL(URLEvent ev) {
        this.barStatus.activateURL(ev);
        String protocol = ev.getProtocol();
        String data = ev.getUrl();
        try {
            if (protocol.equals(BIBLE_PROTOCOL)) {
                Key key;
                Book book;
                BibleViewPane view;
                Iterator iter = this.views.iterator();
                BibleViewPane clearView = null;
                while (iter.hasNext()) {
                    view = (BibleViewPane)iter.next();
                    if (view.isClear()) {
                        clearView = view;
                        continue;
                    }
                    book = view.getSelectPane().getBook();
                    if (book == null) continue;
                    key = book.getKey(data);
                    String dataPassage = key.getName();
                    if (!view.getTitle().equals(dataPassage)) continue;
                    this.views.select((Component)view);
                    return;
                }
                if (clearView != null) {
                    Book book2 = clearView.getSelectPane().getBook();
                    if (book2 != null) {
                        Key key2 = book2.getKey(data);
                        clearView.setKey(key2);
                        this.views.select((Component)clearView);
                    }
                    return;
                }
                view = (BibleViewPane)this.views.addView();
                book = view.getSelectPane().getBook();
                if (book != null) {
                    key = book.getKey(data);
                    view.setKey(key);
                }
            } else if (protocol.equals(COMMENTARY_PROTOCOL)) {
                Book book = Defaults.getCommentary();
                if (book != null && Books.installed().getBook(book.getName()) != null) {
                    this.reference.selectDictionary(book);
                    Key key = this.reference.getBook().getKey(data);
                    this.reference.setKey(key);
                }
            } else if (protocol.equals(GREEK_DEF_PROTOCOL)) {
                this.jump(Defaults.getGreekDefinitions(), data);
            } else if (protocol.equals(HEBREW_DEF_PROTOCOL)) {
                this.jump(Defaults.getHebrewDefinitions(), data);
            } else if (protocol.equals(GREEK_MORPH_PROTOCOL)) {
                this.jump(Defaults.getGreekParse(), data);
            } else if (protocol.equals(HEBREW_MORPH_PROTOCOL)) {
                this.jump(Defaults.getHebrewParse(), data);
            } else if (protocol.equals(DICTIONARY_PROTOCOL)) {
                this.jump(Defaults.getDictionary(), data);
            } else {
                Reporter.informUser((Object)this, (Throwable)new MalformedURLException(Msg.UNKNOWN_PROTOCOL.toString(protocol)));
            }
        }
        catch (NoSuchKeyException ex) {
            Reporter.informUser((Object)this, (LucidException)ex);
        }
    }

    private void jump(Book book, String data) {
        if (book != null && Books.installed().getBook(book.getName()) != null) {
            this.reference.selectDictionary(book);
            this.reference.setWord(data);
        }
    }

    public void enterURL(URLEvent ev) {
    }

    public void leaveURL(URLEvent ev) {
    }

    public void showStatusBar(boolean show) {
        if (show) {
            this.corePanel.add((Component)this.barStatus, "South");
        } else {
            this.corePanel.remove(this.barStatus);
        }
        this.validate();
    }

    public void setCloseEnabled(boolean enabled) {
        this.views.getContextAction("ClearView").setEnabled(enabled);
        this.views.getContextAction("CloseOtherViews").setEnabled(enabled);
    }

    public final void generateConfig() {
        this.fillChoiceFactory();
        this.config = new Config(Msg.CONFIG_TITLE.toString());
        Document xmlconfig = null;
        try {
            xmlconfig = XMLUtil.getDocument((String)CONFIG_KEY);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ExceptionPane.showExceptionDialog(null, (Throwable)ex);
        }
        Locale defaultLocale = Locale.getDefault();
        ResourceBundle configResources = ResourceBundle.getBundle(CONFIG_KEY, defaultLocale, (ClassLoader)new CWClassLoader(Desktop.class));
        this.config.add(xmlconfig, configResources);
        try {
            this.config.setProperties(ResourceUtil.getProperties((String)DESKTOP_KEY));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ExceptionPane.showExceptionDialog(null, (Throwable)ex);
        }
        URL configUrl = Project.instance().getWritablePropertiesURL(DESKTOP_KEY);
        try {
            this.config.localToApplication();
            this.config.localToPermanent(configUrl);
        }
        catch (IOException ex) {
            throw new LucidRuntimeException((MsgBase)Msg.CONFIG_SAVE_FAILED, (Throwable)ex, new Object[]{configUrl});
        }
    }

    public static void setMaxHeight(int maxHeight) {
        Desktop.defaultSize.height = maxHeight;
    }

    public static int getMaxHeight() {
        return Desktop.defaultSize.height;
    }

    public static int getMaxWidth() {
        return Desktop.defaultSize.width;
    }

    public static void setMaxWidth(int maxWidth) {
        Desktop.defaultSize.width = maxWidth;
    }

    public static Dimension getDefaultSize() {
        return defaultSize;
    }

    public static void setDefaultSize(Dimension newDefaultSize) {
        defaultSize = newDefaultSize;
    }

    protected void fillChoiceFactory() {
        this.refreshBooks();
        Map converters = ConverterFactory.getKnownConverters();
        Set keys = converters.keySet();
        String[] names = keys.toArray(new String[keys.size()]);
        ChoiceFactory.getDataMap().put(CONV_KEY, names);
        ConfigurableSwingConverter cstyle = new ConfigurableSwingConverter();
        String[] cstyles = cstyle.getStyles();
        ChoiceFactory.getDataMap().put(CSWING_KEY, cstyles);
    }

    protected final void refreshBooks() {
        boolean newRefBooks;
        Defaults.refreshBooks();
        boolean hasDictionaries = Defaults.getDictionary() != null;
        boolean hasCommentaries = Defaults.getCommentary() != null;
        boolean bl = newRefBooks = hasDictionaries || hasCommentaries;
        if (newRefBooks != this.hasRefBooks) {
            if (this.reference != null) {
                if (!newRefBooks) {
                    this.sptBooks.setDividerLocation(8000);
                } else {
                    int norm = (int)((double)this.sptBooks.getMaximumDividerLocation() * 0.8);
                    this.sptBooks.setDividerLocation(norm);
                }
            }
            this.hasRefBooks = newRefBooks;
        }
    }

    public Config getConfig() {
        return this.config;
    }
}

