/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.TreeNode;
import org.crosswire.bibledesktop.passage.BookTreeNode;
import org.crosswire.bibledesktop.passage.Msg;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.Verse;

public class BibleTreeNode
implements TreeNode {
    protected Passage ref;
    protected TreeNode[] kids = new BookTreeNode[BibleInfo.booksInBible()];
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setPassage(Passage ref, boolean filter) {
        block4: {
            this.ref = ref;
            try {
                if (filter) {
                    this.kids = new BookTreeNode[ref.booksInPassage()];
                    int currentBook = 0;
                    int bookCount = 0;
                    Iterator it = ref.iterator();
                    while (it.hasNext()) {
                        Verse verse = (Verse)it.next();
                        if (currentBook == verse.getBook()) continue;
                        currentBook = verse.getBook();
                        BookTreeNode node = new BookTreeNode(this, currentBook);
                        node.setPassage(ref, true);
                        this.kids[bookCount++] = node;
                    }
                }
            }
            catch (NoSuchVerseException ex) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)ex);
            }
        }
    }

    public TreeNode getChildAt(int i) {
        try {
            if (this.kids[i] != null) {
                return this.kids[i];
            }
            BookTreeNode node = new BookTreeNode(this, i + 1);
            node.setPassage(this.ref, false);
            this.kids[i] = node;
            return this.kids[i];
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return null;
        }
    }

    public int getChildCount() {
        return this.kids.length;
    }

    public TreeNode getParent() {
        return this;
    }

    public int getIndex(TreeNode node) {
        if (!(node instanceof BookTreeNode)) {
            return -1;
        }
        BookTreeNode book = (BookTreeNode)node;
        return book.getBook();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return new NodeEnumeration();
    }

    public String toString() {
        if (this.ref == null) {
            return Msg.WHOLE_BIBLE.toString();
        }
        return Msg.PART_BIBLE.toString(this.ref.getOverview());
    }

    static {
        $assertionsDisabled = !BibleTreeNode.class.desiredAssertionStatus();
    }

    public class NodeEnumeration
    implements Enumeration {
        private int index;

        public boolean hasMoreElements() {
            return this.index < BibleTreeNode.this.kids.length;
        }

        public Object nextElement() {
            return BibleTreeNode.this.kids[this.index++];
        }
    }
}

