/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.util.Iterator;
import javax.swing.tree.TreeNode;
import org.crosswire.bibledesktop.passage.BookTreeNode;
import org.crosswire.bibledesktop.passage.VerseTreeNode;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.Verse;

public class ChapterTreeNode
extends BookTreeNode {
    protected int chapter;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ChapterTreeNode(TreeNode parent, int book, int chapter) throws NoSuchVerseException {
        super(parent, book);
        this.chapter = chapter;
        this.kids = new VerseTreeNode[BibleInfo.versesInChapter((int)book, (int)chapter)];
    }

    public void setPassage(Passage ref, boolean filter) {
        block4: {
            this.ref = ref;
            if (filter) {
                try {
                    this.kids = new VerseTreeNode[ref.versesInPassage(this.book, this.chapter)];
                    int verse_count = 0;
                    Iterator it = ref.iterator();
                    while (it.hasNext()) {
                        Verse verse = (Verse)it.next();
                        if (this.book != 0 && verse.getBook() != this.book || this.chapter != 0 && verse.getChapter() != this.chapter) continue;
                        VerseTreeNode node = new VerseTreeNode(this, this.book, this.chapter, verse.getVerse());
                        node.setPassage(ref, true);
                        this.kids[verse_count++] = node;
                    }
                }
                catch (NoSuchVerseException ex) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)ex);
                }
            }
        }
    }

    public TreeNode getChildAt(int i) {
        try {
            if (this.kids[i] != null) {
                return this.kids[i];
            }
            this.kids[i] = new VerseTreeNode(this, this.book, this.chapter, i + 1);
            return this.kids[i];
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return null;
        }
    }

    public int getIndex(TreeNode node) {
        if (!(node instanceof VerseTreeNode)) {
            return -1;
        }
        VerseTreeNode verse = (VerseTreeNode)node;
        return verse.getVerse();
    }

    public String toString() {
        try {
            String chapNum = Integer.toString(this.chapter);
            if (this.ref == null) {
                return chapNum;
            }
            int verses = this.ref.versesInPassage(this.book, this.chapter);
            if (verses == 0) {
                return chapNum;
            }
            return chapNum + " (" + verses + ')';
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return "!Error!";
        }
    }

    public int getChapter() {
        return this.chapter;
    }

    static {
        $assertionsDisabled = !ChapterTreeNode.class.desiredAssertionStatus();
    }
}

