/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.JobManager;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.basic.Msg;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.Verse;

public class Verifier {
    public static final int GUESS_WORDS = 18500;
    private Book book1;
    private Book book2;

    public Verifier(Book book1, Book book2) {
        this.setBible1(book1);
        this.setBible2(book2);
    }

    public final void setBible1(Book book1) {
        this.book1 = book1;
    }

    public final Book getBible1() {
        return this.book1;
    }

    public final void setBible2(Book book2) {
        this.book2 = book2;
    }

    public final Book getBible2() {
        return this.book2;
    }

    public void checkText(Key key, PrintWriter out) {
        Job job = JobManager.createJob((String)Msg.VERIFY_START.toString(), (Thread)Thread.currentThread(), (boolean)false);
        if (key == null) {
            key = this.book1.getGlobalKeyList();
        }
        int percent = 0;
        Iterator it = key.iterator();
        while (it.hasNext()) {
            Key subkey = (Key)it.next();
            if (subkey.canHaveChildren()) {
                this.checkText(subkey, out);
                continue;
            }
            try {
                BookData text1 = this.book1.getData(subkey);
                BookData text2 = this.book2.getData(subkey);
                if (!text1.equals(text2)) {
                    out.println(Msg.VERIFY_VERSE.toString() + subkey);
                    out.println(this.book1.getName() + ": " + text1);
                    out.println(this.book2.getName() + ": " + text2);
                    out.println();
                }
            }
            catch (Exception ex) {
                out.println(Msg.VERIFY_VERSE.toString() + subkey);
                ex.printStackTrace(out);
                out.println();
            }
            if (subkey instanceof Passage) {
                Verse verse = KeyUtil.getVerse(key);
                percent = 100 * verse.getOrdinal() / BibleInfo.versesInBible();
            }
            job.setProgress(percent, Msg.VERIFY_VERSES.toString());
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            break;
        }
    }

    public void checkPassage(PrintWriter out) throws BookException {
        Job job = JobManager.createJob((String)Msg.VERIFY_PASSAGES.toString(), (Thread)Thread.currentThread(), (boolean)false);
        int count = 0;
        int percent = -1;
        Iterator it = new ArrayList().iterator();
        while (it.hasNext()) {
            String word = (String)it.next();
            this.checkSinglePassage(word, out);
            int newpercent = 100 * count++ / 18500;
            if (percent != newpercent) {
                percent = newpercent;
                job.setProgress(percent, Msg.VERIFY_WORDS.toString());
            }
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            break;
        }
        job.done();
    }

    private void checkSinglePassage(String word, PrintWriter out) throws BookException {
        Key ref2;
        Key ref1 = this.book1.find(word);
        if (!ref1.equals(ref2 = this.book2.find(word))) {
            out.println(Msg.WORD.toString() + word);
            out.println(this.book1.getName() + ": " + ref1);
            out.println(this.book2.getName() + ": " + ref2);
            out.println();
        }
    }
}

