/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.gbf;

import java.util.LinkedList;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.gbf.Tag;
import org.crosswire.jsword.book.filter.gbf.TagBuilder;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class StrongsMorphTagBuilder
implements TagBuilder {
    public Tag createTag(final String tagname) {
        if (!tagname.startsWith("WT")) {
            return null;
        }
        return new Tag(){

            public void updateOsisStack(LinkedList stack) {
                String name = tagname.trim();
                Element ele = (Element)stack.get(0);
                int size = ele.getContentSize();
                if (size == 0) {
                    DataPolice.report("No content to attach word to: <" + name + ">.");
                    return;
                }
                int lastIndex = size - 1;
                Content prevObj = ele.getContent(lastIndex);
                Element word = null;
                if (prevObj instanceof Text) {
                    word = OSISUtil.factory().createW();
                    ele.removeContent(prevObj);
                    word.addContent(prevObj);
                    ele.addContent((Content)word);
                } else if (prevObj instanceof Element) {
                    word = (Element)prevObj;
                } else {
                    DataPolice.report("No words to attach word to: <" + name + ">.");
                    return;
                }
                String existingMorph = word.getAttributeValue("morph");
                StringBuffer newMorph = new StringBuffer();
                if (existingMorph != null && existingMorph.length() > 0) {
                    newMorph.append(existingMorph).append('|');
                }
                newMorph.append("x-StrongsMorph:T").append(name.substring(2));
                word.setAttribute("morph", newMorph.toString());
            }
        };
    }
}

