/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.passage.Key;

public class SwordUtil {
    private static final Logger log = Logger.getLogger((Class)SwordUtil.class);

    private SwordUtil() {
    }

    protected static byte[] readRAF(RandomAccessFile raf, long offset, int size) throws IOException {
        if (offset + (long)size > raf.length()) {
            DataPolice.report("Need to reduce size to avoid EOFException. offset=" + offset + " size=" + size + " but raf.length=" + raf.length());
            size = (int)(raf.length() - offset);
        }
        if (size < 1) {
            DataPolice.report("Nothing to read returning empty because size=" + size);
            return new byte[0];
        }
        raf.seek(offset);
        byte[] read = new byte[size];
        raf.readFully(read);
        return read;
    }

    protected static long decodeLittleEndian32(byte[] data, int offset) {
        long byte1 = SwordUtil.un2complement(data[0 + offset]);
        long byte2 = SwordUtil.un2complement(data[1 + offset]) << 8;
        long byte3 = SwordUtil.un2complement(data[2 + offset]) << 16;
        long byte4 = SwordUtil.un2complement(data[3 + offset]) << 24;
        return byte4 | byte3 | byte2 | byte1;
    }

    protected static int decodeLittleEndian32AsInt(byte[] data, int offset) {
        long result = SwordUtil.decodeLittleEndian32(data, offset);
        if (result > Integer.MAX_VALUE) {
            log.warn("loss of precision converting to integer from " + result + " to " + (int)result);
        }
        return (int)result;
    }

    protected static int decodeLittleEndian16(byte[] data, int offset) {
        int byte1 = SwordUtil.un2complement(data[0 + offset]);
        int byte2 = SwordUtil.un2complement(data[1 + offset]) << 8;
        return byte2 | byte1;
    }

    protected static int un2complement(byte data) {
        return data >= 0 ? data : 256 + data;
    }

    protected static int findByte(byte[] data, byte sought) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != sought) continue;
            return i;
        }
        return -1;
    }

    public static byte[] uncompress(byte[] compressed, int endsize) throws DataFormatException, BookException {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressed);
        byte[] uncompressed = new byte[endsize];
        int realendsize = decompressor.inflate(uncompressed);
        if (!decompressor.finished() || realendsize != endsize) {
            throw new BookException(Msg.GZIP_FORMAT);
        }
        return uncompressed;
    }

    public static String decode(Key key, byte[] data, String charset) {
        String txt = "";
        try {
            txt = new String(data, charset);
        }
        catch (UnsupportedEncodingException ex) {
            log.error("Encoding: " + charset + " not supported", (Throwable)ex);
            txt = new String(data);
        }
        return SwordUtil.clean(key, txt);
    }

    public static String clean(Key key, String data) {
        char[] buffer = data.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char c = buffer[i];
            if ((c < '\u0000' || c >= ' ' || c == '\t' || c == '\n' || c == '\r') && c != '\u00ff' && (c < '\u007f' || c > '\u009f')) continue;
            buffer[i] = 32;
            log.debug(key.getName() + " has bad character " + c + " at position " + i + " in input.");
        }
        return new String(buffer);
    }
}

