/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class MapCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;
    private static final long serialVersionUID = 3258130254177448499L;

    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setText(value == null ? "" : value.toString());
        return this;
    }
}

