/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.Msg;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.util.StringUtil;

public class ClassUtil {
    private static final char PACKAGE_SEPARATOR_CHAR = '.';
    private static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    private static final String EXTENSION_CLASS = ".class";
    private static final String EXTENSION_JAR = ".jar";
    private static final String EXTENSION_ZIP = ".zip";
    private static final Logger log = Logger.getLogger(ClassUtil.class);
    private static final String DEFAULT = "default";

    private ClassUtil() {
    }

    public static String findClasspathEntry(String classname, String classpath) {
        String full = null;
        String[] paths = StringUtil.split(classpath, File.pathSeparator);
        for (int i = 0; i < paths.length; ++i) {
            String file_name;
            if (paths[i].endsWith(EXTENSION_ZIP) || paths[i].endsWith(EXTENSION_JAR)) {
                try {
                    String file_name2 = classname.replace(',', '/') + EXTENSION_CLASS;
                    ZipFile zip = new ZipFile(paths[i]);
                    ZipEntry entry = zip.getEntry(file_name2);
                    if (entry == null || entry.isDirectory()) continue;
                    if (full != null && !full.equals(file_name2)) {
                        log.warn("Warning duplicate " + classname + " found: " + full + " and " + paths[i]);
                        continue;
                    }
                    full = paths[i];
                }
                catch (IOException ex) {}
                continue;
            }
            String extra = classname.replace('.', File.separatorChar);
            if (!paths[i].endsWith(File.separator)) {
                int n = i;
                paths[n] = paths[n] + File.separator;
            }
            if (!new File(file_name = paths[i] + extra + EXTENSION_CLASS).isFile()) continue;
            if (full != null && !full.equals(file_name)) {
                log.warn("Warning duplicate " + classname + " found: " + full + " and " + paths[i]);
                continue;
            }
            full = paths[i];
        }
        return full;
    }

    public static String findClasspathEntry(String classname) {
        String classpath = System.getProperty("java.class.path", "");
        return ClassUtil.findClasspathEntry(classname, classpath);
    }

    public static Class[] getImplementors(Class clazz) {
        try {
            ArrayList matches = new ArrayList();
            Properties props = ResourceUtil.getProperties(clazz);
            Iterator<Object> it = props.values().iterator();
            while (it.hasNext()) {
                try {
                    String name = (String)it.next();
                    Class<?> impl = Class.forName(name);
                    if (clazz.isAssignableFrom(impl)) {
                        matches.add(impl);
                        continue;
                    }
                    log.warn("Class " + impl.getName() + " does not implement " + clazz.getName() + ". Ignoring.");
                }
                catch (Exception ex) {
                    log.warn("Failed to add class to list: " + clazz.getName(), ex);
                }
            }
            log.debug("Found " + matches.size() + " implementors of " + clazz.getName());
            return matches.toArray(new Class[matches.size()]);
        }
        catch (Exception ex) {
            log.error("Failed to get any classes.", ex);
            return new Class[0];
        }
    }

    public static Map getImplementorsMap(Class clazz) {
        HashMap matches = new HashMap();
        try {
            Properties props = ResourceUtil.getProperties(clazz);
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                try {
                    String key = (String)it.next();
                    String value = props.getProperty(key);
                    Class<?> impl = Class.forName(value);
                    if (clazz.isAssignableFrom(impl)) {
                        matches.put(key, impl);
                        continue;
                    }
                    log.warn("Class " + impl.getName() + " does not implement " + clazz.getName() + ". Ignoring.");
                }
                catch (Exception ex) {
                    log.warn("Failed to add class to list: " + clazz.getName(), ex);
                }
            }
            log.debug("Found " + matches.size() + " implementors of " + clazz.getName());
        }
        catch (Exception ex) {
            log.error("Failed to get any classes.", ex);
        }
        return matches;
    }

    public static Class getImplementor(Class clazz) throws IOException, ClassNotFoundException, ClassCastException {
        Properties props = ResourceUtil.getProperties(clazz);
        String name = props.getProperty(DEFAULT);
        Class<?> impl = Class.forName(name);
        if (!clazz.isAssignableFrom(impl)) {
            throw new ClassCastException(Msg.NOT_ASSIGNABLE.toString(new Object[]{impl.getName(), clazz.getName()}));
        }
        return impl;
    }

    public static Object getImplementation(Class clazz) throws MalformedURLException, ClassCastException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class impl = ClassUtil.getImplementor(clazz);
        return impl.newInstance();
    }

    public static String getShortClassName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtil.getShortClassName(object.getClass().getName());
    }

    public static String getShortClassName(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        return ClassUtil.getShortClassName(cls.getName());
    }

    public static String getShortClassName(String className) {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("The class name must not be empty");
        }
        char[] chars = className.toCharArray();
        int lastDot = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '.') {
                lastDot = i + 1;
                continue;
            }
            if (chars[i] != '$') continue;
            chars[i] = 46;
        }
        return new String(chars, lastDot, chars.length - lastDot);
    }
}

