/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.crosswire.bibledesktop.book.install.InstallManagerComboBoxModel;
import org.crosswire.bibledesktop.book.install.Msg;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.install.InstallManager;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.search.IndexManagerFactory;
import org.crosswire.jsword.util.IndexDownloader;

public class IndexResolver {
    private static Object[] options;
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    private IndexResolver() {
    }

    public static void scheduleIndex(Book book, Component parent) {
        String title = Msg.HOW_MESSAGE_TITLE.toString();
        Msg msg = Msg.HOW_MESSAGE;
        int choice = JOptionPane.showOptionDialog(parent, (Object)msg, title, 0, 3, null, options, options[0]);
        switch (choice) {
            case 0: {
                Installer installer = IndexResolver.selectInstaller(parent);
                if (installer == null) break;
                try {
                    IndexDownloader.downloadIndex((Book)book, (Installer)installer);
                }
                catch (Exception ex) {
                    log.error("index download failed: ", (Throwable)ex);
                    String gtitle = Msg.HOW_GENERATE_TITLE.toString();
                    Msg gmsg = Msg.HOW_GENERATE;
                    int yn = JOptionPane.showConfirmDialog(parent, (Object)gmsg, gtitle, 0, 3);
                    if (yn != 0) break;
                    IndexManagerFactory.getIndexManager().scheduleIndexCreation(book);
                }
                break;
            }
            case 1: {
                IndexManagerFactory.getIndexManager().scheduleIndexCreation(book);
                break;
            }
        }
    }

    private static Installer selectInstaller(Component parent) {
        InstallManager insman = new InstallManager();
        Map installers = insman.getInstallers();
        Installer installer = null;
        if (installers.size() == 1) {
            Iterator it = installers.values().iterator();
            boolean hasNext = it.hasNext();
            if (!$assertionsDisabled && !hasNext) {
                throw new AssertionError();
            }
            installer = (Installer)it.next();
        } else {
            JComboBox choice = new JComboBox(new InstallManagerComboBoxModel(insman));
            JLabel label = new JLabel(Msg.HOW_SITE.toString());
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)label, "North");
            panel.add(choice, "Center");
            String title = Msg.HOW_SITE_TITLE.toString();
            int yn = JOptionPane.showConfirmDialog(parent, panel, title, 0);
            if (yn == 0) {
                installer = (Installer)choice.getSelectedItem();
            }
        }
        return installer;
    }

    static {
        $assertionsDisabled = !IndexResolver.class.desiredAssertionStatus();
        options = new Object[]{Msg.OPTION_DOWNLOAD, Msg.OPTION_GENERATE, Msg.OPTION_CANCEL};
        log = Logger.getLogger((Class)IndexResolver.class);
    }
}

