/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.crosswire.bibledesktop.desktop.DebugPane;
import org.crosswire.bibledesktop.desktop.Desktop;
import org.crosswire.bibledesktop.desktop.Msg;
import org.crosswire.common.progress.swing.JobsViewPane;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.ExceptionShelf;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.MapTableModel;

public class AboutPane {
    private static final String SPLASH_FONT = "SanSerif";
    private static final String ABOUT_OK = "AboutOK";
    private static boolean advanced;
    private JDialog dlgMain;
    private JPanel pnlMain;

    public AboutPane(Desktop desktop) {
        this.init(desktop);
    }

    private void init(Desktop desktop) {
        ImageIcon icon = GuiUtil.getIcon((String)Msg.SPLASH_IMAGE.toString());
        JLabel lblPicture = new JLabel();
        lblPicture.setIcon(icon);
        lblPicture.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        lblPicture.setHorizontalAlignment(0);
        lblPicture.setVerticalAlignment(0);
        JLabel lblInfo = new JLabel();
        lblInfo.setFont(new Font(SPLASH_FONT, 1, 14));
        lblInfo.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        lblInfo.setOpaque(true);
        lblInfo.setHorizontalAlignment(4);
        lblInfo.setText(Msg.getVersionInfo());
        ActionFactory actions = new ActionFactory(AboutPane.class, (Object)this);
        JButton btnOk = new JButton(actions.getAction(ABOUT_OK));
        JPanel pnlButtons = new JPanel();
        pnlButtons.add(btnOk);
        this.pnlMain = new JPanel();
        this.pnlMain.setLayout(new BorderLayout(5, 5));
        this.pnlMain.add((Component)pnlButtons, "South");
        this.pnlMain.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel pnlSplash = new JPanel();
        pnlSplash.setLayout(new BorderLayout(5, 0));
        pnlSplash.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlSplash.add((Component)lblPicture, "Center");
        pnlSplash.add((Component)lblInfo, "South");
        if (!advanced) {
            this.pnlMain.add(pnlSplash);
        } else {
            JTabbedPane tabMain = new JTabbedPane();
            this.pnlMain.add((Component)tabMain, "Center");
            tabMain.add((Component)pnlSplash, Msg.getApplicationTitle());
            ExceptionShelf pnlShelf = new ExceptionShelf();
            JPanel pnlHshelf = new JPanel();
            pnlHshelf.setLayout(new BorderLayout());
            pnlHshelf.add((Component)pnlShelf, "North");
            pnlHshelf.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            tabMain.add((Component)pnlHshelf, Msg.ERROR_TAB_TITLE.toString());
            JTable tblProps = new JTable();
            MapTableModel mdlProps = new MapTableModel((Map)System.getProperties());
            tblProps.setModel((TableModel)mdlProps);
            JScrollPane scrProps = new JScrollPane();
            scrProps.setPreferredSize(new Dimension(500, 300));
            scrProps.getViewport().add(tblProps);
            JPanel pnlProps = new JPanel();
            pnlProps.setLayout(new BorderLayout());
            pnlProps.add((Component)scrProps, "Center");
            pnlProps.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            tabMain.add((Component)pnlProps, Msg.SYSTEM_PROPS_TAB_TITLE.toString());
            JobsViewPane pnlJobs = new JobsViewPane();
            tabMain.add((Component)pnlJobs, Msg.TASK_TAB_TITLE.toString());
            DebugPane pnlDebug = new DebugPane(desktop);
            tabMain.add((Component)pnlDebug, Msg.DEBUG_TAB_TITLE.toString());
        }
    }

    public void doAboutOK() {
        if (this.dlgMain != null) {
            this.dlgMain.dispose();
            this.dlgMain = null;
        }
    }

    public void showInDialog(Component parent) {
        this.dlgMain = new JDialog(JOptionPane.getFrameForComponent(parent));
        this.dlgMain.getContentPane().add(this.pnlMain);
        this.dlgMain.setTitle(Msg.getAboutInfo());
        this.dlgMain.setModal(true);
        this.dlgMain.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent ev) {
                AboutPane.this.doAboutOK();
            }
        });
        this.dlgMain.pack();
        this.dlgMain.setLocationRelativeTo(parent);
        this.dlgMain.setVisible(true);
    }

    public static synchronized boolean isAdvanced() {
        return advanced;
    }

    public static synchronized void setAdvanced(boolean advanced) {
        AboutPane.advanced = advanced;
    }
}

