/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

public class WindowsMenuPatch
implements LookAndFeelPatch {
    public void patch(Environment env) {
        UIDefaults defaults = UIManager.getDefaults();
        defaults.put("RadioButtonMenuItem.checkIcon", new WindowsRadioButtonMenuItemIcon());
        defaults.put("MenuItemUI", "net.java.plaf.windows.common.WindowsMenuItemUI");
        defaults.put("RadioButtonMenuItem.margin", new InsetsUIResource(2, 4, 2, 2));
    }

    public void unpatch() {
    }

    public boolean isApplicable(Environment env) {
        return env.isWindowsLookAndFeel();
    }

    private static class WindowsRadioButtonMenuItemIcon
    implements Icon,
    UIResource {
        private WindowsRadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            if (b.isSelected()) {
                g.fillRect(x + 1, y, 4, 6);
                g.fillRect(x, y + 1, 6, 4);
            }
        }

        public int getIconWidth() {
            return 6;
        }

        public int getIconHeight() {
            return 6;
        }
    }
}

