/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;

public class WindowsRadioButtonUI
extends com.sun.java.swing.plaf.windows.WindowsRadioButtonUI {
    private static final WindowsRadioButtonUI windowsRadioButtonUI = new WindowsRadioButtonUI();
    private static final KeyStroke downKeyStroke = KeyStroke.getKeyStroke("pressed DOWN");
    private static final KeyStroke upKeyStroke = KeyStroke.getKeyStroke("pressed UP");
    private static final KeyStroke rightKeyStroke = KeyStroke.getKeyStroke("pressed RIGHT");
    private static final KeyStroke leftKeyStroke = KeyStroke.getKeyStroke("pressed LEFT");
    private static final Action nextAction = new AbstractAction("Next"){

        public void actionPerformed(ActionEvent evt) {
            WindowsRadioButtonUI.selectRadioButton(evt, true);
        }
    };
    private static final Action prevAction = new AbstractAction("Prev"){

        public void actionPerformed(ActionEvent evt) {
            WindowsRadioButtonUI.selectRadioButton(evt, false);
        }
    };

    private static void selectRadioButton(ActionEvent evt, boolean next) {
        if (!(evt.getSource() instanceof JRadioButton)) {
            return;
        }
        ButtonModel model = ((AbstractButton)evt.getSource()).getModel();
        if (!(model instanceof DefaultButtonModel)) {
            return;
        }
        DefaultButtonModel bm = (DefaultButtonModel)model;
        ButtonGroup group = bm.getGroup();
        if (bm == null) {
            return;
        }
        Enumeration<AbstractButton> e = group.getElements();
        if (e == null) {
            return;
        }
        int count = 0;
        boolean found = false;
        count = 0;
        while (e.hasMoreElements()) {
            if (e.nextElement() == evt.getSource()) {
                found = true;
                break;
            }
            ++count;
        }
        if (!found) {
            System.err.println("RadioButton Arrow Key Action error: source not found");
            return;
        }
        count = next ? (e.hasMoreElements() ? ++count : 0) : --count;
        e = group.getElements();
        AbstractButton nextButton = null;
        int i = 0;
        while (count < 0 ? e.hasMoreElements() : i <= count) {
            nextButton = e.nextElement();
            ++i;
        }
        if (!(nextButton instanceof JRadioButton)) {
            return;
        }
        ((JRadioButton)nextButton).requestFocus();
        ((JRadioButton)nextButton).setSelected(true);
    }

    public static ComponentUI createUI(JComponent c) {
        return windowsRadioButtonUI;
    }

    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.getActionMap().put("Next", nextAction);
        b.getActionMap().put("Prev", prevAction);
        b.getInputMap(1).put(downKeyStroke, "Next");
        b.getInputMap(1).put(upKeyStroke, "Prev");
        b.getInputMap(1).put(rightKeyStroke, "Next");
        b.getInputMap(1).put(leftKeyStroke, "Prev");
    }

    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.getActionMap().remove("Next");
        b.getActionMap().remove("Prev");
        b.getInputMap(1).remove(downKeyStroke);
        b.getInputMap(1).remove(upKeyStroke);
        b.getInputMap(1).remove(rightKeyStroke);
        b.getInputMap(1).remove(leftKeyStroke);
    }
}

