/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.XMLUtils;
import com.sun.javaws.util.GeneralUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jdesktop.jdic.packager.impl.FileOperUtility;
import org.jdesktop.jdic.packager.impl.JnlpConstants;

public final class JnlpPackageInfo {
    private static String osName = System.getProperty("os.name").toLowerCase();
    private String[] titles = new String[JnlpConstants.LOCALES.length];
    private String[] vendors = new String[JnlpConstants.LOCALES.length];
    private String[] licenses = new String[JnlpConstants.LOCALES.length];
    private String[] descriptions = new String[JnlpConstants.LOCALES.length];
    private String licenseDirPath;
    private String uniqueTmpDirPath = null;
    private String packageName;
    private String outputDirPath;
    private String jnlpFileHref;
    private String jnlpFilePath;
    private String resourceDirPath;
    private String version;
    private String release;
    private List jnlpRefFilePaths;
    private String bannerJpgFilePath = null;
    private String panelJpgFilePath = null;
    private String msSDKDirPath;
    private String rawMsiFilePath;
    private boolean enableLocalization = false;
    private boolean enableLicense;
    private boolean shortcutEnabled;
    private boolean enableAssociation;
    private boolean enableSystemCache;

    public String getBannerJpgFilePath() {
        return this.bannerJpgFilePath;
    }

    public void setBannerJpgFilePath(String string) {
        this.bannerJpgFilePath = string;
    }

    public String getPanelJpgFilePath() {
        return this.panelJpgFilePath;
    }

    public void setPanelJpgFilePath(String string) {
        this.panelJpgFilePath = string;
    }

    public String getMSSDKDirPath() {
        return this.msSDKDirPath;
    }

    public void setMSSDKDirPath(String string) {
        this.msSDKDirPath = string;
    }

    public String getRawMsiFilePath() {
        return this.rawMsiFilePath;
    }

    public void setRawMsiFilePath(String string) {
        this.rawMsiFilePath = string;
    }

    public boolean getSystemCacheEnabled() {
        return this.enableSystemCache;
    }

    public void setSystemCacheEnabled(boolean bl) {
        this.enableSystemCache = bl;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getOutputDirPath() {
        return this.outputDirPath;
    }

    public void setOutputDirPath(String string) {
        this.outputDirPath = string;
    }

    public String getJnlpFileHref() {
        return this.jnlpFileHref;
    }

    public void setJnlpFileHref(String string) {
        this.jnlpFileHref = string;
    }

    public String getJnlpFilePath() {
        return this.jnlpFilePath;
    }

    public void setJnlpFilePath(String string) {
        this.jnlpFilePath = string;
    }

    public String getJnlpFileName() {
        return new File(this.jnlpFilePath).getName();
    }

    public String getResourceDirPath() {
        return this.resourceDirPath;
    }

    public void setResourcePath(String string) {
        this.resourceDirPath = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        if (osName.startsWith("windows")) {
            try {
                Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Error: Illegal Version Number (Valid input: digits & '.')");
            }
        }
        this.version = string;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String string) {
        if (osName.startsWith("windows")) {
            try {
                Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Error: Illegal Release Number (Valid input: digits & '.')");
            }
        }
        this.release = string;
    }

    public Iterator getJnlpRefFilePaths() {
        return this.jnlpRefFilePaths.iterator();
    }

    public void setJnlpRefFilePaths(List list) {
        this.jnlpRefFilePaths = list;
    }

    public boolean getShortcutEnabled() {
        return this.shortcutEnabled;
    }

    public void setShortcutEnabled(boolean bl) {
        this.shortcutEnabled = bl;
    }

    public boolean getAssociationEnabled() {
        return this.enableAssociation;
    }

    public void setAssociationEnabled(boolean bl) {
        this.enableAssociation = bl;
    }

    public boolean getLocalizationEnabled() {
        return this.enableLocalization;
    }

    public void setGlocalizationEnabled(boolean bl) {
        this.enableLocalization = bl;
    }

    public String getLicenseDirPath() {
        return this.licenseDirPath;
    }

    public void setLicenseDirPath(String string) {
        this.licenseDirPath = string;
    }

    public void setShowLicense(boolean bl) {
        this.enableLicense = bl;
    }

    public boolean getShowLicense() {
        return this.enableLicense;
    }

    public String getUniqueTmpDirPath() throws IOException {
        if (this.uniqueTmpDirPath == null) {
            this.uniqueTmpDirPath = FileOperUtility.createUniqueTmpDir();
        }
        return this.uniqueTmpDirPath;
    }

    public String getLocalizedJnlpInfo(String string, String string2) {
        int n = this.getLocaleIndex(string);
        String string3 = null;
        if (string2.compareToIgnoreCase("title") == 0) {
            string3 = this.titles[n];
        } else if (string2.compareToIgnoreCase("vendor") == 0) {
            string3 = this.vendors[n];
        } else if (string2.compareToIgnoreCase("license") == 0) {
            string3 = this.licenses[n];
        } else if (string2.compareToIgnoreCase("description") == 0) {
            string3 = this.descriptions[n];
        }
        return string3;
    }

    protected int getLocaleIndex(String string) {
        int n = -1;
        for (int i = 0; i < JnlpConstants.LOCALES.length; ++i) {
            if (string.compareToIgnoreCase(JnlpConstants.LOCALES[i]) != 0) continue;
            n = i;
            break;
        }
        return n;
    }

    public void parseJnlpInfo() throws MissingFieldException, BadFieldException {
        XMLNode xMLNode;
        try {
            File file = new File(this.jnlpFilePath);
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray, 0, n);
            fileInputStream.close();
            String string = new String(byArray);
            xMLNode = new XMLParser(string).parse();
        }
        catch (Exception exception) {
            return;
        }
        XMLUtils.visitElements((XMLNode)xMLNode, (String)"<information>", (XMLUtils.ElementVisitor)new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                int n;
                String[] stringArray = GeneralUtil.getStringList((String)XMLUtils.getAttribute((XMLNode)xMLNode, (String)"", (String)"locale"));
                int n2 = n = stringArray == null ? 0 : JnlpPackageInfo.this.getLocaleIndex(stringArray[0]);
                if (n != -1) {
                    ((JnlpPackageInfo)JnlpPackageInfo.this).titles[n] = new String(XMLUtils.getElementContents((XMLNode)xMLNode, (String)"<title>"));
                    ((JnlpPackageInfo)JnlpPackageInfo.this).vendors[n] = new String(XMLUtils.getElementContents((XMLNode)xMLNode, (String)"<vendor>"));
                    ((JnlpPackageInfo)JnlpPackageInfo.this).descriptions[n] = XMLUtils.getElementContents((XMLNode)xMLNode, (String)"<description>");
                }
            }
        });
        for (int i = 1; i < JnlpConstants.LOCALES.length; ++i) {
            this.titles[i] = this.titles[i] == null ? this.titles[0] : this.titles[i];
            this.vendors[i] = this.vendors[i] == null ? this.vendors[0] : this.vendors[i];
            this.descriptions[i] = this.descriptions[i] == null ? this.descriptions[0] : this.descriptions[i];
        }
    }
}

