/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.UIManager;

public final class Environment {
    private final boolean m_isWindowsLookAndFeel = UIManager.getLookAndFeel() instanceof WindowsLookAndFeel;
    private final boolean m_isWindowsXPThemed = this.isWindowsXPThemedImpl();
    private final JavaVersion m_javaVersion = new JavaVersion(System.getProperty("java.version"));
    private final boolean m_isWindowsXP;
    private final boolean m_isWindows2000;
    private boolean m_isLonghorn;
    private final boolean m_is32bitColor = Toolkit.getDefaultToolkit().getColorModel().getPixelSize() == 24;
    public static final JavaVersion JAVA_1_4_0 = new JavaVersion("1.4.0");
    public static final JavaVersion JAVA_1_4_2 = new JavaVersion("1.4.2");

    public Environment() {
        this.m_isWindowsXP = System.getProperty("os.name").indexOf("XP") > 0;
        this.m_isWindows2000 = System.getProperty("os.name").indexOf("2000") > 0;
        try {
            if (System.getProperty("os.name").indexOf("Windows") > 0) {
                this.m_isLonghorn = Float.parseFloat(System.getProperty("os.version")) > 5.1f;
            }
        }
        catch (RuntimeException re) {
            this.m_isLonghorn = false;
        }
    }

    public static void main(String[] args) {
        Environment env = new Environment();
        boolean atLeast13 = env.isJavaVersionAtLeast("1.3.0");
        System.out.println("true? " + atLeast13);
        boolean atLeast14 = env.isJavaVersionAtLeast("1.4.0");
        System.out.println("true? " + atLeast14);
        boolean atLeast142 = env.isJavaVersionAtLeast("1.4.2");
        System.out.println("true? " + atLeast142);
        boolean atLeast143 = env.isJavaVersionAtLeast("1.4.3");
        System.out.println("false? " + atLeast143);
        boolean atLeast15 = env.isJavaVersionAtLeast("1.5.0");
        System.out.println("false? " + atLeast15);
    }

    public boolean isWindowsLookAndFeel() {
        return this.m_isWindowsLookAndFeel;
    }

    public boolean isWindowsXP() {
        return this.m_isWindowsXP;
    }

    public boolean isWindows2000() {
        return this.m_isWindows2000;
    }

    public boolean isWindowsLonghorn() {
        return this.m_isLonghorn;
    }

    public boolean isWindowsXPThemed() {
        return this.m_isWindowsXPThemed;
    }

    public boolean isAlphaIconCapable() {
        return this.isWindowsXPThemed() && this.m_is32bitColor;
    }

    public boolean isJavaVersionAtLeast(String version) {
        return this.isJavaVersionAtLeast(new JavaVersion(version));
    }

    public boolean isJavaVersionAtLeast(JavaVersion version) {
        return this.m_javaVersion.compareTo(version) >= 0;
    }

    public boolean isJavaVersionLessThan(String version) {
        return this.isJavaVersionLessThan(new JavaVersion(version));
    }

    public boolean isJavaVersionLessThan(JavaVersion version) {
        return this.m_javaVersion.compareTo(version) < 0;
    }

    private boolean isWindowsXPThemedImpl() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Boolean themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
        if (themeActive == null) {
            return false;
        }
        return themeActive != false && System.getProperty("swing.noxp") == null;
    }

    public boolean hasBug(int sunBugNumber) {
        return false;
    }

    public static final class JavaVersion
    implements Comparable {
        ArrayList parts = new ArrayList(4);

        JavaVersion(String versionString) {
            StringTokenizer tok = new StringTokenizer(versionString, "._-");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                try {
                    int number = Integer.parseInt(token);
                    this.parts.add(new Integer(number));
                }
                catch (Exception e) {
                    this.parts.add(token);
                }
            }
        }

        public int compareTo(Object o) {
            JavaVersion that = (JavaVersion)o;
            int partIndex = 0;
            Iterator i = this.parts.iterator();
            while (i.hasNext()) {
                int difference;
                Object thisPart = i.next();
                Object thatPart = that.parts.get(partIndex);
                ++partIndex;
                if (!(thisPart instanceof Integer) || !(thatPart instanceof Integer) || (difference = (Integer)thisPart - (Integer)thatPart) == 0) continue;
                return difference;
            }
            Object thatLastPart = that.parts.get(that.parts.size() - 1);
            Object thisLastPart = this.parts.get(this.parts.size() - 1);
            if (thatLastPart instanceof String && thisLastPart instanceof String) {
                if (thatLastPart.equals(thisLastPart)) {
                    return 0;
                }
                return -1;
            }
            if (thatLastPart instanceof String) {
                return -1;
            }
            return 1;
        }
    }
}

