/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.xp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellRenderer;

public class DefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected JTree tree;
    protected boolean selected;
    protected boolean hasFocus;
    protected boolean drawsFocusBorderAroundIcon;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color backgroundNoFocusSelectionColor;
    protected Color borderSelectionColor;

    public DefaultTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        this.setBackgroundNoFocusSelectionColor(UIManager.getColor("Label.background"));
        Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = value != null && (Boolean)value != false;
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon newIcon) {
        this.openIcon = newIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon newIcon) {
        this.closedIcon = newIcon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon newIcon) {
        this.leafIcon = newIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setBackgroundNoFocusSelectionColor(Color newColor) {
        this.backgroundNoFocusSelectionColor = newColor;
    }

    public Color getBackgroundNoFocusSelectionColor() {
        return this.backgroundNoFocusSelectionColor;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.tree = tree;
        this.hasFocus = hasFocus;
        this.selected = selected;
        String textValue = this.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        this.setText(textValue);
        this.setEnabled(tree.isEnabled());
        Icon icon = this.convertValueToIcon(value, selected, expanded, leaf, row, hasFocus);
        if (!tree.isEnabled()) {
            this.setDisabledIcon(icon);
        } else {
            this.setIcon(icon);
        }
        boolean focusPermanentlyLost = this.isFocusPermanentlyLost();
        if (selected && hasFocus || selected && !hasFocus && !focusPermanentlyLost) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        return this;
    }

    protected String convertValueToText(Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
    }

    protected Icon convertValueToIcon(Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value == null) {
            if (leaf) {
                return this.getDefaultLeafIcon();
            }
            return this.getDefaultOpenIcon();
        }
        if (leaf) {
            return this.getLeafIcon();
        }
        if (expanded) {
            return this.getOpenIcon();
        }
        return this.getClosedIcon();
    }

    public void paint(Graphics g) {
        Color bColor;
        boolean weLostFocusPermanently = this.isFocusPermanentlyLost();
        if (this.selected && this.hasFocus || this.selected && !this.hasFocus && !weLostFocusPermanently) {
            bColor = this.getBackgroundSelectionColor();
        } else if (this.selected && !this.hasFocus && weLostFocusPermanently) {
            bColor = this.getBackgroundNoFocusSelectionColor();
        } else {
            bColor = this.getBackgroundNonSelectionColor();
            if (bColor == null) {
                bColor = this.getBackground();
            }
        }
        int imageOffset = -1;
        if (bColor != null) {
            imageOffset = this.getLabelStart();
            g.setColor(bColor);
            if (this.getComponentOrientation().isLeftToRight()) {
                g.fillRect(imageOffset, 0, this.getWidth() - 1 - imageOffset, this.getHeight());
            } else {
                g.fillRect(0, 0, this.getWidth() - 1 - imageOffset, this.getHeight());
            }
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                imageOffset = 0;
            } else if (imageOffset == -1) {
                imageOffset = this.getLabelStart();
            }
            Color bsColor = this.getBorderSelectionColor();
            if (bsColor != null) {
                g.setColor(bsColor);
                if (this.getComponentOrientation().isLeftToRight()) {
                    g.drawRect(imageOffset, 0, this.getWidth() - 1 - imageOffset, this.getHeight() - 1);
                } else {
                    g.drawRect(0, 0, this.getWidth() - 1 - imageOffset, this.getHeight() - 1);
                }
            }
        }
        super.paint(g);
    }

    protected boolean isFocusPermanentlyLost() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = kfm.getPermanentFocusOwner();
        if (component == null) {
            return this.hasFocus;
        }
        Window window = this.windowForComponent(this.tree);
        Window activeWindow = kfm.getActiveWindow();
        if (activeWindow == null) {
            return true;
        }
        return !component.equals(this.tree) || !activeWindow.equals(window);
    }

    protected Window windowForComponent(Component aComponent) {
        if (aComponent == null) {
            return null;
        }
        Container parent = aComponent.getParent();
        Window window = null;
        boolean found = false;
        while (parent != null && !found) {
            if (parent instanceof Window) {
                window = (Window)parent;
                found = true;
                continue;
            }
            parent = parent.getParent();
        }
        return window;
    }

    private int getLabelStart() {
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

