/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.xp;

import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.text.View;

public class XPMenuItemUI
extends WindowsMenuItemUI {
    private String _acceleratorDelimiter;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();
    private boolean m_mouseOver = false;

    public static ComponentUI createUI(JComponent c) {
        return new XPMenuItemUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this._acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this._acceleratorDelimiter == null) {
            this._acceleratorDelimiter = "+";
        }
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this._acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.myLayoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(XPMenuItemUI.iconRect.x, XPMenuItemUI.iconRect.y, XPMenuItemUI.iconRect.width, XPMenuItemUI.iconRect.height, r);
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int maxAccValue;
            JComponent p = (JComponent)parent;
            Integer maxTextWidth = (Integer)p.getClientProperty(MAX_TEXT_WIDTH);
            Integer maxAccWidth = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
            int maxTextValue = maxTextWidth != null ? maxTextWidth : 0;
            int n = maxAccValue = maxAccWidth != null ? maxAccWidth : 0;
            if (XPMenuItemUI.r.width < maxTextValue) {
                XPMenuItemUI.r.width = maxTextValue;
            } else {
                p.putClientProperty(MAX_TEXT_WIDTH, new Integer(XPMenuItemUI.r.width));
            }
            if (XPMenuItemUI.acceleratorRect.width > maxAccValue) {
                maxAccValue = XPMenuItemUI.acceleratorRect.width;
                p.putClientProperty(MAX_ACC_WIDTH, new Integer(XPMenuItemUI.acceleratorRect.width));
            }
            XPMenuItemUI.r.width += maxAccValue;
            XPMenuItemUI.r.width += defaultTextIconGap;
        }
        if (this.myUseCheckAndArrow()) {
            XPMenuItemUI.r.width += XPMenuItemUI.checkIconRect.width;
            XPMenuItemUI.r.width += defaultTextIconGap;
            XPMenuItemUI.r.width += defaultTextIconGap;
            XPMenuItemUI.r.width += XPMenuItemUI.arrowIconRect.width;
        }
        XPMenuItemUI.r.width += 2 * defaultTextIconGap;
        Insets insets = b.getInsets();
        if (insets != null) {
            XPMenuItemUI.r.width += insets.left + insets.right;
            XPMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (XPMenuItemUI.r.width % 2 == 0) {
            ++XPMenuItemUI.r.width;
        }
        if (XPMenuItemUI.r.height % 2 == 0) {
            ++XPMenuItemUI.r.height;
        }
        return r.getSize();
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        XPMenuItemUI.viewRect.x += i.left;
        XPMenuItemUI.viewRect.y += i.top;
        XPMenuItemUI.viewRect.width -= i.right + XPMenuItemUI.viewRect.x;
        XPMenuItemUI.viewRect.height -= i.bottom + XPMenuItemUI.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this._acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text = this.myLayoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, 0);
        this.paintBackground(g, b, background);
        Color holdc = g.getColor();
        if (checkIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (this.myUseCheckAndArrow()) {
                checkIcon.paintIcon(c, g, XPMenuItemUI.checkIconRect.x, XPMenuItemUI.checkIconRect.y);
            }
            g.setColor(holdc);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(c, g, XPMenuItemUI.iconRect.x, XPMenuItemUI.iconRect.y);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p = (JComponent)parent;
                Integer maxValueInt = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
                int maxValue = maxValueInt != null ? maxValueInt : XPMenuItemUI.acceleratorRect.width;
                accOffset = maxValue - XPMenuItemUI.acceleratorRect.width;
            }
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g.setColor(this.disabledForeground);
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, XPMenuItemUI.acceleratorRect.x - accOffset, XPMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                } else {
                    g.setColor(b.getBackground().brighter());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, XPMenuItemUI.acceleratorRect.x - accOffset, XPMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                    g.setColor(b.getBackground().darker());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, XPMenuItemUI.acceleratorRect.x - accOffset - 1, XPMenuItemUI.acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, XPMenuItemUI.acceleratorRect.x - accOffset, XPMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (this.myUseCheckAndArrow()) {
                arrowIcon.paintIcon(c, g, XPMenuItemUI.arrowIconRect.x, XPMenuItemUI.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    private String myLayoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (this.myUseCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            if (icon == null) {
                textRect.x += viewRect.x + checkIcon.getIconWidth();
                iconRect.x += viewRect.x + checkIcon.getIconWidth();
            }
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
            if (this.myUseCheckAndArrow()) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
        } else {
            textRect.x -= menuItemGap;
            iconRect.x -= menuItemGap;
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;
            if (this.myUseCheckAndArrow()) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
        }
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (this.myUseCheckAndArrow()) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        return text;
    }

    private boolean myUseCheckAndArrow() {
        JMenu menu;
        if (this.menuItem instanceof JMenu && (menu = (JMenu)this.menuItem).isTopLevelMenu()) {
            return false;
        }
        if (this.menuItem instanceof JCheckBoxMenuItem) {
            return true;
        }
        if (this.menuItem instanceof JRadioButtonMenuItem) {
            return true;
        }
        Icon icon = this.menuItem.getIcon();
        return icon == null;
    }

    protected void paintBackground(Graphics g, JMenuItem item, Color bgColor) {
        ButtonModel model = item.getModel();
        Color oldColor = g.getColor();
        if (item.isOpaque()) {
            if (item.isArmed() || item instanceof JMenu && model.isSelected() || !model.isEnabled() && this.m_mouseOver) {
                g.setColor(bgColor);
            } else {
                g.setColor(item.getBackground());
            }
        }
        g.fillRect(0, 0, item.getWidth(), item.getHeight());
        g.setColor(oldColor);
    }

    protected MouseInputListener createMouseInputListener(JComponent jc) {
        return new XPMouseInputHandler();
    }

    protected class XPMouseInputHandler
    extends BasicMenuItemUI.MouseInputHandler {
        protected XPMouseInputHandler() {
            super((BasicMenuItemUI)((Object)XPMenuItemUI.this));
        }

        public void mouseEntered(MouseEvent me) {
            super.mouseEntered(me);
            XPMenuItemUI.this.m_mouseOver = true;
            XPMenuItemUI.this.menuItem.repaint();
        }

        public void mouseExited(MouseEvent me) {
            super.mouseExited(me);
            XPMenuItemUI.this.m_mouseOver = false;
            XPMenuItemUI.this.menuItem.repaint();
        }
    }
}

