/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.jdesktop.jdic.packager.impl.JnlpConstants;
import org.jdesktop.jdic.packager.impl.JnlpPackageInfo;

public class FileOperUtility {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void urlFile2LocalFile(URL uRL, String string, String string2) throws IOException {
        FilterOutputStream filterOutputStream;
        block23: {
            boolean bl;
            Object object;
            Serializable serializable;
            URL uRL2 = null;
            try {
                serializable = null;
                object = uRL.toString();
                serializable = !((String)object).endsWith("/") ? new URL(((String)object).concat("/")) : uRL;
                uRL2 = new URL((URL)serializable, string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            serializable = new File(string2, string);
            object = ((File)serializable).getParentFile();
            if (!((File)object).exists()) {
                bl = ((File)object).mkdirs();
                if (!bl) {
                    throw new IOException("Failed to create local directory: " + object);
                }
            } else {
                if (!((File)object).canWrite()) {
                    throw new IOException("The local directory is not writable: " + object);
                }
                if (((File)serializable).exists() && !(bl = ((File)serializable).delete())) {
                    throw new IOException("Failed to remove the already existed local file: " + serializable);
                }
            }
            try {
                bl = ((File)serializable).createNewFile();
                if (!bl) {
                    throw new IOException("Failed to create local file: " + serializable);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Failed to create local file: " + serializable);
            }
            DataInputStream dataInputStream = null;
            filterOutputStream = null;
            try {
                try {
                    dataInputStream = new DataInputStream(uRL2.openStream());
                    filterOutputStream = new DataOutputStream(new FileOutputStream((File)serializable));
                    byte[] byArray = new byte[1024];
                    while (true) {
                        int n;
                        if ((n = dataInputStream.read(byArray)) == -1) {
                            Object var11_14 = null;
                            if (dataInputStream == null) break block23;
                            break;
                        }
                        ((DataOutputStream)filterOutputStream).write(byArray, 0, n);
                    }
                }
                catch (IOException iOException) {
                    throw new IOException("Failed to copy file: " + uRL2 + " to file: " + serializable);
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new IOException("Failed to close the input stream during file copy.");
                    }
                }
                if (filterOutputStream == null) throw throwable;
                try {
                    filterOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new IOException("Failed to close the output stream during file copy.");
                }
            }
            try {}
            catch (IOException iOException) {
                throw new IOException("Failed to close the input stream during file copy.");
            }
            dataInputStream.close();
        }
        if (filterOutputStream == null) return;
        try {}
        catch (IOException iOException) {
            throw new IOException("Failed to close the output stream during file copy.");
        }
        filterOutputStream.close();
    }

    public static void urlFile2LocalFile(URL uRL, String string) throws IOException {
        String string2 = uRL.toString();
        int n = string2.lastIndexOf(47);
        URL uRL2 = null;
        try {
            uRL2 = new URL(string2.substring(0, n));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("The given url doesn't point to a file path: " + uRL);
        }
        String string3 = string2.substring(n + 1, string2.length());
        FileOperUtility.urlFile2LocalFile(uRL2, string3, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(String string, String string2) throws IOException {
        Object object;
        File[] fileArray;
        File file;
        File file2;
        block21: {
            FileOutputStream fileOutputStream;
            block18: {
                boolean bl;
                file2 = new File(string);
                file = new File(string2);
                if (file2.isDirectory()) break block21;
                if (!FileOperUtility.isFileReadable(file2)) {
                    throw new IOException("Copy file failed. The source file is not readable: " + file2);
                }
                fileArray = file.getParentFile();
                if (!fileArray.exists() && !(bl = fileArray.mkdirs())) {
                    throw new IOException("Failed to create the parent directory for: " + string2);
                }
                object = null;
                fileOutputStream = null;
                try {
                    try {
                        object = new FileInputStream(file2);
                        fileOutputStream = new FileOutputStream(file);
                        byte[] byArray = new byte[1024];
                        while (true) {
                            int n;
                            if ((n = ((FileInputStream)object).read(byArray)) == -1) {
                                Object var10_12 = null;
                                if (object == null) break block18;
                                break;
                            }
                            fileOutputStream.write(byArray, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        throw new IOException("Failed to copy file: " + file2 + " to file: " + string2);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    if (object != null) {
                        try {
                            ((FileInputStream)object).close();
                        }
                        catch (IOException iOException) {
                            throw new IOException("Failed to close the input stream during file copy.");
                        }
                    }
                    if (fileOutputStream == null) throw throwable;
                    try {
                        fileOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new IOException("Failed to close the ouput stream during file copy.");
                    }
                }
                try {}
                catch (IOException iOException) {
                    throw new IOException("Failed to close the input stream during file copy.");
                }
                ((FileInputStream)object).close();
            }
            if (fileOutputStream != null) {
                try {}
                catch (IOException iOException) {
                    throw new IOException("Failed to close the ouput stream during file copy.");
                }
                fileOutputStream.close();
            }
        }
        if (!file2.isDirectory()) return;
        fileArray = file2.listFiles();
        if (!file.exists()) {
            file.mkdirs();
        }
        int i = 0;
        while (i < fileArray.length) {
            object = fileArray[i].getName();
            FileOperUtility.copyFile(fileArray[i].getCanonicalPath(), string2 + File.separator + (String)object);
            ++i;
        }
    }

    public static void copyFile(String string, String string2, String string3) throws IOException {
        File file = new File(string, string2);
        File file2 = new File(string3, string2);
        FileOperUtility.copyFile(file.toString(), file2.toString());
    }

    public static void copyJnlpFiles(JnlpPackageInfo jnlpPackageInfo, String string) throws IOException {
        boolean bl;
        File file = new File(string);
        if (file.isDirectory()) {
            FileOperUtility.deleteDirTree(file);
        }
        if (!(bl = file.mkdirs())) {
            throw new IOException("Failed to create the temp directory to copy jnlp files: " + string);
        }
        String string2 = jnlpPackageInfo.getJnlpFilePath();
        File file2 = new File(string2);
        try {
            FileOperUtility.copyFile(file2.getParent(), jnlpPackageInfo.getJnlpFileName(), string);
            Iterator iterator = jnlpPackageInfo.getJnlpRefFilePaths();
            String string3 = jnlpPackageInfo.getResourceDirPath();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (string4 == null) continue;
                FileOperUtility.copyFile(string3, string4, string);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to copy jnlp files into the temp directory: " + string);
        }
    }

    public static void copyCopyrightFiles(JnlpPackageInfo jnlpPackageInfo, String string) throws IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            FileOperUtility.deleteDirTree(file);
        }
        String string2 = "licenses" + File.separator + jnlpPackageInfo.getLocalizedJnlpInfo("en", "vendor") + File.separator + jnlpPackageInfo.getPackageName() + File.separator + jnlpPackageInfo.getVersion() + '.' + jnlpPackageInfo.getRelease();
        File file2 = new File(file, string2 = string2.replaceAll(" ", ""));
        boolean bl = file2.mkdirs();
        if (!bl) {
            throw new IOException("Failed to create the temp directory to copy copyright file(s): " + file2);
        }
        String string3 = jnlpPackageInfo.getLicenseDirPath();
        try {
            for (int i = 0; i < JnlpConstants.LOCALES.length; ++i) {
                String string4 = "LICENSE." + JnlpConstants.LOCALES[i];
                File file3 = new File(string3 + File.separator + string4);
                if (!FileOperUtility.isFileReadable(file3)) continue;
                FileOperUtility.copyFile(string3, string4, file2.toString());
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to copy license files into the temp directory: " + string);
        }
    }

    public static boolean isFileReadable(File file) {
        return file.isFile() && file.canRead();
    }

    public static boolean isDirectoryReadable(File file) {
        return file.isDirectory() && file.canRead();
    }

    public static boolean isDirectoryWritable(File file) {
        return file.isDirectory() && file.canWrite();
    }

    public static void deleteDirTree(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileOperUtility.deleteDirTree(fileArray[i]);
            }
            file.delete();
        } else if (file.exists()) {
            file.delete();
        }
    }

    public static String getFileNameWithoutExt(File file) {
        int n;
        String string = null;
        String string2 = file.getName();
        if (string2 != null && (n = string2.lastIndexOf(46)) != -1 && n != string2.length()) {
            string = string2.substring(0, n);
        }
        return string;
    }

    public static String createUniqueTmpDir() throws IOException {
        String string = null;
        try {
            File file = new File(System.getProperty("java.io.tmpdir"));
            File file2 = File.createTempFile("jnlp", "jnlp", file);
            string = FileOperUtility.formatPath(file2.toString());
            file2.delete();
            file2 = new File(string);
            file2.mkdirs();
            file2.deleteOnExit();
        }
        catch (IOException iOException) {
            throw new IOException("Failed to create a local temp directory: " + string);
        }
        return string;
    }

    public static File httpJnlp2localJnlp(URL uRL, String string) throws IOException {
        String string2 = uRL.toString();
        String string3 = null;
        int n = 0;
        n = string2.lastIndexOf("/");
        if (n != 0) {
            string3 = string2.substring(n, string2.length());
        }
        File file = new File(string + string3);
        try {
            FileOperUtility.urlFile2LocalFile(uRL, string);
        }
        catch (IOException iOException) {
            throw new IOException("Failed to retrieve the http jnlp file locally: " + file);
        }
        return file;
    }

    public static void httpJnlpRes2localRes(JnlpPackageInfo jnlpPackageInfo, String string) throws IOException {
        Iterator iterator;
        Iterator iterator2;
        String string2 = jnlpPackageInfo.getJnlpFileHref();
        String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
        iterator = iterator2 = (iterator = jnlpPackageInfo.getJnlpRefFilePaths());
        while (iterator.hasNext()) {
            String string4 = null;
            URL uRL = null;
            String string5 = null;
            String string6 = (String)iterator.next();
            try {
                string5 = string3 + string6;
                uRL = new URL(string5);
                string6 = string6.replace('/', '\\');
                String string7 = string + "\\" + string6;
                string4 = string7.substring(0, string7.lastIndexOf("\\"));
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException("Failed to construct an URL: " + string5);
            }
            try {
                FileOperUtility.urlFile2LocalFile(uRL, string4);
            }
            catch (IOException iOException) {
                throw new IOException("Failed to retrieve jnlp resource file locally: " + uRL);
            }
        }
    }

    public static String formatPath(String string) {
        String string2 = null;
        string2 = string + (string.endsWith(File.separator) ? "" : File.separator);
        return string2;
    }
}

