/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.jdesktop.jdic.packager.impl.FileOperUtility;
import org.jdesktop.jdic.packager.impl.JnlpConstants;
import org.jdesktop.jdic.packager.impl.JnlpPackageInfo;
import org.jdesktop.jdic.packager.impl.PackageGenerator;
import org.jdesktop.jdic.packager.impl.WinMsiUtility;
import org.jdesktop.jdic.packager.impl.WinMsiWrapper;
import org.jdesktop.jdic.packager.impl.WinUtility;

public class MsiPackageGenerator
implements PackageGenerator {
    private static final String SYS_JAR_FILE_NAME = "packager.jar";
    private static final String JNLP_FILES_JAR_NAME = "JnlpFiles.jar";
    private static final String MSI_SUPPORT_FILES_HIERARCHY_PATH = "org/jdesktop/jdic/packager/impl/files/";
    private static final String MAKECAB_EXE_PATH = "Samples\\sysmgmt\\msi\\Patching\\makecab.exe";
    private static final String MSIDB_EXE_PATH = "bin\\msidb.exe";
    private static final String SYS_BOOTSTRAPPER_FILE_PATH = "org/jdesktop/jdic/packager/impl/files/bootstrapper.exe";
    private static final String CUSTOM_DLL_FILE_NAME = "custom.dll";
    private static final String LOCALIZED_WELCOME_MSG_FILE_NAME = "WelcomeMsg.idt";
    public static final String LOCALIZED_WELCOME_MSG_TABLE_NAME = "WelcomeMsg";
    private static final String PANEL_JPG_FILE_NAME = "panel.jpg";
    private static final String BANNER_JPG_FILE_NAME = "banner.jpg";
    private static final String JAVA_HOME_DIR_PROPERTY = "java.home";
    private static final String SYS_CLASS_PATH = "java.class.path";
    private static final String AUTHOR_INFO = "http://jdic.dev.java.net";
    private static final int VI_CONTROL_TEXT = 10;
    private static final int VI_CONTROLEVENT_ARGUMENT = 4;
    private static final int VI_CONTROLEVENT_EVENT = 3;
    private static final int VI_PROPERTY_VALUE = 2;
    private static final int PID_REVISION_NUMBER = 9;
    private static final int PID_AUTHOR = 4;
    private static String packagerJarFilePath = null;

    private static void getPackagerJarFilePath() throws IOException {
        String string = System.getProperty(SYS_CLASS_PATH);
        int n = string.indexOf(SYS_JAR_FILE_NAME);
        int n2 = -1;
        int n3 = n;
        while (n3 > 0) {
            char c;
            if ((c = string.charAt(--n3)) != ';' && n3 != 0) continue;
            n2 = n3;
            break;
        }
        if (n2 > 0) {
            packagerJarFilePath = string.substring(n2 + 1, n + SYS_JAR_FILE_NAME.length());
        } else if (n2 == 0) {
            packagerJarFilePath = string.substring(n2, n + SYS_JAR_FILE_NAME.length());
        } else {
            throw new IOException("Could not locate packager.jar in system CLASSPATH setting!");
        }
    }

    private static void adjustMsiLicenseFields(String string, JnlpPackageInfo jnlpPackageInfo, int n) throws IOException {
        String string2;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (jnlpPackageInfo.getShowLicense()) {
            try {
                string2 = new String();
                string2 = string2 + "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deftab720{\\fonttbl{\\f0\\froman\\fprq2 Times New Roman;}}{\\colortbl\\red0\\green0\\blue0;} \\deflang1033\\horzdoc{\\*\\fchars }{\\*\\lchars }\\pard\\plain\\f0\\fs20";
                File file = new File(jnlpPackageInfo.getLicenseDirPath() + File.separator + JnlpConstants.LOCALES[n] + ".txt");
                if (!file.exists()) {
                    file = new File(jnlpPackageInfo.getLicenseDirPath() + File.separator + JnlpConstants.LOCALES[0] + ".txt");
                }
                FileInputStream fileInputStream = new FileInputStream(file);
                int n2 = (int)file.length();
                byte[] byArray = new byte[n2];
                fileInputStream.read(byArray, 0, n2);
                fileInputStream.close();
                string2 = string2 + new String(byArray);
                string2 = string2 + "\\par }";
                treeMap.clear();
                treeMap.put("AgreementText", string2);
                WinMsiUtility.winMsiSetProperty(string, "Control", "Control", 10, false, treeMap);
            }
            catch (IOException iOException) {
                throw new IOException("License Agreement: Modify Control Table failed: Set MSI LicenseAgreement field property failed!");
            }
            try {
                treeMap.clear();
                treeMap.put("AfterWelcomeDlg", "LicenseAgreementDlg");
                WinMsiUtility.winMsiSetProperty(string, "ControlEvent", "Argument", 4, false, treeMap);
            }
            catch (IOException iOException) {
                throw new IOException("License Agreement: Modify ControlEvent Table failed: Insert License Agreement dialog failed!");
            }
        }
        try {
            treeMap.clear();
            treeMap.put("AfterWelcomeDlg", "EndDialog");
            WinMsiUtility.winMsiSetProperty(string, "ControlEvent", "Argument", 3, false, treeMap);
        }
        catch (IOException iOException) {
            throw new IOException("No License Agreement: Modify ControlEvent Table failed: AfterWelcomeDlg/EndDialog");
        }
        try {
            treeMap.clear();
            treeMap.put("AfterWelcomeDlg", "Return");
            WinMsiUtility.winMsiSetProperty(string, "ControlEvent", "Argument", 4, false, treeMap);
        }
        catch (IOException iOException) {
            throw new IOException("No License Agreement: Modify ControlEvent Table failed: AfterWelcomeDlg/Return");
        }
        string2 = WinMsiUtility.getWelcomeMsg(string, JnlpConstants.LOCALES[n], jnlpPackageInfo.getShowLicense());
        try {
            treeMap.clear();
            treeMap.put("SunButton", "[ButtonText_Next]");
            treeMap.put("WelcomeDescription", string2);
            WinMsiUtility.winMsiSetProperty(string, "Control", "Text", 10, false, treeMap);
        }
        catch (IOException iOException) {
            throw new IOException("Handling Agreement: Modify Control Table failed: Next Button/WelcomeDescription");
        }
    }

    private static void customizeNonLocalizedMsiFields(String string, JnlpPackageInfo jnlpPackageInfo) throws IOException {
        String string2;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string3 = "{" + WinMsiUtility.genUUID() + "}";
        String string4 = "{" + WinMsiUtility.genUUID() + "}";
        try {
            treeMap.clear();
            treeMap.put("ARPCONTACT", AUTHOR_INFO);
            treeMap.put("ARPHELPLINK", AUTHOR_INFO);
            treeMap.put("ARPURLINFOABOUT", AUTHOR_INFO);
            treeMap.put("ARPURLUPDATEINFO", AUTHOR_INFO);
            treeMap.put("ARPCOMMENTS", "Generated by JDIC Project");
            treeMap.put("ProductCode", string3);
            treeMap.put("UpgradeCode", string4);
            treeMap.put("ProductVersion", jnlpPackageInfo.getVersion() + "." + jnlpPackageInfo.getRelease());
            treeMap.put("JnlpFileName", jnlpPackageInfo.getJnlpFileName());
            treeMap.put("UninstallInfo", jnlpPackageInfo.getJnlpFileHref());
            treeMap.put("Shortcut", jnlpPackageInfo.getShortcutEnabled() ? "1" : "0");
            treeMap.put("Association", jnlpPackageInfo.getAssociationEnabled() ? "1" : "0");
            treeMap.put("CacheType", jnlpPackageInfo.getSystemCacheEnabled() ? "system" : "user");
            WinMsiUtility.winMsiSetProperty(string, "Property", "Property", 2, false, treeMap);
        }
        catch (IOException iOException) {
            throw new IOException("Set MSI field property failed!");
        }
        try {
            WinMsiUtility.setSummaryInfoProperty(string, 9, string3);
            WinMsiUtility.setSummaryInfoProperty(string, 4, AUTHOR_INFO);
        }
        catch (IOException iOException) {
            throw new IOException("Set MSI summary information stream failed!");
        }
        String[] stringArray = new String[]{"Name", "Data"};
        String[] stringArray2 = new String[]{"String", "Stream"};
        String[] stringArray3 = new String[2];
        try {
            string2 = jnlpPackageInfo.getUniqueTmpDirPath() + CUSTOM_DLL_FILE_NAME;
            WinUtility.extractFileFromJarFile(packagerJarFilePath, "org/jdesktop/jdic/packager/impl/files/custom.dll", string2);
            stringArray3[0] = "CustomDLL";
            stringArray3[1] = string2;
            WinMsiUtility.addBinaryRecord(string, "Binary", stringArray, stringArray2, stringArray3);
        }
        catch (IOException iOException) {
            throw new IOException("Binary: insert CustomDLL field failed!");
        }
        try {
            string2 = jnlpPackageInfo.getUniqueTmpDirPath() + JNLP_FILES_JAR_NAME;
            WinUtility.jarJnlpFiles(string2, jnlpPackageInfo);
            stringArray3[0] = "JarPack";
            stringArray3[1] = string2;
            WinMsiUtility.addBinaryRecord(string, "Binary", stringArray, stringArray2, stringArray3);
        }
        catch (IOException iOException) {
            throw new IOException("Binary: insert JarPack field failed!");
        }
        treeMap.clear();
        try {
            string2 = jnlpPackageInfo.getUniqueTmpDirPath() + BANNER_JPG_FILE_NAME;
            if (jnlpPackageInfo.getBannerJpgFilePath() != null) {
                string2 = jnlpPackageInfo.getBannerJpgFilePath();
            } else {
                WinUtility.extractFileFromJarFile(packagerJarFilePath, "org/jdesktop/jdic/packager/impl/files/banner.jpg", string2);
            }
            treeMap.put("bannrbmp", string2);
        }
        catch (IOException iOException) {
            throw new IOException("Binary: pre insert bannrbmp field failed!");
        }
        try {
            string2 = jnlpPackageInfo.getUniqueTmpDirPath() + PANEL_JPG_FILE_NAME;
            if (jnlpPackageInfo.getPanelJpgFilePath() != null) {
                string2 = jnlpPackageInfo.getPanelJpgFilePath();
            } else {
                WinUtility.extractFileFromJarFile(packagerJarFilePath, "org/jdesktop/jdic/packager/impl/files/panel.jpg", string2);
            }
            treeMap.put("dlgbmp", string2);
        }
        catch (IOException iOException) {
            throw new IOException("Binary: pre insert dlgbmp field failed!");
        }
        try {
            WinMsiUtility.winMsiSetProperty(string, "Binary", "Name", 2, true, treeMap);
        }
        catch (IOException iOException) {
            throw new IOException("Binary: insert bannrbmp and dlgbmp field failed!");
        }
    }

    private static void createTemplateMsiFile(String string, JnlpPackageInfo jnlpPackageInfo) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("CREATE TABLE Directory (Directory CHAR(72) NOT NULL, Directory_Parent CHAR(72), DefaultDir CHAR(255) NOT NULL LOCALIZABLE PRIMARY KEY Directory)");
        arrayList.add("INSERT INTO Directory (Directory, Directory_Parent, DefaultDir) VALUES ('TARGETDIR', '', 'SourceDir')");
        arrayList.add("INSERT INTO Directory (Directory, Directory_Parent, DefaultDir) VALUES ('ProgramFilesFolder', 'TARGETDIR', '.:PROGRA~1|program files')");
        arrayList.add("INSERT INTO Directory (Directory, Directory_Parent, DefaultDir) VALUES ('INSTALLDIR', 'TempFolder', '.')");
        arrayList.add("INSERT INTO Directory (Directory, Directory_Parent, DefaultDir) VALUES ('TempFolder', 'TARGETDIR', '.:Temp')");
        arrayList.add("CREATE TABLE Component (Component CHAR(72) NOT NULL, ComponentId CHAR(38), Directory_ CHAR(72) NOT NULL, Attributes INT NOT NULL, Condition CHAR(255), KeyPath CHAR(72) PRIMARY KEY Component)");
        arrayList.add("INSERT INTO Component (Component, ComponentId, Directory_, Attributes, Condition, KeyPath) VALUES ('AllOtherFiles', '{31CCF52F-FCB3-4239-9D82-05CDA204867A}', 'INSTALLDIR', 8, '', '')");
        arrayList.add("CREATE TABLE File (File CHAR(72) NOT NULL, Component_ CHAR(72) NOT NULL, FileName CHAR(255) NOT NULL LOCALIZABLE, FileSize LONG NOT NULL, Version CHAR(72), Language CHAR(20), Attributes INT, Sequence INT NOT NULL PRIMARY KEY File)");
        arrayList.add("INSERT INTO File (File, Component_, FileName, FileSize, Version, Language, Attributes, Sequence) VALUES ('place.txt', 'AllOtherFiles', 'place.txt', 18, '', '', 16384, 1)");
        arrayList.add("CREATE TABLE Media (DiskId INT NOT NULL, LastSequence INT NOT NULL, DiskPrompt CHAR(64) LOCALIZABLE, Cabinet CHAR(255), VolumeLabel CHAR(32), Source CHAR(72) PRIMARY KEY DiskId)");
        arrayList.add("INSERT INTO Media (DiskId, LastSequence, DiskPrompt, Cabinet, VolumeLabel, Source) VALUES (1, 1, '', '#Data1.cab', '', '')");
        arrayList.add("CREATE TABLE Feature (Feature CHAR(38) NOT NULL, Feature_Parent CHAR(38), Title CHAR(64) LOCALIZABLE, Description CHAR(255) LOCALIZABLE, Display INT, Level INT NOT NULL, Directory_ CHAR(72), Attributes INT NOT NULL PRIMARY KEY Feature)");
        arrayList.add("INSERT INTO Feature (Feature, Feature_Parent, Title, Description, Display, Level, Directory_ , Attributes) VALUES ('NewFeature1', '', 'NewFeature1', '', 2, 1, 'INSTALLDIR', 0)");
        arrayList.add("CREATE TABLE FeatureComponents (Feature_ CHAR(38) NOT NULL, Component_ CHAR(72) NOT NULL PRIMARY KEY Feature_, Component_)");
        arrayList.add("INSERT INTO FeatureComponents (Feature_, Component_) VALUES ('NewFeature1', 'AllOtherFiles')");
        arrayList.add("CREATE TABLE CustomAction(Action CHAR(72) NOT NULL, Type INT NOT NULL, Source CHAR(72), Target CHAR(255) PRIMARY KEY Action)");
        arrayList.add("INSERT INTO CustomAction (Action,Type,Source,Target) VALUES ('CustomInstallAction', 1, 'CustomDLL', 'InstallAction')");
        arrayList.add("INSERT INTO CustomAction (Action,Type,Source,Target) VALUES ('CustomUninstallAction', 1, 'CustomDLL', 'UninstallAction')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('Manufacturer','http://jdic.dev.java.net')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('ProductCode', '{3D11E9FC-142F-4945-8010-861EAA24850F}')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('ProductName','Default')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('ProductVersion','1.00.0000')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('UpgradeCode', '{20AC1669-B481-4CAD-82AF-2CD00005F304}')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('JnlpFileName','ok')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('UninstallInfo','ok')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('Locale','en')");
        arrayList.add("UPDATE Property SET Value='http://jdic.dev.java.net' where Property='ARPHELPLINK'");
        arrayList.add("UPDATE Property SET Value='http://jdic.dev.java.net' where Property='ComponentDownload'");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('ARPCONTACT','http://jdic.dev.java.net')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('ARPURLINFOABOUT','http://jdic.dev.java.net')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('ARPURLUPDATEINFO','http://jdic.dev.java.net')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('ARPCOMMENTS','Generated by JDIC Project')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('Shortcut','yes')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('Association','yes')");
        arrayList.add("INSERT INTO Property (Property,Value) VALUES ('CacheType','user')");
        arrayList.add("INSERT INTO InstallExecuteSequence (Action, Condition, Sequence) VALUES ('CustomInstallAction', 'NOT Installed', 6650)");
        arrayList.add("INSERT INTO InstallExecuteSequence (Action, Condition, Sequence) VALUES ('CustomUninstallAction', 'Installed', 6651)");
        arrayList.add("UPDATE Dialog SET Control_Cancel='RemoveButton' where Dialog='MaintenanceTypeDlg'");
        arrayList.add("UPDATE Control SET Attributes=0 where Dialog_='MaintenanceTypeDlg' and Control='ChangeLabel'");
        arrayList.add("UPDATE Control SET Attributes=5767168 where Dialog_='MaintenannceTypeDlg' and Control='ChangeButton'");
        arrayList.add("UPDATE Control SET Attributes=0 where Dialog_='MaintenanceTypeDlg' and Control='ChangeText'");
        arrayList.add("UPDATE Control SET Attributes=0 where Dialog_='MaintenanceTypeDlg' and Control='RepairLabel'");
        arrayList.add("UPDATE Control SET Attributes=5767168 where Dialog_='MaintenanceTypeDlg' and Control='RepairButton'");
        arrayList.add("UPDATE Control SET Attributes=0 where Dialog_='MaintenanceTypeDlg' and Control='RepairText'");
        arrayList.add("UPDATE Control SET Y=65 where Dialog_='MaintenanceTypeDlg' and Control='RemoveButton'");
        arrayList.add("UPDATE Control SET Y=65 where Dialog_='MaintenanceTypeDlg' and Control='RemoveLabel'");
        arrayList.add("UPDATE Control SET Y=78 where Dialog_='MaintenanceTypeDlg' and Control='RemoveText'");
        arrayList.add("UPDATE Control SET Y=78 where Dialog_='MaintenanceTypeDlg' and Control='RemoveText'");
        arrayList.add("UPDATE Control SET Text='[DlgTitleFont]Remove installation' where Dialog_='MaintenanceTypeDlg' and Control='Title'");
        arrayList.add("UPDATE Control SET Attributes=196608 where Dialog_='MaintenanceTypeDlg' and Control='Description'");
        arrayList.add("UPDATE Control SET Text='The [Wizard] is ready to begin the installation' where Dialog_='VerifyReadyDlg' and Control='Description'");
        arrayList.add("UPDATE Control SET Text='Click Install to begin the installation. Click Cancel to exit the wizard.' where Dialog_='VerifyReadyDlg' and Control='Text'");
        arrayList.add("UPDATE Control SET Text='The [Wizard] will allow you toremove [ProductName] from your computer. Click Next to continue or Cancel to exit the [Wizard].' where Dialog_='MaintenanceWelcomeDlg' and Control='Description'");
        arrayList.add("UPDATE Control SET Text='Click Remove to remove [ProductName] from your computer. Click Cancel to exit the wizard.' where Dialog_='VerifyRemoveDlg' and Control='Text'");
        arrayList.add("UPDATE Control SET Text='{\\DlgFontBold8}Remove [ProductName]' where Dialog_='VerifyRemoveDlg' and Control='Title'");
        arrayList.add("UPDATE Control SET Text='SunButton' where Dialog_='WelcomeDlg' and Control='Next'");
        arrayList.add("UPDATE Control SET Text='WelcomeDescription' where Dialog_='WelcomeDlg' and Control='Description'");
        arrayList.add("UPDATE Control SET Text='[ButtonText_Remove]' where Dialog_='MaintenanceWelcomeDlg' and Control='Next'");
        arrayList.add("UPDATE Control SET Text='The [Wizard] will allow you to remove [ProductName] from your computer. Click Remove to continue or Cancel to exit the [Wizard].' where Dialog_='MaintenanceWelcomeDlg' and Control='Description'");
        arrayList.add("DELETE FROM ControlEvent where Dialog_='WelcomeDlg' and Control_='Next'");
        arrayList.add("INSERT INTO ControlEvent (Dialog_, Control_, Event, Argument, Condition) VALUES ('WelcomeDlg', 'Next', 'NewDialog', 'AfterWelcomeDlg', 1)");
        arrayList.add("DELETE from ControlEvent where Dialog_='LicenseAgreementDlg' and Control_='Next' and Event='NewDialog'");
        arrayList.add("INSERT INTO ControlEvent (Dialog_, Control_,Event, Argument, Condition, Ordering) VALUES ('LicenseAgreementDlg', 'Next', 'EndDialog', 'Return', 'IAgree = \"Yes\"', 1)");
        arrayList.add("DELETE FROM ControlEvent where Dialog_='MaintenanceWelcomeDlg' and Control_='Next'");
        arrayList.add("INSERT INTO ControlEvent (Dialog_, Control_, Event, Argument, Condition, Ordering) VALUES ('MaintenanceWelcomeDlg', 'Next', '[InstallMode]', 'Remove', '1', 1)");
        arrayList.add("INSERT INTO ControlEvent (Dialog_, Control_, Event, Argument, Condition, Ordering) VALUES ('MaintenanceWelcomeDlg', 'Next', '[Progress1]', 'Removing', '1', 2)");
        arrayList.add("INSERT INTO ControlEvent (Dialog_, Control_, Event, Argument, Condition, Ordering) VALUES ('MaintenanceWelcomeDlg', 'Next', '[Progress2]', 'removes', '1', 3)");
        arrayList.add("INSERT INTO ControlEvent (Dialog_, Control_, Event, Argument, Condition, Ordering) VALUES ('MaintenanceWelcomeDlg', 'Next', 'SpawnWaitDialog', 'WaitForCostingDlg', 'CostingComplete = 1', 4)");
        arrayList.add("INSERT INTO ControlEvent (Dialog_, Control_, Event, Argument, Condition, Ordering) VALUES ('MaintenanceWelcomeDlg', 'Next', 'Remove', 'All', '1', 5)");
        arrayList.add("INSERT INTO ControlEvent (Dialog_, Control_, Event, Argument, Condition, Ordering) VALUES ('MaintenanceWelcomeDlg', 'Next', 'EndDialog', 'Return', '1', 6)");
        WinMsiUtility.runSql(string, arrayList);
        File file = new File(jnlpPackageInfo.getUniqueTmpDirPath() + "place.txt");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        String string2 = new String(AUTHOR_INFO);
        byte[] byArray = string2.getBytes();
        fileOutputStream.write(byArray, 0, string2.length());
        fileOutputStream.close();
        String string3 = jnlpPackageInfo.getMSSDKDirPath() + MAKECAB_EXE_PATH;
        String string4 = jnlpPackageInfo.getMSSDKDirPath() + MSIDB_EXE_PATH;
        File file2 = new File(string3);
        if (!file2.exists()) {
            throw new IOException("Can not locate makecab.exe at" + string3);
        }
        file2 = new File(string4);
        if (!file2.exists()) {
            throw new IOException("Can not locate msidb.exe at" + string4);
        }
        String string5 = jnlpPackageInfo.getUniqueTmpDirPath() + "Data1.cab";
        WinMsiWrapper.winNativeCreateProcess("\"" + string3 + "\" " + file.toString() + " " + string5);
        WinMsiWrapper.winNativeCreateProcess("\"" + string4 + "\" -d " + string + " -a " + string5);
        String string6 = jnlpPackageInfo.getUniqueTmpDirPath() + LOCALIZED_WELCOME_MSG_FILE_NAME;
        String string7 = "org/jdesktop/jdic/packager/impl/files/WelcomeMsg.idt";
        WinUtility.extractFileFromJarFile(packagerJarFilePath, string7, string6);
        WinMsiUtility.importTableFromFile(string, jnlpPackageInfo.getUniqueTmpDirPath(), LOCALIZED_WELCOME_MSG_FILE_NAME);
    }

    public final void generatePackage(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        MsiPackageGenerator.getPackagerJarFilePath();
        String string = jnlpPackageInfo.getUniqueTmpDirPath() + "en.msi";
        String string2 = jnlpPackageInfo.getRawMsiFilePath();
        FileOperUtility.copyFile(string2, string);
        MsiPackageGenerator.createTemplateMsiFile(string, jnlpPackageInfo);
        MsiPackageGenerator.customizeNonLocalizedMsiFields(string, jnlpPackageInfo);
        this.putProductNameIntoMsi(string, jnlpPackageInfo, 0);
        MsiPackageGenerator.adjustMsiLicenseFields(string, jnlpPackageInfo, 0);
        if (jnlpPackageInfo.getLocalizationEnabled()) {
            for (int i = 1; i < JnlpConstants.LOCALES.length; ++i) {
                String string3 = jnlpPackageInfo.getUniqueTmpDirPath() + JnlpConstants.LOCALES[i] + ".msi";
                FileOperUtility.copyFile(string, string3);
                this.importLocalizedTables(string3, jnlpPackageInfo, i);
                this.putProductNameIntoMsi(string3, jnlpPackageInfo, i);
                MsiPackageGenerator.adjustMsiLicenseFields(string3, jnlpPackageInfo, i);
            }
        }
        this.generateBootStrapper(jnlpPackageInfo);
    }

    public final void importLocalizedTables(String string, JnlpPackageInfo jnlpPackageInfo, int n) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("DROP TABLE ActionText");
        arrayList.add("DROP TABLE Error");
        arrayList.add("DROP TABLE Control");
        arrayList.add("DROP TABLE ControlEvent");
        WinMsiUtility.runSql(string, arrayList);
        String string2 = "Control." + JnlpConstants.LOCALES_SUFFIX[n];
        String string3 = jnlpPackageInfo.getUniqueTmpDirPath() + string2;
        String string4 = "ControlEvent." + JnlpConstants.LOCALES_SUFFIX[n];
        String string5 = jnlpPackageInfo.getUniqueTmpDirPath() + string4;
        WinUtility.extractFileFromJarFile(packagerJarFilePath, MSI_SUPPORT_FILES_HIERARCHY_PATH + string2, string3);
        WinUtility.extractFileFromJarFile(packagerJarFilePath, MSI_SUPPORT_FILES_HIERARCHY_PATH + string4, string5);
        WinMsiUtility.importTableFromFile(string, jnlpPackageInfo.getUniqueTmpDirPath(), "ActionTe." + JnlpConstants.LOCALES_SUFFIX[n]);
        WinMsiUtility.importTableFromFile(string, jnlpPackageInfo.getUniqueTmpDirPath(), "Error" + JnlpConstants.LOCALES_SUFFIX[n]);
        WinMsiUtility.importTableFromFile(string, jnlpPackageInfo.getUniqueTmpDirPath(), string2);
        WinMsiUtility.importTableFromFile(string, jnlpPackageInfo.getUniqueTmpDirPath(), string4);
    }

    public final void putProductNameIntoMsi(String string, JnlpPackageInfo jnlpPackageInfo, int n) throws IOException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        try {
            treeMap.clear();
            treeMap.put("ProductName", jnlpPackageInfo.getLocalizedJnlpInfo(JnlpConstants.LOCALES[n], "title"));
            treeMap.put("Locale", JnlpConstants.LOCALES[n]);
            WinMsiUtility.winMsiSetProperty(string, "Property", "Property", 2, false, treeMap);
        }
        catch (IOException iOException) {
            throw new IOException("Property Table: Modify ProductName field failed!");
        }
    }

    public final void generateBootStrapper(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        String string;
        String string2;
        String string3 = jnlpPackageInfo.getUniqueTmpDirPath() + JnlpConstants.LOCALES[0] + ".msi";
        if (jnlpPackageInfo.getLocalizationEnabled()) {
            for (int i = 1; i < JnlpConstants.LOCALES.length; ++i) {
                string2 = jnlpPackageInfo.getUniqueTmpDirPath() + JnlpConstants.LOCALES[i] + ".msi";
                string = jnlpPackageInfo.getUniqueTmpDirPath() + JnlpConstants.LOCALES[i] + ".mst";
                WinMsiUtility.generateTransform(string3, string2, string);
            }
            for (int i = 1; i < JnlpConstants.LOCALES.length; ++i) {
                string = jnlpPackageInfo.getUniqueTmpDirPath() + JnlpConstants.LOCALES[i] + ".mst";
                String string4 = "cust_" + JnlpConstants.LOCALES[i];
                WinMsiUtility.incorporateMST(string3, string, string4);
            }
        }
        string2 = jnlpPackageInfo.getUniqueTmpDirPath() + jnlpPackageInfo.getPackageName() + ".exe";
        WinUtility.extractFileFromJarFile(packagerJarFilePath, SYS_BOOTSTRAPPER_FILE_PATH, string2);
        string = WinMsiUtility.genUUID();
        WinUtility.updateResourceString(string2, string, 1600);
        WinUtility.updateResourceData(string2, string3, 104);
        String string5 = jnlpPackageInfo.getLocalizationEnabled() ? "localization supported" : "no localization support";
        WinUtility.updateResourceString(string2, string5, 1760);
        String string6 = jnlpPackageInfo.getOutputDirPath() + jnlpPackageInfo.getPackageName() + ".exe";
        FileOperUtility.copyFile(string2, string6);
        File file = new File(string6);
        if (file.exists()) {
            System.out.println("\nSuccess: The bootstrapper MSI file has been generated at: \n" + string6 + "\n");
        }
        File file2 = new File(jnlpPackageInfo.getUniqueTmpDirPath());
        FileOperUtility.deleteDirTree(file2);
    }
}

