/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.xp;

import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

public class XPMenuPatch
implements LookAndFeelPatch {
    public boolean isApplicable(Environment env) {
        return env.isWindowsLookAndFeel() && env.isWindowsXPThemed();
    }

    public void patch(Environment env) {
        UIDefaults defaults = UIManager.getDefaults();
        defaults.put("PopupMenu.border", this.createPopupMenuBorder());
        defaults.put("SeparatorUI", "net.java.plaf.windows.xp.XPSeparatorUI");
        defaults.put("PopupMenuSeparatorUI", "net.java.plaf.windows.xp.XPPopupMenuSeparatorUI");
        defaults.put("Menu.disabledForeground", defaults.get("MenuItem.disabledForeground"));
        defaults.put("MenuUI", "net.java.plaf.windows.xp.XPMenuUI");
        defaults.put("MenuItem.margin", new InsetsUIResource(1, 0, 1, 2));
        defaults.put("Menu.margin", new InsetsUIResource(1, 1, 1, 2));
        defaults.put("CheckBoxMenuItem.margin", new InsetsUIResource(1, 1, 1, 2));
        defaults.put("RadioButtonMenuItem.margin", new InsetsUIResource(1, 4, 1, 2));
    }

    private Border createPopupMenuBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("controlShadow")), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public void unpatch() {
    }
}

