/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.jdesktop.jdic.packager.impl.FileOperUtility;
import org.jdesktop.jdic.packager.impl.JnlpPackageInfo;
import org.jdesktop.jdic.packager.impl.JnlpParser;
import org.jdesktop.jdic.packager.impl.PackageGenerator;
import org.jdesktop.jdic.packager.impl.PackageGeneratorFactory;

public final class Jnlp2Package {
    private Jnlp2Package() {
    }

    private static boolean getBoolProperty(String string) {
        String string2 = System.getProperty(string);
        boolean bl = false;
        if (string2 == null) {
            bl = false;
        } else if (string2.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string2.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new IllegalArgumentException("The value of property " + string + " can only be either true or false.");
        }
        return bl;
    }

    private static JnlpPackageInfo parseArguments(String[] stringArray) throws IOException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Please specify the jnlp file path.");
        }
        JnlpPackageInfo jnlpPackageInfo = new JnlpPackageInfo();
        jnlpPackageInfo.setJnlpFilePath(Jnlp2Package.getValidFileArgument(stringArray[0], "jnlp file path", false));
        Jnlp2Package.checkJnlpFilePathArgument(jnlpPackageInfo);
        Jnlp2Package.checkResourcePathArgument(jnlpPackageInfo);
        Jnlp2Package.checkPackageNameArgument(jnlpPackageInfo);
        Jnlp2Package.checkOutputDirNameArgument(jnlpPackageInfo);
        string = System.getProperty("Version");
        if (string == null) {
            string = "1.0";
        }
        jnlpPackageInfo.setVersion(string);
        string2 = System.getProperty("Release");
        if (string2 == null) {
            string2 = "1";
        }
        jnlpPackageInfo.setRelease(string2);
        string3 = System.getProperty("LicenseDir");
        string3 = Jnlp2Package.getValidFileArgument(string3, "license directory", true);
        if (string3 != null) {
            bl = true;
        }
        jnlpPackageInfo.setShowLicense(bl);
        jnlpPackageInfo.setLicenseDirPath(string3);
        string4 = System.getProperty("BannerJpgFile");
        string4 = Jnlp2Package.getValidFileArgument(string4, "Banner Jpeg File", true);
        jnlpPackageInfo.setBannerJpgFilePath(string4);
        string5 = System.getProperty("PanelJpgFile");
        string5 = Jnlp2Package.getValidFileArgument(string5, "Panel Jpeg File", true);
        jnlpPackageInfo.setPanelJpgFilePath(string5);
        Jnlp2Package.checkMSSDKPathArgument(jnlpPackageInfo);
        bl2 = Jnlp2Package.getBoolProperty("EnableShortcut");
        jnlpPackageInfo.setShortcutEnabled(bl2);
        bl3 = Jnlp2Package.getBoolProperty("EnableAssociation");
        jnlpPackageInfo.setAssociationEnabled(bl3);
        bl4 = Jnlp2Package.getBoolProperty("EnableSystemCache");
        jnlpPackageInfo.setSystemCacheEnabled(bl4);
        try {
            jnlpPackageInfo.parseJnlpInfo();
        }
        catch (Exception exception) {
            return null;
        }
        return jnlpPackageInfo;
    }

    private static String getValidFileArgument(String string, String string2, boolean bl) throws IOException {
        if (string == null) {
            if (bl) {
                return null;
            }
            throw new IllegalArgumentException(string2 + " could not be null.");
        }
        File file = new File(string);
        if ((file = file.getCanonicalFile()).canRead()) {
            return file.toString();
        }
        throw new IllegalArgumentException("The given " + string2 + " is not valid: " + string);
    }

    private static void checkJnlpFilePathArgument(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        String string = jnlpPackageInfo.getJnlpFilePath();
        if (!string.endsWith(".jnlp")) {
            throw new IllegalArgumentException("The jnlp file path doesn't points to a valid .jnlp file.");
        }
        File file = new File(string);
        String string2 = null;
        String string3 = null;
        string2 = JnlpParser.parseJnlpInfo(file, "codebase");
        if (string2 == null) {
            throw new IOException("Cann't retrieve the codebase information from the given jnlp file.");
        }
        String string4 = JnlpParser.parseJnlpHref(file);
        if (string4 == null) {
            throw new IOException("Cann't retrieve the href information from the given jnlp file.");
        }
        Object object = file.getName();
        if (!((String)object).equals(string4)) {
            throw new IOException("The given jnlp file name is different from its href value: " + string4);
        }
        if (!string2.endsWith("/")) {
            string2 = string2.concat(File.separator);
        }
        string3 = string2 + string4;
        object = JnlpParser.parseJnlpRefFiles(file);
        if (object == null) {
            throw new IOException("Cann't retrieve the jnlp resource files information from the given jnlp file.");
        }
        jnlpPackageInfo.setJnlpFileHref(string3);
        jnlpPackageInfo.setJnlpRefFilePaths((List)object);
    }

    private static void checkResourcePathArgument(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        Object object;
        String string = System.getProperty("ResourceDir");
        String string2 = jnlpPackageInfo.getJnlpFilePath();
        File file = new File(string2);
        if (string == null) {
            object = file.getParent();
            string = Jnlp2Package.getValidFileArgument((String)object, "resource dir", false);
        } else {
            string = Jnlp2Package.getValidFileArgument(string, "resource dir", false);
        }
        object = new File(string);
        Iterator iterator = jnlpPackageInfo.getJnlpRefFilePaths();
        while (iterator.hasNext()) {
            File file2;
            String string3 = (String)iterator.next();
            if (string3 == null || FileOperUtility.isFileReadable(file2 = new File((File)object, string3))) continue;
            throw new IllegalArgumentException("Cann't read resource file: " + string3 + " from resource path: " + ((File)object).toString());
        }
        jnlpPackageInfo.setResourcePath(string);
    }

    private static void checkPackageNameArgument(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        File file;
        String string = System.getProperty("PackageName");
        if (string == null && (string = FileOperUtility.getFileNameWithoutExt(file = new File(jnlpPackageInfo.getJnlpFilePath()))) == null) {
            throw new IllegalArgumentException("The given jnlp file name is not a valid package name.");
        }
        jnlpPackageInfo.setPackageName(string);
    }

    private static void checkMSSDKPathArgument(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = null;
        String string3 = null;
        if (string.startsWith("windows")) {
            string2 = System.getProperty("MSSDKDir");
            string2 = Jnlp2Package.getValidFileArgument(string2, "MS SDK Path", false);
            string2 = string2 + (string2.endsWith(File.separator) ? "" : File.separator);
            string3 = string2 + "Samples\\SysMgmt\\msi\\database\\UISample.Msi";
            string3 = Jnlp2Package.getValidFileArgument(string3, "raw MSI file path", false);
        }
        jnlpPackageInfo.setMSSDKDirPath(string2);
        jnlpPackageInfo.setRawMsiFilePath(string3);
    }

    private static void checkOutputDirNameArgument(JnlpPackageInfo jnlpPackageInfo) throws IOException {
        File file;
        String string = System.getProperty("OutputDir");
        if (string == null) {
            string = "." + File.separator;
        }
        if (!(string = Jnlp2Package.getValidFileArgument(string, "output dir", false)).endsWith(File.separator)) {
            string = string + File.separator;
        }
        if ((file = new File(string)).isDirectory()) {
            if (!file.canWrite()) {
                throw new IllegalArgumentException("The given package path is not writable: " + file);
            }
        } else {
            throw new IllegalArgumentException("The given output dir is not valid: " + file);
        }
        jnlpPackageInfo.setOutputDirPath(string);
    }

    public static void generatePackage(String[] stringArray) throws IOException {
        Object object;
        boolean bl = false;
        String string = null;
        if (stringArray[0].startsWith("http://")) {
            bl = true;
            string = FileOperUtility.createUniqueTmpDir();
            object = FileOperUtility.httpJnlp2localJnlp(new URL(stringArray[0]), string);
            stringArray[0] = ((File)object).toString();
        }
        object = null;
        object = Jnlp2Package.parseArguments(stringArray);
        if (bl) {
            FileOperUtility.httpJnlpRes2localRes((JnlpPackageInfo)object, string);
        }
        PackageGenerator packageGenerator = PackageGeneratorFactory.newInstance();
        packageGenerator.generatePackage((JnlpPackageInfo)object);
        if (bl) {
            FileOperUtility.deleteDirTree(new File(string));
        }
    }
}

