/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import java.io.IOException;

public class WinMsiWrapper {
    public static final int MSIDBOPEN_CREATE = 3;
    public static final int MSIDBOPEN_DIRECT = 2;
    public static final int MSIDBOPEN_READONLY = 0;
    public static final int MSIDBOPEN_TRANSACT = 1;
    public static final int MSIMODIFY_SEEK = -1;
    public static final int MSIMODIFY_REFRESH = 0;
    public static final int MSIMODIFY_INSERT = 1;
    public static final int MSIMODIFY_UPDATE = 2;
    public static final int MSIMODIFY_ASSIGN = 3;
    public static final int MSIMODIFY_REPLACE = 4;
    public static final int MSIMODIFY_MERGE = 5;
    public static final int MSIMODIFY_DELETE = 6;
    public static final int MSIMODIFY_INSERT_TEMPORARY = 7;
    public static final int MSIMODIFY_VALIDATE = 8;
    public static final int MSIMODIFY_VALIDATE_NEW = 9;
    public static final int MSIMODIFY_VALIDATE_FIELD = 10;
    public static final int MSIMODIFY_VALIDATE_DELETE = 11;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_INVALID_HANDLE = 6;
    public static final int ERROR_INVALID_DATA = 13;
    public static final int ERROR_INVALID_PARAMETER = 87;
    public static final int ERROR_OPEN_FAILED = 110;
    public static final int ERROR_BAD_PATHNAME = 161;
    public static final int ERROR_NO_MORE_ITEMS = 259;
    public static final int ERROR_INVALID_HANDLE_STATE = 1609;
    public static final int ERROR_BAD_QUERY_SYNTAX = 1615;
    public static final int ERROR_CREATE_FAILED = 1631;
    public static final int ERROR_FUNCTION_FAILED = 1627;

    private static native int[] msiOpenDatabase(byte[] var0, int var1);

    private static native int[] msiDatabaseOpenView(int var0, byte[] var1);

    private static native int msiViewExecute(int var0, int var1);

    private static native int[] msiViewFetch(int var0);

    private static native byte[] msiRecordGetString(int var0, int var1);

    private static native int msiRecordSetString(int var0, int var1, byte[] var2);

    private static native int msiViewModify(int var0, int var1, int var2);

    private static native int msiRecordGetFieldCount(int var0);

    private static native int msiCreateRecord(int var0);

    private static native int msiViewClose(int var0);

    private static native int msiDatabaseCommit(int var0);

    private static native int msiCloseHandle(int var0);

    private static native int msiRecordSetStream(int var0, int var1, byte[] var2);

    private static native byte[] msiRecordReadStream(int var0, int var1);

    private static native int[] msiGetSummaryInformation(int var0);

    private static native int msiSummaryInfoSetProperty(int var0, int var1, byte[] var2);

    private static native int msiSummaryInfoPersist(int var0);

    private static native int msiCloseAllHandles();

    private static native int msiDatabaseGenerateTransform(int var0, int var1, byte[] var2);

    private static native int msiCreateTransformSummaryInfo(int var0, int var1, byte[] var2);

    private static native int msiDatabaseImport(int var0, byte[] var1, byte[] var2);

    private static native int msiDatabaseApplyTransform(int var0, byte[] var1, int var2);

    private static native byte[] genUUID();

    private static native int updateResourceString(byte[] var0, byte[] var1, int var2);

    private static native int updateResourceData(byte[] var0, byte[] var1, int var2);

    private static native int nativeCreateProcess(byte[] var0);

    private static byte[] stringToByteArray(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = 0;
        return byArray2;
    }

    private static String byteArrayToString(byte[] byArray) {
        String string;
        if (byArray != null && (string = new String(byArray)) != null) {
            return string;
        }
        return null;
    }

    public static int[] winMsiOpenDatabase(String string, int n) throws IOException {
        int[] nArray = WinMsiWrapper.msiOpenDatabase(WinMsiWrapper.stringToByteArray(string), n);
        if (nArray[0] == 0) {
            return nArray;
        }
        throw new IOException("MSI Open database failed!");
    }

    public static int[] winMsiDatabaseOpenView(int n, String string) throws IOException {
        int[] nArray = WinMsiWrapper.msiDatabaseOpenView(n, WinMsiWrapper.stringToByteArray(string));
        if (nArray[0] == 0) {
            return nArray;
        }
        throw new IOException("MSI Database Open View Failed!");
    }

    public static void winMsiViewExecute(int n, int n2) throws IOException {
        if (WinMsiWrapper.msiViewExecute(n, n2) != 0) {
            throw new IOException("MSI View Execuation Failed!");
        }
    }

    public static int[] winMsiViewFetch(int n) throws IOException {
        int[] nArray = WinMsiWrapper.msiViewFetch(n);
        if (nArray[0] == 0) {
            return nArray;
        }
        throw new IOException("MSI View Fetch failed!");
    }

    public static String winMsiRecordGetString(int n, int n2) {
        byte[] byArray = WinMsiWrapper.msiRecordGetString(n, n2);
        if (byArray != null) {
            return WinMsiWrapper.byteArrayToString(byArray);
        }
        return null;
    }

    public static void winMsiRecordSetString(int n, int n2, String string) throws IOException {
        if (WinMsiWrapper.msiRecordSetString(n, n2, WinMsiWrapper.stringToByteArray(string)) != 0) {
            throw new IOException("MSI Record Set String Failed!");
        }
    }

    public static void winMsiViewModify(int n, int n2, int n3) throws IOException {
        if (WinMsiWrapper.msiViewModify(n, n2, n3) != 0) {
            throw new IOException("MSI View Modification Failed!");
        }
    }

    public static int winMsiRecordGetFieldCount(int n) throws IOException {
        int n2 = WinMsiWrapper.msiRecordGetFieldCount(n);
        if (n2 != -1) {
            return n2;
        }
        throw new IOException("MSI Record Get Field Count Failed!");
    }

    public static void winMsiViewClose(int n) throws IOException {
        if (WinMsiWrapper.msiViewClose(n) != 0) {
            throw new IOException("MSI View Close Failed!");
        }
    }

    public static void winMsiDatabaseCommit(int n) throws IOException {
        if (WinMsiWrapper.msiDatabaseCommit(n) != 0) {
            throw new IOException("MSI Database Commit Failed!");
        }
    }

    public static void winMsiDatabaseApplyTransform(int n, String string) throws IOException {
        if (0 != WinMsiWrapper.msiDatabaseApplyTransform(n, WinMsiWrapper.stringToByteArray(string), 0)) {
            throw new IOException("MSI Database apply tranform failed!");
        }
    }

    public static void winMsiCloseHandle(int n) throws IOException {
        if (WinMsiWrapper.msiCloseHandle(n) != 0) {
            throw new IOException("MSI Close Handle Failed!");
        }
    }

    public static void winMsiRecordSetStream(int n, int n2, String string) throws IOException {
        if (WinMsiWrapper.msiRecordSetStream(n, n2, WinMsiWrapper.stringToByteArray(string)) != 0) {
            throw new IOException("MSI Record Set Stream Failed!");
        }
    }

    public static byte[] winMsiRecordReadStream(int n, int n2) {
        return WinMsiWrapper.msiRecordReadStream(n, n2);
    }

    public static int[] winMsiGetSummaryInformation(int n) {
        return WinMsiWrapper.msiGetSummaryInformation(n);
    }

    public static void winMsiSummaryInfoSetProperty(int n, int n2, String string) throws IOException {
        if (WinMsiWrapper.msiSummaryInfoSetProperty(n, n2, WinMsiWrapper.stringToByteArray(string)) != 0) {
            throw new IOException("MSI SummaryInfo Set Property Failed!");
        }
    }

    public static void winMsiSummaryInfoPersist(int n) throws IOException {
        if (WinMsiWrapper.msiSummaryInfoPersist(n) != 0) {
            throw new IOException("MSI Summaryinfo Persist Failed!");
        }
    }

    public static int winMsiCloseAllHandles() {
        return WinMsiWrapper.msiCloseAllHandles();
    }

    public static String generateUUID() {
        byte[] byArray = WinMsiWrapper.genUUID();
        if (byArray != null) {
            return WinMsiWrapper.byteArrayToString(byArray);
        }
        return null;
    }

    public static void winMsiDatabaseGenerateTransform(int n, int n2, String string) throws IOException {
        int n3 = WinMsiWrapper.msiDatabaseGenerateTransform(n, n2, WinMsiWrapper.stringToByteArray(string));
        if (n3 != 0) {
            throw new IOException("MSI Database Generate Transform Failed!");
        }
    }

    public static void winMsiCreateTransformSummaryInfo(int n, int n2, String string) throws IOException {
        int n3 = WinMsiWrapper.msiCreateTransformSummaryInfo(n, n2, WinMsiWrapper.stringToByteArray(string));
        if (n3 != 0) {
            throw new IOException("MSI Database Generate Transform Failed!");
        }
    }

    public static void winMsiDatabaseImport(int n, String string, String string2) throws IOException {
        int n2 = WinMsiWrapper.msiDatabaseImport(n, WinMsiWrapper.stringToByteArray(string), WinMsiWrapper.stringToByteArray(string2));
        if (0 != n2) {
            throw new IOException("MSI Databse import failed!");
        }
    }

    public static void winUpdateResourceString(String string, String string2, int n) throws IOException {
        int n2 = WinMsiWrapper.updateResourceString(WinMsiWrapper.stringToByteArray(string), WinMsiWrapper.stringToByteArray(string2), n);
        if (n2 != 0) {
            throw new IOException("Windows Update Resource String Failed!");
        }
    }

    public static void winUpdateResourceData(String string, String string2, int n) throws IOException {
        int n2 = WinMsiWrapper.updateResourceData(WinMsiWrapper.stringToByteArray(string), WinMsiWrapper.stringToByteArray(string2), n);
        if (n2 != 0) {
            throw new IOException("Windows Update Resource Binary Data Failed!");
        }
    }

    public static void winNativeCreateProcess(String string) throws IOException {
        int n = WinMsiWrapper.nativeCreateProcess(WinMsiWrapper.stringToByteArray(string));
        if (n != 0) {
            throw new IOException("Windows create native process failed!");
        }
    }

    public static int winMsiCreateRecord(int n) throws IOException {
        int n2 = WinMsiWrapper.msiCreateRecord(n);
        if (n2 != -1) {
            return n2;
        }
        throw new IOException("MSI Create Record Failed!");
    }

    static {
        System.loadLibrary("WinMsiWrapper");
    }
}

