package org.crosswire.bibledesktop.book;

import java.util.EventObject;

import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.passage.Key;

/**
 * A DisplaySelectEvent happens whenever a user makes a command.
 * 
 * <p><table border='1' cellPadding='3' cellSpacing='0'>
 * <tr><td bgColor='white' class='TableRowColor'><font size='-7'>
 *
 * Distribution Licence:<br />
 * JSword is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public License,
 * version 2 as published by the Free Software Foundation.<br />
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.<br />
 * The License is available on the internet
 * <a href='http://www.gnu.org/copyleft/gpl.html'>here</a>, or by writing to:
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA<br />
 * The copyright to this program is held by it's authors.
 * </font></td></tr></table>
 * @see gnu.gpl.Licence
 * @author Joe Walker [joe at eireneh dot com]
 * @version $Id: DisplaySelectEvent.java,v 1.6 2005/03/06 20:21:36 dmsmith Exp $
 */
public class DisplaySelectEvent extends EventObject
{
    /**
     * For when a command has been made
     * @param source The thing that started this off
     * @param key The selected Key
     * @param book The selected book
     */
    public DisplaySelectEvent(Object source, Key key, Book book)
    {
        super(source);

        this.key = key;
        this.book = book;
    }

    /**
     * Get the type of command
     * @return The type of command
     */
    public Key getKey()
    {
        return key;
    }

    /**
     * Get the type of command
     * @return The type of command
     */
    public Book getBook()
    {
        return book;
    }

    /**
     * The new passage
     */
    private Key key;

    /**
     * The new Book
     */
    private Book book;

    /**
     * Serialization ID
     */
    private static final long serialVersionUID = 3689068456540910136L;
}
