package org.crosswire.bibledesktop.display.scrolled;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JScrollPane;

import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.proxy.ProxyBookDataDisplay;

/**
 * An inner component of Passage pane that can't show the list.
 * 
 * <p><table border='1' cellPadding='3' cellSpacing='0'>
 * <tr><td bgColor='white' class='TableRowColor'><font size='-7'>
 *
 * Distribution Licence:<br />
 * JSword is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public License,
 * version 2 as published by the Free Software Foundation.<br />
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.<br />
 * The License is available on the internet
 * <a href='http://www.gnu.org/copyleft/gpl.html'>here</a>, or by writing to:
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA<br />
 * The copyright to this program is held by it's authors.
 * </font></td></tr></table>
 * @see gnu.gpl.Licence
 * @author Joe Walker [joe at eireneh dot com]
 * @version $Id: ScrolledBookDataDisplay.java,v 1.2 2004/05/26 15:05:52 joe Exp $
 */
public class ScrolledBookDataDisplay extends ProxyBookDataDisplay implements BookDataDisplay
{
    /**
     * Simple Constructor
     */
    public ScrolledBookDataDisplay(BookDataDisplay child)
    {
        super(child);

        scrView.getViewport().setPreferredSize(new Dimension(500, 400));
        scrView.getViewport().add(getProxy().getComponent(), null);
    }

    /* (non-Javadoc)
     * @see org.crosswire.bibledesktop.display.BookDataDisplay#getComponent()
     */
    public Component getComponent()
    {
        return scrView;
    }

    /**
     * The scroller for the TextPaneBookDataDisplay component
     */
    private JScrollPane scrView = new JScrollPane();
}
