package org.crosswire.common.xml;

import javax.xml.transform.TransformerException;

/**
 * A generic method of converting one SAX stream into another.
 * This can be a wrapper around an XSL transform or anything else.
 * 
 * <p><table border='1' cellPadding='3' cellSpacing='0'>
 * <tr><td bgColor='white' class='TableRowColor'><font size='-7'>
 *
 * Distribution Licence:<br />
 * JSword is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public License,
 * version 2 as published by the Free Software Foundation.<br />
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.<br />
 * The License is available on the internet
 * <a href='http://www.gnu.org/copyleft/gpl.html'>here</a>, or by writing to:
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA<br />
 * The copyright to this program is held by it's authors.
 * </font></td></tr></table>
 * @see gnu.gpl.Licence
 * @author Joe Walker [joe at eireneh dot com]
 * @version $Id: Converter.java,v 1.1 2004/04/20 21:16:08 joe Exp $
 */
public interface Converter
{
    /**
     * Convert one SAX stream into another.
     * @param provider The source stream
     * @return The destination stream
     * @throws TransformerException If the transformation can't be completed
     */
    public SAXEventProvider convert(SAXEventProvider provider) throws TransformerException;
}
