package org.crosswire.bibledesktop.passage;

import java.util.Iterator;

import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.VerseRange;

/**
 * A Simple extension to JList to customize it to hold a Passage and
 * provide Passage related actions.
 * 
 * <p><table border='1' cellPadding='3' cellSpacing='0'>
 * <tr><td bgColor='white' class='TableRowColor'><font size='-7'>
 *
 * Distribution Licence:<br />
 * JSword is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public License,
 * version 2 as published by the Free Software Foundation.<br />
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.<br />
 * The License is available on the internet
 * <a href='http://www.gnu.org/copyleft/gpl.html'>here</a>, or by writing to:
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA<br />
 * The copyright to this program is held by it's authors.
 * </font></td></tr></table>
 * @see gnu.gpl.Licence
 * @author Joe Walker [joe at eireneh dot com]
 * @version $Id: PassageGuiUtil.java,v 1.6 2004/08/30 09:26:14 joe Exp $
 */
public class PassageGuiUtil
{
    /**
     * Prevent Instansiation
     */
    private PassageGuiUtil()
    {
    }

    /**
     * Remove all of the selected verses from the passage
     */
    public static void deleteSelectedVersesFromList(JList list)
    {
        PassageListModel plm = (PassageListModel) list.getModel();

        Passage ref = plm.getPassage();
        Object[] selected = list.getSelectedValues();
        for (int i = 0; i < selected.length; i++)
        {
            VerseRange range = (VerseRange) selected[i];
            ref.remove(range);
        }

        list.setSelectedIndices(new int[0]);
    }

    /**
     * @param tree The tree to delete selected verses from
     */
    public static void deleteSelectedVersesFromTree(JTree tree)
    {
        Key selected = getSelectedKeys(tree);

        KeyTreeModel mdl = (KeyTreeModel) tree.getModel();
        Key root = mdl.getKey();

        for (Iterator it = selected.iterator(); it.hasNext(); )
        {
            Key key = (Key) it.next();
            root.removeAll(key);
        }

        mdl.setKey(root);
    }

    /**
     * @return The selected keys in the tree
     */
    public static Key getSelectedKeys(JTree tree)
    {
        Key selected = new DefaultKeyList();
        TreePath[] paths = tree.getSelectionPaths();

        for (int i = 0; i < paths.length; i++)
        {
            KeyTreeNode node = (KeyTreeNode) paths[1].getLastPathComponent();
            selected.addAll(node.getKey());
        }

        return selected;
    }
}
