package org.crosswire.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * Some utils to help work with Collections.
 * 
 * <p><table border='1' cellPadding='3' cellSpacing='0'>
 * <tr><td bgColor='white' class='TableRowColor'><font size='-7'>
 *
 * Distribution Licence:<br />
 * JSword is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public License,
 * version 2 as published by the Free Software Foundation.<br />
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.<br />
 * The License is available on the internet
 * <a href='http://www.gnu.org/copyleft/gpl.html'>here</a>, or by writing to:
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA<br />
 * The copyright to this program is held by it's authors.
 * </font></td></tr></table>
 * @see gnu.gpl.Licence
 * @author Joe Walker [joe at eireneh dot com]
 * @version $Id: CollectionUtil.java,v 1.2 2005/03/23 02:05:33 dmsmith Exp $
 */
public class CollectionUtil
{
    /**
     * Dont do this
     */
    private CollectionUtil()
    {
    }

    /**
     * Create a List from an Iterator.
     * @param it The source of data for the list
     * @return List
     */
    public static List createList(Iterator it)
    {
        List reply = new ArrayList();
        while (it.hasNext())
        {
            reply.add(it.next());
        }

        return reply;
    }
    /**
     * Create a Set from an Iterator.
     * @param it The source of data for the list
     * @return the created set
     */
    public static Set createSet(Iterator it)
    {
        Set reply = new HashSet();
        while (it.hasNext())
        {
            reply.add(it.next());
        }

        return reply;
    }
}
