package org.crosswire.jsword.book.install;

import java.util.EventListener;

/**
 * InstallerListener are able to be notified about changes to the numbers
 * of Installers known to the system.
 * 
 * <p><table border='1' cellPadding='3' cellSpacing='0'>
 * <tr><td bgColor='white' class='TableRowColor'><font size='-7'>
 *
 * Distribution Licence:<br />
 * JSword is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public License,
 * version 2 as published by the Free Software Foundation.<br />
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.<br />
 * The License is available on the internet
 * <a href='http://www.gnu.org/copyleft/gpl.html'>here</a>, or by writing to:
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA<br />
 * The copyright to this program is held by it's authors.
 * </font></td></tr></table>
 * @see gnu.gpl.Licence
 * @author Joe Walker [joe at eireneh dot com]
 * @version $Id: InstallerListener.java,v 1.1 2004/02/04 09:52:53 joe Exp $
 */
public interface InstallerListener extends EventListener
{
    /**
     * Called whenever a new Installer is added to the system.
     * @param ev A description of the change
     */
    public void installerAdded(InstallerEvent ev);

    /**
     * Called whenever an Installer is removed from the system.
     * @param ev A description of the change
     */
    public void installerRemoved(InstallerEvent ev);
}
