/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.xml.PrettySerializingContentHandler;
import org.crosswire.common.xml.SAXEventProvider;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class XMLUtil {
    protected static final Logger log = Logger.getLogger(XMLUtil.class);
    private static Pattern validCharacterEntityPattern = Pattern.compile("^&#x?\\d{2,4};");

    private XMLUtil() {
    }

    public static Document getDocument(String subject) throws JDOMException, IOException {
        String resource = subject + ".xml";
        InputStream in = ResourceUtil.getResourceAsStream(resource);
        log.debug("Loading " + subject + ".xml from classpath: [OK]");
        SAXBuilder builder = new SAXBuilder(true);
        return builder.build(in);
    }

    public static String writeToString(SAXEventProvider provider) throws SAXException {
        PrettySerializingContentHandler ser = new PrettySerializingContentHandler();
        provider.provideSAXEvents(ser);
        return ((Object)ser).toString();
    }

    public static void debugSAXAttributes(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            log.debug("attr[" + i + "]: " + attrs.getQName(i) + '=' + attrs.getValue(i));
        }
    }

    public static String escape(String s) {
        if (s == null) {
            return s;
        }
        int len = s.length();
        StringBuffer str = new StringBuffer(len);
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block6;
                }
                case '>': {
                    str.append("&gt;");
                    continue block6;
                }
                case '&': {
                    str.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block6;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String cleanAllEntities(String broken) {
        int amp;
        if (broken == null) {
            return null;
        }
        String working = broken;
        int cleanfrom = 0;
        while ((amp = working.indexOf(38, cleanfrom)) != -1) {
            if (validCharacterEntityPattern.matcher(working.substring(amp)).find()) {
                cleanfrom = working.indexOf(59, amp) + 1;
                continue;
            }
            int i = amp + 1;
            while (true) {
                String replace;
                String entity;
                if (i >= working.length()) {
                    String entity2 = working.substring(amp);
                    String replace2 = XMLUtil.guessEntity(entity2);
                    working = working.substring(0, amp) + replace2;
                    break;
                }
                char c = working.charAt(i);
                if (c == ';') {
                    entity = working.substring(amp, i + 1);
                    replace = XMLUtil.guessEntity(entity);
                    working = working.substring(0, amp) + replace + working.substring(i + 1);
                    break;
                }
                if (!Character.isLetterOrDigit(c) && c != '-') {
                    entity = working.substring(amp, i);
                    replace = XMLUtil.guessEntity(entity);
                    working = working.substring(0, amp) + replace + working.substring(i);
                    break;
                }
                ++i;
            }
            cleanfrom = amp + 1;
        }
        return working;
    }

    private static String guessEntity(String brokenEntity) {
        String broken = brokenEntity;
        if (broken.endsWith(";")) {
            broken = broken.substring(0, broken.length() - 1);
        }
        if (broken.charAt(0) == '&') {
            broken = broken.substring(1);
        }
        if ("amp".equals(broken)) {
            return "&#38;";
        }
        if ("lt".equals(broken)) {
            return "&#60;";
        }
        if ("gt".equals(broken)) {
            return "&#62;";
        }
        if ("quot".equals(broken)) {
            return "&#34;";
        }
        if ("nbsp".equals(broken)) {
            return "&#160;";
        }
        if ("pound".equals(broken)) {
            return "&#163;";
        }
        if ("yen".equals(broken)) {
            return "&#165;";
        }
        if ("euro".equals(broken)) {
            return "&#8364;";
        }
        if ("copy".equals(broken)) {
            return "&#169;";
        }
        if ("para".equals(broken)) {
            return "&#182;";
        }
        if ("lsquo".equals(broken)) {
            return "&#8216;";
        }
        if ("rsquo".equals(broken)) {
            return "&#8217;";
        }
        return "";
    }

    public static String cleanAllTags(String broken) {
        int lt;
        if (broken == null) {
            return null;
        }
        String working = broken;
        while ((lt = working.indexOf(60)) != -1) {
            int i = lt;
            int startattr = -1;
            while (true) {
                if (++i >= working.length()) {
                    --i;
                    break;
                }
                char c = working.charAt(i);
                if (c == '>') break;
                if (c != ' ') continue;
                if (startattr == -1) {
                    startattr = i;
                    continue;
                }
                String value = working.substring(startattr, i);
                if (value.indexOf("=") == -1) break;
            }
            working = working.substring(0, lt) + working.substring(i + 1);
        }
        return working;
    }
}

