/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.Properties;
import org.crosswire.common.util.StringUtil;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.IndexStatus;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBookMetaData;
import org.crosswire.jsword.book.search.IndexManager;
import org.crosswire.jsword.book.search.IndexManagerFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class DefaultBookMetaData
extends AbstractBookMetaData {
    private BookCategory type;
    private String name;
    private String initials;

    public DefaultBookMetaData(BookDriver driver, Book book, Properties prop) {
        this.setDriver(driver);
        this.setProperties(prop);
        this.setName(prop.getProperty("Description"));
        this.setType(prop.getProperty("Category"));
        this.setLanguage(prop.getProperty("Language"));
        IndexManager imanager = IndexManagerFactory.getIndexManager();
        if (imanager.isIndexed(book)) {
            this.setIndexStatus(IndexStatus.DONE);
        } else {
            this.setIndexStatus(IndexStatus.UNDONE);
        }
    }

    public DefaultBookMetaData(BookDriver driver, String name, BookCategory type) {
        this.setDriver(driver);
        this.setName(name);
        this.setBookCategory(type);
        this.setLanguage(null);
    }

    public BookCategory getBookCategory() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getInitials() {
        return this.initials;
    }

    public boolean isLeftToRight() {
        return true;
    }

    public void setLanguage(String language) {
        this.putProperty("Language", DefaultBookMetaData.getLanguage(this.initials, language));
    }

    public void setInitials(String initials) {
        this.initials = initials == null ? (this.name == null ? "" : StringUtil.getInitials((String)this.name)) : initials;
        this.putProperty("Initials", this.initials);
    }

    public void setName(String name) {
        this.name = name;
        this.putProperty("Description", this.name);
        this.setInitials(StringUtil.getInitials((String)name));
    }

    public void setBookCategory(BookCategory aType) {
        BookCategory t = aType;
        if (t == null) {
            t = BookCategory.BIBLE;
        }
        this.type = t;
        this.putProperty("Category", this.type.toString());
    }

    public void setType(String typestr) {
        BookCategory newType = null;
        if (typestr != null) {
            newType = BookCategory.fromString(typestr);
        }
        this.setBookCategory(newType);
    }

    public Document toOSIS() {
        OSISUtil.ObjectFactory factory = OSISUtil.factory();
        Element ele = factory.createTable();
        this.addRow(ele, "Initials", this.getInitials());
        this.addRow(ele, "Description", this.getFullName());
        this.addRow(ele, "Key", this.getBookCategory().toString());
        this.addRow(ele, "Language", this.getLanguage());
        return new Document(ele);
    }

    private void addRow(Element table, String key, String value) {
        if (value == null) {
            return;
        }
        OSISUtil.ObjectFactory factory = OSISUtil.factory();
        Element rowEle = factory.createRow();
        Element nameEle = factory.createCell();
        Element hiEle = factory.createHI();
        hiEle.setAttribute("type", "bold");
        nameEle.addContent((Content)hiEle);
        Element valueElement = factory.createCell();
        rowEle.addContent((Content)nameEle);
        rowEle.addContent((Content)valueElement);
        hiEle.addContent(key);
        String expandedValue = XMLUtil.escape((String)value);
        valueElement.addContent(expandedValue);
        table.addContent((Content)rowEle);
    }
}

