/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.search.lucene;

import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.search.Index;
import org.crosswire.jsword.book.search.lucene.AbstractBinaryQuery;
import org.crosswire.jsword.book.search.lucene.Query;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.RestrictionType;

public class BlurQuery
extends AbstractBinaryQuery {
    private int factor;

    public BlurQuery(Query theLeftToken, Query theRightToken, int theFactor) {
        super(theLeftToken, theRightToken);
        this.factor = theFactor;
    }

    public Key find(Index index) throws BookException {
        Key left = this.getLeftToken().find(index);
        Key right = this.getRightToken().find(index);
        right.blur(this.factor, RestrictionType.getDefaultBlurRestriction());
        left.retainAll(right);
        return left;
    }

    public int getFactor() {
        return this.factor;
    }
}

