/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.search.lucene;

import java.util.Iterator;
import java.util.List;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.search.Index;
import org.crosswire.jsword.book.search.SearchRequest;
import org.crosswire.jsword.book.search.Searcher;
import org.crosswire.jsword.book.search.basic.DefaultSearchRequest;
import org.crosswire.jsword.book.search.lucene.Query;
import org.crosswire.jsword.book.search.lucene.QueryBuilder;
import org.crosswire.jsword.passage.Key;

public class IndexSearcher
implements Searcher {
    private Index index;

    public void init(Index newindex) {
        this.index = newindex;
    }

    public Key search(String request) throws BookException {
        return this.search(new DefaultSearchRequest(request));
    }

    public Key search(SearchRequest request) throws BookException {
        this.index.setSearchModifier(request.getSearchModifier());
        List output = QueryBuilder.tokenize(request.getRequest());
        Key results = this.search(output);
        this.index.setSearchModifier(null);
        return results;
    }

    protected Key search(List matches) throws BookException {
        Key key = this.index.find(null);
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            Query token = (Query)iter.next();
            key.addAll(token.find(this.index));
        }
        return key;
    }

    protected Index getIndex() {
        return this.index;
    }
}

