/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.Iterator;
import java.util.List;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookList;

public class DefaultBook {
    private Book book;
    private final BookList books;
    private final BookFilter filter;
    private static final Logger log = Logger.getLogger((Class)DefaultBook.class);

    public DefaultBook(BookList bookList, BookFilter bookFilter) {
        this.books = bookList;
        this.filter = bookFilter;
    }

    public void setDefault(Book newBook) {
        if (this.filter.test(newBook)) {
            this.book = newBook;
        }
    }

    public void setDefaultConditionally(Book newBook) {
        if (this.book == null) {
            this.setDefault(newBook);
        }
    }

    protected void unsetDefault() {
        this.book = null;
        this.checkReplacement();
    }

    protected void unsetDefaultConditionally(Book oldBook) {
        if (this.book == oldBook) {
            this.unsetDefault();
        }
    }

    public Book getDefault() {
        return this.book;
    }

    public String getDefaultName() {
        if (this.book == null) {
            return null;
        }
        return this.book.getFullName();
    }

    public void setDefaultByName(String name) {
        if (name == null || name.length() == 0) {
            log.warn("Attempt to set empty book as default. Ignoring");
            return;
        }
        List bookList = this.books.getBooks(this.filter);
        Iterator it = bookList.iterator();
        while (it.hasNext()) {
            Book aBook = (Book)it.next();
            if (!name.equals(aBook.getFullName())) continue;
            this.setDefault(aBook);
            return;
        }
        log.warn("Book not found. Ignoring: " + name);
    }

    protected void checkReplacement() {
        List bookList = this.books.getBooks(this.filter);
        Iterator it = bookList.iterator();
        if (it.hasNext()) {
            this.book = (Book)it.next();
        }
    }
}

