/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.search.lucene;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.jsword.book.search.lucene.AndNotQuery;
import org.crosswire.jsword.book.search.lucene.AndQuery;
import org.crosswire.jsword.book.search.lucene.BaseQuery;
import org.crosswire.jsword.book.search.lucene.BlurQuery;
import org.crosswire.jsword.book.search.lucene.Query;
import org.crosswire.jsword.book.search.lucene.RangeQuery;

public final class QueryBuilder {
    private static final Pattern RANGE_PATTERN = Pattern.compile("^\\s*([-+]?)\\[([^\\[\\]]+)\\]\\s*");
    private static final Pattern BLUR_PATTERN = Pattern.compile("\\s~(\\d*)?\\s");

    private QueryBuilder() {
    }

    public static List tokenize(String aSearch) {
        Matcher blurMatcher;
        String sought = aSearch;
        ArrayList<Query> output = new ArrayList<Query>();
        if (sought == null || sought.length() == 0) {
            return output;
        }
        int i = 0;
        Query query = null;
        RangeQuery range = null;
        String rangeModifier = null;
        Matcher rangeMatcher = RANGE_PATTERN.matcher(sought);
        if (rangeMatcher.find()) {
            rangeModifier = rangeMatcher.group(1);
            range = new RangeQuery(rangeMatcher.group(2));
            sought = sought.substring(rangeMatcher.end() - 1);
        }
        if ((blurMatcher = BLUR_PATTERN.matcher(sought)).find()) {
            int blurFactor = 1;
            if (blurMatcher.groupCount() > 0) {
                blurFactor = Integer.valueOf(blurMatcher.group(1));
            }
            BaseQuery left = new BaseQuery(sought.substring(i, blurMatcher.start()));
            BaseQuery right = new BaseQuery(sought.substring(blurMatcher.end()));
            query = new BlurQuery(left, right, blurFactor);
        } else {
            query = new BaseQuery(sought);
        }
        if (range != null) {
            if (rangeModifier == null) {
                output.add(query);
                output.add(range);
            } else if (rangeModifier.charAt(0) == '+') {
                output.add(new AndQuery(query, range));
            } else {
                output.add(new AndNotQuery(query, range));
            }
        } else {
            output.add(query);
        }
        return output;
    }
}

