/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.ChoiceFactory;
import org.crosswire.common.config.ConfigEvent;
import org.crosswire.common.config.ConfigException;
import org.crosswire.common.config.ConfigListener;
import org.crosswire.common.config.Msg;
import org.crosswire.common.util.EventListenerList;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.Reporter;
import org.jdom.Document;
import org.jdom.Element;

public class Config {
    private static final Logger log;
    protected String title;
    protected List keys = new ArrayList();
    protected List models = new ArrayList();
    protected Properties local = new Properties();
    protected EventListenerList listenerList = new EventListenerList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Config(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void add(String key, Choice model) {
        this.keys.add(key);
        this.models.add(model);
        String value = model.getString();
        if (value == null) {
            value = "";
            log.info("key=" + key + " had a null value");
        }
        this.local.put(key, value);
        this.fireChoiceAdded(key, model);
    }

    public void add(Document xmlconfig, ResourceBundle configResources) {
        Element root = xmlconfig.getRootElement();
        Iterator iter = root.getChildren().iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            String key = element.getAttributeValue("key");
            try {
                Choice choice = ChoiceFactory.getChoice(element, configResources);
                this.add(key, choice);
            }
            catch (Exception ex) {
                log.warn("Error creating config element, key=" + key, ex);
            }
        }
    }

    public void remove(String key) {
        Choice model = this.getChoice(key);
        this.keys.remove(key);
        this.models.remove(model);
        this.fireChoiceRemoved(key, model);
    }

    public Iterator getPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = this.models.iterator();
        while (iter.hasNext()) {
            Choice choice = (Choice)iter.next();
            String path = Config.getPath(choice.getFullPath());
            if (paths.contains(path)) continue;
            paths.add(path);
        }
        return paths.iterator();
    }

    public Iterator getNames() {
        return this.keys.iterator();
    }

    public Choice getChoice(String key) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return null;
        }
        return (Choice)this.models.get(index);
    }

    public int size() {
        return this.keys.size();
    }

    public void setLocal(String name, String value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        this.local.put(name, value);
    }

    public String getLocal(String name) {
        return this.local.getProperty(name);
    }

    public void applicationToLocal() {
        Iterator iter = this.keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            try {
                Choice model = this.getChoice(key);
                String value = model.getString();
                this.local.put(key, value);
            }
            catch (Exception ex) {
                log.warn("Failure with setting " + key);
                Reporter.informUser((Object)this, ex);
            }
        }
    }

    public void localToApplication() {
        Iterator iter = this.keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Choice choice = this.getChoice(key);
            String oldValue = choice.getString();
            String newValue = this.local.getProperty(key);
            if (newValue == null || newValue.length() == 0) {
                if (oldValue == null) continue;
                this.local.setProperty(key, oldValue);
                newValue = oldValue;
            }
            try {
                if (newValue.equals(oldValue)) continue;
                log.info("Setting " + key + "=" + newValue + " (was " + oldValue + ")");
                choice.setString(newValue);
            }
            catch (Exception ex) {
                log.warn("Failure setting " + key + "=" + newValue, ex);
                Reporter.informUser((Object)this, new ConfigException(Msg.CONFIG_SETFAIL, ex, new Object[]{choice.getFullPath()}));
            }
        }
    }

    public void setProperties(Properties prop) {
        Iterator<Object> iter = prop.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = prop.getProperty(key);
            if (value == null) continue;
            this.local.put(key, value);
        }
    }

    public Properties getProperties() {
        Properties prop = new Properties();
        Iterator iter = this.keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = this.local.getProperty(key);
            Choice model = this.getChoice(key);
            if (model.isSaveable()) {
                prop.put(key, value);
                continue;
            }
            prop.remove(key);
        }
        return prop;
    }

    public void permanentToLocal(URL url) throws IOException {
        Properties prop = new Properties();
        prop.load(url.openStream());
        this.setProperties(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localToPermanent(URL url) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(url.getFile());
            this.getProperties().store(out, this.title);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public static String getPath(String key) {
        int lastDot = key.lastIndexOf(46);
        if (lastDot == -1) {
            throw new IllegalArgumentException("key=" + key + " does not contain a dot.");
        }
        return key.substring(0, lastDot);
    }

    public static String getLeaf(String key) {
        int lastDot = key.lastIndexOf(46);
        if (lastDot == -1) {
            throw new IllegalArgumentException("key=" + key + " does not contain a dot.");
        }
        return key.substring(lastDot + 1);
    }

    public void addConfigListener(ConfigListener li) {
        this.listenerList.add(ConfigListener.class, li);
    }

    public void removeConfigListener(ConfigListener li) {
        this.listenerList.remove(ConfigListener.class, li);
    }

    protected void fireChoiceAdded(String key, Choice model) {
        Object[] listeners = this.listenerList.getListenerList();
        ConfigEvent ev = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$common$config$ConfigListener == null ? Config.class$("org.crosswire.common.config.ConfigListener") : class$org$crosswire$common$config$ConfigListener)) continue;
            if (ev == null) {
                ev = new ConfigEvent(this, key, model);
            }
            ((ConfigListener)listeners[i + 1]).choiceAdded(ev);
        }
    }

    protected void fireChoiceRemoved(String key, Choice model) {
        Object[] listeners = this.listenerList.getListenerList();
        ConfigEvent ev = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$common$config$ConfigListener == null ? Config.class$("org.crosswire.common.config.ConfigListener") : class$org$crosswire$common$config$ConfigListener)) continue;
            if (ev == null) {
                ev = new ConfigEvent(this, key, model);
            }
            ((ConfigListener)listeners[i + 1]).choiceRemoved(ev);
        }
    }

    static {
        $assertionsDisabled = !Config.class.desiredAssertionStatus();
        log = Logger.getLogger(Config.class);
    }
}

