/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.crosswire.bibledesktop.desktop.Msg;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.WorkEvent;
import org.crosswire.common.progress.WorkListener;
import org.crosswire.common.progress.swing.JobsProgressBar;
import org.crosswire.common.swing.GuiUtil;

public class Splash
extends JWindow {
    private transient CustomWorkListener listener = new CustomWorkListener();
    private static final String SPLASH_FONT = "SanSerif";
    private static final long serialVersionUID = 3258133565731256119L;

    public Splash() {
        super(GuiUtil.getFrame(null));
        this.init();
    }

    private void init() {
        ImageIcon icon = GuiUtil.getIcon((String)Msg.SPLASH_IMAGE.toString());
        JLabel lblPicture = new JLabel();
        lblPicture.setBackground(Color.WHITE);
        lblPicture.setOpaque(true);
        lblPicture.setIcon(icon);
        lblPicture.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        JPanel pnlDisplay = new JPanel();
        pnlDisplay.setLayout(new GridBagLayout());
        pnlDisplay.add((Component)lblPicture, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblInfo = new JLabel();
        lblInfo.setBorder(null);
        lblInfo.setFont(new Font(SPLASH_FONT, 0, 9));
        lblInfo.setForeground(Color.WHITE);
        lblInfo.setBackground(Color.BLACK);
        lblInfo.setHorizontalAlignment(4);
        lblInfo.setText(Msg.getVersionInfo() + ' ');
        lblInfo.setOpaque(true);
        JobsProgressBar pnlJobs = new JobsProgressBar(false);
        pnlJobs.setBackground(Color.WHITE);
        pnlJobs.setForeground(Color.BLACK);
        pnlJobs.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        JPanel pnlInfo = new JPanel();
        pnlInfo.setLayout(new BorderLayout(5, 0));
        pnlInfo.setOpaque(true);
        pnlInfo.add((Component)lblInfo, "Center");
        pnlInfo.add((Component)pnlJobs, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)pnlInfo, "South");
        this.getContentPane().add((Component)pnlDisplay, "Center");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = lblPicture.getPreferredSize();
        this.setLocation(screen.width / 2 - window.width / 2, screen.height / 2 - window.height / 2);
        JobManager.addWorkListener((WorkListener)this.listener);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                Splash.this.close();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public void close() {
        JobManager.removeWorkListener((WorkListener)this.listener);
        this.setVisible(false);
        this.dispose();
    }

    private final class CustomWorkListener
    implements WorkListener {
        private CustomWorkListener() {
        }

        public void workProgressed(WorkEvent ev) {
            Job job = ev.getJob();
            if (job.getPercent() == 0 || job.isFinished()) {
                Splash.this.pack();
            }
        }

        public void workStateChanged(WorkEvent ev) {
        }
    }
}

