/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.index.IndexStatus;
import org.jdom.Document;

public abstract class AbstractBookMetaData
implements BookMetaData {
    private static final Logger log;
    public static final String DEFAULT_LANG_CODE = "en";
    private static final String UNKNOWN_LANG_CODE = "und";
    private static ResourceBundle languages;
    private Map prop = new LinkedHashMap();
    private BookDriver driver;
    private String fullName;
    private String displayName;
    private IndexStatus indexStatus = IndexStatus.UNDONE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BookDriver getDriver() {
        return this.driver;
    }

    public String getDriverName() {
        if (this.getDriver() == null) {
            return null;
        }
        return this.getDriver().getDriverName();
    }

    public boolean hasFeature(FeatureType feature) {
        return false;
    }

    public String getOsisID() {
        return this.getBookCategory().toString() + '.' + this.getInitials();
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = this.computeFullName();
        }
        return this.fullName;
    }

    private String computeFullName() {
        StringBuffer buf = new StringBuffer(this.getName());
        if (this.getDriver() != null) {
            buf.append(" (").append(this.getDriverName()).append(")");
        }
        return buf.toString();
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isEnciphered() {
        return false;
    }

    public boolean isLocked() {
        return false;
    }

    public boolean unlock(String unlockKey) {
        return false;
    }

    public String getUnlockKey() {
        return null;
    }

    public boolean isQuestionable() {
        return false;
    }

    public String getLanguage() {
        return (String)this.getProperty("Language");
    }

    public Map getProperties() {
        return this.prop;
    }

    public void setProperties(Map newProperties) {
        this.prop = newProperties;
    }

    protected Object getProperty(String key) {
        return this.prop.get(key);
    }

    protected void putProperty(String key, String value) {
        this.prop.put(key, value);
    }

    public IndexStatus getIndexStatus() {
        return this.indexStatus;
    }

    public void setIndexStatus(IndexStatus newValue) {
        this.indexStatus = newValue;
        this.prop.put("IndexStatus", newValue.toString());
    }

    public Document toOSIS() {
        throw new UnsupportedOperationException("If you want to use this, implement it.");
    }

    public void setDriver(BookDriver driver) {
        this.driver = driver;
    }

    public static String getLanguage(String ident, String iso639Code) {
        String lookup = iso639Code;
        if (lookup == null || lookup.length() == 0) {
            return AbstractBookMetaData.getLanguage(ident, DEFAULT_LANG_CODE);
        }
        if (lookup.indexOf(95) != -1) {
            String[] locale = StringUtil.split((String)lookup, (char)'_');
            return AbstractBookMetaData.getLanguage(ident, locale[0]);
        }
        char firstLangChar = lookup.charAt(0);
        if (firstLangChar == 'x' || firstLangChar == 'X' || lookup.length() > 3) {
            return AbstractBookMetaData.getLanguage(ident, UNKNOWN_LANG_CODE);
        }
        try {
            return languages.getString(lookup);
        }
        catch (MissingResourceException e) {
            log.error("Not a valid language code:" + iso639Code + " in book " + ident);
            return AbstractBookMetaData.getLanguage(ident, UNKNOWN_LANG_CODE);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        BookMetaData that = (BookMetaData)obj;
        return this.getBookCategory().equals(that.getBookCategory()) && this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int compareTo(Object obj) {
        int result = this.getBookCategory().compareTo(((BookMetaData)obj).getBookCategory());
        if (result == 0) {
            result = this.getInitials().compareTo(((BookMetaData)obj).getInitials());
        }
        return result;
    }

    public String toString() {
        if (this.displayName == null) {
            StringBuffer buf = new StringBuffer("[");
            buf.append(this.getInitials());
            buf.append("] - ");
            buf.append(this.getFullName());
            this.displayName = buf.toString();
        }
        return this.displayName;
    }

    static {
        block2: {
            $assertionsDisabled = !AbstractBookMetaData.class.desiredAssertionStatus();
            log = Logger.getLogger((Class)AbstractBookMetaData.class);
            try {
                languages = ResourceBundle.getBundle("iso639", Locale.getDefault(), (ClassLoader)new CWClassLoader());
            }
            catch (MissingResourceException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

