/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.basic.AbstractBookList;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.sword.HttpSwordInstaller;
import org.crosswire.jsword.book.install.sword.Msg;
import org.crosswire.jsword.book.sword.ConfigEntry;
import org.crosswire.jsword.book.sword.SwordBook;
import org.crosswire.jsword.book.sword.SwordBookDriver;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.util.Project;

public abstract class AbstractSwordInstaller
extends AbstractBookList
implements Installer,
Comparable {
    protected static final String PACKAGE_DIR = "packages/rawzip";
    private static final String LIST_DIR = "raw";
    protected Map entries = new HashMap();
    protected String host;
    protected String proxyHost;
    protected Integer proxyPort;
    protected String directory = "/";
    protected boolean loaded;
    protected static final String FILE_LIST_GZ = "mods.d.tar.gz";
    protected static final String ZIP_SUFFIX = ".zip";
    private static final Logger log;
    protected static final String SEARCH_DIR = "search/jsword/L1";
    protected static final String DOWNLOAD_PREFIX = "download-";
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract void download(Job var1, String var2, String var3, URL var4) throws InstallException;

    public String getInstallerDefinition() {
        StringBuffer buf = new StringBuffer(this.host);
        buf.append(',');
        buf.append(this.directory);
        buf.append(',');
        if (this.proxyHost != null) {
            buf.append(this.proxyHost);
        }
        buf.append(',');
        if (this.proxyPort != null) {
            buf.append(this.proxyPort);
        }
        return buf.toString();
    }

    public boolean isNewer(Book book) {
        SwordBookMetaData sbmd;
        File dldir = SwordBookDriver.getDownloadDir();
        File conf = new File(dldir, (sbmd = (SwordBookMetaData)book.getBookMetaData()).getConfPath());
        if (!conf.exists()) {
            return false;
        }
        URL configurl = null;
        try {
            configurl = new URL("file", null, conf.getAbsolutePath());
        }
        catch (MalformedURLException ex) {
            log.error("Failed to create URL for file: " + conf, (Throwable)ex);
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }
        URL remote = this.toRemoteURL(book);
        return NetUtil.isNewer((URL)remote, (URL)configurl, (String)this.proxyHost, (Integer)this.proxyPort);
    }

    public List getBooks() {
        try {
            if (!this.loaded) {
                this.loadCachedIndex();
            }
            ArrayList mutable = new ArrayList();
            mutable.addAll(this.entries.values());
            return Collections.unmodifiableList(mutable);
        }
        catch (InstallException ex) {
            log.error("Failed to reload cached index file", (Throwable)((Object)ex));
            return new ArrayList();
        }
    }

    public void install(Book book) {
        if (Books.installed().getBook(book.getName()) != null) {
            return;
        }
        final SwordBookMetaData sbmd = (SwordBookMetaData)book.getBookMetaData();
        Thread worker = new Thread("DisplayPreLoader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                URL predicturl = Project.instance().getWritablePropertiesURL("sword-install");
                Job job = JobManager.createJob((String)Msg.INSTALLING.toString(sbmd.getName()), (URL)predicturl, (Thread)this, (boolean)true);
                1.yield();
                try {
                    job.setProgress(Msg.JOB_INIT.toString());
                    URL temp = NetUtil.getTemporaryURL((String)"swd", (String)AbstractSwordInstaller.ZIP_SUFFIX);
                    AbstractSwordInstaller.this.download(job, AbstractSwordInstaller.this.directory + '/' + AbstractSwordInstaller.PACKAGE_DIR, sbmd.getInitials() + AbstractSwordInstaller.ZIP_SUFFIX, temp);
                    job.setInterruptable(false);
                    File dldir = SwordBookDriver.getDownloadDir();
                    if (!job.isFinished()) {
                        IOUtil.unpackZip((File)NetUtil.getAsFile((URL)temp), (File)dldir);
                        job.setProgress(Msg.JOB_CONFIG.toString());
                        SwordBookDriver.registerNewBook(sbmd, dldir);
                    }
                }
                catch (Exception ex) {
                    Reporter.informUser((Object)this, (Throwable)ex);
                    job.ignoreTimings();
                }
                finally {
                    job.done();
                }
            }
        };
        worker.setPriority(1);
        worker.start();
    }

    public void reloadBookList() throws InstallException {
        Job job = JobManager.createJob((String)Msg.JOB_DOWNLOADING.toString(), (Thread)Thread.currentThread(), (boolean)false);
        try {
            URL scratchfile = this.getCachedIndexFile();
            this.download(job, this.directory + '/' + LIST_DIR, FILE_LIST_GZ, scratchfile);
            this.loaded = false;
        }
        catch (InstallException ex) {
            job.ignoreTimings();
            throw ex;
        }
        finally {
            job.done();
        }
    }

    public void downloadSearchIndex(Book book, URL localDest) throws InstallException {
        Job job = JobManager.createJob((String)Msg.JOB_DOWNLOADING.toString(), (Thread)Thread.currentThread(), (boolean)false);
        try {
            this.download(job, this.directory + '/' + SEARCH_DIR, book.getInitials() + ZIP_SUFFIX, localDest);
        }
        catch (Exception ex) {
            job.ignoreTimings();
            throw new InstallException((MsgBase)Msg.UNKNOWN_ERROR, ex);
        }
        finally {
            job.done();
        }
    }

    private void loadCachedIndex() throws InstallException {
        BookDriver fake = SwordBookDriver.instance();
        this.entries.clear();
        URL cache = this.getCachedIndexFile();
        if (!NetUtil.isFile((URL)cache)) {
            this.reloadBookList();
        }
        InputStream in = null;
        GZIPInputStream gin = null;
        TarInputStream tin = null;
        try {
            TarEntry entry;
            ConfigEntry.resetStatistics();
            in = cache.openStream();
            gin = new GZIPInputStream(in);
            tin = new TarInputStream((InputStream)gin);
            while ((entry = tin.getNextEntry()) != null) {
                String internal = entry.getName();
                if (entry.isDirectory()) continue;
                try {
                    int size = (int)entry.getSize();
                    byte[] buffer = new byte[size];
                    if (tin.read(buffer) != size) {
                        log.warn("Did not read all that was expected " + internal);
                    }
                    if (internal.endsWith(".conf")) {
                        internal = internal.substring(0, internal.length() - 5);
                    }
                    if (internal.startsWith("mods.d/")) {
                        internal = internal.substring(7);
                    }
                    SwordBookMetaData sbmd = new SwordBookMetaData(buffer, internal);
                    sbmd.setDriver(fake);
                    SwordBook book = new SwordBook(sbmd, null);
                    this.entries.put(book.getName(), book);
                }
                catch (Exception ex) {
                    log.warn("Failed to load config for entry: " + internal, (Throwable)ex);
                }
            }
            this.loaded = true;
            ConfigEntry.dumpStatistics();
        }
        catch (IOException ex) {
            try {
                throw new InstallException((MsgBase)Msg.CACHE_ERROR, ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(tin);
                IOUtil.close(gin);
                IOUtil.close((InputStream)in);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)tin);
        IOUtil.close((InputStream)gin);
        IOUtil.close((InputStream)in);
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String newDirectory) {
        if (this.directory == null || !this.directory.equals(newDirectory)) {
            this.directory = newDirectory;
            this.loaded = false;
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String newHost) {
        if (this.host == null || !this.host.equals(newHost)) {
            this.host = newHost;
            this.loaded = false;
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String newProxyHost) {
        String pHost = null;
        if (newProxyHost != null && newProxyHost.length() > 0) {
            pHost = newProxyHost;
        }
        if (this.proxyHost == null || !this.proxyHost.equals(pHost)) {
            this.proxyHost = pHost;
            this.loaded = false;
        }
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer newProxyPort) {
        if (this.proxyPort == null || !this.proxyPort.equals(newProxyPort)) {
            this.proxyPort = newProxyPort;
            this.loaded = false;
        }
    }

    protected URL getCachedIndexFile() throws InstallException {
        try {
            URL scratchdir = Project.instance().getTempScratchSpace(AbstractSwordInstaller.getTempFileExtension(this.host, this.directory), true);
            return NetUtil.lengthenURL((URL)scratchdir, (String)FILE_LIST_GZ);
        }
        catch (IOException ex) {
            throw new InstallException((MsgBase)Msg.URL_FAILED, ex);
        }
    }

    private static String getTempFileExtension(String host, String directory) {
        return DOWNLOAD_PREFIX + host + directory.replace('/', '_');
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractSwordInstaller)) {
            return false;
        }
        AbstractSwordInstaller that = (AbstractSwordInstaller)object;
        if (!this.equals(this.host, that.host)) {
            return false;
        }
        return this.equals(this.directory, that.directory);
    }

    public int compareTo(Object arg0) {
        HttpSwordInstaller myClass = (HttpSwordInstaller)arg0;
        int ret = this.host.compareTo(myClass.host);
        if (ret != 0) {
            ret = this.directory.compareTo(myClass.directory);
        }
        return ret;
    }

    public int hashCode() {
        return this.host.hashCode() + this.directory.hashCode();
    }

    protected boolean equals(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        return string1.equals(string2);
    }

    static {
        $assertionsDisabled = !AbstractSwordInstaller.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)AbstractSwordInstaller.class);
    }
}

