/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.swing.ButtonPane;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.FieldMap;
import org.crosswire.common.config.swing.Msg;
import org.crosswire.common.config.swing.TreeConfigEditor;
import org.crosswire.common.util.Reporter;

public class AdvancedConfigEditor
extends TreeConfigEditor {
    protected Map comps;
    private static final long serialVersionUID = 3616451198199345203L;

    protected void jbInit() {
        this.ctm = new AdvancedConfigureTreeModel();
        this.tree = new JTree();
        JScrollPane scroll = new JScrollPane();
        CustomTreeCellRenderer render = new CustomTreeCellRenderer();
        this.comps = new HashMap();
        Color orig = UIManager.getColor("control");
        Color bg = new Color(orig.getRed(), orig.getGreen(), orig.getBlue());
        render.setLeafIcon(TASK_ICON_SMALL);
        render.setBackgroundNonSelectionColor(bg);
        scroll.setPreferredSize(new Dimension(150, 150));
        scroll.setViewportView(this.tree);
        this.tree.setBackground(bg);
        this.tree.setModel(this.ctm);
        this.tree.setCellRenderer(render);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.putClientProperty("JTree.lineStyle", "None");
        this.tree.setSelectionRow(0);
        this.tree.setEditable(true);
        this.setLayout(new BorderLayout(5, 10));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add("Center", scroll);
        this.add("South", new ButtonPane(this));
    }

    protected void updateTree() {
        this.ctm.fireTreeStructureChanged(this);
    }

    protected void addChoice(String key, Choice model) {
        try {
            Field field = FieldMap.getField(model);
            this.fields.put(key, field);
            JComponent comp = field.getComponent();
            comp.setToolTipText(model.getHelpText());
            this.comps.put(key, comp);
            String value = this.config.getLocal(key);
            field.setValue(value);
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    protected void removeChoice(String key) {
        try {
            Component comp;
            Field field = (Field)this.fields.get(key);
            if (field != null) {
                this.fields.remove(field);
            }
            if ((comp = (Component)this.comps.get(key)) != null) {
                this.comps.remove(key);
            }
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    public void selectCard() {
        Object obj = this.tree.getLastSelectedPathComponent();
        if (obj == null) {
            return;
        }
        this.title.setText(obj + Msg.PROPERTIES.toString());
        Object[] list = this.tree.getSelectionPath().getPath();
        StringBuffer path = new StringBuffer();
        for (int i = 1; i < list.length; ++i) {
            if (i > 1) {
                path.append(".");
            }
            path.append(list[i].toString());
        }
        String key = path.toString();
        if (this.decks.containsKey(key)) {
            this.layout.show(this.deck, key);
        } else {
            this.layout.show(this.deck, "$$BLANK$$");
        }
        this.deck.repaint();
    }

    class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3256720688860576049L;

        CustomTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jtree, Object value, boolean isselected, boolean expanded, boolean leaf, int row, boolean focus) {
            if (!(value instanceof CompNode)) {
                return super.getTreeCellRendererComponent(jtree, value, isselected, expanded, leaf, row, focus);
            }
            JComponent comp = (JComponent)AdvancedConfigEditor.this.comps.get(value.toString());
            if (comp == null) {
                return super.getTreeCellRendererComponent(jtree, value, isselected, expanded, leaf, row, focus);
            }
            if (isselected) {
                comp.setBorder(BorderFactory.createLineBorder(Color.black));
            } else {
                comp.setBorder(BorderFactory.createEmptyBorder());
            }
            return comp;
        }
    }

    static class CompNode {
        private String path;

        public CompNode(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path;
        }

        public String getFullName() {
            return this.path;
        }
    }

    class AdvancedConfigureTreeModel
    extends TreeConfigEditor.ConfigureTreeModel {
        AdvancedConfigureTreeModel() {
            super(AdvancedConfigEditor.this);
        }

        protected List getChildren(String path) {
            ArrayList<String> retcode = new ArrayList<String>();
            Iterator it = AdvancedConfigEditor.this.config.getNames();
            while (it.hasNext()) {
                int dotPos;
                String temp = (String)it.next();
                if (!temp.startsWith(path) || temp.equals(path)) continue;
                if ((temp = temp.substring(path.length())).startsWith(".")) {
                    temp = temp.substring(1);
                }
                if ((dotPos = temp.indexOf(".")) != -1) {
                    temp = temp.substring(0, dotPos);
                }
                if (temp.length() <= 0 || retcode.contains(temp)) continue;
                retcode.add(temp);
            }
            return retcode;
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof CompNode) {
                return null;
            }
            String path = ((TreeConfigEditor.Node)parent).getFullName();
            List children = this.getChildren(path);
            if (children.size() == 0) {
                return new CompNode(path);
            }
            String name = (String)children.get(index);
            return new TreeConfigEditor.Node(path, name);
        }

        public int getChildCount(Object parent) {
            if (parent instanceof CompNode) {
                return 0;
            }
            String path = ((TreeConfigEditor.Node)parent).getFullName();
            int children = this.getChildren(path).size();
            if (children == 0) {
                children = 1;
            }
            return children;
        }

        public boolean isLeaf(Object node) {
            return node instanceof CompNode;
        }
    }
}

