/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PatternFormatter
extends Formatter {
    private Date dat = new Date();
    private static final String DEFAULT_FORMAT = "{1}({2}): {3}{8} {4}";
    private MessageFormat formatter;
    private String lineSeparator = System.getProperty("line.separator", "\r\n");
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized String format(LogRecord record) {
        Logger logger;
        String throwable;
        block6: {
            this.dat.setTime(record.getMillis());
            throwable = "";
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    throwable = sw.toString();
                }
                catch (Exception ex) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
        }
        String format = LogManager.getLogManager().getProperty(PatternFormatter.class.getName() + ".format");
        String loggerName = record.getLoggerName();
        for (Logger aLogger = logger = LogManager.getLogManager().getLogger(loggerName); aLogger != null; aLogger = aLogger.getParent()) {
            String property = null;
            String aLoggerName = aLogger.getName();
            if (aLoggerName != null) {
                property = LogManager.getLogManager().getProperty(aLoggerName + ".format");
            }
            if (property == null) continue;
            format = property;
            break;
        }
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        Object[] args = new Object[]{this.dat, record.getLoggerName(), record.getLevel().getLocalizedName(), this.formatMessage(record), throwable, record.getSourceClassName(), record.getSourceMethodName(), new Long(record.getSequenceNumber()), this.lineSeparator};
        StringBuffer text = new StringBuffer();
        this.formatter = new MessageFormat(format);
        this.formatter.format(args, text, (FieldPosition)null);
        return text.toString();
    }

    static {
        $assertionsDisabled = !PatternFormatter.class.desiredAssertionStatus();
    }
}

