/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.ArrayList;
import java.util.List;
import org.crosswire.common.util.Msg;
import org.crosswire.common.util.Reporter;

public final class ThreadUtil {
    private static final String PADDING = "                                                                ";

    private ThreadUtil() {
    }

    public static synchronized void soundSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Reporter.informUser((Object)ThreadUtil.class, ex);
        }
    }

    public static ThreadGroup findRoot() {
        ThreadGroup top = Thread.currentThread().getThreadGroup();
        while (top.getParent() != null) {
            top = top.getParent();
        }
        return top;
    }

    public static String[] getListing() {
        return ThreadUtil.getListing(ThreadUtil.findRoot());
    }

    public static String[] getListing(ThreadGroup base) {
        ArrayList list = new ArrayList();
        ThreadUtil.listThreads(list, 0, base);
        return list.toArray(new String[list.size()]);
    }

    private static void listThreads(List list, int depth, ThreadGroup group) {
        if (group == null) {
            return;
        }
        try {
            int i;
            int num_threads = group.activeCount();
            int num_groups = group.activeGroupCount();
            Thread[] threads = new Thread[num_threads];
            ThreadGroup[] groups = new ThreadGroup[num_groups];
            group.enumerate(threads, false);
            group.enumerate(groups, false);
            try {
                ThreadUtil.addItem(list, depth, group.getName());
            }
            catch (SecurityException ex) {
                ThreadUtil.addItem(list, depth, Msg.UNAVILABLE.toString());
            }
            for (i = 0; i < num_threads; ++i) {
                ThreadUtil.listThread(list, depth + 1, threads[i]);
            }
            for (i = 0; i < num_groups; ++i) {
                ThreadUtil.listThreads(list, depth + 1, groups[i]);
            }
        }
        catch (Exception ex) {
            ThreadUtil.addItem(list, depth, ex.toString());
        }
    }

    private static void listThread(List list, int depth, Thread thread) {
        if (thread == null) {
            return;
        }
        try {
            ThreadUtil.addItem(list, depth, thread.getName() + " (" + thread.getPriority() + ')');
        }
        catch (SecurityException ex) {
            ThreadUtil.addItem(list, depth, Msg.UNAVILABLE.toString());
        }
    }

    private static void addItem(List list, int depth, String item) {
        list.add(PADDING.substring(0, depth * 2) + item);
    }
}

