/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.text.MessageFormat;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;

public class LucidRuntimeException
extends RuntimeException {
    private static final Logger log = Logger.getLogger(LucidRuntimeException.class);
    private static final long serialVersionUID = 3906091143962965817L;
    protected final Object[] params;

    public LucidRuntimeException(MsgBase msg) {
        this(msg, null, null);
    }

    public LucidRuntimeException(MsgBase msg, Throwable cause) {
        this(msg, cause, null);
    }

    public LucidRuntimeException(MsgBase msg, Object[] params) {
        this(msg, null, params);
    }

    public LucidRuntimeException(MsgBase msg, Throwable cause, Object[] params) {
        super(msg.toString(), cause);
        this.params = (Object[])params.clone();
    }

    public String getMessage() {
        String out = super.getMessage();
        if (this.params == null) {
            return out;
        }
        try {
            return MessageFormat.format(out, this.params);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Format fail for '" + out + '\'', ex);
            return "Error formatting message '" + out + '\'';
        }
    }
}

