/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.examples;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.common.util.StringUtil;
import org.crosswire.common.xml.XMLProcess;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.sword.SwordConstants;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseFactory;

public class BibleToOsis {
    private static final String BIBLE_NAME = "KJV";
    private static final String BIBLE_RANGE = "Gen-Rev";
    private static final boolean BY_BOOK = false;
    private static FieldPosition pos = new FieldPosition(0);
    private static String preVerseStart = "<title subtype=\"x-preverse\" type=\"section\">";
    private static String preVerseElement = "<title subtype=\"x-preverse\" type=\"section\">(.*?)</title>";
    private static Pattern preVersePattern = Pattern.compile(preVerseElement);
    private static String psalmTitleStart = "<title type=\"psalm\">";
    private static String psalmTitleElement = "<title type=\"psalm\">(.*?)</title>";
    private static Pattern psalmTitlePattern = Pattern.compile(psalmTitleElement);
    private static String divineNameElement = "(<divineName.*?>)(.*?)(LORD'S|LORD|GOD|JEHOVAH)(.*?)(</divineName>)";
    private static String divineNameReplace = "$2<seg><divineName>$3</divineName></seg>$4";
    private static Pattern divineNamePattern = Pattern.compile(divineNameElement);
    private static Pattern dna1Pattern = Pattern.compile("(<w\\s+lemma=\"strong:H03069\"\\s*>.*?)(GOD|LORD|LORD'S)(.*?</w>)");
    private static Pattern dna2Pattern = Pattern.compile("(<w\\s+lemma=\"strong:H03050\"\\s*>.*?)(GOD|LORD|LORD'S|JAH)(.*?</w>)");
    private static String dna1Replace = "$1<seg><divineName>$2</divineName></seg>$3";
    private static Pattern dn1Pattern = Pattern.compile("<divineName>LORD</divineName>");
    private static String dn1Replace = "<divineName>Lord</divineName>";
    private static Pattern dn2Pattern = Pattern.compile("<divineName>LORD'S</divineName>");
    private static String dn2Replace = "<divineName>Lord's</divineName>";
    private static Pattern dn3Pattern = Pattern.compile("<divineName>GOD</divineName>");
    private static String dn3Replace = "<divineName>God</divineName>";
    private static Pattern dn4Pattern = Pattern.compile("<divineName>JEHOVAH</divineName>");
    private static String dn4Replace = "<divineName>Jehovah</divineName>";
    private static Pattern dn5Pattern = Pattern.compile("<divineName>JAH</divineName>");
    private static String dn5Replace = "<divineName>Jah</divineName>";
    private static Pattern dn6Pattern = Pattern.compile("LORD'S");
    private static String dn6Replace = "<divineName>Lord's</divineName>";
    private static Pattern dn7Pattern = Pattern.compile("LORD");
    private static String dn7Replace = "<divineName>Lord</divineName>";
    private static Pattern dn8Pattern = Pattern.compile("GOD");
    private static String dn8Replace = "<divineName>God</divineName>";
    private static Pattern dn9Pattern = Pattern.compile("JEHOVAH");
    private static String dn9Replace = "<divineName>Jehovah</divineName>";
    private static Pattern dn10Pattern = Pattern.compile("JAH");
    private static String dn10Replace = "<divineName>Jah</divineName>";
    private static String transChangeSeg = "<seg type=\"transChange\" subType=\"type:added\">([^<]*)</seg>";
    private static Pattern transChangeSegPattern = Pattern.compile(transChangeSeg);
    private static String badNote = "<note type=\"[^\"]*\" (name=\"([^\"]*)\" date=\"([^\"]*)\"/)>([^<]*)</note>";
    private static Pattern badNotePattern = Pattern.compile(badNote);
    private static String respElement = "<resp.*?name=\"(.*?)\".*?date=\"(.*?)\".*?>";
    private static Pattern respPattern = Pattern.compile(respElement);
    private static Pattern pPattern = Pattern.compile("(<p/>\\s*)+(<w[^>]+></w>)\\s*");
    private static String wElement = "<w\\s[^>]*>";
    private static Pattern wPattern = Pattern.compile(wElement);
    private static Pattern srcPattern = Pattern.compile("src=\"([^\"]*)\"");
    private static Pattern morphNPattern = Pattern.compile("morph=\"robinson:N-([^\"]*)\"");
    private static Pattern morphTPattern = Pattern.compile("morph=\"robinson:T-([^\"]*)\"");
    private static Pattern a1Pattern = Pattern.compile("(\\w+s')(\\w\\w+)");
    private static Pattern a2Pattern = Pattern.compile("(LORD')(</w>)");
    private static Pattern a3Pattern = Pattern.compile("(\\w*[^s]')(</w>|</note>|</seg>|</transChange>)");
    private static Pattern a4Pattern = Pattern.compile("(\\w*[^s])</w>('s)");
    private static Pattern a5Pattern = Pattern.compile("(LORD') ");
    private static Pattern a6Pattern = Pattern.compile("(\\w*[^s>]') ");
    private static Pattern a7Pattern = Pattern.compile("(LORD')([.:])");
    private static Pattern a8Pattern = Pattern.compile("(\\w+[^s>]')([.:])");
    private static Pattern a9Pattern = Pattern.compile("(\\w+)</w>'<");
    private static Pattern a10Pattern = Pattern.compile("(\\w+)</w>'(s\\w+)");
    private static Pattern a11Pattern = Pattern.compile("</w>(<w[^>]*>)('s?) ");
    private static Pattern a12Pattern = Pattern.compile("</w>' ");
    private static Pattern a13Pattern = Pattern.compile("</w>'");
    private static Pattern a14Pattern = Pattern.compile("(\\w+[^Ss]')</w>(.)");
    private static Pattern a15Pattern = Pattern.compile("(husband') ");
    private static Pattern a16Pattern = Pattern.compile("(cockatrice')s");
    private static Pattern a17Pattern = Pattern.compile("(ass')([^s])");
    private static Pattern w1Pattern = Pattern.compile("\\s([,;:.?!])");
    private static Pattern w4Pattern = Pattern.compile("[\n\r\t]");
    private static Pattern w5Pattern = Pattern.compile("([!\"#$%&()*+,-./:;=?@^_`{|}~ ]+)(</w>|</transChange>)");
    private static Pattern w6Pattern = Pattern.compile("(<w\\s[^>]*>|<transChange\\s[^>]*>)([!\"#$%&'()*+,-./:;=?@^_`{|}~ ]+)");
    private static Pattern w7Pattern = Pattern.compile("(<w\\s[^>]*></w>)([!\"#$%&'()*+,-./:;=?@^_`{|}~ ]+)");
    private static Pattern w2Pattern = Pattern.compile("\\s\\)");
    private static Pattern w3Pattern = Pattern.compile("\\(\\s");
    private static Pattern w8Pattern = Pattern.compile("(<milestone type=\"x-p\" marker=\"\u00b6\"/>)\\s+");
    private static Pattern w9Pattern = Pattern.compile("(<title\\s[^>]*>)\\s+");
    private static Pattern w10Pattern = Pattern.compile("(</title>) ");
    private static Pattern w11Pattern = Pattern.compile(" (<note)");
    private static Pattern w12Pattern = Pattern.compile("\\s+(</note>)");
    private static Pattern wnPattern = Pattern.compile("\\s\\s+");
    private static Pattern p1Pattern = Pattern.compile("\\.\\.\\.");
    private static Map bookTitles = new HashMap();
    private static Map colophons;
    private static Map acrostics;
    private static Map hebLetters;
    private boolean moveP;
    private static Set paragraphs;
    private Writer writer;
    private String filename;

    public static void main(String[] args) {
        new BibleToOsis().dump(BIBLE_NAME, BIBLE_RANGE);
    }

    public void dump(String name, String range) {
        Books books = Books.installed();
        Book bible = books.getBook(name);
        BookMetaData bmd = bible.getBookMetaData();
        String lastBookName = "";
        int lastChapter = -1;
        StringBuffer buf = new StringBuffer();
        boolean inPreVerse = false;
        try {
            Key keys = bible.getKey(range);
            this.openOutputFile(bmd.getInitials(), true);
            this.buildDocumentOpen(buf, bmd, range, true);
            this.writeDocument(buf);
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                boolean newBookFound;
                Verse verse = (Verse)iter.next();
                String raw = bible.getRawData(verse);
                String osisID = verse.getOsisID();
                Verse v = null;
                try {
                    v = VerseFactory.fromString(osisID);
                }
                catch (NoSuchVerseException e) {
                    // empty catch block
                }
                String currentBookName = BibleInfo.getOSISName(verse.getBook());
                int currentChapter = verse.getChapter();
                boolean bl = newBookFound = !lastBookName.equals(currentBookName);
                if (newBookFound) {
                    if (lastBookName.length() > 0) {
                        if (currentChapter == 1) {
                            if (inPreVerse) {
                                this.buildPreVerseClose(buf);
                                inPreVerse = false;
                            }
                            this.buildChapterClose(buf);
                        }
                        this.buildBookClose(buf, lastBookName);
                        this.buildDocumentClose(buf, false);
                        this.openOutputFile(lastBookName, false);
                        this.writeDocument(buf);
                        this.closeOutputFile(false);
                    }
                    buf = new StringBuffer();
                    this.buildDocumentOpen(buf, bmd, currentBookName, false);
                    this.buildBookOpen(buf, currentBookName);
                }
                if (newBookFound || lastChapter != currentChapter) {
                    if (currentChapter != 1) {
                        if (inPreVerse) {
                            this.buildPreVerseClose(buf);
                            inPreVerse = false;
                        }
                        this.buildChapterClose(buf);
                    }
                    this.buildChapterOpen(buf, currentBookName, currentChapter);
                }
                if (osisID.equals("Ps.132.1")) {
                    raw = this.replace(raw, "<w lemma=\"x-Strongs:H07892\">A Song</w> <w lemma=\"x-Strongs:H04609\">of degrees</w>. ", "<title type=\"psalm\"><w lemma=\"x-Strongs:H07892\">A Song</w> <w lemma=\"x-Strongs:H04609\">of degrees</w>.</title>");
                }
                boolean foundPreVerse = false;
                String preVerseText = "";
                if (raw.indexOf(preVerseStart) != -1) {
                    Matcher matcher = preVersePattern.matcher(raw);
                    StringBuffer rawbuf = new StringBuffer();
                    if (matcher.find()) {
                        foundPreVerse = true;
                        preVerseText = matcher.group(1);
                        matcher.appendReplacement(rawbuf, "");
                    }
                    matcher.appendTail(rawbuf);
                    raw = rawbuf.toString();
                }
                boolean foundPsalmTitle = false;
                String psalmTitleText = "";
                if (raw.indexOf(psalmTitleStart) != -1) {
                    Matcher matcher = psalmTitlePattern.matcher(raw);
                    StringBuffer rawbuf = new StringBuffer();
                    if (matcher.find()) {
                        foundPsalmTitle = true;
                        psalmTitleText = matcher.group(1);
                        matcher.appendReplacement(rawbuf, "");
                    }
                    matcher.appendTail(rawbuf);
                    raw = rawbuf.toString();
                }
                if (foundPsalmTitle) {
                    this.buildPsalmTitle(buf, this.cleanup(osisID, psalmTitleText, false));
                }
                if (foundPreVerse && !preVerseText.equals(psalmTitleText)) {
                    if (inPreVerse) {
                        this.buildPreVerseClose(buf);
                    }
                    this.buildPreVerseOpen(buf, this.cleanup(osisID, preVerseText, false));
                    inPreVerse = true;
                }
                if (SwordConstants.getTestament(v) == 2 && raw.indexOf("<title") != -1) {
                    Pattern p = Pattern.compile("<title.*?>(.*?)</title>");
                    Matcher matcher = p.matcher(raw);
                    StringBuffer rawbuf = new StringBuffer();
                    while (matcher.find()) {
                        matcher.appendReplacement(rawbuf, "");
                    }
                    matcher.appendTail(rawbuf);
                    raw = rawbuf.toString();
                }
                this.buildVerseOpen(buf, osisID);
                buf.append(this.cleanup(osisID, raw, true));
                this.buildVerseClose(buf, osisID);
                lastChapter = currentChapter;
                lastBookName = currentBookName;
            }
            if (inPreVerse) {
                this.buildPreVerseClose(buf);
                inPreVerse = false;
            }
            this.buildChapterClose(buf);
            this.buildBookClose(buf, lastBookName);
            this.buildDocumentClose(buf, true);
            this.openOutputFile(lastBookName, false);
            this.writeDocument(buf);
            this.closeOutputFile(true);
        }
        catch (BookException e) {
            e.printStackTrace();
        }
        catch (NoSuchVerseException e) {
            e.printStackTrace();
        }
        catch (NoSuchKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String unescape(String s) {
        StringBuffer sbuf = new StringBuffer();
        int l = s.length();
        int ch = -1;
        int b = 0;
        int sumb = 0;
        int i = 0;
        int more = -1;
        for (i = 0; i < l; ++i) {
            ch = s.charAt(i);
            switch (ch) {
                case 37: {
                    ch = s.charAt(++i);
                    int hb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    break;
                }
                case 43: {
                    b = 32;
                    break;
                }
                default: {
                    b = ch;
                }
            }
            if ((b & 0xC0) == 128) {
                sumb = sumb << 6 | b & 0x3F;
                if (--more != 0) continue;
                sbuf.append((char)sumb);
                continue;
            }
            if ((b & 0x80) == 0) {
                sbuf.append((char)b);
                continue;
            }
            if ((b & 0xE0) == 192) {
                sumb = b & 0x1F;
                more = 1;
                continue;
            }
            if ((b & 0xF0) == 224) {
                sumb = b & 0xF;
                more = 2;
                continue;
            }
            if ((b & 0xF8) == 240) {
                sumb = b & 7;
                more = 3;
                continue;
            }
            if ((b & 0xFC) == 248) {
                sumb = b & 3;
                more = 4;
                continue;
            }
            sumb = b & 1;
            more = 5;
        }
        return sbuf.toString();
    }

    private void buildDocumentOpen(StringBuffer buf, BookMetaData bmd, String range, boolean force) {
        if (!force) {
            return;
        }
        StringBuffer docBuffer = new StringBuffer();
        docBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        docBuffer.append("\n<osis");
        docBuffer.append("\n  xmlns=\"http://www.bibletechnologies.net/2003/OSIS/namespace\"");
        docBuffer.append("\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        docBuffer.append("\n  xsi:schemaLocation=\"http://www.bibletechnologies.net/2003/OSIS/namespace http://www.bibletechnologies.net/osisCore.2.1.1.xsd\">");
        docBuffer.append("\n<osisText osisIDWork=\"{0}\" osisRefWork=\"defaultReferenceScheme\" xml:lang=\"en\">");
        docBuffer.append("\n<header>");
        docBuffer.append("\n  <work osisWork=\"{0}\">");
        docBuffer.append("\n    <title>{1}</title>");
        docBuffer.append("\n    <identifier type=\"OSIS\">Bible.{0}</identifier>");
        docBuffer.append("\n    <scope>{2}</scope>");
        docBuffer.append("\n    <refSystem>Bible.KJV</refSystem>");
        docBuffer.append("\n  </work>");
        docBuffer.append("\n  <work osisWork=\"defaultReferenceScheme\">");
        docBuffer.append("\n    <refSystem>Bible.KJV</refSystem>");
        docBuffer.append("\n  </work>");
        docBuffer.append("\n  <work osisWork=\"strong\">");
        docBuffer.append("\n    <refSystem>Dict.Strongs</refSystem>");
        docBuffer.append("\n  </work>");
        docBuffer.append("\n  <work osisWork=\"robinson\">");
        docBuffer.append("\n    <refSystem>Dict.Robinsons</refSystem>");
        docBuffer.append("\n  </work>");
        docBuffer.append("\n  <work osisWork=\"strongMorph\">");
        docBuffer.append("\n    <refSystem>Dict.strongMorph</refSystem>");
        docBuffer.append("\n  </work>");
        docBuffer.append("\n</header>");
        docBuffer.append('\n');
        MessageFormat msgFormat = new MessageFormat(docBuffer.toString());
        msgFormat.format(new Object[]{bmd.getInitials(), bmd.getName(), range}, buf, pos);
    }

    private void buildDocumentClose(StringBuffer buf, boolean force) {
        if (force) {
            buf.append("</osisText>\n</osis>\n");
        }
    }

    private void buildBookOpen(StringBuffer buf, String bookName) {
        System.err.println("processing " + bookName);
        MessageFormat msgFormat = new MessageFormat("<div type=\"book\" osisID=\"{0}\" canonical=\"true\">\n");
        msgFormat.format(new Object[]{bookName}, buf, pos);
        MessageFormat titleFormat = new MessageFormat("<title type=\"main\">{0}</title>\n");
        String title = (String)bookTitles.get(bookName);
        if (title != null) {
            titleFormat.format(new Object[]{title}, buf, pos);
        }
    }

    private void buildBookClose(StringBuffer buf, String bookName) {
        String colophon = (String)colophons.get(bookName);
        if (colophon != null) {
            buf.append(colophon);
        }
        buf.append("</div>\n");
    }

    private void buildChapterClose(StringBuffer buf) {
        buf.append("</chapter>\n");
    }

    private void buildChapterOpen(StringBuffer buf, String bookName, int chapter) {
        if (bookName.equals("Obad") || bookName.equals("Phlm") || bookName.equals("2John") || bookName.equals("3John") || bookName.equals("Jude")) {
            MessageFormat msgSingleFormat = new MessageFormat("<chapter osisID=\"{0}.{1}\" chapterTitle=\"{2} {1}.\">\n");
            msgSingleFormat.format(new Object[]{bookName, new Integer(chapter)}, buf, pos);
            return;
        }
        String chapterName = "CHAPTER";
        if (bookName.equals("Ps")) {
            chapterName = "PSALM";
        }
        MessageFormat msgFormat = new MessageFormat("<chapter osisID=\"{0}.{1}\" chapterTitle=\"{2} {1}.\">\n<title type=\"chapter\">{2} {1}.</title>\n");
        msgFormat.format(new Object[]{bookName, new Integer(chapter), chapterName}, buf, pos);
    }

    private void buildPsalmTitle(StringBuffer buf, String psalmTitle) {
        MessageFormat msgFormat = new MessageFormat("<title type=\"psalm\" canonical=\"true\">{0}</title>");
        msgFormat.format(new Object[]{psalmTitle}, buf, pos);
    }

    private void buildPreVerseOpen(StringBuffer buf, String preVerse) {
        MessageFormat msgFormat = new MessageFormat("<div type=\"section\" canonical=\"true\"><title canonical=\"true\">{0}</title>");
        msgFormat.format(new Object[]{preVerse}, buf, pos);
    }

    private void buildPreVerseClose(StringBuffer buf) {
        buf.append("</div>\n");
    }

    private void buildVerseOpen(StringBuffer buf, String osisID) {
        MessageFormat msgFormat = new MessageFormat("<verse osisID=\"{0}\">");
        msgFormat.format(new Object[]{osisID}, buf, pos);
    }

    private void buildVerseClose(StringBuffer buf, String osisID) {
        MessageFormat msgFormat = new MessageFormat("</verse>\n");
        msgFormat.format(new Object[]{osisID}, buf, pos);
    }

    private void openOutputFile(String newFilename, boolean open) throws IOException {
        if (open) {
            this.filename = newFilename;
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename + ".xml"), "UTF-8");
        }
    }

    private void writeDocument(StringBuffer buf) throws IOException {
        this.writer.write(buf.toString());
    }

    private void closeOutputFile(boolean close) throws IOException {
        if (close) {
            this.writer.close();
            this.parse();
        }
    }

    private void parse() {
        XMLProcess parser = new XMLProcess();
        parser.getFeatures().setFeatureStates(new String[]{"-s", "-f", "-va", "-dv"});
        parser.parse(this.filename + ".xml");
    }

    private String cleanup(String osisID, String input, boolean inVerse) {
        String acrostic = (String)acrostics.get(osisID);
        if (acrostic != null) {
            MessageFormat msgFormat = new MessageFormat("<title type=\"acrostic\" canonical=\"true\">{0}</title>");
            input = input.replaceFirst((String)hebLetters.get(osisID), "");
            input = msgFormat.format(new Object[]{acrostic}) + input;
        }
        if (input.indexOf("note type=\"strongsMarkup\"") != -1) {
            MessageFormat noteCleanupFormat = new MessageFormat("<note type=\"x-strongsMarkup\" resp=\"{0} {1}\">{2}</note>");
            Matcher matcher = badNotePattern.matcher(input);
            StringBuffer buf = new StringBuffer();
            while (matcher.find()) {
                String content = XMLUtil.escape((String)BibleToOsis.unescape(matcher.group(4)));
                String replacement = noteCleanupFormat.format(new Object[]{matcher.group(2), matcher.group(3), content});
                matcher.appendReplacement(buf, replacement);
            }
            matcher.appendTail(buf);
            input = buf.toString();
        }
        if (input.indexOf("<resp") != -1) {
            Matcher matcher = respPattern.matcher(input);
            StringBuffer buf = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(buf, "<milestone type=\"x-strongsMarkup\" resp=\"$1 $2\"/>");
            }
            matcher.appendTail(buf);
            input = buf.toString();
        }
        if (osisID.equals("1Cor.16.24")) {
            input = input + "<w src=\"15\" lemma=\"strong:G575\" morph=\"robinson:PREP\"></w><w src=\"11\" lemma=\"strong:G4314\" morph=\"robinson:PREP\"></w><w src=\"12\" lemma=\"strong:G2881\" morph=\"robinson:A-APM\"></w>";
        }
        if (osisID.equals("2Cor.13.14")) {
            input = input + "<w src=\"26\" lemma=\"strong:G575\" morph=\"robinson:PREP\"></w><w src=\"22\" lemma=\"strongs:G4314\" morph=\"robinson:PREP\"></w>";
        }
        if (osisID.equals("1Thess.1.8")) {
            input = this.replace(input, "<w src=\"25\" lemma=\"strong:G4314\" morph=\"robinson:PREP\">to</w> <w src=\"26 27\" lemma=\"strong:G3588 strong:G2316\" morph=\"robinson:T-ASM robinson:N-ASM\">God</w>-<w src=\"25\" lemma=\"strong:G4314\" morph=\"robinson:PREP\" type=\"x-split\" subType=\"x-36\">ward</w>", "<w src=\"25 26 27\" lemma=\"strong:G4314 strong:G3588 strong:G2316\" morph=\"robinson:PREP robinson:T-ASM robinson:N-ASM\">to God-ward</w>");
        }
        if (osisID.equals("1Thess.5.28")) {
            input = input + "<w src=\"11\" lemma=\"strong:G4314\" morph=\"robinson:PREP\"></w><w src=\"12\" lemma=\"strong:G2331\" morph=\"robinson:N-APM\"></w>";
        }
        TreeSet<Integer> before = new TreeSet<Integer>();
        Matcher wMatcher = wPattern.matcher(input);
        while (wMatcher.find()) {
            String whole = wMatcher.group(0);
            String fixed = whole.replaceAll(" (src|w|morph)(?=[^=])", " ");
            fixed = fixed.replaceAll("\\|", " ");
            fixed = fixed.replaceAll("\\s+", " ");
            fixed = fixed.replaceAll("x-Strongs", "strong");
            fixed = fixed.replaceAll("x-Robinson", "robinson");
            if (!whole.equals(fixed = fixed.replaceAll("split(ID|id)=\"", "type=\"x-split\" subType=\"x-"))) {
                input = this.replace(input, whole, fixed);
            }
            Matcher srcMatcher = srcPattern.matcher(fixed);
            while (srcMatcher.find()) {
                Integer src = new Integer(srcMatcher.group(1));
                before.add(src);
            }
        }
        int i = 1;
        Iterator<Object> iter = before.iterator();
        while (iter.hasNext()) {
            Integer number = (Integer)iter.next();
            int j = number;
            if (i != j) {
                while (i < j) {
                    System.out.println(osisID + " missing src=" + i);
                    ++i;
                }
            }
            ++i;
        }
        input = input.replaceAll("changeType=\"", "type=\"");
        if (osisID.startsWith("Ps")) {
            Matcher matcher = transChangeSegPattern.matcher(input);
            StringBuffer buf = null;
            while (matcher.find()) {
                if (buf == null) {
                    buf = new StringBuffer();
                }
                matcher.appendReplacement(buf, "<transChange type=\"added\">$1</transChange>");
            }
            if (buf != null) {
                matcher.appendTail(buf);
                input = buf.toString();
            }
        }
        input = input.replaceAll("\"transChange\"", "\"x-transChange\"");
        input = input.replaceAll("type:", "x-");
        input = input.replaceAll(" type=\"x-yhwh\"", "");
        input = input.replaceAll("x-StudyNote", "study");
        input = input.replace('#', 'G');
        input = input.replace('`', '\'');
        input = input.replace('_', ' ');
        input = input.replaceAll("[{][Ff][iI][}]", "");
        input = this.replace(input, "@hotmail.", "at hotmail dot ");
        if (osisID.equals("Exod.32.32")) {
            input = this.replace(input, "<w morph=\"strongMorph:TH8798\" lemma=\"strong:H04229\">--; ", "\u2015; <w morph=\"strongMorph:TH8798\" lemma=\"strong:H04229\">");
        }
        if (osisID.equals("Ezek.26.16")) {
            input = this.replace(input, "\\pa", "");
        }
        if (osisID.equals("Matt.5.30")) {
            input = this.replace(input, "<w src=\"10\" lemma=\"strong:G846\" morph=\"robinson:P-ASF\">if</w>", "<w src=\"10\" lemma=\"strong:G846\" morph=\"robinson:P-ASF\">it</w>");
        }
        if (osisID.equals("Matt.16.17")) {
            input = this.replace(input, "<w src=\"10\" lemma=\"strong:G920\" morph=\"robinson:ARAM\">Bar</w><w src=\"11\" lemma=\"strong:G920\" morph=\"robinson:ARAM\">jona</w>", "<w src=\"10 11\" lemma=\"strong:G920\" morph=\"robinson:ARAM\">Bar\u2013jona</w>");
        }
        if (osisID.equals("Matt.24.38")) {
            input = this.replace(input, "<w src=\"18\" lemma=\"strong:G3739\" morph=\"robinson:R-GSF\"><w src=\"7\" lemma=\"strong:G3588\" morph=\"robinson:T-DPF\">that</w></w>", "<w src=\"18\" lemma=\"strong:G3739\" morph=\"robinson:R-GSF\"></w><w src=\"7\" lemma=\"strong:G3588\" morph=\"robinson:T-DPF\">that</w>");
        }
        if (osisID.equals("Matt.18.28")) {
            input = this.replace(input, "<w src=\"19\" lemma=\"strong:G4155\" morph=\"robinson:V-IAI-3S\">and took <transChange type=\"added\">him</transChange> by the throat</w>", "<w src=\"19\" lemma=\"strong:G4155\" morph=\"robinson:V-IAI-3S\">and took <seg type=\"x-transChange\" subType=\"x-added\">him</seg> by the throat</w>");
        }
        if (osisID.equals("Matt.21.28")) {
            input = this.replace(input, "<w src=\"5\" lemma=\"strong:G444\" morph=\"robinson:N-NSM\">A <transChange type=\"added\">certain</transChange> man</w>", "<w src=\"5\" lemma=\"strong:G444\" morph=\"robinson:N-NSM\">A <seg type=\"x-transChange\" subType=\"x-added\">certain</seg> man</w>");
        }
        if (osisID.equals("Matt.21.31")) {
            input = this.replace(input, "<w src=\"9\" lemma=\"strong:G3962\" morph=\"robinson:N-GSM\">of <transChange type=\"added\">his</transChange> father</w>", "<w src=\"9\" lemma=\"strong:G3962\" morph=\"robinson:N-GSM\">of <seg type=\"x-transChange\" subType=\"x-added\">his</seg> father</w>");
        }
        if (osisID.equals("Matt.22.6")) {
            input = this.replace(input, "<w src=\"8\" lemma=\"strong:G5195\" morph=\"robinson:V-AAI-3P\">and entreated <transChange type=\"added\">them</transChange> spitefully</w>", "<w src=\"8\" lemma=\"strong:G5195\" morph=\"robinson:V-AAI-3P\">and entreated <seg type=\"x-transChange\" subType=\"x-added\">them</seg> spitefully</w>");
        }
        if (osisID.equals("Matt.23.4")) {
            input = this.replace(input, "<w src=\"19\" lemma=\"strong:G2309\" morph=\"robinson:V-PAI-3P\">they <transChange type=\"added\">themselves</transChange> will</w>", "<w src=\"19\" lemma=\"strong:G2309\" morph=\"robinson:V-PAI-3P\">they <seg type=\"x-transChange\" subType=\"x-added\">themselves</seg> will</w>");
        }
        if (osisID.equals("Matt.25.37")) {
            input = this.replace(input, "<w src=\"17\" lemma=\"strong:G4222\" morph=\"robinson:V-AAI-1P\">gave <transChange type=\"added\">thee</transChange> drink</w>", "<w src=\"17\" lemma=\"strong:G4222\" morph=\"robinson:V-AAI-1P\">gave <seg type=\"x-transChange\" subType=\"x-added\">thee</seg> drink</w>");
        }
        if (osisID.equals("Matt.25.38")) {
            input = this.replace(input, "<w src=\"7\" lemma=\"strong:G4863\" morph=\"robinson:V-2AAI-1P\">took <transChange type=\"added\">thee</transChange> in</w>", "<w src=\"7\" lemma=\"strong:G4863\" morph=\"robinson:V-2AAI-1P\">took <seg type=\"x-transChange\" subType=\"x-added\">thee</seg> in</w>");
        }
        if (osisID.equals("Matt.26.17")) {
            input = this.replace(input, "<w src=\"5\" lemma=\"strong:G106\" morph=\"robinson:A-GPN\">of the <transChange type=\"added\">feast of</transChange> unleavened bread</w>", "<w src=\"5\" lemma=\"strong:G106\" morph=\"robinson:A-GPN\">of the <seg type=\"x-transChange\" subType=\"x-added\">feast of</seg> unleavened bread</w>");
        }
        if (osisID.equals("Matt.26.45")) {
            input = this.replace(input, "<w src=\"15\" lemma=\"strong:G373\" morph=\"robinson:V-PMI-2P\">take <transChange type=\"added\">your</transChange> rest</w>", "<w src=\"15\" lemma=\"strong:G373\" morph=\"robinson:V-PMI-2P\">take <seg type=\"x-transChange\" subType=\"x-added\">your</seg> rest</w>");
        }
        if (osisID.equals("Matt.26.67")) {
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G4474\" morph=\"robinson:V-AAI-3P\">smote <transChange type=\"added\">him</transChange> with the palms of their hands</w>", "<w src=\"12\" lemma=\"strong:G4474\" morph=\"robinson:V-AAI-3P\">smote <seg type=\"x-transChange\" subType=\"x-added\">him</seg> with the palms of their hands</w>");
        }
        if (osisID.equals("Matt.26.69")) {
            input = this.replace(input, "<w src=\"2\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\"><w src=\"9\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\">and</w></w>", "<w src=\"2 9\" lemma=\"strong:G1161 strong:G2532\" morph=\"robinson:CONJ\">and</w>");
        }
        if (osisID.equals("Mark.10.27")) {
            input = this.replace(input, "<transChange type=\"added\"><w src=\"9\" lemma=\"strong:G102\" morph=\"robinson:A-NSN\">it is</transChange> impossible</w>", "<transChange type=\"added\">it is</transChange> <w src=\"9\" lemma=\"strong:G102\" morph=\"robinson:A-NSN\">impossible</w>");
        }
        if (osisID.equals("Luke.9.36")) {
            input = this.replace(input, "<w src=\"13\" lemma=\"strong:G4601\" morph=\"robinson:V-AAI-3P\">kept <transChange type=\"added\">it</transChange> close</w>", "<w src=\"13\" lemma=\"strong:G4601\" morph=\"robinson:V-AAI-3P\">kept <seg type=\"x-transChange\" subType=\"x-added\">it</seg> close</w>");
        }
        if (osisID.equals("Luke.11.19")) {
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G1544\" morph=\"robinson:V-PAI-3P\" type=\"x-split\" subType=\"x-21\">cast <transChange type=\"added\">them</transChange> out</w>", "<w src=\"14\" lemma=\"strong:G1544\" morph=\"robinson:V-PAI-3P\" type=\"x-split\" subType=\"x-21\">cast <seg type=\"x-transChange\" subType=\"x-added\">them</seg> out</w>");
        }
        if (osisID.equals("Luke.12.13")) {
            input = this.replace(input, "<w src=\"1\" lemma=\"strong:G2036\" morph=\"robinson:V-2AAI-3S\"><w src=\"9\" lemma=\"strong:G2036\" morph=\"robinson:V-2AAM-2S\">speak</w></w>", "<w src=\"1 9\" lemma=\"strong:G2036\" morph=\"robinson:V-2AAI-3S robinson:V-2AAM-2S\">speak</w>");
        }
        if (osisID.equals("Luke.14.21")) {
            input = this.replace(input, "<w src=\"26\" lemma=\"strong:G3588\" morph=\"robinson:T-GSF\"><w src=\"22\" lemma=\"strong:G3588\" morph=\"robinson:T-APF\"></w></w>", "<w src=\"26 22\" lemma=\"strong:G3588\" morph=\"robinson:T-GSF robinson:T-APF\"></w>");
        }
        if (osisID.equals("Luke.14.25")) {
            input = this.replace(input, "<w src=\"8\" lemma=\"strong:G2036\" morph=\"robinson:V-2AAI-3S\"></w><w src=\"5\" lemma=\"strong:G4183\" morph=\"robinson:A-NPM\"></w><w src=\"2\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\">", "");
            input = this.replace(input, "An</w>d</w> <w morph=\"robinson:V-INI-3P\" src=\"1\" lemma=\"strong:G4848\">there went</w>", "And </w> <w morph=\"robinson:V-INI-3P\" src=\"1\" lemma=\"strong:G4848\" type=\"x-split\" subType=\"x-1\">there went</w>");
            input = this.replace(input, "<w morph=\"robinson:A-NPM\" src=\"5\" lemma=\"strong:G4183\">g<w src=\"4\" lemma=\"strong:G3793\" morph=\"robinson:N-NPM\">reat</w> <w morph=\"robinson:N-NPM\" src=\"4\" lemma=\"strong:G3793\">mu</w>ltitud<w src=\"1\" lemma=\"strong:G4848\" morph=\"robinson:V-INI-3P\"></w>e<w src=\"3\" lemma=\"strong:G846\" morph=\"robinson:P-DSM\">s</w> </w>", "<w morph=\"robinson:A-NPM\" src=\"5\" lemma=\"strong:G4183\">great</w> <w morph=\"robinson:N-NPM\" src=\"4\" lemma=\"strong:G3793\">multitudes</w> ");
            input = this.replace(input, "<w morph=\"robinson:P-DSM\" src=\"3\" lemma=\"strong:G846\">w<w src=\"6\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\">ith</w> him<w src=\"7\" lemma=\"strong:G4762\" morph=\"robinson:V-2APP-NSM\"></w>: <w morph=\"robinson:CONJ\" src=\"6\" lemma=\"strong:G2532\">an</w>d<w src=\"10\" lemma=\"strong:G846\" morph=\"robinson:P-APM\"></w></w>", "<w morph=\"robinson:V-INI-3P\" src=\"1\" lemma=\"strong:G4848\" type=\"x-split\" subType=\"x-1\">with</w> <w morph=\"robinson:P-DSM\" src=\"3\" lemma=\"strong:G846\">him</w>: <w morph=\"robinson:CONJ\" src=\"6\" lemma=\"strong:G2532\">and</w>");
            input = this.replace(input, "<w morph=\"robinson:V-2APP-NSM\" src=\"7\" lemma=\"strong:G4762\">he turned<w src=\"9\" lemma=\"strong:G4314\" morph=\"robinson:PREP\"></w></w>", "<w morph=\"robinson:V-2APP-NSM\" src=\"7\" lemma=\"strong:G4762\">he turned</w>");
        }
        if (osisID.equals("Luke.14.35")) {
            input = this.replace(input, "<w morph=\"robinson:CONJ\" src=\"1\" lemma=\"strong:G3777\"><w src=\"1\" lemma=\"strong:G3777\" morph=\"robinson:CONJ\"></w>neither</w>", "<w src=\"1\" lemma=\"strong:G3777\" morph=\"robinson:CONJ\">neither</w>");
            input = this.replace(input, "<w morph=\"robinson:V-PAM-3S\" src=\"16\" lemma=\"strong:G191\">l<w src=\"16\" lemma=\"strong:G191\" morph=\"robinson:V-PAM-3S\"></w>et him hear</w>", "<w morph=\"robinson:V-PAM-3S\" src=\"16\" lemma=\"strong:G191\">let him hear</w>");
            input = this.replace(input, "<w src=\"2\" lemma=\"strong:G1519\" morph=\"robinson:PREP\"></w><w src=\"3\" lemma=\"strong:G1093\" morph=\"robinson:N-ASF\"></w><w src=\"4\" lemma=\"strong:G3777\" morph=\"robinson:CONJ\"></w><w src=\"5\" lemma=\"strong:G1519\" morph=\"robinson:PREP\"></w><w src=\"6\" lemma=\"strong:G2874\" morph=\"robinson:N-ASF\"></w><w src=\"7\" lemma=\"strong:G2111\" morph=\"robinson:A-NSN\"></w><w src=\"8\" lemma=\"strong:G2076\" morph=\"robinson:V-PXI-3S\"></w><w src=\"9\" lemma=\"strong:G1854\" morph=\"robinson:ADV\"></w><w src=\"10\" lemma=\"strong:G906\" morph=\"robinson:V-PAI-3P\"></w><w src=\"11\" lemma=\"strong:G846\" morph=\"robinson:P-ASN\"></w><w src=\"12\" lemma=\"strong:G3588\" morph=\"robinson:T-NSM\"></w><w src=\"13\" lemma=\"strong:G2192\" morph=\"robinson:V-PAP-NSM\"></w><w src=\"14\" lemma=\"strong:G3775\" morph=\"robinson:N-APN\"></w><w src=\"15\" lemma=\"strong:G191\" morph=\"robinson:V-PAN\"></w>", "");
        }
        if (osisID.equals("Luke.15.24")) {
            input = this.replace(input, "<w src=\"16\" lemma=\"strong:G756\" morph=\"robinson:V-ADI-3P\"></w><w src=\"14\" lemma=\"strong:G2147\" morph=\"robinson:V-API-3S\"></w><w src=\"9\" lemma=\"strong:G326\" morph=\"robinson:V-AAI-3S\"></w><w src=\"3\" lemma=\"strong:G3588\" morph=\"robinson:T-NSM\"></w><w morph=\"robinson:T-NSM\" src=\"3\" lemma=\"strong:G3588\"></w><w morph=\"robinson:CONJ\" src=\"1\" lemma=\"strong:G3754\"></w>F", "");
            input = this.replace(input, "<w src=\"2\" lemma=\"strong:G3778\" morph=\"robinson:D-NSM\">or</w> </w>", "<w src=\"1\" lemma=\"strong:G3778\" morph=\"robinson:D-NSM\">For</w>");
            input = this.replace(input, "<w morph=\"robinson:D-NSM\" src=\"2\" lemma=\"strong:G3778\">th<w src=\"5\" lemma=\"strong:G3450\" morph=\"robinson:P-1GS\">i<w src=\"4\" lemma=\"strong:G5207\" morph=\"robinson:N-NSM\"></w>s</w> </w>", "<w morph=\"robinson:D-NSM\" src=\"2\" lemma=\"strong:G3778\">this</w><w morph=\"robinson:T-NSM\" src=\"3\" lemma=\"strong:G3588\"></w>");
            input = this.replace(input, "<w morph=\"robinson:P-1GS\" src=\"5\" lemma=\"strong:G3450\">my<w src=\"7\" lemma=\"strong:G2258\" morph=\"robinson:V-IXI-3S\"></w> <w src=\"6\" lemma=\"strong:G3498\" morph=\"robinson:A-NSM\"></w><w morph=\"robinson:N-NSM\" src=\"4\" lemma=\"strong:G5207\">son</w></w>", "<w morph=\"robinson:P-1GS\" src=\"5\" lemma=\"strong:G3450\">my</w> <w morph=\"robinson:N-NSM\" src=\"4\" lemma=\"strong:G5207\">son</w>");
            input = this.replace(input, "<w src=\"8\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\"><w morph=\"robinson:V-IXI-3S\" src=\"7\" lemma=\"strong:G2258\"><w src=\"10\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\">wa</w></w>s</w>", "<w morph=\"robinson:V-IXI-3S\" src=\"7\" lemma=\"strong:G2258\">was</w>");
            input = this.replace(input, "<w morph=\"robinson:V-AAI-3S\" src=\"9\" lemma=\"strong:G326\">is a<w src=\"12\" lemma=\"strong:G2258\" morph=\"robinson:V-IXI-3S\">li<w src=\"11\" lemma=\"strong:G622\" morph=\"robinson:V-2RAP-NSM\"></w>ve a</w>ga<w src=\"13\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\">i<w src=\"15\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\">n</w></w></w>", "<w morph=\"robinson:V-AAI-3S\" src=\"9\" lemma=\"strong:G326\">is alive again</w>");
            input = this.replace(input, "<w morph=\"robinson:V-IXI-3S\" src=\"12\" lemma=\"strong:G2258\">he was</w> <w morph=\"robinson:CONJ\" src=\"10\" lemma=\"strong:G2532\"></w>", "<w morph=\"robinson:CONJ\" src=\"10\" lemma=\"strong:G2532\"></w><w morph=\"robinson:V-IXI-3S\" src=\"12\" lemma=\"strong:G2258\">he was</w> ");
            input = this.replace(input, "<w morph=\"robinson:V-API-3S\" src=\"14\" lemma=\"strong:G2147\">i<w src=\"17\" lemma=\"strong:G2165\" morph=\"robinson:V-PPN\">s found</w></w>", "<w morph=\"robinson:V-API-3S\" src=\"14\" lemma=\"strong:G2147\">is found</w>");
            input = "<q who=\"Jesus\">" + input;
        }
        if (osisID.equals("Luke.19.30")) {
            input = this.replace(input, "<w src=\"16\" lemma=\"strong:G4455\" morph=\"robinson:ADV\">never</w> <w src=\"15\" lemma=\"strong:G3762\" morph=\"robinson:A-NSM\"><w src=\"17\" lemma=\"strong:G444\" morph=\"robinson:N-GPM\">man</w></w>", "<w src=\"15 16\" lemma=\"strong:G3762 strong:G4455\" morph=\"robinson:A-NSM robinson:ADV\">never</w> <w src=\"17\" lemma=\"strong:G444\" morph=\"robinson:N-GPM\">man</w>");
        }
        if (osisID.equals("John.5.36")) {
            input = this.replace(input, "<w src=\"8\" lemma=\"strong:G2491\" morph=\"robinson:N-GSM\">than <transChange type=\"added\">that</transChange> of John</w>", "<w src=\"8\" lemma=\"strong:G2491\" morph=\"robinson:N-GSM\">than <seg type=\"x-transChange\" subType=\"x-added\">that</seg> of John</w>");
        }
        if (osisID.equals("Acts.17.25")) {
            input = this.replace(input, "<w morph=\"robinson:A-APN\" src=\"16\" lemma=\"strong:G3956\"><w src=\"15\" lemma=\"strong:G3956\" morph=\"robinson:A-APN\">all things;</w></w>", "<w morph=\"robinson:A-APN\" src=\"15 16\" lemma=\"strong:G3956\">all things;</w>");
        }
        if (osisID.equals("Acts.26.3")) {
            input = this.replace(input, "<w src=\"18\" lemma=\"strong:G3450\" morph=\"robinson:P-1GS\"><w morph=\"robinson:P-1GS\" src=\"19\" lemma=\"strong:G3450\">me</w></w>", "<w src=\"18 19\" lemma=\"strong:G3450\" morph=\"robinson:P-1GS\">me</w>");
        }
        if (osisID.equals("2Cor.5.4")) {
            input = this.replace(input, "<w src=\"18\" lemma=\"strong:G3588\" morph=\"robinson:T-NSN\">might be <w src=\"22\" lemma=\"strong:G2222\" morph=\"robinson:N-GSF\"></w>swallowed up</w>", "<w src=\"18\" lemma=\"strong:G3588\" morph=\"robinson:T-NSN\"></w><w src=\"22\" lemma=\"strong:G2222\" morph=\"robinson:N-GSF\">might be swallowed up</w>");
        }
        if (osisID.equals("1Thess.1.6")) {
            input = this.replace(input, "<w src=\"17\" lemma=\"strong:G4151\" morph=\"robinson:N-GSN\"><w src=\"18\" lemma=\"strong:G40\" morph=\"robinson:A-GSN\">of the Holy</w> Ghost</w>", "<w src=\"18\" lemma=\"strong:G40\" morph=\"robinson:A-GSN\">of the Holy</w> <w src=\"17\" lemma=\"strong:G4151\" morph=\"robinson:N-GSN\">Ghost</w>");
        }
        if (osisID.equals("2Thess.1.11")) {
            input = this.replace(input, "<w src=\"8\" lemma=\"strong:G2443\" morph=\"robinson:CONJ\">th<w src=\"2\" lemma=\"strong:G3739\" morph=\"robinson:R-ASN\"></w>at</w>", "<w src=\"2 8\" lemma=\"strong:G3739 strong:G2443\" morph=\"robinson:R-ASN robinson:CONJ\">that</w>");
        }
        if (osisID.equals("Phlm.1.15")) {
            input = this.replace(input, "<w src=\"6\" lemma=\"strong:G4314\" morph=\"robinson:PREP\"><w src=\"3\" lemma=\"strong:G1223\" morph=\"robinson:PREP\">for</w></w>", "<w src=\"3 6\" lemma=\"strong:G1223 strong:G4314\" morph=\"robinson:PREP\">for</w>");
        }
        if (osisID.equals("Rev.8.6")) {
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G4537\" morph=\"robinson:V-AAS-3P\"><w morph=\"robinson:V-AAS-3P\" src=\"13\" lemma=\"strong:G4537\">sound.</w></w>", "<w src=\"12 13\" lemma=\"strong:G4537\" morph=\"robinson:V-AAS-3P\">sound.</w>");
        }
        if (osisID.equals("Rev.11.1")) {
            input = this.replace(input, "<w src=\"19\" lemma=\"strong:G3588\" morph=\"robinson:T-APM\"><w morph=\"robinson:T-APM\" src=\"23\" lemma=\"strong:G3588\">them that</w></w>", "<w src=\"19 23\" lemma=\"strong:G3588\" morph=\"robinson:T-APM\">them that</w>");
            input = this.replace(input, "<w morph=\"robinson:V-PAP-APM\" src=\"24\" lemma=\"strong:G4352\"><w src=\"20\" lemma=\"strong:G4352\" morph=\"robinson:V-PAP-APM\">worship</w></w>", "<w morph=\"robinson:V-PAP-APM\" src=\"20 24\" lemma=\"strong:G4352\">worship</w>");
            input = this.replace(input, "<w morph=\"robinson:P-DSM\" src=\"26\" lemma=\"strong:G846\"><w src=\"22\" lemma=\"strong:G846\" morph=\"robinson:P-DSM\">therein.</w></w>", "<w morph=\"robinson:P-DSM\" src=\"22 26\" lemma=\"strong:G846\">therein.</w>");
        }
        if (osisID.equals("Rev.11.4")) {
            input = this.replace(input, "<w src=\"15\" lemma=\"strong:G2476\" morph=\"robinson:V-RAP-NPF\"><w morph=\"robinson:V-RAP-NPF\" src=\"16\" lemma=\"strong:G2476\">standing</w></w>", "<w src=\"15 16\" lemma=\"strong:G2476\" morph=\"robinson:V-RAP-NPF\">standing</w>");
        }
        if (osisID.equals("Rev.11.14")) {
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G5035\" morph=\"robinson:ADV\"><w morph=\"robinson:ADV\" src=\"13\" lemma=\"strong:G5035\">quickly.</w></w>", "<w src=\"12 13\" lemma=\"strong:G5035\" morph=\"robinson:ADV\">quickly.</w>");
        }
        if (osisID.equals("Rev.14.7")) {
            input = this.replace(input, "<w src=\"32\" lemma=\"strong:G5204\" morph=\"robinson:N-GPN\"><w morph=\"robinson:N-GPN\" src=\"33\" lemma=\"strong:G5204\">of waters.</w></w>", "<w src=\"32 33\" lemma=\"strong:G5204\" morph=\"robinson:N-GPN\">of waters.</w>");
        }
        if (osisID.equals("Rev.14.18")) {
            input = this.replace(input, "<w morph=\"robinson:P-GSF\" src=\"42\" lemma=\"strong:G846\"><w src=\"40\" lemma=\"strong:G846\" morph=\"robinson:P-GSF\">her</w></w>", "<w morph=\"robinson:P-GSF\" src=\"40 42\" lemma=\"strong:G846\">her</w>");
            input = this.replace(input, "<w morph=\"robinson:N-NPF\" src=\"41\" lemma=\"strong:G4718\"><w src=\"39\" lemma=\"strong:G4718\" morph=\"robinson:N-NPF\">grapes</w></w>", "<w morph=\"robinson:N-NPF\" src=\"39 41\" lemma=\"strong:G4718\">grapes</w>");
        }
        if (osisID.equals("Rev.19.14")) {
            input = this.replace(input, "<w src=\"16\" lemma=\"strong:G2513\" morph=\"robinson:A-ASN\"><w morph=\"robinson:A-ASN\" src=\"17\" lemma=\"strong:G2513\">clean.</w></w>", "<w src=\"16 17\" lemma=\"strong:G2513\" morph=\"robinson:A-ASN\">clean.</w>");
        }
        if (osisID.equals("Rev.19.18")) {
            input = this.replace(input, "<w src=\"28\" lemma=\"strong:G3173\" morph=\"robinson:A-GPM\"><w morph=\"robinson:A-GPM\" src=\"29\" lemma=\"strong:G3173\">great.</w></w>", "<w src=\"28 29\" lemma=\"strong:G3173\" morph=\"robinson:A-GPM\">great.</w>");
        }
        if (osisID.equals("Rev.21.13")) {
            input = this.replace(input, "<w src=\"16\" lemma=\"strong:G5140\" morph=\"robinson:A-NPM\"><w morph=\"robinson:A-NPM\" src=\"17\" lemma=\"strong:G5140\">three</w></w>", "<w src=\"16 17\" lemma=\"strong:G5140\" morph=\"robinson:A-NPM\">three</w>");
        }
        if (osisID.equals("Mark.1.9")) {
            input = this.replace(input, "<w src=\"20\" morph=\"robinson:N-ASM\" lemma=\"strong:G2446\"><w src=\"19\" lemma=\"strong:G2446\" morph=\"robinson:N-ASM\">Jordan</w></w>.", "<w src=\"20\" morph=\"robinson:N-ASM\" lemma=\"strong:G2446\">Jordan</w>.<w src=\"19\" lemma=\"strong:G2446\" morph=\"robinson:N-ASM\"></w>");
        }
        if (osisID.equals("Mark.1.18")) {
            input = this.replace(input, "<w morph=\"robinson:V-AAI-3P\" type=\"x-split\" subType=\"x-10\" src=\"9\" lemma=\"strong:G190\"><w src=\"7\" lemma=\"strong:G190\" morph=\"robinson:V-AAI-3P\">and followed</w></w>", "<w morph=\"robinson:V-AAI-3P\" type=\"x-split\" subType=\"x-10\" src=\"9\" lemma=\"strong:G190\">and followed</w><w src=\"7\" lemma=\"strong:G190\" morph=\"robinson:V-AAI-3P\"></w>");
        }
        if (osisID.equals("Mark.1.38")) {
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G1519\" morph=\"robinson:PREP\"><w src=\"13\" lemma=\"strong:G5124\" morph=\"robinson:D-ASN\">therefore</w></w>", "<w src=\"12 13\" lemma=\"strong:G1519 strong:G5124\" morph=\"robinson:PREP robinson:D-ASN\">therefore</w>");
        }
        if (osisID.equals("Mark.2.4")) {
            input = this.replace(input, "<w src=\"19\" lemma=\"strong:G1909\" morph=\"robinson:PREP\"><w src=\"20\" lemma=\"strong:G3739\" morph=\"robinson:R-DSM\">wherein</w></w>", "<w src=\"19 20\" lemma=\"strong:G1909 strong:G3739\" morph=\"robinson:PREP robinson:R-DSM\">wherein</w>");
        }
        if (osisID.equals("Mark.2.7")) {
            input = this.replace(input, "<w src=\"10\" lemma=\"strong:G1487\" morph=\"robinson:COND\"><w src=\"11\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">but</w></w>", "<w src=\"10 11\" lemma=\"strong:G1487 strong:G3361\" morph=\"robinson:COND robinson:PRT-N\">but</w>");
        }
        if (osisID.equals("Mark.2.18")) {
            input = this.replace(input, "<w src=\"16\" lemma=\"strong:G1223\" morph=\"robinson:PREP\"><w src=\"17\" lemma=\"strong:G5101\" morph=\"robinson:I-ASN\">Why</w></w>", "<w src=\"16 17\" lemma=\"strong:G1223 strong:G5101\" morph=\"robinson:PREP robinson:I-ASN\">Why</w>");
        }
        if (osisID.equals("Mark.2.19")) {
            input = this.replace(input, "<w src=\"6\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\"><w src=\"7\" lemma=\"strong:G1410\" morph=\"robinson:V-PNI-3P\">Can</w></w>", "<w src=\"6 7\" lemma=\"strong:G3361 strong:G1410\" morph=\"robinson:PRT-N robinson:V-PNI-3P\">Can</w>");
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G1722\" morph=\"robinson:PREP\"><w src=\"13\" lemma=\"strong:G3739\" morph=\"robinson:R-DSM\">while</w></w>", "<w src=\"12 13\" lemma=\"strong:G1722 strong:G3739\" morph=\"robinson:PREP robinson:R-DSM\">while</w>");
            input = this.replace(input, "<w src=\"21\" lemma=\"strong:G5550\" morph=\"robinson:N-ASM\"><w src=\"20\" lemma=\"strong:G3745\" morph=\"robinson:K-ASM\">as long as</w></w>", "<w src=\"21 20\" lemma=\"strong:G5550 strong:G3745\" morph=\"robinson:N-ASM robinson:K-ASM\">as long as</w>");
        }
        if (osisID.equals("Mark.2.21")) {
            input = this.replace(input, "<w src=\"11\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\"><w src=\"10\" lemma=\"strong:G1487\" morph=\"robinson:COND\"><w src=\"12\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">else</w></w></w>", "<w src=\"11 10 12\" lemma=\"strong:G1161 strong:G1487 strong:G3361\" morph=\"robinson:CONJ robinson:COND robinson:PRT-N\">else</w>");
        }
        if (osisID.equals("Mark.2.22")) {
            input = this.replace(input, "<w src=\"9\" lemma=\"strong:G1487\" morph=\"robinson:COND\"><w src=\"10\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\"><w src=\"11\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">else</w></w></w>", "<w src=\"9 10 11\" lemma=\"strong:G1487 strong:G1161 strong:G3361\" morph=\"robinson:COND robinson:CONJ robinson:PRT-N\">else</w>");
        }
        if (osisID.equals("Mark.2.23")) {
            input = this.replace(input, "<w src=\"17\" lemma=\"strong:G4160\" morph=\"robinson:V-PAN\"><w src=\"18\" lemma=\"strong:G5089\" morph=\"robinson:V-PAP-NPM\">to pluck</w></w>", "<w src=\"17 18\" lemma=\"strong:G4160 strong:G5089\" morph=\"robinson:V-PAN robinson:V-PAP-NPM\">to pluck</w>");
        }
        if (osisID.equals("Mark.2.26")) {
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G740\" morph=\"robinson:N-APM\"><w src=\"16\" lemma=\"strong:G4286\" morph=\"robinson:N-GSF\">the shewbread</w></w>", "<w src=\"14 16\" lemma=\"strong:G740 strong:G4286\" morph=\"robinson:N-APM robinson:N-GSF\">the shewbread</w>");
            input = this.replace(input, "<w src=\"22\" lemma=\"strong:G1487\" morph=\"robinson:COND\"><w src=\"23\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">but</w></w>", "<w src=\"22 23\" lemma=\"strong:G1487 strong:G3361\" morph=\"robinson:COND robinson:PRT-N\">but</w>");
        }
        if (osisID.equals("Mark.3.9")) {
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\"><w src=\"13\" lemma=\"strong:G2443\" morph=\"robinson:CONJ\">lest</w></w>", "<w src=\"14 13\" lemma=\"strong:G3361 strong:G2443\" morph=\"robinson:PRT-N robinson:CONJ\">lest</w>");
        }
        if (osisID.equals("Mark.3.16")) {
            input = this.replace(input, "<w src=\"2\" lemma=\"strong:G2007\" morph=\"robinson:V-AAI-3S\">he <w src=\"6\" lemma=\"strong:G4074\" morph=\"robinson:N-ASM\">surnamed</w></w>", "<w src=\"2\" lemma=\"strong:G2007\" morph=\"robinson:V-AAI-3S\">he</w> <w src=\"6\" lemma=\"strong:G4074\" morph=\"robinson:N-ASM\">surnamed</w>");
        }
        if (osisID.equals("Mark.3.17")) {
            input = this.replace(input, "<w src=\"13\" lemma=\"strong:G2007\" morph=\"robinson:V-AAI-3S\">he <w src=\"15\" lemma=\"strong:G3686\" morph=\"robinson:N-APN\">surnamed</w></w>", "<w src=\"13\" lemma=\"strong:G2007\" morph=\"robinson:V-AAI-3S\">he</w> <w src=\"15\" lemma=\"strong:G3686\" morph=\"robinson:N-APN\">surnamed</w>");
        }
        if (osisID.equals("Mark.3.24")) {
            input = this.replace(input, "<w src=\"8\" lemma=\"strong:G1410\" morph=\"robinson:V-PNI-3S\"><w src=\"7\" lemma=\"strong:G3756\" morph=\"robinson:PRT-N\">cannot</w></w>", "<w src=\"8 7\" lemma=\"strong:G1410 strong:G3756\" morph=\"robinson:V-PNI-3S robinson:PRT-N\">cannot</w>");
        }
        if (osisID.equals("Mark.3.25")) {
            input = this.replace(input, "<w src=\"8\" lemma=\"strong:G1410\" morph=\"robinson:V-PNI-3S\"><w src=\"7\" lemma=\"strong:G3756\" morph=\"robinson:PRT-N\">cannot</w></w>", "<w src=\"8 7\" lemma=\"strong:G1410 strong:G3756\" morph=\"robinson:V-PNI-3S robinson:PRT-N\">cannot</w>");
        }
        if (osisID.equals("Mark.3.26")) {
            input = this.replace(input, "<w src=\"11\" lemma=\"strong:G1410\" morph=\"robinson:V-PNI-3S\">he <w src=\"10\" lemma=\"strong:G3756\" morph=\"robinson:PRT-N\">cannot</w></w>", "<w src=\"11\" lemma=\"strong:G1410\" morph=\"robinson:V-PNI-3S\">he</w> <w src=\"10\" lemma=\"strong:G3756\" morph=\"robinson:PRT-N\">cannot</w>");
        }
        if (osisID.equals("Mark.3.27")) {
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G1437\" morph=\"robinson:COND\"><w src=\"15\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">except</w></w>", "<w src=\"14 15\" lemma=\"strong:G1437 strong:G3361\" morph=\"robinson:COND robinson:PRT-N\">except</w>");
        }
        if (osisID.equals("Mark.3.29")) {
            input = this.replace(input, "<w src=\"10\" lemma=\"strong:G3756\" morph=\"robinson:PRT-N\"><w src=\"13\" lemma=\"strong:G1519\" morph=\"robinson:PREP\"><w src=\"15\" lemma=\"strong:G165\" morph=\"robinson:N-ASM\">never</w></w></w>", "<w src=\"10 13 15\" lemma=\"strong:G3756 strong:G1519 strong:G165\" morph=\"robinson:PRT-N robinson:PREP robinson:N-ASM\">never</w>");
            input = this.replace(input, "<w src=\"7\" lemma=\"strong:G4151\" morph=\"robinson:N-ASN\"><w src=\"9\" lemma=\"strong:G40\" morph=\"robinson:A-ASN\">the Holy</w> Ghost</w>", "<w src=\"9\" lemma=\"strong:G40\" morph=\"robinson:A-ASN\">the Holy</w> <w src=\"7\" lemma=\"strong:G4151\" morph=\"robinson:N-ASN\">Ghost</w>");
        }
        if (osisID.equals("Mark.3.35")) {
            input = this.replace(input, "<w src=\"1\" lemma=\"strong:G3739\" morph=\"robinson:R-NSM\"><w src=\"3\" lemma=\"strong:G302\" morph=\"robinson:PRT\">whosoever</w></w>", "<w src=\"1 3\" lemma=\"strong:G3739 strong:G302\" morph=\"robinson:R-NSM robinson:PRT\">whosoever</w>");
        }
        if (osisID.equals("Mark.4.4")) {
            input = this.replace(input, "<w src=\"6\" lemma=\"strong:G3739\" morph=\"robinson:R-NSN\"><w src=\"7\" lemma=\"strong:G3303\" morph=\"robinson:PRT\">some</w></w>", "<w src=\"6 7\" lemma=\"strong:G3739 strong:G3303\" morph=\"robinson:R-NSN robinson:PRT\">some</w>");
        }
        if (osisID.equals("Mark.4.20")) {
            input = this.replace(input, "<w src=\"22\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\"><w src=\"26\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\">and</w></w>", "<w src=\"22 26\" lemma=\"strong:G2532 strong:G2532\" morph=\"robinson:CONJ robinson:CONJ\">and</w>");
        }
        if (osisID.equals("Mark.4.22")) {
            input = this.replace(input, "<w src=\"1\" lemma=\"strong:G3756\" morph=\"robinson:PRT-N\"><w src=\"4\" lemma=\"strong:G5100\" morph=\"robinson:X-NSN\">nothing</w></w>", "<w src=\"1 4\" lemma=\"strong:G3756 strong:G5100\" morph=\"robinson:PRT-N robinson:X-NSN\">nothing</w>");
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G2443\" morph=\"robinson:CONJ\"><w src=\"15\" lemma=\"strong:G1519\" morph=\"robinson:PREP\">that</w></w>", "<w src=\"14 15\" lemma=\"strong:G2443 strong:G1519\" morph=\"robinson:CONJ robinson:PREP\">that</w>");
        }
        if (osisID.equals("Mark.4.34")) {
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G3956\" morph=\"robinson:A-APN\">all things <w src=\"11\" lemma=\"strong:G3101\" morph=\"robinson:N-DPM\">to</w> <w src=\"12\" lemma=\"strong:G846\" morph=\"robinson:P-GSM\">his</w> <w src=\"11\" lemma=\"strong:G3101\" morph=\"robinson:N-DPM\" type=\"x-split\" subType=\"x-15\">disciples</w>.</w>", "<w src=\"14\" lemma=\"strong:G3956\" morph=\"robinson:A-APN\">all things</w> <w src=\"11\" lemma=\"strong:G3101\" morph=\"robinson:N-DPM\">to</w> <w src=\"12\" lemma=\"strong:G846\" morph=\"robinson:P-GSM\">his</w> <w src=\"11\" lemma=\"strong:G3101\" morph=\"robinson:N-DPM\" type=\"x-split\" subType=\"x-15\">disciples</w>.");
        }
        if (osisID.equals("Mark.5.29")) {
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G4983\" morph=\"robinson:N-DSN\">in <transChange type=\"added\">her</transChange> body</w>", "<w src=\"12\" lemma=\"strong:G4983\" morph=\"robinson:N-DSN\">in <seg type=\"x-transChange\" subType=\"x-added\">her</seg> body</w>");
        }
        if (osisID.equals("Mark.8.1")) {
            input = this.replace(input, "<w src=\"11\" lemma=\"strong:G5101\" morph=\"robinson:I-ASN\"><w src=\"9\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">nothing</w></w>", "<w src=\"11 9\" lemma=\"strong:G5101 strong:G3361\" morph=\"robinson:I-ASN robinson:PRT-N\">nothing</w>");
        }
        if (osisID.equals("Mark.8.2")) {
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G3756\" morph=\"robinson:PRT-N\"><w src=\"14\" lemma=\"strong:G5101\" morph=\"robinson:I-ASN\">nothing</w></w>", "<w src=\"12 14\" lemma=\"strong:G3756 strong:G5101\" morph=\"robinson:PRT-N robinson:I-ASN\">nothing</w>");
        }
        if (osisID.equals("Mark.8.14")) {
            input = this.replace(input, "<w src=\"10\" lemma=\"strong:G3756\" morph=\"robinson:PRT-N\"><w src=\"7\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\"><w src=\"6\" lemma=\"strong:G1487\" morph=\"robinson:COND\"><w src=\"5\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\">neither</w></w></w></w>", "<w src=\"10 7 6 5\" lemma=\"strong:G3756 strong:G3361 strong:G1487 strong:G2532\" morph=\"robinson:PRT-N robinson:PRT-N robinson:COND robinson:CONJ\">neither</w>");
        }
        if (osisID.equals("Mark.8.24")) {
            input = this.replace(input, "<w src=\"10\" lemma=\"strong:G3708\" morph=\"robinson:V-PAI-1S\"><w src=\"4\" lemma=\"strong:G991\" morph=\"robinson:V-PAI-1S\">I see</w></w>", "<w src=\"10 4\" lemma=\"strong:G3708 strong:G991\" morph=\"robinson:V-PAI-1S robinson:V-PAI-1S\">I see</w>");
            input = this.replace(input, "<w src=\"7\" lemma=\"strong:G3754\" morph=\"robinson:CONJ\"><w src=\"8\" lemma=\"strong:G5613\" morph=\"robinson:ADV\">as</w></w>", "<w src=\"7 8\" lemma=\"strong:G3754 strong:G5613\" morph=\"robinson:CONJ robinson:ADV\">as</w>");
        }
        if (osisID.equals("Mark.8.35")) {
            input = this.replace(input, "<w src=\"1\" lemma=\"strong:G3739\" morph=\"robinson:R-NSM\"><w src=\"3\" lemma=\"strong:G302\" morph=\"robinson:PRT\">whosoever</w></w>", "<w src=\"1 3\" lemma=\"strong:G3739 strong:G302\" morph=\"robinson:R-NSM robinson:PRT\">whosoever</w>");
            input = this.replace(input, "<w src=\"13\" lemma=\"strong:G302\" morph=\"robinson:PRT\"><w src=\"11\" lemma=\"strong:G3739\" morph=\"robinson:R-NSM\">whosoever</w></w>", "<w src=\"13 11\" lemma=\"strong:G302 strong:G3739\" morph=\"robinson:PRT robinson:R-NSM\">whosoever</w>");
        }
        if (osisID.equals("Mark.8.38")) {
            input = this.replace(input, "<w src=\"1\" lemma=\"strong:G3739\" morph=\"robinson:R-NSM\"><w src=\"3\" lemma=\"strong:G302\" morph=\"robinson:PRT\">Whosoever</w></w>", "<w src=\"1 3\" lemma=\"strong:G3739 strong:G302\" morph=\"robinson:R-NSM robinson:PRT\">Whosoever</w>");
        }
        if (osisID.equals("Mark.9.1")) {
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G3756\" morph=\"robinson:PRT-N\"><w src=\"15\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">not</w></w>", "<w src=\"14 15\" lemma=\"strong:G3756 strong:G3361\" morph=\"robinson:PRT-N robinson:PRT-N\">not</w>");
            input = this.replace(input, "<w src=\"18\" lemma=\"strong:G2193\" morph=\"robinson:CONJ\"><w src=\"19\" lemma=\"strong:G302\" morph=\"robinson:PRT\">till</w></w>", "<w src=\"18 19\" lemma=\"strong:G2193 strong:G302\" morph=\"robinson:CONJ robinson:PRT\">till</w>");
        }
        if (osisID.equals("Mark.9.9")) {
            input = this.replace(input, "<w src=\"19\" lemma=\"strong:G3588\" morph=\"robinson:T-GSM\"></w><w src=\u000f\" lemma=\"strong:G3588\" morph=\"robinson:T-NSM\"></w><w src=\"5\" lemma=\"strong:G3588\" morph=\"robinson:T-GSN\"></w>", "");
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G1487\" morph=\"robinson:COND\"><w src=\"15\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\"><w src=\"16\" lemma=\"strong:G3752\" morph=\"robinson:CONJ\">till</w></w></w>", "<w src=\"14 15 16\" lemma=\"strong:G1487 strong:G3361 strong:G3752\" morph=\"robinson:COND robinson:PRT-N robinson:CONJ\">till</w>");
            input = this.replace(input, "<w src=\"1\" lemma=\"strong:G2597\" morph=\"robinson:V-PAP-GPM\">as <w src=\"3\" lemma=\"strong:G846\" morph=\"robinson:P-GPM\">they</w> came down</w>", "<w src=\"1\" lemma=\"strong:G2597\" morph=\"robinson:V-PAP-GPM\">as</w> <w src=\"3\" lemma=\"strong:G846\" morph=\"robinson:P-GPM\">they came down</w>");
        }
        if (osisID.equals("Mark.9.18")) {
            input = this.replace(input, "<w src=\"2\" lemma=\"strong:G3699\" morph=\"robinson:ADV\"><w src=\"3\" lemma=\"strong:G302\" morph=\"robinson:PRT\">wheresoever</w></w>", "<w src=\"2 3\" lemma=\"strong:G3699 strong:G302\" morph=\"robinson:ADV robinson:PRT\">wheresoever</w>");
        }
        if (osisID.equals("Mark.9.19")) {
            input = this.replace(input, "<w src=\"9\" lemma=\"strong:G2193\" morph=\"robinson:CONJ\"><w src=\"10\" lemma=\"strong:G4219\" morph=\"robinson:PRT-I\">how long</w></w>", "<w src=\"9 10\" lemma=\"strong:G2193 strong:G4219\" morph=\"robinson:CONJ robinson:PRT-I\">how long</w>");
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G2193\" morph=\"robinson:CONJ\"><w src=\"15\" lemma=\"strong:G4219\" morph=\"robinson:PRT-I\">how long</w></w>", "<w src=\"14 15\" lemma=\"strong:G2193 strong:G4219\" morph=\"robinson:CONJ robinson:PRT-I\">how long</w>");
        }
        if (osisID.equals("Mark.9.25")) {
            input = this.replace(input, "<w src=\"2\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\"><w src=\"2\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\" type=\"x-split\" subType=\"x-32\">When</w></w>", "<w src=\"2\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\" type=\"x-split\" subType=\"x-32\">When</w>");
        }
        if (osisID.equals("Mark.9.26")) {
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G3004\" morph=\"robinson:V-PAN\"><w src=\"15\" lemma=\"strong:G3754\" morph=\"robinson:CONJ\">said</w></w>", "<w src=\"14 15\" lemma=\"strong:G3004 strong:G3754\" morph=\"robinson:V-PAN robinson:CONJ\">said</w>");
        }
        if (osisID.equals("Mark.9.28")) {
            input = this.replace(input, "<w src=\"2\" lemma=\"strong:G1525\" morph=\"robinson:V-2AAP-ASM\">when <w src=\"3\" lemma=\"strong:G846\" morph=\"robinson:P-ASM\">he</w> was come <w src=\"4\" lemma=\"strong:G1519\" morph=\"robinson:PREP\">into</w></w>", "<w src=\"2\" lemma=\"strong:G1525\" morph=\"robinson:V-2AAP-ASM\">when</w> <w src=\"3\" lemma=\"strong:G846\" morph=\"robinson:P-ASM\">he was come</w> <w src=\"4\" lemma=\"strong:G1519\" morph=\"robinson:PREP\">into</w>");
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G2398\" morph=\"robinson:A-ASF\"><w src=\"11\" lemma=\"strong:G2596\" morph=\"robinson:PREP\">privately</w></w>", "<w src=\"12 11\" lemma=\"strong:G2398 strong:G2596\" morph=\"robinson:A-ASF robinson:PREP\">privately</w>");
            input = this.replace(input, "<w src=\"11\" lemma=\"strong:G1487\" morph=\"robinson:COND\"><w src=\"12\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">but</w></w>", "<w src=\"11 12\" lemma=\"strong:G1487 strong:G3361\" morph=\"robinson:COND robinson:PRT-N\">but</w>");
        }
        if (osisID.equals("Mark.9.29")) {
            input = this.replace(input, "<w src=\"11\" lemma=\"strong:G1487\" morph=\"robinson:COND\"><w src=\"12\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">but</w></w>", "<w src=\"11 12\" lemma=\"strong:G1487 strong:G3361\" morph=\"robinson:COND robinson:PRT-N\">but</w>");
        }
        if (osisID.equals("Mark.9.37")) {
            input = this.replace(input, "<w src=\"1\" lemma=\"strong:G3739\" morph=\"robinson:R-NSM\"><w src=\"2\" lemma=\"strong:G1437\" morph=\"robinson:COND\">Whosoever</w></w>", "<w src=\"1 2\" lemma=\"strong:G3739 strong:G1437\" morph=\"robinson:R-NSM robinson:COND\">Whosoever</w>");
            input = this.replace(input, "<w src=\"15\" lemma=\"strong:G3739\" morph=\"robinson:R-NSM\"><w src=\"16\" lemma=\"strong:G1437\" morph=\"robinson:COND\">whosoever</w></w>", "<w src=\"15 16\" lemma=\"strong:G3739 strong:G1437\" morph=\"robinson:R-NSM robinson:COND\">whosoever</w>");
        }
        if (osisID.equals("Mark.9.41")) {
            input = this.replace(input, "<w src=\"1\" lemma=\"strong:G3739\" morph=\"robinson:R-NSM\"><w src=\"3\" lemma=\"strong:G302\" morph=\"robinson:PRT\">whosoever</w></w>", "<w src=\"1 3\" lemma=\"strong:G3739 strong:G302\" morph=\"robinson:R-NSM robinson:PRT\">whosoever</w>");
            input = this.replace(input, "<w src=\"18\" lemma=\"strong:G3756\" morph=\"robinson:PRT-N\"><w src=\"19\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">not</w></w>", "<w src=\"18 19\" lemma=\"strong:G3756 strong:G3361\" morph=\"robinson:PRT-N robinson:PRT-N\">not</w>");
        }
        if (osisID.equals("Mark.9.42")) {
            input = this.replace(input, "<w src=\"3\" lemma=\"strong:G302\" morph=\"robinson:PRT\"><w src=\"2\" lemma=\"strong:G3739\" morph=\"robinson:R-NSM\">whosoever</w></w>", "<w src=\"3 2\" lemma=\"strong:G302 strong:G3739\" morph=\"robinson:PRT robinson:R-NSM\">whosoever</w>");
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G2570\" morph=\"robinson:A-NSN\"><w src=\"15\" lemma=\"strong:G3123\" morph=\"robinson:ADV\">better</w></w>", "<w src=\"12 15\" lemma=\"strong:G2570 strong:G3123\" morph=\"robinson:A-NSN robinson:ADV\">better</w>");
            input = this.replace(input, "<w src=\"18\" lemma=\"strong:G3037\" morph=\"robinson:N-NSM\"><w src=\"19\" lemma=\"strong:G3457\" morph=\"robinson:A-NSM\">a millstone</w></w>", "<w src=\"18 19\" lemma=\"strong:G3037 strong:G3457\" morph=\"robinson:N-NSM robinson:A-NSM\">a millstone</w>");
        }
        if (osisID.equals("Mark.9.50")) {
            input = this.replace(input, "<w src=\"9\" lemma=\"strong:G1096\" morph=\"robinson:V-2ADS-3S\"><w src=\"8\" lemma=\"strong:G358\" morph=\"robinson:A-NSN\">have lost his saltness</w></w>", "<w src=\"9 8\" lemma=\"strong:G1096 strong:G358\" morph=\"robinson:V-2ADS-3S robinson:A-NSN\">have lost his saltness</w>");
            input = this.replace(input, "<w src=\"10\" lemma=\"strong:G1722\" morph=\"robinson:PREP\"><w src=\"11\" lemma=\"strong:G5101\" morph=\"robinson:I-DSN\">wherewith</w></w>", "<w src=\"10 11\" lemma=\"strong:G1722 strong:G5101\" morph=\"robinson:PREP robinson:I-DSN\">wherewith</w>");
        }
        if (osisID.equals("Mark.10.4")) {
            input = this.replace(input, "<w src=\"10\" lemma=\"strong:G630\" morph=\"robinson:V-AAN\">to put <transChange type=\"added\">her</transChange> away</w>", "<w src=\"10\" lemma=\"strong:G630\" morph=\"robinson:V-AAN\">to put <seg type=\"x-transChange\" subType=\"x-added\">her</seg> away</w>");
        }
        TreeSet<Integer> split = new TreeSet<Integer>();
        TreeSet<Integer> dup = new TreeSet<Integer>();
        HashSet<Integer> after = new HashSet<Integer>();
        HashMap<Integer, String> wMap = new HashMap<Integer, String>();
        wMatcher = wPattern.matcher(input);
        while (wMatcher.find()) {
            String whole = wMatcher.group();
            Matcher srcMatcher = srcPattern.matcher(whole);
            while (srcMatcher.find()) {
                String[] numbers = StringUtil.split((String)srcMatcher.group(1), (char)' ');
                for (int j = 0; j < numbers.length; ++j) {
                    Integer src = new Integer(numbers[j]);
                    if (!wMap.containsKey(src)) {
                        wMap.put(src, whole);
                    }
                    if (whole.indexOf("x-split") != -1) {
                        split.add(src);
                    }
                    if (after.contains(src)) {
                        dup.add(src);
                    }
                    after.add(src);
                }
            }
        }
        iter = wMap.entrySet().iterator();
        while (iter.hasNext()) {
            String nType;
            Matcher morphNMatcher;
            Matcher morphTMatcher;
            Map.Entry entry = (Map.Entry)iter.next();
            String definiteArticle = entry.getValue() + "</w>";
            if (input.indexOf(definiteArticle) == -1 || definiteArticle.indexOf("G3588") == -1 || !(morphTMatcher = morphTPattern.matcher(definiteArticle)).find()) continue;
            String tType = morphTMatcher.group(1);
            Integer here = (Integer)entry.getKey();
            Integer next = new Integer(here + 1);
            String found = (String)wMap.get(next);
            if (found == null || !(morphNMatcher = morphNPattern.matcher(found)).find() || !tType.equals(nType = morphNMatcher.group(1)) || input.indexOf("src=\"" + next + "\"") == -1) continue;
            String changed = found;
            changed = this.replace(changed, "src=\"", "src=\"" + here + " ");
            changed = this.replace(changed, "lemma=\"", "lemma=\"strong:G3588 ");
            changed = this.replace(changed, "morph=\"", "morph=\"robinson:T-" + tType + " ");
            input = this.replace(input, definiteArticle, "");
            input = this.replace(input, found, changed);
        }
        dup.removeAll(split);
        if (!dup.isEmpty()) {
            System.err.println(osisID + " duplicate src=" + dup);
        }
        if (!((Object)before).equals(after)) {
            before.removeAll(after);
            System.err.println(osisID + ": Problems with w src attribute. Missing: " + before);
        }
        input = this.fixApostrophe(osisID, input);
        input = this.fixPunctuation(osisID, input);
        input = this.fixDivineName(osisID, input);
        input = this.fixSpelling(osisID, input);
        input = this.fixTransChange(osisID, input);
        input = this.fixHyphenatedNames(osisID, input);
        input = this.fixInscriptions(osisID, input);
        input = this.fixParagraphs(osisID, input, inVerse);
        input = this.fixNotes(osisID, input);
        return input;
    }

    private String fixApostrophe(String osisID, String input) {
        Verse v = null;
        try {
            v = VerseFactory.fromString(osisID);
        }
        catch (NoSuchVerseException e) {
            return input;
        }
        if (input.indexOf(39) == -1) {
            return input;
        }
        input = a1Pattern.matcher(input).replaceAll("$1 $2");
        input = a2Pattern.matcher(input).replaceAll("$1S$2");
        input = a3Pattern.matcher(input).replaceAll("$1s$2");
        input = a4Pattern.matcher(input).replaceAll("$1$2</w>");
        input = a5Pattern.matcher(input).replaceAll("$1S ");
        if (SwordConstants.getTestament(v) == 1) {
            input = a6Pattern.matcher(input).replaceAll("$1s ");
        }
        input = a7Pattern.matcher(input).replaceAll("$1S $2");
        if (SwordConstants.getTestament(v) == 1) {
            input = a8Pattern.matcher(input).replaceAll("$1s $2");
        }
        input = a9Pattern.matcher(input).replaceAll("$1'</w> <");
        input = a10Pattern.matcher(input).replaceAll("$1'</w> $2");
        input = a11Pattern.matcher(input).replaceAll("$2</w> $1");
        input = a12Pattern.matcher(input).replaceAll("'</w> ");
        input = a13Pattern.matcher(input).replaceAll("'</w> ");
        input = a14Pattern.matcher(input).replaceAll("$1s</w>$2");
        input = a15Pattern.matcher(input).replaceAll("$1s ");
        if (osisID.equals("Isa.59.5") || osisID.equals("Isa.11.8")) {
            input = a16Pattern.matcher(input).replaceAll("$1 ");
        }
        input = a17Pattern.matcher(input).replaceAll("$1s$2");
        return input;
    }

    private String fixPunctuation(String osisID, String input) {
        int length;
        input = input.replaceAll("<milestone type=\"line\"/>", "<lb/>");
        if (osisID.equals("Lev.2.3") || osisID.equals("Lev.2.10")) {
            input = this.replace(input, "sons'", "sons':");
        }
        if (osisID.equals("Lev.7.31")) {
            input = this.replace(input, "sons'", "sons'.");
        }
        if (osisID.equals("Lev.24.9") || osisID.equals("Ezek.46.16")) {
            input = this.replace(input, "sons'", "sons';");
        }
        if (osisID.equals("1Sam.6.9")) {
            input = this.replace(input, "us:", "us;");
        }
        if (osisID.equals("2Kgs.12.16")) {
            input = this.replace(input, "priests'", "priests'.");
        }
        if (osisID.equals("Isa.30.14")) {
            input = this.replace(input, "..:", "...:");
        }
        input = w1Pattern.matcher(input).replaceAll("$1");
        input = w4Pattern.matcher(input).replaceAll(" ");
        input = w5Pattern.matcher(input).replaceAll("$2$1");
        input = w6Pattern.matcher(input).replaceAll("$2$1");
        input = w2Pattern.matcher(input).replaceAll(") ");
        input = w3Pattern.matcher(input).replaceAll(" (");
        input = input.replaceAll("\\s+</q>", "</q>");
        int here = length = input.length();
        while (input.charAt(here - 1) == ' ') {
            --here;
        }
        if (here < length) {
            input = input.substring(0, here);
        }
        input = w7Pattern.matcher(input).replaceAll("$2$1");
        input = w8Pattern.matcher(input).replaceAll("$1");
        input = w9Pattern.matcher(input).replaceAll("$2$1");
        input = w10Pattern.matcher(input).replaceAll("$1");
        input = w11Pattern.matcher(input).replaceAll("$1");
        input = w12Pattern.matcher(input).replaceAll("$1");
        here = 0;
        while (input.charAt(here) == ' ') {
            ++here;
        }
        if (here > 0) {
            input = input.substring(here);
        }
        input = wnPattern.matcher(input).replaceAll(" ");
        input = p1Pattern.matcher(input).replaceAll("\u2026");
        if (osisID.equals("Matt.15.39")) {
            input = this.replace(input, "Magdala</w>,", "Magdala</w>.");
        }
        if (osisID.equals("Matt.26.56")) {
            input = this.replace(input, ".</q>", ".</q> ");
        }
        if (osisID.equals("Mark.2.1")) {
            input = this.replace(input, ",", "");
        }
        if (osisID.equals("Luke.8.47")) {
            input = this.replace(input, " <w src=\"24", ", <w src=\"24");
        }
        if (osisID.equals("Luke.12.49")) {
            input = this.replace(input, "will I</w>", "will I</w>,");
        }
        if (osisID.equals("Luke.15.24")) {
            input = this.replace(input, "For</w>", "For</w> ");
            input = this.replace(input, "this</w>", "this</w> ");
        }
        if (osisID.equals("Luke.17.37")) {
            input = this.replace(input, " is</w>,", "</w> <transChange type=\"added\">is</transChange>,");
        }
        if (osisID.equals("Acts.2.17")) {
            input = this.replace(input, "God</w>,<w", "God</w>, <w");
        }
        if (osisID.equals("Acts.5.21")) {
            input = this.replace(input, "Israel</w>", "Israel</w>,");
        }
        if (osisID.equals("Acts.16.40")) {
            input = this.replace(input, "Lydia</w>", "Lydia</w>:");
        }
        if (osisID.equals("Acts.24.25")) {
            input = this.replace(input, "come</w>", "come</w>,");
        }
        if (osisID.equals("1Cor.15.27")) {
            input = this.replace(input, "</w>,", "</w>");
        }
        return input;
    }

    private String fixSpelling(String osisID, String input) {
        if (osisID.equals("Matt.5.10")) {
            input = this.replace(input, "righteousness", "righteousness'");
        }
        if (osisID.equals("Matt.26.39")) {
            input = this.replace(input, "farther", "further");
        }
        if (osisID.equals("Matt.27.3")) {
            input = this.replace(input, "betrayeth", "betrayed");
        }
        if (osisID.equals("Mark.1.19")) {
            input = this.replace(input, "farther", "further");
        }
        if (osisID.equals("Mark.12.36")) {
            input = input.replaceFirst("Lord", "<seg><divineName>Lord</divineName></seg>");
        }
        if (osisID.equals("Mark.14.43")) {
            input = this.replace(input, "priest", "priests");
        }
        if (osisID.equals("Luke.7.25")) {
            input = this.replace(input, "kings", "kings'");
        }
        if (osisID.equals("Luke.23.32")) {
            input = this.replace(input, "others", "other");
        }
        if (osisID.equals("John.19.18")) {
            input = this.replace(input, "others", "other");
        }
        if (osisID.equals("John.20.27")) {
            input = input.replaceFirst("reach", "Reach");
        }
        if (osisID.equals("John.21.11")) {
            input = this.replace(input, "and hundred", "an hundred");
        }
        if (osisID.equals("Acts.11.12") || osisID.equals("Acts.11.28") || osisID.equals("1John.5.8")) {
            input = this.replace(input, "spirit", "Spirit");
        }
        if (osisID.equals("Acts.16.23")) {
            input = this.replace(input, "jailer", "jailor");
        }
        if (osisID.equals("Acts.28.15")) {
            input = this.replace(input, "Forum", "forum");
        }
        if (osisID.equals("Rom.4.15")) {
            input = this.replace(input, "instructers", "instructors");
        }
        if (osisID.equals("Rom.4.19") || osisID.equals("Rom.9.9") || osisID.equals("1Pet.3.6")) {
            input = this.replace(input, "Sarah", "Sara");
        }
        if (osisID.equals("1Cor.15.58")) {
            input = this.replace(input, "unmovable", "unmoveable");
        }
        if (osisID.equals("2Cor.9.13")) {
            input = this.replace(input, "into", "unto");
        }
        if (osisID.equals("Gal.4.30")) {
            input = this.replace(input, "free woman", "freewoman");
        }
        if (osisID.equals("Phil.2.25")) {
            input = this.replace(input, "fellow soldier", "fellowsoldier");
        }
        if (osisID.equals("Col.4.11")) {
            input = this.replace(input, "fellow workers", "fellowworkers");
        }
        if (osisID.equals("Heb.1.13")) {
            input = this.replace(input, "times", "time");
        }
        if (osisID.equals("2Pet.2.6")) {
            input = this.replace(input, "Gomorrah", "Gomorrha");
        }
        if (osisID.equals("2Pet.2.13")) {
            input = this.replace(input, "daytime", "day time");
        }
        if (osisID.equals("Rev.2.6") || osisID.equals("Rev.2.15")) {
            input = this.replace(input, "Nicolaitanes", "Nicolaitans");
        }
        if (osisID.startsWith("Acts.9.33") || osisID.equals("Acts.9.34")) {
            input = this.replace(input, "Aeneas", "\u00c6neas");
        }
        if (osisID.startsWith("John.3.23")) {
            input = this.replace(input, "Aenon", "\u00c6non");
        }
        if (osisID.equals("Mark.2.14") || osisID.equals("Luke.6.15")) {
            input = this.replace(input, "Alphaeus", "Alph\u00e6us");
        }
        if (osisID.startsWith("Matt.27.57") || osisID.equals("Luke.23.51")) {
            input = this.replace(input, "Arimathaea", "Arimath\u00e6a");
        }
        if (osisID.startsWith("Mark.10.46")) {
            input = this.replace(input, "Bartimaeus", "Bartim\u00e6us");
        }
        if (!(osisID.equals("Matt.22.17") || osisID.equals("Phil.4.22") || osisID.equals("Matt.16.13"))) {
            input = this.replace(input, "Caesar", "C\u00e6sar");
        }
        if (osisID.equals("Acts.7.4")) {
            input = this.replace(input, "Chaldaeans", "Chald\u00e6ans");
        }
        if (osisID.startsWith("Mark") || osisID.startsWith("Luke") || osisID.startsWith("John") || osisID.startsWith("Acts")) {
            input = this.replace(input, "Judaea", "Jud\u00e6a");
        }
        if (!osisID.equals("Mark.14.70")) {
            input = this.replace(input, "Galilaean", "Galil\u00e6an");
        }
        if (osisID.equals("Mark.15.16")) {
            input = this.replace(input, "Praetorium", "Pr\u00e6torium");
        }
        if (osisID.equals("Mark.10.46")) {
            input = this.replace(input, "Timaeus", "Tim\u00e6us");
        }
        if (osisID.startsWith("Luke.19")) {
            input = this.replace(input, "Zacchaeus", "Zacch\u00e6us");
        }
        return input;
    }

    private String fixTransChange(String osisID, String input) {
        if (osisID.equals("Matt.2.6")) {
            input = this.replace(input, "<w src=\"4\" lemma=\"strong:G1093\" morph=\"robinson:N-VSF\">in ", "<transChange type=\"added\">in</transChange> <w src=\"4\" lemma=\"strong:G1093\" morph=\"robinson:N-VSF\">");
        }
        if (osisID.equals("Matt.5.30")) {
            input = this.replace(input, "cast it</w>", "cast</w> <transChange type=\"added\">it</transChange>");
        }
        if (osisID.equals("Matt.8.13")) {
            input = this.replace(input, "<w src=\"11\" lemma=\"strong:G1096\" morph=\"robinson:V-AOM-3S\">so ", "<transChange type=\"added\">so</transChange> <w src=\"11\" lemma=\"strong:G1096\" morph=\"robinson:V-AOM-3S\">");
        }
        if (osisID.equals("Matt.20.11")) {
            input = this.replace(input, " it</w>", "</w> <transChange type=\"added\">it</transChange>");
        }
        if (osisID.equals("Matt.24.26")) {
            input = input.replaceFirst("<w src=\"9\" lemma=\"strong:G2076\" morph=\"robinson:V-PXI-3S\">he is</w>", "<transChange type=\"added\">he is</transChange>");
            input = input.replaceFirst("<transChange type=\"added\">he is</transChange>", "<w src=\"9\" lemma=\"strong:G2076\" morph=\"robinson:V-PXI-3S\">he is</w>");
        }
        if (osisID.equals("Matt.24.32")) {
            input = this.replace(input, "<w src=\"21\" lemma=\"strong:G1451\" morph=\"robinson:ADV\">is ", "<transChange type=\"added\">is</transChange> <w src=\"21\" lemma=\"strong:G1451\" morph=\"robinson:ADV\">");
        }
        if (osisID.equals("Mark.4.11")) {
            input = this.replace(input, "<w src=\"20\" lemma=\"strong:G3956\" morph=\"robinson:A-NPN\">all these</w> <transChange type=\"added\">things</transChange>", "<w src=\"20\" lemma=\"strong:G3956\" morph=\"robinson:A-NPN\" type=\"x-split\" subType=\"x-20\">all</w> <transChange type=\"added\">these</transChange> <w src=\"20\" lemma=\"strong:G3956\" morph=\"robinson:A-NPN\" type=\"x-split\" subType=\"x-20\">things</w>");
        }
        if (osisID.equals("Mark.12.30")) {
            input = this.replace(input, " is</w>", "</w> <transChange type=\"added\">is</transChange>");
        }
        if (osisID.equals("Luke.4.18")) {
            input = this.replace(input, "<w src=\"3\" lemma=\"strong:G1909\" morph=\"robinson:PREP\">is ", "<transChange type=\"added\">is</transChange> <w src=\"3\" lemma=\"strong:G1909\" morph=\"robinson:PREP\">");
        }
        if (osisID.equals("Luke.11.27")) {
            input = this.replace(input, " is</w> <w src=\"18", "</w> <transChange type=\"added\">is</transChange> <w src=\"18");
        }
        if (osisID.equals("Luke.11.31")) {
            input = this.replace(input, "<w src=\"31\" lemma=\"strong:G5602\" morph=\"robinson:ADV\">is ", "<transChange type=\"added\">is</transChange> <w src=\"31\" lemma=\"strong:G5602\" morph=\"robinson:ADV\">");
        }
        if (osisID.equals("Luke.17.37")) {
            input = this.replace(input, " is</w>,", "</w> <transChange type=\"added\">is</transChange>,");
        }
        if (osisID.equals("Luke.18.1")) {
            input = this.replace(input, "<transChange type=\"added\"><w src=\"6\" lemma=\"strong:G4314\" morph=\"robinson:PREP\">", "<w src=\"6\" lemma=\"strong:G4314\" morph=\"robinson:PREP\"></w><transChange type=\"added\">");
            input = this.replace(input, "</w>,</transChange>", "</transChange>,");
        }
        if (osisID.equals("Luke.21.34")) {
            input = this.replace(input, " so</w>", "</w> <transChange type=\"added\">so</transChange>");
        }
        if (osisID.equals("John.10.38")) {
            input = this.replace(input, "</w> is <w", "</w> <transChange type=\"added\">is</transChange> <w");
        }
        if (osisID.equals("John.13.13")) {
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G1510\" morph=\"robinson:V-PXI-1S\">so ", "<transChange type=\"added\">so</transChange> <w src=\"12\" lemma=\"strong:G1510\" morph=\"robinson:V-PXI-1S\">");
        }
        if (osisID.equals("John.14.2")) {
            input = this.replace(input, "<w src=\"12\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">not</w> <w src=\"11\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\">so</w>", "<w src=\"11\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\"></w><w src=\"12\" lemma=\"strong:G3361\" morph=\"robinson:PRT-N\">not</w> <transChange type=\"added\">so</transChange>");
        }
        if (osisID.equals("John.15.18")) {
            input = input.replaceFirst("<w src=\"12\" lemma=\"strong:G3404\" morph=\"robinson:V-RAI-3S\">it hated</w>", "<transChange type=\"added\">it hated</transChange>");
            input = input.replaceFirst("<transChange type=\"added\">it hated</transChange>", "<w src=\"12\" lemma=\"strong:G3404\" morph=\"robinson:V-RAI-3S\">it hated</w>");
        }
        if (osisID.equals("Acts.6.9")) {
            input = input.replaceFirst("<w src=\"6 7\" lemma=\"strong:G3588 strong:G4864\" morph=\"robinson:T-GSF robinson:N-GSF\">the synagogue</w>", "<transChange type=\"added\">the synagogue</transChange>");
            input = input.replaceFirst("<transChange type=\"added\">the synagogue</transChange>", "<w src=\"6 7\" lemma=\"strong:G3588 strong:G4864\" morph=\"robinson:T-GSF robinson:N-GSF\">the synagogue</w>");
        }
        if (osisID.equals("Acts.10.2")) {
            input = this.replace(input, "<w src=\"1\" lemma=\"strong:G2152\" morph=\"robinson:A-NSM\">A ", "<transChange type=\"added\">A</transChange> <w src=\"1\" lemma=\"strong:G2152\" morph=\"robinson:A-NSM\">");
        }
        if (osisID.equals("Acts.16.11")) {
            input = this.replace(input, " day</w>", "</w> <transChange type=\"added\">day</transChange>");
        }
        if (osisID.equals("Acts.19.19")) {
            input = this.replace(input, "found it</w>", "found</w> <transChange type=\"added\">it</transChange>");
        }
        if (osisID.equals("Acts.22.3")) {
            input = this.replace(input, "<w src=\"9 10\" lemma=\"strong:G3588 strong:G2791\" morph=\"robinson:T-GSF robinson:N-GSF\">a city ", "<transChange type=\"added\">a city</transChange> <w src=\"9 10\" lemma=\"strong:G3588 strong:G2791\" morph=\"robinson:T-GSF robinson:N-GSF\">");
        }
        if (osisID.equals("Rom.6.5")) {
            input = this.replace(input, "<transChange type=\"added\">in the likeness of his</transChange>", "<transChange type=\"added\">in the likeness</transChange> of <transChange type=\"added\">his</transChange>");
        }
        if (osisID.equals("Rom.12.2")) {
            input = this.replace(input, " is</w>", "</w> <transChange type=\"added\">is</transChange>");
        }
        if (osisID.equals("1Cor.10.20")) {
            input = this.replace(input, "<transChange type=\"added\">I say</transChange>", "I <transChange type=\"added\">say</transChange>");
        }
        if (osisID.equals("1Cor.11.26")) {
            input = this.replace(input, "</w><transChange type=\"added\">this</transChange>", "this</w>");
        }
        if (osisID.equals("1Cor.11.27")) {
            input = this.replace(input, "<w src=\"10 11\" lemma=\"strong:G3588 strong:G4221\" morph=\"robinson:T-ASN robinson:N-ASN\">this ", "<transChange type=\"added\">this</transChange> <w src=\"10 11\" lemma=\"strong:G3588 strong:G4221\" morph=\"robinson:T-ASN robinson:N-ASN\">");
        }
        if (osisID.equals("1Cor.15.10")) {
            input = this.replace(input, "<transChange type=\"added\">which was bestowed</transChange>", "which <transChange type=\"added\">was bestowed</transChange>");
        }
        if (osisID.equals("2Cor.1.2")) {
            input = this.replace(input, "<w src=\"2\" lemma=\"strong:G5213\" morph=\"robinson:P-2DP\">be ", "<transChange type=\"added\">be</transChange> <w src=\"2\" lemma=\"strong:G5213\" morph=\"robinson:P-2DP\">");
        }
        if (osisID.equals("2Cor.2.6")) {
            input = this.replace(input, "<w src=\"6\" lemma=\"strong:G3778\" morph=\"robinson:D-NSF\">is ", "<transChange type=\"added\">is</transChange> <w src=\"6\" lemma=\"strong:G3778\" morph=\"robinson:D-NSF\">");
        }
        if (osisID.equals("2Cor.8.18")) {
            input = this.replace(input, "<w src=\"10\" lemma=\"strong:G1722\" morph=\"robinson:PREP\">is ", "<transChange type=\"added\">is</transChange> <w src=\"10\" lemma=\"strong:G1722\" morph=\"robinson:PREP\">");
        }
        if (osisID.equals("2Cor.11.9")) {
            input = this.replace(input, "<w src=\"28\" lemma=\"strong:G5083\" morph=\"robinson:V-FAI-1S\">so ", "<transChange type=\"added\">so</transChange> <w src=\"28\" lemma=\"strong:G5083\" morph=\"robinson:V-FAI-1S\">");
        }
        if (osisID.equals("Eph.5.9")) {
            input = this.replace(input, "<w src=\"6\" lemma=\"strong:G1722\" morph=\"robinson:PREP\">is ", "<transChange type=\"added\">is</transChange> <w src=\"6\" lemma=\"strong:G1722\" morph=\"robinson:PREP\">");
        }
        if (osisID.equals("1Tim.3.11")) {
            input = this.replace(input, "</w> be <w", "</w> <transChange type=\"added\">be</transChange> <w");
        }
        if (osisID.equals("Phlm.1.1")) {
            input = this.replace(input, "<w src=\"7\" lemma=\"strong:G3588\" morph=\"robinson:T-NSM\">our</w> <w src=\"8\" lemma=\"strong:G80\" morph=\"robinson:N-NSM\">", "<transChange type=\"added\">our</transChange> <w src=\"7 8\" lemma=\"strong:G3588 strong:G80\" morph=\"robinson:T-NSM robinson:N-NSM\">");
        }
        if (osisID.equals("Heb.10.23")) {
            input = this.replace(input, "he is</w>", "he</w> <transChange type=\"added\">is</transChange>");
        }
        if (osisID.equals("Heb.12.1")) {
            input = this.replace(input, "</w> us,", "</w> <transChange type=\"added\">us</transChange>,");
        }
        if (osisID.equals("Heb.12.19")) {
            input = this.replace(input, "<transChange type=\"added\">which</transChange> <w src=\"7\" lemma=\"strong:G3739\" morph=\"robinson:R-GSF\">voice</w>", "<w src=\"7\" lemma=\"strong:G3739\" morph=\"robinson:R-GSF\">which</w> <transChange type=\"added\">voice</transChange>");
        }
        if (osisID.equals("Jas.2.16")) {
            input = this.replace(input, "<w src=\"10\" lemma=\"strong:G2328\" morph=\"robinson:V-PEM-2P\">be ye warmed</w>", "<w src=\"10\" lemma=\"strong:G2328\" morph=\"robinson:V-PEM-2P\" type=\"x-split\" subType=\"x-10\">be</w> <transChange type=\"added\">ye</transChange> <w src=\"10\" lemma=\"strong:G2328\" morph=\"robinson:V-PEM-2P\" type=\"x-split\" subType=\"x-10\">warmed</w>");
        }
        if (osisID.equals("1John.2.23")) {
            input = this.replace(input, "(<transChange type=\"added\">", "<transChange type=\"added\">(");
        }
        if (osisID.equals("1John.5.19")) {
            input = this.replace(input, "<w src=\"1\" lemma=\"strong:G1492\" morph=\"robinson:V-RAI-1P\">And ", "<transChange type=\"added\">And</transChange> <w src=\"1\" lemma=\"strong:G1492\" morph=\"robinson:V-RAI-1P\">");
        }
        if (osisID.equals("1John.5.20")) {
            input = this.replace(input, "<transChange type=\"added\"><w src=\"2\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\">And</w></transChange>", "<w src=\"2\" lemma=\"strong:G1161\" morph=\"robinson:CONJ\">And</w>");
        }
        if (osisID.equals("Rev.22.2")) {
            input = this.replace(input, "</transChange> <w src=\"15\" lemma=\"strong:G2590\" morph=\"robinson:N-APM\">of ", " of</transChange> <w src=\"15\" lemma=\"strong:G2590\" morph=\"robinson:N-APM\">");
        }
        if (osisID.equals("Rev.22.7")) {
            input = this.replace(input, "<w src=\"5\" lemma=\"strong:G3588\" morph=\"robinson:T-NSM\">is ", "<transChange type=\"added\">is</transChange> <w src=\"5\" lemma=\"strong:G3588\" morph=\"robinson:T-NSM\">");
        }
        return input;
    }

    private String fixHyphenatedNames(String osisID, String input) {
        Verse v = null;
        try {
            v = VerseFactory.fromString(osisID);
        }
        catch (NoSuchVerseException e) {
            // empty catch block
        }
        if (osisID.equals("Eph.3.2")) {
            input = this.replace(input, "youward", "you-ward");
        }
        if (input.indexOf("Abednego") != -1) {
            input = input.replaceAll("\\bAbednego\\b", "Abed\u2013nego");
        }
        if (input.indexOf("Abelbethmaachah") != -1) {
            input = input.replaceAll("\\bAbelbethmaachah\\b", "Abel\u2013beth\u2013maachah");
        }
        if (input.indexOf("Abelmaim") != -1) {
            input = input.replaceAll("\\bAbelmaim\\b", "Abel\u2013maim");
        }
        if (input.indexOf("Abelmeholah") != -1) {
            input = input.replaceAll("\\bAbelmeholah\\b", "Abel\u2013meholah");
        }
        if (input.indexOf("Abelmizraim") != -1) {
            input = input.replaceAll("\\bAbelmizraim\\b", "Abel\u2013mizraim");
        }
        if (input.indexOf("Abelshittim") != -1) {
            input = input.replaceAll("\\bAbelshittim\\b", "Abel\u2013shittim");
        }
        if (input.indexOf("Abialbon") != -1) {
            input = input.replaceAll("\\bAbialbon\\b", "Abi\u2013albon");
        }
        if ((osisID.equals("Judg.6.34") || osisID.equals("Judg.8.2") || osisID.equals("1Chr.11.28") || osisID.equals("1Chr.27.12")) && input.indexOf("Abiezer") != -1) {
            input = input.replaceAll("\\bAbiezer\\b", "Abi\u2013ezer");
        }
        if (input.indexOf("Abiezrites") != -1) {
            input = input.replaceAll("\\bAbiezrites\\b", "Abi\u2013ezrites");
        }
        if (input.indexOf("Abiezrite") != -1) {
            input = input.replaceAll("\\bAbiezrite\\b", "Abi\u2013ezrite");
        }
        if (input.indexOf("Adonibezek") != -1) {
            input = input.replaceAll("\\bAdonibezek\\b", "Adoni\u2013bezek");
        }
        if (input.indexOf("Adonizedek") != -1) {
            input = input.replaceAll("\\bAdonizedek\\b", "Adoni\u2013zedek");
        }
        if (input.indexOf("Allonbachuth") != -1) {
            input = input.replaceAll("\\bAllonbachuth\\b", "Allon\u2013bachuth");
        }
        if (input.indexOf("Almondiblathaim") != -1) {
            input = input.replaceAll("\\bAlmondiblathaim\\b", "Almon\u2013diblathaim");
        }
        if (input.indexOf("Ashdothpisgah") != -1) {
            input = input.replaceAll("\\bAshdothpisgah\\b", "Ashdoth\u2013pisgah");
        }
        if (input.indexOf("Atarothadar") != -1) {
            input = input.replaceAll("\\bAtarothadar\\b", "Ataroth\u2013adar");
        }
        if (input.indexOf("Atarothaddar") != -1) {
            input = input.replaceAll("\\bAtarothaddar\\b", "Ataroth\u2013addar");
        }
        if (input.indexOf("Aznothtabor") != -1) {
            input = input.replaceAll("\\bAznothtabor\\b", "Aznoth\u2013tabor");
        }
        if (input.indexOf("Baalathbeer") != -1) {
            input = input.replaceAll("\\bBaalathbeer\\b", "Baalath\u2013beer");
        }
        if (input.indexOf("Baalberith") != -1) {
            input = input.replaceAll("\\bBaalberith\\b", "Baal\u2013berith");
        }
        if (input.indexOf("Baalgad") != -1) {
            input = input.replaceAll("\\bBaalgad\\b", "Baal\u2013gad");
        }
        if (input.indexOf("Baalhamon") != -1) {
            input = input.replaceAll("\\bBaalhamon\\b", "Baal\u2013hamon");
        }
        if (input.indexOf("Baalhanan") != -1) {
            input = input.replaceAll("\\bBaalhanan\\b", "Baal\u2013hanan");
        }
        if (input.indexOf("Baalhazor") != -1) {
            input = input.replaceAll("\\bBaalhazor\\b", "Baal\u2013hazor");
        }
        if (input.indexOf("Baalhermon") != -1) {
            input = input.replaceAll("\\bBaalhermon\\b", "Baal\u2013hermon");
        }
        if (input.indexOf("Baalmeon") != -1) {
            input = input.replaceAll("\\bBaalmeon\\b", "Baal\u2013meon");
        }
        if (input.indexOf("Baalpeor") != -1) {
            input = input.replaceAll("\\bBaalpeor\\b", "Baal\u2013peor");
        }
        if (input.indexOf("Baalperazim") != -1) {
            input = input.replaceAll("\\bBaalperazim\\b", "Baal\u2013perazim");
        }
        if (input.indexOf("Baalshalisha") != -1) {
            input = input.replaceAll("\\bBaalshalisha\\b", "Baal\u2013shalisha");
        }
        if (input.indexOf("Baaltamar") != -1) {
            input = input.replaceAll("\\bBaaltamar\\b", "Baal\u2013tamar");
        }
        if (input.indexOf("Baalzebub") != -1) {
            input = input.replaceAll("\\bBaalzebub\\b", "Baal\u2013zebub");
        }
        if (input.indexOf("Baalzephon") != -1) {
            input = input.replaceAll("\\bBaalzephon\\b", "Baal\u2013zephon");
        }
        if (input.indexOf("Bamothbaal") != -1) {
            input = input.replaceAll("\\bBamothbaal\\b", "Bamoth\u2013baal");
        }
        if (input.indexOf("Bashanhavothjair") != -1) {
            input = input.replaceAll("\\bBashanhavothjair\\b", "Bashan\u2013havoth\u2013jair");
        }
        if (input.indexOf("Bathrabbim") != -1) {
            input = input.replaceAll("\\bBathrabbim\\b", "Bath\u2013rabbim");
        }
        if (input.indexOf("Bathsheba") != -1) {
            input = input.replaceAll("\\bBathsheba\\b", "Bath\u2013sheba");
        }
        if (input.indexOf("Bathshua") != -1) {
            input = input.replaceAll("\\bBathshua\\b", "Bath\u2013shua");
        }
        if (input.indexOf("Beerelim") != -1) {
            input = input.replaceAll("\\bBeerelim\\b", "Beer\u2013elim");
        }
        if (input.indexOf("Beerlahairoi") != -1) {
            input = input.replaceAll("\\bBeerlahairoi\\b", "Beer\u2013lahai\u2013roi");
        }
        if (input.indexOf("Beersheba") != -1) {
            input = input.replaceAll("\\bBeersheba\\b", "Beer\u2013sheba");
        }
        if (input.indexOf("Beeshterah") != -1) {
            input = input.replaceAll("\\bBeeshterah\\b", "Beesh\u2013terah");
        }
        if (input.indexOf("Benammi") != -1) {
            input = input.replaceAll("\\bBenammi\\b", "Ben\u2013ammi");
        }
        if (input.indexOf("Beneberak") != -1) {
            input = input.replaceAll("\\bBeneberak\\b", "Bene\u2013berak");
        }
        if (input.indexOf("Benejaakan") != -1) {
            input = input.replaceAll("\\bBenejaakan\\b", "Bene\u2013jaakan");
        }
        if (input.indexOf("Benhadad") != -1) {
            input = input.replaceAll("\\bBenhadad\\b", "Ben\u2013hadad");
        }
        if (input.indexOf("Benhail") != -1) {
            input = input.replaceAll("\\bBenhail\\b", "Ben\u2013hail");
        }
        if (input.indexOf("Benhanan") != -1) {
            input = input.replaceAll("\\bBenhanan\\b", "Ben\u2013hanan");
        }
        if (input.indexOf("Benoni") != -1) {
            input = input.replaceAll("\\bBenoni\\b", "Ben\u2013oni");
        }
        if (input.indexOf("Benzoheth") != -1) {
            input = input.replaceAll("\\bBenzoheth\\b", "Ben\u2013zoheth");
        }
        if (input.indexOf("Berodachbaladan") != -1) {
            input = input.replaceAll("\\bBerodachbaladan\\b", "Berodach\u2013baladan");
        }
        if (input.indexOf("Bethanath") != -1) {
            input = input.replaceAll("\\bBethanath\\b", "Beth\u2013anath");
        }
        if (input.indexOf("Bethanoth") != -1) {
            input = input.replaceAll("\\bBethanoth\\b", "Beth\u2013anoth");
        }
        if (input.indexOf("Betharabah") != -1) {
            input = input.replaceAll("\\bBetharabah\\b", "Beth\u2013arabah");
        }
        if (input.indexOf("Betharam") != -1) {
            input = input.replaceAll("\\bBetharam\\b", "Beth\u2013aram");
        }
        if (input.indexOf("Betharbel") != -1) {
            input = input.replaceAll("\\bBetharbel\\b", "Beth\u2013arbel");
        }
        if (input.indexOf("Bethaven") != -1) {
            input = input.replaceAll("\\bBethaven\\b", "Beth\u2013aven");
        }
        if (input.indexOf("Bethazmaveth") != -1) {
            input = input.replaceAll("\\bBethazmaveth\\b", "Beth\u2013azmaveth");
        }
        if (input.indexOf("Bethbaalmeon") != -1) {
            input = input.replaceAll("\\bBethbaalmeon\\b", "Beth\u2013baal\u2013meon");
        }
        if (input.indexOf("Bethbarah") != -1) {
            input = input.replaceAll("\\bBethbarah\\b", "Beth\u2013barah");
        }
        if (input.indexOf("Bethbirei") != -1) {
            input = input.replaceAll("\\bBethbirei\\b", "Beth\u2013birei");
        }
        if (input.indexOf("Bethcar") != -1) {
            input = input.replaceAll("\\bBethcar\\b", "Beth\u2013car");
        }
        if (input.indexOf("Bethdagon") != -1) {
            input = input.replaceAll("\\bBethdagon\\b", "Beth\u2013dagon");
        }
        if (input.indexOf("Bethdiblathaim") != -1) {
            input = input.replaceAll("\\bBethdiblathaim\\b", "Beth\u2013diblathaim");
        }
        if (input.indexOf("Bethel") != -1) {
            input = input.replaceAll("\\bBethel\\b", "Beth\u2013el");
        }
        if (input.indexOf("Bethemek") != -1) {
            input = input.replaceAll("\\bBethemek\\b", "Beth\u2013emek");
        }
        if (input.indexOf("Bethezel") != -1) {
            input = input.replaceAll("\\bBethezel\\b", "Beth\u2013ezel");
        }
        if (input.indexOf("Bethgader") != -1) {
            input = input.replaceAll("\\bBethgader\\b", "Beth\u2013gader");
        }
        if (input.indexOf("Bethgamul") != -1) {
            input = input.replaceAll("\\bBethgamul\\b", "Beth\u2013gamul");
        }
        if (input.indexOf("Bethhaccerem") != -1) {
            input = input.replaceAll("\\bBethhaccerem\\b", "Beth\u2013haccerem");
        }
        if (input.indexOf("Bethharan") != -1) {
            input = input.replaceAll("\\bBethharan\\b", "Beth\u2013haran");
        }
        if (input.indexOf("Bethhoglah") != -1) {
            input = input.replaceAll("\\bBethhoglah\\b", "Beth\u2013hoglah");
        }
        if (input.indexOf("Bethhogla") != -1) {
            input = input.replaceAll("\\bBethhogla\\b", "Beth\u2013hogla");
        }
        if (input.indexOf("Bethhoron") != -1) {
            input = input.replaceAll("\\bBethhoron\\b", "Beth\u2013horon");
        }
        if (input.indexOf("Bethjeshimoth") != -1) {
            input = input.replaceAll("\\bBethjeshimoth\\b", "Beth\u2013jeshimoth");
        }
        if (input.indexOf("Bethjesimoth") != -1) {
            input = input.replaceAll("\\bBethjesimoth\\b", "Beth\u2013jesimoth");
        }
        if (input.indexOf("Bethlebaoth") != -1) {
            input = input.replaceAll("\\bBethlebaoth\\b", "Beth\u2013lebaoth");
        }
        if (input.indexOf("Bethlehemjudah") != -1) {
            input = input.replaceAll("\\bBethlehemjudah\\b", "Beth\u2013lehem\u2013judah");
        }
        if (input.indexOf("Bethlehem") != -1 && SwordConstants.getTestament(v) == 1) {
            input = input.replaceAll("\\bBethlehem\\b", "Beth\u2013lehem");
        }
        if (input.indexOf("Bethmaachah") != -1) {
            input = input.replaceAll("\\bBethmaachah\\b", "Beth\u2013maachah");
        }
        if (input.indexOf("Bethmarcaboth") != -1) {
            input = input.replaceAll("\\bBethmarcaboth\\b", "Beth\u2013marcaboth");
        }
        if (input.indexOf("Bethmeon") != -1) {
            input = input.replaceAll("\\bBethmeon\\b", "Beth\u2013meon");
        }
        if (input.indexOf("Bethnimrah") != -1) {
            input = input.replaceAll("\\bBethnimrah\\b", "Beth\u2013nimrah");
        }
        if (input.indexOf("Bethpalet") != -1) {
            input = input.replaceAll("\\bBethpalet\\b", "Beth\u2013palet");
        }
        if (input.indexOf("Bethpazzez") != -1) {
            input = input.replaceAll("\\bBethpazzez\\b", "Beth\u2013pazzez");
        }
        if (input.indexOf("Bethpeor") != -1) {
            input = input.replaceAll("\\bBethpeor\\b", "Beth\u2013peor");
        }
        if (input.indexOf("Bethphelet") != -1) {
            input = input.replaceAll("\\bBethphelet\\b", "Beth\u2013phelet");
        }
        if (input.indexOf("Bethrapha") != -1) {
            input = input.replaceAll("\\bBethrapha\\b", "Beth\u2013rapha");
        }
        if (input.indexOf("Bethrehob") != -1) {
            input = input.replaceAll("\\bBethrehob\\b", "Beth\u2013rehob");
        }
        if (input.indexOf("Bethshan") != -1) {
            input = input.replaceAll("\\bBethshan\\b", "Beth\u2013shan");
        }
        if (input.indexOf("Bethshean") != -1) {
            input = input.replaceAll("\\bBethshean\\b", "Beth\u2013shean");
        }
        if (input.indexOf("Bethshemesh") != -1) {
            input = input.replaceAll("\\bBethshemesh\\b", "Beth\u2013shemesh");
        }
        if (input.indexOf("Bethshemite") != -1) {
            input = input.replaceAll("\\bBethshemite\\b", "Beth\u2013shemite");
        }
        if (input.indexOf("Bethshittah") != -1) {
            input = input.replaceAll("\\bBethshittah\\b", "Beth\u2013shittah");
        }
        if (input.indexOf("Bethtappuah") != -1) {
            input = input.replaceAll("\\bBethtappuah\\b", "Beth\u2013tappuah");
        }
        if (input.indexOf("Bethzur") != -1) {
            input = input.replaceAll("\\bBethzur\\b", "Beth\u2013zur");
        }
        if (input.indexOf("Calebephratah") != -1) {
            input = input.replaceAll("\\bCalebephratah\\b", "Caleb\u2013ephratah");
        }
        if (input.indexOf("Chepharhaammonai") != -1) {
            input = input.replaceAll("\\bChepharhaammonai\\b", "Chephar\u2013haammonai");
        }
        if (input.indexOf("Chislothtabor") != -1) {
            input = input.replaceAll("\\bChislothtabor\\b", "Chisloth\u2013tabor");
        }
        if (input.indexOf("Chorashan") != -1) {
            input = input.replaceAll("\\bChorashan\\b", "Chor\u2013ashan");
        }
        if (input.indexOf("Chushanrishathaim") != -1) {
            input = input.replaceAll("\\bChushanrishathaim\\b", "Chushan\u2013rishathaim");
        }
        if (input.indexOf("Colhozeh") != -1) {
            input = input.replaceAll("\\bColhozeh\\b", "Col\u2013hozeh");
        }
        if (input.indexOf("Danjaan") != -1) {
            input = input.replaceAll("\\bDanjaan\\b", "Dan\u2013jaan");
        }
        if (input.indexOf("Dibongad") != -1) {
            input = input.replaceAll("\\bDibongad\\b", "Dibon\u2013gad");
        }
        if (input.indexOf("Ebedmelech") != -1) {
            input = input.replaceAll("\\bEbedmelech\\b", "Ebed\u2013melech");
        }
        if (input.indexOf("Ebenezer") != -1) {
            input = input.replaceAll("\\bEbenezer\\b", "Eben\u2013ezer");
        }
        if (input.indexOf("Elbethel") != -1) {
            input = input.replaceAll("\\bElbethel\\b", "El\u2013beth\u2013el");
        }
        if (input.indexOf("Elelohe-Israel") != -1) {
            input = input.replaceAll("\\bElelohe-Israel\\b", "El\u2013elohe\u2013Israel");
        }
        if (input.indexOf("Elonbethhanan") != -1) {
            input = input.replaceAll("\\bElonbethhanan\\b", "Elon\u2013beth\u2013hanan");
        }
        if (input.indexOf("Elparan") != -1) {
            input = input.replaceAll("\\bElparan\\b", "El\u2013paran");
        }
        if (input.indexOf("Eneglaim") != -1) {
            input = input.replaceAll("\\bEneglaim\\b", "En\u2013eglaim");
        }
        if (input.indexOf("Engannim") != -1) {
            input = input.replaceAll("\\bEngannim\\b", "En\u2013gannim");
        }
        if (input.indexOf("Engedi") != -1) {
            input = input.replaceAll("\\bEngedi\\b", "En\u2013gedi");
        }
        if (input.indexOf("Enhaddah") != -1) {
            input = input.replaceAll("\\bEnhaddah\\b", "En\u2013haddah");
        }
        if (input.indexOf("Enhakkore") != -1) {
            input = input.replaceAll("\\bEnhakkore\\b", "En\u2013hakkore");
        }
        if (input.indexOf("Enhazor") != -1) {
            input = input.replaceAll("\\bEnhazor\\b", "En\u2013hazor");
        }
        if (input.indexOf("Enmishpat") != -1) {
            input = input.replaceAll("\\bEnmishpat\\b", "En\u2013mishpat");
        }
        if (input.indexOf("Enrimmon") != -1) {
            input = input.replaceAll("\\bEnrimmon\\b", "En\u2013rimmon");
        }
        if (input.indexOf("Enrogel") != -1) {
            input = input.replaceAll("\\bEnrogel\\b", "En\u2013rogel");
        }
        if (input.indexOf("Enshemesh") != -1) {
            input = input.replaceAll("\\bEnshemesh\\b", "En\u2013shemesh");
        }
        if (input.indexOf("Entappuah") != -1) {
            input = input.replaceAll("\\bEntappuah\\b", "En\u2013tappuah");
        }
        if (input.indexOf("Ephesdammim") != -1) {
            input = input.replaceAll("\\bEphesdammim\\b", "Ephes\u2013dammim");
        }
        if (input.indexOf("Esarhaddon") != -1) {
            input = input.replaceAll("\\bEsarhaddon\\b", "Esar\u2013haddon");
        }
        if (input.indexOf("Eshbaal") != -1) {
            input = input.replaceAll("\\bEshbaal\\b", "Esh\u2013baal");
        }
        if (input.indexOf("Evilmerodach") != -1) {
            input = input.replaceAll("\\bEvilmerodach\\b", "Evil\u2013merodach");
        }
        if (input.indexOf("Eziongaber") != -1) {
            input = input.replaceAll("\\bEziongaber\\b", "Ezion\u2013gaber");
        }
        if (input.indexOf("Eziongeber") != -1) {
            input = input.replaceAll("\\bEziongeber\\b", "Ezion\u2013geber");
        }
        if (input.indexOf("Gathhepher") != -1) {
            input = input.replaceAll("\\bGathhepher\\b", "Gath\u2013hepher");
        }
        if (input.indexOf("Gathrimmon") != -1) {
            input = input.replaceAll("\\bGathrimmon\\b", "Gath\u2013rimmon");
        }
        if (input.indexOf("Gibeah-haaraloth") != -1) {
            input = input.replaceAll("\\bGibeah-haaraloth\\b", "Gibeah\u2013haaraloth");
        }
        if (input.indexOf("Gittahhepher") != -1) {
            input = input.replaceAll("\\bGittahhepher\\b", "Gittah\u2013hepher");
        }
        if (input.indexOf("Gurbaal") != -1) {
            input = input.replaceAll("\\bGurbaal\\b", "Gur\u2013baal");
        }
        if (input.indexOf("Hamathzobah") != -1) {
            input = input.replaceAll("\\bHamathzobah\\b", "Hamath\u2013zobah");
        }
        if (input.indexOf("Hammothdor") != -1) {
            input = input.replaceAll("\\bHammothdor\\b", "Hammoth\u2013dor");
        }
        if (input.indexOf("Hamongog") != -1) {
            input = input.replaceAll("\\bHamongog\\b", "Hamon\u2013gog");
        }
        if (input.indexOf("Havothjair") != -1) {
            input = input.replaceAll("\\bHavothjair\\b", "Havoth\u2013jair");
        }
        if (input.indexOf("Hazaraddar") != -1) {
            input = input.replaceAll("\\bHazaraddar\\b", "Hazar\u2013addar");
        }
        if (input.indexOf("Hazarenan") != -1) {
            input = input.replaceAll("\\bHazarenan\\b", "Hazar\u2013enan");
        }
        if (input.indexOf("Hazargaddah") != -1) {
            input = input.replaceAll("\\bHazargaddah\\b", "Hazar\u2013gaddah");
        }
        if (input.indexOf("Hazarhatticon") != -1) {
            input = input.replaceAll("\\bHazarhatticon\\b", "Hazar\u2013hatticon");
        }
        if (input.indexOf("Hazarshual") != -1) {
            input = input.replaceAll("\\bHazarshual\\b", "Hazar\u2013shual");
        }
        if (input.indexOf("Hazarsusah") != -1) {
            input = input.replaceAll("\\bHazarsusah\\b", "Hazar\u2013susah");
        }
        if (input.indexOf("Hazarsusim") != -1) {
            input = input.replaceAll("\\bHazarsusim\\b", "Hazar\u2013susim");
        }
        if (input.indexOf("Hazazontamar") != -1) {
            input = input.replaceAll("\\bHazazontamar\\b", "Hazazon\u2013tamar");
        }
        if (input.indexOf("Hazezontamar") != -1) {
            input = input.replaceAll("\\bHazezontamar\\b", "Hazezon\u2013tamar");
        }
        if (input.indexOf("Helkathhazzurim") != -1) {
            input = input.replaceAll("\\bHelkathhazzurim\\b", "Helkath\u2013hazzurim");
        }
        if (input.indexOf("Hephzibah") != -1) {
            input = input.replaceAll("\\bHephzibah\\b", "Hephzi\u2013bah");
        }
        if (input.indexOf("Horhagidgad") != -1) {
            input = input.replaceAll("\\bHorhagidgad\\b", "Hor\u2013hagidgad");
        }
        if (input.indexOf("Ichabod") != -1) {
            input = input.replaceAll("\\bIchabod\\b", "I\u2013chabod");
        }
        if (input.indexOf("Ijeabarim") != -1) {
            input = input.replaceAll("\\bIjeabarim\\b", "Ije\u2013abarim");
        }
        if (input.indexOf("Irnahash") != -1) {
            input = input.replaceAll("\\bIrnahash\\b", "Ir\u2013nahash");
        }
        if (input.indexOf("Irshemesh") != -1) {
            input = input.replaceAll("\\bIrshemesh\\b", "Ir\u2013shemesh");
        }
        if (input.indexOf("Ishbibenob") != -1) {
            input = input.replaceAll("\\bIshbibenob\\b", "Ishbi\u2013benob");
        }
        if (input.indexOf("Ishbosheth") != -1) {
            input = input.replaceAll("\\bIshbosheth\\b", "Ish\u2013bosheth");
        }
        if (input.indexOf("Ishtob") != -1) {
            input = input.replaceAll("\\bIshtob\\b", "Ish\u2013tob");
        }
        if (input.indexOf("Ittahkazin") != -1) {
            input = input.replaceAll("\\bIttahkazin\\b", "Ittah\u2013kazin");
        }
        if (input.indexOf("Jaareoregim") != -1) {
            input = input.replaceAll("\\bJaareoregim\\b", "Jaare\u2013oregim");
        }
        if (input.indexOf("Jabeshgilead") != -1) {
            input = input.replaceAll("\\bJabeshgilead\\b", "Jabesh\u2013gilead");
        }
        if (input.indexOf("Jashubilehem") != -1) {
            input = input.replaceAll("\\bJashubilehem\\b", "Jashubi\u2013lehem");
        }
        if (input.indexOf("Jegarsahadutha") != -1) {
            input = input.replaceAll("\\bJegarsahadutha\\b", "Jegar\u2013sahadutha");
        }
        if (input.indexOf("Jehovahjireh") != -1) {
            input = input.replaceAll("\\bJehovahjireh\\b", "Jehovah\u2013jireh");
        }
        if (input.indexOf("Jehovahnissi") != -1) {
            input = input.replaceAll("\\bJehovahnissi\\b", "Jehovah\u2013nissi");
        }
        if (input.indexOf("Jehovahshalom") != -1) {
            input = input.replaceAll("\\bJehovahshalom\\b", "Jehovah\u2013shalom");
        }
        if (input.indexOf("Jiphthahel") != -1) {
            input = input.replaceAll("\\bJiphthahel\\b", "Jiphthah\u2013el");
        }
        if (input.indexOf("Jushabhesed") != -1) {
            input = input.replaceAll("\\bJushabhesed\\b", "Jushab\u2013hesed");
        }
        if (input.indexOf("Kadeshbarnea") != -1) {
            input = input.replaceAll("\\bKadeshbarnea\\b", "Kadesh\u2013barnea");
        }
        if (input.indexOf("Kedeshnaphtali") != -1) {
            input = input.replaceAll("\\bKedeshnaphtali\\b", "Kedesh\u2013naphtali");
        }
        if (input.indexOf("Kerenhappuch") != -1) {
            input = input.replaceAll("\\bKerenhappuch\\b", "Keren\u2013happuch");
        }
        if (input.indexOf("Kibrothhattaavah") != -1) {
            input = input.replaceAll("\\bKibrothhattaavah\\b", "Kibroth\u2013hattaavah");
        }
        if (input.indexOf("Kirharaseth") != -1) {
            input = input.replaceAll("\\bKirharaseth\\b", "Kir\u2013haraseth");
        }
        if (input.indexOf("Kirhareseth") != -1) {
            input = input.replaceAll("\\bKirhareseth\\b", "Kir\u2013hareseth");
        }
        if (input.indexOf("Kirharesh") != -1) {
            input = input.replaceAll("\\bKirharesh\\b", "Kir\u2013haresh");
        }
        if (input.indexOf("Kirheres") != -1) {
            input = input.replaceAll("\\bKirheres\\b", "Kir\u2013heres");
        }
        if (input.indexOf("Kirjatharba") != -1) {
            input = input.replaceAll("\\bKirjatharba\\b", "Kirjath\u2013arba");
        }
        if (input.indexOf("Kirjatharim") != -1) {
            input = input.replaceAll("\\bKirjatharim\\b", "Kirjath\u2013arim");
        }
        if (input.indexOf("Kirjathbaal") != -1) {
            input = input.replaceAll("\\bKirjathbaal\\b", "Kirjath\u2013baal");
        }
        if (input.indexOf("Kirjathhuzoth") != -1) {
            input = input.replaceAll("\\bKirjathhuzoth\\b", "Kirjath\u2013huzoth");
        }
        if (input.indexOf("Kirjathjearim") != -1) {
            input = input.replaceAll("\\bKirjathjearim\\b", "Kirjath\u2013jearim");
        }
        if (input.indexOf("Kirjathsannah") != -1) {
            input = input.replaceAll("\\bKirjathsannah\\b", "Kirjath\u2013sannah");
        }
        if (input.indexOf("Kirjathsepher") != -1) {
            input = input.replaceAll("\\bKirjathsepher\\b", "Kirjath\u2013sepher");
        }
        if (input.indexOf("Lahairoi") != -1) {
            input = input.replaceAll("\\bLahairoi\\b", "Lahai\u2013roi");
        }
        if (input.indexOf("Loammi") != -1) {
            input = input.replaceAll("\\bLoammi\\b", "Lo\u2013ammi");
        }
        if (input.indexOf("Lodebar") != -1) {
            input = input.replaceAll("\\bLodebar\\b", "Lo\u2013debar");
        }
        if (input.indexOf("Loruhamah") != -1) {
            input = input.replaceAll("\\bLoruhamah\\b", "Lo\u2013ruhamah");
        }
        if (input.indexOf("Maalehacrabbim") != -1) {
            input = input.replaceAll("\\bMaalehacrabbim\\b", "Maaleh\u2013acrabbim");
        }
        if (input.indexOf("Magormissabib") != -1) {
            input = input.replaceAll("\\bMagormissabib\\b", "Magor\u2013missabib");
        }
        if (input.indexOf("Mahanehdan") != -1) {
            input = input.replaceAll("\\bMahanehdan\\b", "Mahaneh\u2013dan");
        }
        if (input.indexOf("Mahershalalhashbaz") != -1) {
            input = input.replaceAll("\\bMahershalalhashbaz\\b", "Maher\u2013shalal\u2013hash\u2013baz");
        }
        if (input.indexOf("Maher-shalal-hash-baz") != -1) {
            input = input.replaceAll("\\bMaher-shalal-hash-baz\\b", "Maher\u2013shalal\u2013hash\u2013baz");
        }
        if (input.indexOf("Malchishua") != -1) {
            input = input.replaceAll("\\bMalchishua\\b", "Malchi\u2013shua");
        }
        if (input.indexOf("Mejarkon") != -1) {
            input = input.replaceAll("\\bMejarkon\\b", "Me\u2013jarkon");
        }
        if (input.indexOf("Melchishua") != -1) {
            input = input.replaceAll("\\bMelchishua\\b", "Melchi\u2013shua");
        }
        if (input.indexOf("Meribah-Kadesh") != -1) {
            input = input.replaceAll("\\bMeribah-Kadesh\\b", "Meribah\u2013Kadesh");
        }
        if (input.indexOf("Meribaal") != -1) {
            input = input.replaceAll("\\bMeribaal\\b", "Meri\u2013baal");
        }
        if (input.indexOf("Meribbaal") != -1) {
            input = input.replaceAll("\\bMeribbaal\\b", "Merib\u2013baal");
        }
        if (input.indexOf("Merodachbaladan") != -1) {
            input = input.replaceAll("\\bMerodachbaladan\\b", "Merodach\u2013baladan");
        }
        if (input.indexOf("Methegammah") != -1) {
            input = input.replaceAll("\\bMethegammah\\b", "Metheg\u2013ammah");
        }
        if (input.indexOf("Migdalel") != -1) {
            input = input.replaceAll("\\bMigdalel\\b", "Migdal\u2013el");
        }
        if (input.indexOf("Migdalgad") != -1) {
            input = input.replaceAll("\\bMigdalgad\\b", "Migdal\u2013gad");
        }
        if (input.indexOf("Misrephothmaim") != -1) {
            input = input.replaceAll("\\bMisrephothmaim\\b", "Misrephoth\u2013maim");
        }
        if (input.indexOf("Moreshethgath") != -1) {
            input = input.replaceAll("\\bMoreshethgath\\b", "Moresheth\u2013gath");
        }
        if (input.indexOf("Nathanmelech") != -1) {
            input = input.replaceAll("\\bNathanmelech\\b", "Nathan\u2013melech");
        }
        if (input.indexOf("Nebuzaradan") != -1) {
            input = input.replaceAll("\\bNebuzaradan\\b", "Nebuzar\u2013adan");
        }
        if (input.indexOf("Nergalsharezer") != -1) {
            input = input.replaceAll("\\bNergalsharezer\\b", "Nergal\u2013sharezer");
        }
        if (input.indexOf("Obededom") != -1) {
            input = input.replaceAll("\\bObededom\\b", "Obed\u2013edom");
        }
        if (input.indexOf("Padanaram") != -1) {
            input = input.replaceAll("\\bPadanaram\\b", "Padan\u2013aram");
        }
        if (input.indexOf("Pahathmoab") != -1) {
            input = input.replaceAll("\\bPahathmoab\\b", "Pahath\u2013moab");
        }
        if (input.indexOf("Pasdammim") != -1) {
            input = input.replaceAll("\\bPasdammim\\b", "Pas\u2013dammim");
        }
        if (input.indexOf("Perezuzzah") != -1) {
            input = input.replaceAll("\\bPerezuzzah\\b", "Perez\u2013uzzah");
        }
        if (input.indexOf("Perezuzza") != -1) {
            input = input.replaceAll("\\bPerezuzza\\b", "Perez\u2013uzza");
        }
        if (input.indexOf("Pharaohhophra") != -1) {
            input = input.replaceAll("\\bPharaohhophra\\b", "Pharaoh\u2013hophra");
        }
        if (input.indexOf("Pharaohnechoh") != -1) {
            input = input.replaceAll("\\bPharaohnechoh\\b", "Pharaoh\u2013nechoh");
        }
        if (input.indexOf("Pharaohnecho") != -1) {
            input = input.replaceAll("\\bPharaohnecho\\b", "Pharaoh\u2013necho");
        }
        if (input.indexOf("Pibeseth") != -1) {
            input = input.replaceAll("\\bPibeseth\\b", "Pi\u2013beseth");
        }
        if (input.indexOf("Pihahiroth") != -1) {
            input = input.replaceAll("\\bPihahiroth\\b", "Pi\u2013hahiroth");
        }
        if (input.indexOf("Potipherah") != -1) {
            input = input.replaceAll("\\bPotipherah\\b", "Poti\u2013pherah");
        }
        if (input.indexOf("Rabsaris") != -1 && !osisID.equals("2Kgs.18.17")) {
            input = input.replaceAll("\\bRabsaris\\b", "Rab\u2013saris");
        }
        if (input.indexOf("Rabshakeh") != -1 && osisID.startsWith("2Kgs")) {
            input = input.replaceAll("\\bRabshakeh\\b", "Rab\u2013shakeh");
        }
        if (input.indexOf("Ramathaimzophim") != -1) {
            input = input.replaceAll("\\bRamathaimzophim\\b", "Ramathaim\u2013zophim");
        }
        if (input.indexOf("Ramathlehi") != -1) {
            input = input.replaceAll("\\bRamathlehi\\b", "Ramath\u2013lehi");
        }
        if (input.indexOf("Ramathmizpeh") != -1) {
            input = input.replaceAll("\\bRamathmizpeh\\b", "Ramath\u2013mizpeh");
        }
        if (input.indexOf("Ramothgilead") != -1) {
            input = input.replaceAll("\\bRamothgilead\\b", "Ramoth\u2013gilead");
        }
        if (input.indexOf("Regemmelech") != -1) {
            input = input.replaceAll("\\bRegemmelech\\b", "Regem\u2013melech");
        }
        if (input.indexOf("Remmonmethoar") != -1) {
            input = input.replaceAll("\\bRemmonmethoar\\b", "Remmon\u2013methoar");
        }
        if (input.indexOf("Rimmonparez") != -1) {
            input = input.replaceAll("\\bRimmonparez\\b", "Rimmon\u2013parez");
        }
        if (input.indexOf("Romamtiezer") != -1) {
            input = input.replaceAll("\\bRomamtiezer\\b", "Romamti\u2013ezer");
        }
        if (input.indexOf("Ruhamah") != -1) {
            input = input.replaceAll("\\bRuhamah\\b", "Ru\u2013hamah");
        }
        if (input.indexOf("Samgarnebo") != -1) {
            input = input.replaceAll("\\bSamgarnebo\\b", "Samgar\u2013nebo");
        }
        if (input.indexOf("Selahammahlekoth") != -1) {
            input = input.replaceAll("\\bSelahammahlekoth\\b", "Sela\u2013hammahlekoth");
        }
        if (input.indexOf("Shearjashub") != -1) {
            input = input.replaceAll("\\bShearjashub\\b", "Shear\u2013jashub");
        }
        if (input.indexOf("Shetharboznai") != -1) {
            input = input.replaceAll("\\bShetharboznai\\b", "Shethar\u2013boznai");
        }
        if (input.indexOf("Shihorlibnath") != -1) {
            input = input.replaceAll("\\bShihorlibnath\\b", "Shihor\u2013libnath");
        }
        if (input.indexOf("Shimronmeron") != -1) {
            input = input.replaceAll("\\bShimronmeron\\b", "Shimron\u2013meron");
        }
        if (input.indexOf("Succothbenoth") != -1) {
            input = input.replaceAll("\\bSuccothbenoth\\b", "Succoth\u2013benoth");
        }
        if (input.indexOf("Syriadamascus") != -1) {
            input = input.replaceAll("\\bSyriadamascus\\b", "Syria\u2013damascus");
        }
        if (input.indexOf("Syriamaachah") != -1) {
            input = input.replaceAll("\\bSyriamaachah\\b", "Syria\u2013maachah");
        }
        if (input.indexOf("Taanathshiloh") != -1) {
            input = input.replaceAll("\\bTaanathshiloh\\b", "Taanath\u2013shiloh");
        }
        if (input.indexOf("Tahtimhodshi") != -1) {
            input = input.replaceAll("\\bTahtimhodshi\\b", "Tahtim\u2013hodshi");
        }
        if (input.indexOf("Telabib") != -1) {
            input = input.replaceAll("\\bTelabib\\b", "Tel\u2013abib");
        }
        if (input.indexOf("Telharesha") != -1) {
            input = input.replaceAll("\\bTelharesha\\b", "Tel\u2013haresha");
        }
        if (input.indexOf("Telharsa") != -1) {
            input = input.replaceAll("\\bTelharsa\\b", "Tel\u2013harsa");
        }
        if (input.indexOf("Telmelah") != -1) {
            input = input.replaceAll("\\bTelmelah\\b", "Tel\u2013melah");
        }
        if (input.indexOf("Tiglathpileser") != -1) {
            input = input.replaceAll("\\bTiglathpileser\\b", "Tiglath\u2013pileser");
        }
        if (input.indexOf("Tilgathpilneser") != -1) {
            input = input.replaceAll("\\bTilgathpilneser\\b", "Tilgath\u2013pilneser");
        }
        if (input.indexOf("Timnathheres") != -1) {
            input = input.replaceAll("\\bTimnathheres\\b", "Timnath\u2013heres");
        }
        if (input.indexOf("Timnathserah") != -1) {
            input = input.replaceAll("\\bTimnathserah\\b", "Timnath\u2013serah");
        }
        if (input.indexOf("Tobadonijah") != -1) {
            input = input.replaceAll("\\bTobadonijah\\b", "Tob\u2013adonijah");
        }
        if (input.indexOf("Tubalcain") != -1) {
            input = input.replaceAll("\\bTubalcain\\b", "Tubal\u2013cain");
        }
        if (input.indexOf("Uzzensherah") != -1) {
            input = input.replaceAll("\\bUzzensherah\\b", "Uzzen\u2013sherah");
        }
        if (input.indexOf("Zarethshahar") != -1) {
            input = input.replaceAll("\\bZarethshahar\\b", "Zareth\u2013shahar");
        }
        if (input.indexOf("Zaphnathpaaneah") != -1) {
            input = input.replaceAll("\\bZaphnathpaaneah\\b", "Zaphnath\u2013paaneah");
        }
        if (input.indexOf("Altaschith") != -1) {
            input = input.replaceAll("\\bAltaschith\\b", "Al\u2013taschith");
        }
        if (input.indexOf("Aramnaharaim") != -1) {
            input = input.replaceAll("\\bAramnaharaim\\b", "Aram\u2013naharaim");
        }
        if (input.indexOf("Aramzobah") != -1) {
            input = input.replaceAll("\\bAramzobah\\b", "Aram\u2013zobah");
        }
        if (input.indexOf("Jonathelemrechokim") != -1) {
            input = input.replaceAll("\\bJonathelemrechokim\\b", "Jonath\u2013elem\u2013rechokim");
        }
        if (input.indexOf("Bathshuah") != -1) {
            input = input.replaceAll("\\bBathshuah\\b", "Bath\u2013shuah");
        }
        if (input.indexOf("Benabinadab") != -1) {
            input = input.replaceAll("\\bBenabinadab\\b", "Ben\u2013abinadab");
        }
        if (input.indexOf("Bendekar") != -1) {
            input = input.replaceAll("\\bBendekar\\b", "Ben\u2013dekar");
        }
        if (input.indexOf("Bengeber") != -1) {
            input = input.replaceAll("\\bBengeber\\b", "Ben\u2013geber");
        }
        if (input.indexOf("Benhesed") != -1) {
            input = input.replaceAll("\\bBenhesed\\b", "Ben\u2013hesed");
        }
        if (input.indexOf("Benhur") != -1) {
            input = input.replaceAll("\\bBenhur\\b", "Ben\u2013hur");
        }
        if (input.indexOf("Betheden") != -1) {
            input = input.replaceAll("\\bBetheden\\b", "Beth\u2013eden");
        }
        if (input.indexOf("Hatsihammenuchoth") != -1) {
            input = input.replaceAll("\\bHatsihammenuchoth\\b", "Hatsi\u2013ham\u2013menuchoth");
        }
        if (input.indexOf("Jehovahshammah") != -1) {
            input = input.replaceAll("\\bJehovahshammah\\b", "Jehovah\u2013shammah");
        }
        if (input.indexOf("Jehovahtsidkenu") != -1) {
            input = input.replaceAll("\\bJehovahtsidkenu\\b", "Jehovah\u2013tsidkenu");
        }
        if (input.indexOf("Meribahkadesh") != -1) {
            input = input.replaceAll("\\bMeribahkadesh\\b", "Meribah\u2013kadesh");
        }
        if (input.indexOf("Shoshannimeduth") != -1) {
            input = input.replaceAll("\\bShoshannimeduth\\b", "Shoshannim\u2013eduth");
        }
        if (input.indexOf("Shushaneduth") != -1) {
            input = input.replaceAll("\\bShushaneduth\\b", "Shushan\u2013eduth");
        }
        if (input.indexOf("Bethelite") != -1) {
            input = input.replaceAll("\\bBethelite\\b", "Beth\u2013elite");
        }
        if (input.indexOf("Bethlehemite") != -1) {
            input = input.replaceAll("\\bBethlehemite\\b", "Beth\u2013lehemite");
        }
        if (input.indexOf("Rabmag") != -1) {
            input = input.replaceAll("\\bRabmag\\b", "Rab\u2013mag");
        }
        return input;
    }

    private String fixDivineName(String osisID, String input) {
        if (input.indexOf("divineName") != -1) {
            input = divineNamePattern.matcher(input).replaceAll(divineNameReplace);
        }
        if (input.indexOf("H03069") != -1) {
            input = dna1Pattern.matcher(input).replaceAll(dna1Replace);
        }
        if (input.indexOf("H03050") != -1) {
            input = dna2Pattern.matcher(input).replaceAll(dna1Replace);
        }
        input = dn1Pattern.matcher(input).replaceAll(dn1Replace);
        input = dn2Pattern.matcher(input).replaceAll(dn2Replace);
        input = dn3Pattern.matcher(input).replaceAll(dn3Replace);
        input = dn4Pattern.matcher(input).replaceAll(dn4Replace);
        input = dn5Pattern.matcher(input).replaceAll(dn5Replace);
        if (osisID.equals("Matt.22.44")) {
            input = this.replace(input, "<w src=\"2 3\" lemma=\"strong:G3588 strong:G2962\" morph=\"robinson:T-NSM robinson:N-NSM\">The LORD</w>", "<w src=\"2 3\" lemma=\"strong:G3588 strong:G2962\" morph=\"robinson:T-NSM robinson:N-NSM\">The <seg><divineName>Lord</divineName></seg></w>");
        }
        if (osisID.equals("Luke.20.42")) {
            input = this.replace(input, "<w src=\"9 10\" lemma=\"strong:G3588 strong:G2962\" morph=\"robinson:T-NSM robinson:N-NSM\">The LORD</w>", "<w src=\"9 10\" lemma=\"strong:G3588 strong:G2962\" morph=\"robinson:T-NSM robinson:N-NSM\">The <seg><divineName>Lord</divineName></seg></w>");
        }
        if (osisID.equals("Acts.2.34")) {
            input = this.replace(input, "<w src=\"12 13\" lemma=\"strong:G3588 strong:G2962\" morph=\"robinson:T-NSM robinson:N-NSM\">The LORD</w>", "<w src=\"12 13\" lemma=\"strong:G3588 strong:G2962\" morph=\"robinson:T-NSM robinson:N-NSM\">The <seg><divineName>Lord</divineName></seg></w>");
        }
        input = dn6Pattern.matcher(input).replaceAll(dn6Replace);
        input = dn7Pattern.matcher(input).replaceAll(dn7Replace);
        input = dn8Pattern.matcher(input).replaceAll(dn8Replace);
        input = dn9Pattern.matcher(input).replaceAll(dn9Replace);
        input = dn10Pattern.matcher(input).replaceAll(dn10Replace);
        if (osisID.equals("Deut.28.58")) {
            input = this.replace(input, "<divineName>God</divineName>", "GOD");
        }
        if (osisID.equals("Jer.23.6") || osisID.equals("Jer.33.16")) {
            input = this.replace(input, "<divineName>Lord</divineName>", "<seg><divineName>Lord</divineName></seg>");
        }
        return input;
    }

    private String fixInscriptions(String osisID, String input) {
        if (osisID.equals("Exod.28.36") || osisID.equals("Exod.39.30")) {
            input = this.replace(input, "<w lemma=\"strong:H06944\">HOLINESS</w> <w lemma=\"strong:H03068\">TO THE <seg><divineName>Lord</divineName></seg></w>", "<inscription><w lemma=\"strong:H06944\">HOLINESS</w> <w lemma=\"strong:H03068\">TO THE <seg><divineName>Lord</divineName></seg></w></inscription>");
        }
        if (osisID.equals("Dan.5.25")) {
            input = this.replace(input, "<w morph=\"strongMorph:TH8752\" lemma=\"strong:H04484\">MENE</w>, <w morph=\"strongMorph:TH8752\" lemma=\"strong:H04484\">MENE</w>, <w morph=\"strongMorph:TH8752\" lemma=\"strong:H08625\">TEKEL</w>, <w morph=\"strongMorph:TH8751\" lemma=\"strong:H06537\">UPHARSIN</w>", "<inscription><w morph=\"strongMorph:TH8752\" lemma=\"strong:H04484\">MENE</w>, <w morph=\"strongMorph:TH8752\" lemma=\"strong:H04484\">MENE</w>, <w morph=\"strongMorph:TH8752\" lemma=\"strong:H08625\">TEKEL</w>, <w morph=\"strongMorph:TH8751\" lemma=\"strong:H06537\">UPHARSIN</w></inscription>");
        }
        if (osisID.equals("Dan.5.26")) {
            input = this.replace(input, "<w morph=\"strongMorph:TH8752\" lemma=\"strong:H04484\">MENE</w>", "<inscription><w morph=\"strongMorph:TH8752\" lemma=\"strong:H04484\">MENE</w></inscription>");
        }
        if (osisID.equals("Dan.5.27")) {
            input = this.replace(input, "<w morph=\"strongMorph:TH8752\" lemma=\"strong:H08625\">TEKEL</w>", "<inscription><w morph=\"strongMorph:TH8752\" lemma=\"strong:H08625\">TEKEL</w></inscription>");
        }
        if (osisID.equals("Dan.5.28")) {
            input = this.replace(input, "<w morph=\"strongMorph:TH8752\" lemma=\"strong:H06537\">PERES</w>", "<inscription><w morph=\"strongMorph:TH8752\" lemma=\"strong:H06537\">PERES</w></inscription>");
        }
        if (osisID.equals("Zech.14.20")) {
            input = this.replace(input, "<w lemma=\"strong:H06944\">HOLINESS</w> <w lemma=\"strong:H03068\">UNTO THE <seg><divineName>Lord</divineName></seg></w>", "<inscription><w lemma=\"strong:H06944\">HOLINESS</w> <w lemma=\"strong:H03068\">UNTO THE <seg><divineName>Lord</divineName></seg></w></inscription>");
        }
        if (osisID.equals("Matt.27.37")) {
            input = this.replace(input, "<w src=\"11\" lemma=\"strong:G3778\" morph=\"robinson:D-NSM\">THIS</w> <w src=\"12\" lemma=\"strong:G2076\" morph=\"robinson:V-PXI-3S\">IS</w> <w src=\"13\" lemma=\"strong:G2424\" morph=\"robinson:N-NSM\">JESUS</w> <w src=\"14 15\" lemma=\"strong:G3588 strong:G935\" morph=\"robinson:T-NSM robinson:N-NSM\">THE KING</w> <w src=\"16\" lemma=\"strong:G3588\" morph=\"robinson:T-GPM\"></w><w src=\"17\" lemma=\"strong:G2453\" morph=\"robinson:A-GPM\">OF THE JEWS</w>", "<inscription><w src=\"11\" lemma=\"strong:G3778\" morph=\"robinson:D-NSM\">THIS</w> <w src=\"12\" lemma=\"strong:G2076\" morph=\"robinson:V-PXI-3S\">IS</w> <w src=\"13\" lemma=\"strong:G2424\" morph=\"robinson:N-NSM\">JESUS</w> <w src=\"14 15\" lemma=\"strong:G3588 strong:G935\" morph=\"robinson:T-NSM robinson:N-NSM\">THE KING</w> <w src=\"16\" lemma=\"strong:G3588\" morph=\"robinson:T-GPM\"></w><w src=\"17\" lemma=\"strong:G2453\" morph=\"robinson:A-GPM\">OF THE JEWS</w></inscription>");
        }
        if (osisID.equals("Luke.23.38")) {
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G3778\" morph=\"robinson:D-NSM\">THIS</w> <w src=\"15\" lemma=\"strong:G2076\" morph=\"robinson:V-PXI-3S\">IS</w> <w src=\"16 17\" lemma=\"strong:G3588 strong:G935\" morph=\"robinson:T-NSM robinson:N-NSM\">THE KING</w> <w src=\"19\" lemma=\"strong:G2453\" morph=\"robinson:A-GPM\">OF THE JEWS</w>", "<inscription><w src=\"14\" lemma=\"strong:G3778\" morph=\"robinson:D-NSM\">THIS</w> <w src=\"15\" lemma=\"strong:G2076\" morph=\"robinson:V-PXI-3S\">IS</w> <w src=\"16 17\" lemma=\"strong:G3588 strong:G935\" morph=\"robinson:T-NSM robinson:N-NSM\">THE KING</w> <w src=\"19\" lemma=\"strong:G2453\" morph=\"robinson:A-GPM\">OF THE JEWS</w></inscription>");
        }
        if (osisID.equals("John.19.19")) {
            input = this.replace(input, "<w src=\"15\" lemma=\"strong:G2424\" morph=\"robinson:N-NSM\">JESUS</w> <w src=\"16 17\" lemma=\"strong:G3588 strong:G3480\" morph=\"robinson:T-NSM robinson:N-NSM\">OF NAZARETH</w> <w src=\"18 19\" lemma=\"strong:G3588 strong:G935\" morph=\"robinson:T-NSM robinson:N-NSM\">THE KING</w> <w src=\"21\" lemma=\"strong:G2453\" morph=\"robinson:A-GPM\">OF THE JEWS</w>", "<inscription><w src=\"15\" lemma=\"strong:G2424\" morph=\"robinson:N-NSM\">JESUS</w> <w src=\"16 17\" lemma=\"strong:G3588 strong:G3480\" morph=\"robinson:T-NSM robinson:N-NSM\">OF NAZARETH</w> <w src=\"18 19\" lemma=\"strong:G3588 strong:G935\" morph=\"robinson:T-NSM robinson:N-NSM\">THE KING</w> <w src=\"21\" lemma=\"strong:G2453\" morph=\"robinson:A-GPM\">OF THE JEWS</w></inscription>");
        }
        if (osisID.equals("Acts.17.23")) {
            input = this.replace(input, "<w src=\"14\" lemma=\"strong:G57\" morph=\"robinson:A-DSM\">TO THE UNKNOWN</w> <w src=\"15\" lemma=\"strong:G2316\" morph=\"robinson:N-DSM\"><divineName>God</divineName></w>", "<inscription><w src=\"14\" lemma=\"strong:G57\" morph=\"robinson:A-DSM\">TO THE UNKNOWN</w> <w src=\"15\" lemma=\"strong:G2316\" morph=\"robinson:N-DSM\">GOD</w></inscription>");
        }
        if (osisID.equals("Rev.19.16")) {
            input = this.replace(input, "<w src=\"13\" lemma=\"strong:G1125\" morph=\"robinson:V-RPP-ASN\">KING</w> <w src=\"14\" lemma=\"strong:G935\" morph=\"robinson:N-NSM\">OF KINGS</w>, <w src=\"15\" lemma=\"strong:G935\" morph=\"robinson:N-GPM\">AND</w> <w src=\"16\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\"><divineName>Lord</divineName></w> <w src=\"17\" lemma=\"strong:G2962\" morph=\"robinson:N-NSM\">OF <divineName>Lord</divineName>S</w>", "<inscription><w src=\"13\" lemma=\"strong:G1125\" morph=\"robinson:V-RPP-ASN\">KING</w> <w src=\"14\" lemma=\"strong:G935\" morph=\"robinson:N-NSM\">OF KINGS</w>, <w src=\"15\" lemma=\"strong:G935\" morph=\"robinson:N-GPM\">AND</w> <w src=\"16\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\">LORD</w> <w src=\"17\" lemma=\"strong:G2962\" morph=\"robinson:N-NSM\">OF LORDS</w></inscription>");
        }
        if (osisID.equals("Mark.15.26")) {
            input = this.replace(input, "<w src=\"9 10\" lemma=\"strong:G3588 strong:G935\" morph=\"robinson:T-NSM robinson:N-NSM\">THE KING</w> <w src=\"12\" lemma=\"strong:G2453\" morph=\"robinson:A-GPM\">OF THE JEWS</w>", "<inscription><w src=\"9 10\" lemma=\"strong:G3588 strong:G935\" morph=\"robinson:T-NSM robinson:N-NSM\">THE KING</w> <w src=\"12\" lemma=\"strong:G2453\" morph=\"robinson:A-GPM\">OF THE JEWS</w></inscription>");
        }
        if (osisID.equals("Rev.17.5")) {
            input = this.replace(input, "<w src=\"8\" lemma=\"strong:G3466\" morph=\"robinson:N-NSN\">MYSTERY</w>, <w src=\"9\" lemma=\"strong:G897\" morph=\"robinson:N-NSF\">BABYLON</w> <w src=\"11\" lemma=\"strong:G3173\" morph=\"robinson:A-NSF\">THE GREAT</w>, <w src=\"12 13\" lemma=\"strong:G3588 strong:G3384\" morph=\"robinson:T-NSF robinson:N-NSF\">THE MOTHER</w> <w src=\"14 15\" lemma=\"strong:G3588 strong:G4204\" morph=\"robinson:T-GPF robinson:N-GPF\">OF HARLOTS</w> <w src=\"16\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\">AND</w> <w src=\"17 18\" lemma=\"strong:G3588 strong:G946\" morph=\"robinson:T-GPN robinson:N-GPN\">ABOMINATIONS</w> <w src=\"19 20\" lemma=\"strong:G3588 strong:G1093\" morph=\"robinson:T-GSF robinson:N-GSF\">OF THE EARTH</w>", "<inscription><w src=\"8\" lemma=\"strong:G3466\" morph=\"robinson:N-NSN\">MYSTERY</w>, <w src=\"9\" lemma=\"strong:G897\" morph=\"robinson:N-NSF\">BABYLON</w> <w src=\"11\" lemma=\"strong:G3173\" morph=\"robinson:A-NSF\">THE GREAT</w>, <w src=\"12 13\" lemma=\"strong:G3588 strong:G3384\" morph=\"robinson:T-NSF robinson:N-NSF\">THE MOTHER</w> <w src=\"14 15\" lemma=\"strong:G3588 strong:G4204\" morph=\"robinson:T-GPF robinson:N-GPF\">OF HARLOTS</w> <w src=\"16\" lemma=\"strong:G2532\" morph=\"robinson:CONJ\">AND</w> <w src=\"17 18\" lemma=\"strong:G3588 strong:G946\" morph=\"robinson:T-GPN robinson:N-GPN\">ABOMINATIONS</w> <w src=\"19 20\" lemma=\"strong:G3588 strong:G1093\" morph=\"robinson:T-GSF robinson:N-GSF\">OF THE EARTH</w></inscription>");
        }
        return input;
    }

    private String fixParagraphs(String osisID, String input, boolean inVerse) {
        if (input.indexOf("<p/>") != -1) {
            input = this.replace(input, "<p/></transChange>", "</transChange><p/>");
            input = this.replace(input, "<p/></q>", "</q><p/>");
            input = input.replaceAll("<p/>\\s+", "<p/>");
            Matcher matcher = pPattern.matcher(input);
            while (matcher.find()) {
                input = matcher.replaceFirst("$2<p/>");
                matcher.reset(input);
            }
            input = input.replaceAll("(<p/>\\s*)+", "<p/>");
            input = input.replaceAll("<p/>(?=<note)", "<milestone type=\"x-p\" marker=\"\u00b6\"/>");
            input = input.replaceAll("<p/>(?=<milestone type=\"x-strongsMarkup\")", "<milestone type=\"x-p\" marker=\"\u00b6\"/>");
            input = input.replaceAll("<p/>(?=$)", "<milestone type=\"x-p\" subType=\"x-end\" marker=\"\u00b6\"/>");
            input = input.replaceAll("<p/>", "<milestone type=\"x-extra-p\"/>");
        }
        input = input.replaceAll("<milestone type=\"x-p\"\\s*/>", "<milestone type=\"x-p\" marker=\"\u00b6\"/>");
        boolean seenP = false;
        if (input.indexOf("<milestone type=\"x-p\" marker=\"\u00b6\"/>") != -1) {
            input = input.replaceAll("<milestone type=\"x-p\" marker=\"\u00b6\"/>", "");
            this.moveP = true;
        } else if (this.moveP && inVerse) {
            Verse v = null;
            try {
                v = VerseFactory.fromString(osisID);
            }
            catch (NoSuchVerseException e) {
                // empty catch block
            }
            if (v.getVerse() != 1) {
                input = paragraphs.contains(osisID) ? "<milestone type=\"x-p\" marker=\"\u00b6\"/>" + input : "<milestone type=\"x-extra-p\"/>" + input;
            }
            seenP = true;
            this.moveP = false;
        }
        if (inVerse && paragraphs.contains(osisID) && !seenP) {
            input = "<milestone type=\"x-p\" subType=\"x-added\" marker=\"\u00b6\"/>" + input;
        }
        return input;
    }

    private String fixNotes(String osisID, String input) {
        if (osisID.equals("Deut.3.17")) {
            input = this.replace(input, "Ashdoth\u2013pisgah;", "Ashdoth\u2013pisgah:");
        }
        if (osisID.equals("Josh.15.3")) {
            input = this.replace(input, "Maalehacrebbim", "Maaleh\u2013acrabbim");
        }
        if (osisID.equals("Judg.2.9")) {
            input = this.replace(input, "Timnathhares", "Timnath\u2013heres");
        }
        if (osisID.equals("2Sam.19.6")) {
            input = this.replace(input, "in\u2026:", "In\u2026:");
        }
        if (osisID.equals("1Kgs.5.18")) {
            input = this.replace(input, "stonesquares", "stonesquarers");
        }
        if (osisID.equals("1Kgs.6.38")) {
            input = this.replace(input, "through out", "throughout");
        }
        if (osisID.equals("Neh.7.70")) {
            input = this.replace(input, "the Tirshatha", "The Tirshatha");
        }
        if (osisID.equals("Ps.40.12")) {
            input = this.replace(input, "falleth", "faileth");
        }
        if (osisID.equals("Ps.65.3")) {
            input = this.replace(input, "iniquities:", "Iniquities:");
        }
        if (osisID.equals("Ps.73.22")) {
            input = this.replace(input, "before Heb. with", "before: Heb. with");
        }
        if (osisID.equals("Ps.78.31")) {
            input = this.replace(input, "Chosen\u2026:", "chosen\u2026:");
        }
        if (osisID.equals("Ps.89.33")) {
            input = this.replace(input, "to fall", "to fail");
        }
        if (osisID.equals("Ps.103.8")) {
            input = this.replace(input, "plentious", "plenteous");
        }
        if (osisID.equals("Ps.106.27")) {
            input = this.replace(input, "to overthrow:", "To overthrow:");
        }
        if (osisID.equals("Ps.106.27")) {
            input = this.replace(input, "to make them", "To make them");
        }
        if (osisID.equals("Prov.18.8")) {
            input = this.replace(input, "most\u2026:", "innermost\u2026:");
        }
        if (osisID.equals("Prov.24.18")) {
            input = this.replace(input, "displeaseth\u2026:", "displease\u2026:");
        }
        if (osisID.equals("Prov.31.5")) {
            input = this.replace(input, "prevert:", "pervert:");
        }
        if (osisID.equals("Eccl.5.8")) {
            input = this.replace(input, "at the\u2026 Heb.", "at the\u2026: Heb.");
        }
        if (osisID.equals("Eccl.5.18")) {
            input = this.replace(input, "It is good\u2026", "it is good\u2026");
        }
        if (osisID.equals("Isa.8.9")) {
            input = this.replace(input, "people and:", "people, and:");
        }
        if (osisID.equals("Isa.11.8")) {
            input = this.replace(input, "cockatrice' or", "cockatrice': or");
        }
        if (osisID.equals("Isa.34.14")) {
            input = this.replace(input, "The wild\u2026desert", "The wild beasts of the desert");
        }
        if (osisID.equals("Isa.34.14")) {
            input = this.replace(input, "the wild\u2026island", "the wild beasts of the island");
        }
        if (osisID.equals("Isa.59.5")) {
            input = this.replace(input, "cockatrice' or", "cockatrice': or");
        }
        if (osisID.equals("Jer.50.16")) {
            input = this.replace(input, "sickle; or, scythe", "sickle: or, scythe");
        }
        if (osisID.equals("Ezek.43.15")) {
            input = this.replace(input, "the altar (first)", "the altar shall");
        }
        if (osisID.equals("Ezek.43.15")) {
            input = this.replace(input, "the altar (second)", "the altar and");
        }
        if (osisID.equals("Ezek.48.23")) {
            input = this.replace(input, "A portion:", "a portion:");
        }
        if (osisID.equals("Mic.5.4")) {
            input = this.replace(input, "feed or, rule", "feed: or, rule");
        }
        if (osisID.equals("Zeph.1.2")) {
            input = this.replace(input, "I will\u2026; Heb.", "I will\u2026: Heb.");
        }
        return input;
    }

    private String replace(String input, String pattern, String replacement) {
        int patternLength = pattern.length();
        if (patternLength == 0) {
            throw new IllegalArgumentException("Pattern cannot be empty.");
        }
        StringBuffer result = new StringBuffer();
        int start = 0;
        int match = input.indexOf(pattern, start);
        while (match >= 0) {
            result.append(input.substring(start, match));
            result.append(replacement);
            start = match + patternLength;
            match = input.indexOf(pattern, start);
        }
        result.append(input.substring(start));
        return result.toString();
    }

    static {
        bookTitles.put("Gen", "THE FIRST BOOK OF MOSES CALLED GENESIS");
        bookTitles.put("Exod", "THE SECOND BOOK OF MOSES CALLED EXODUS");
        bookTitles.put("Lev", "THE THIRD BOOK OF MOSES CALLED LEVITICUS");
        bookTitles.put("Num", "THE FOURTH BOOK OF MOSES CALLED NUMBERS");
        bookTitles.put("Deut", "THE FIFTH BOOK OF MOSES CALLED DEUTERONOMY");
        bookTitles.put("Josh", "THE BOOK OF JOSHUA");
        bookTitles.put("Judg", "THE BOOK OF JUDGES");
        bookTitles.put("Ruth", "THE BOOK OF RUTH");
        bookTitles.put("1Sam", "THE FIRST BOOK OF SAMUEL OTHERWISE CALLED THE FIRST BOOK OF THE KINGS");
        bookTitles.put("2Sam", "THE SECOND BOOK OF SAMUEL OTHERWISE CALLED THE SECOND BOOK OF THE KINGS");
        bookTitles.put("1Kgs", "THE FIRST BOOK OF THE KINGS COMMONLY CALLED THE THIRD BOOK OF THE KINGS");
        bookTitles.put("2Kgs", "THE SECOND BOOK OF THE KINGS COMMONLY CALLED THE FOURTH BOOK OF THE KINGS");
        bookTitles.put("1Chr", "THE FIRST BOOK OF THE CHRONICLES");
        bookTitles.put("2Chr", "THE SECOND BOOK OF THE CHRONICLES");
        bookTitles.put("Ezra", "EZRA");
        bookTitles.put("Neh", "THE BOOK OF NEHEMIAH");
        bookTitles.put("Esth", "THE BOOK OF ESTHER");
        bookTitles.put("Job", "THE BOOK OF JOB");
        bookTitles.put("Ps", "THE BOOK OF PSALMS");
        bookTitles.put("Prov", "THE PROVERBS");
        bookTitles.put("Eccl", "ECCLESIASTES OR, THE PREACHER");
        bookTitles.put("Song", "THE SONG OF SOLOMON");
        bookTitles.put("Isa", "THE BOOK OF THE PROPHET ISAIAH");
        bookTitles.put("Jer", "THE BOOK OF THE PROPHET JEREMIAH");
        bookTitles.put("Lam", "THE LAMENTATIONS OF JEREMIAH");
        bookTitles.put("Ezek", "THE BOOK OF THE PROPHET EZEKIEL");
        bookTitles.put("Dan", "THE BOOK OF DANIEL");
        bookTitles.put("Hos", "HOSEA");
        bookTitles.put("Joel", "JOEL");
        bookTitles.put("Amos", "AMOS");
        bookTitles.put("Obad", "OBADIAH");
        bookTitles.put("Jonah", "JONAH");
        bookTitles.put("Mic", "MICAH");
        bookTitles.put("Nah", "NAHUM");
        bookTitles.put("Hab", "HABAKKUK");
        bookTitles.put("Zeph", "ZEPHANIAH");
        bookTitles.put("Hag", "HAGGAI");
        bookTitles.put("Zech", "ZECHARIAH");
        bookTitles.put("Mal", "MALACHI");
        bookTitles.put("Matt", "THE GOSPEL ACCORDING TO <abbr expansion=\"Saint\">ST.</abbr> MATTHEW");
        bookTitles.put("Mark", "THE GOSPEL ACCORDING TO <abbr expansion=\"Saint\">ST.</abbr> MARK");
        bookTitles.put("Luke", "THE GOSPEL ACCORDING TO <abbr expansion=\"Saint\">ST.</abbr> LUKE");
        bookTitles.put("John", "THE GOSPEL ACCORDING TO <abbr expansion=\"Saint\">ST.</abbr> JOHN");
        bookTitles.put("Acts", "THE ACTS OF THE APOSTLES");
        bookTitles.put("Rom", "THE EPISTLE OF PAUL THE APOSTLE TO THE ROMANS");
        bookTitles.put("1Cor", "THE FIRST EPISTLE OF PAUL THE APOSTLE TO THE CORINTHIANS");
        bookTitles.put("2Cor", "THE SECOND EPISTLE OF PAUL THE APOSTLE TO THE CORINTHIANS");
        bookTitles.put("Gal", "THE EPISTLE OF PAUL THE APOSTLE TO THE GALATIANS");
        bookTitles.put("Eph", "THE EPISTLE OF PAUL THE APOSTLE TO THE EPHESIANS");
        bookTitles.put("Phil", "THE EPISTLE OF PAUL THE APOSTLE TO THE PHILIPPIANS");
        bookTitles.put("Col", "THE EPISTLE OF PAUL THE APOSTLE TO THE COLOSSIANS");
        bookTitles.put("1Thess", "THE FIRST EPISTLE OF PAUL THE APOSTLE TO THE THESSALONIANS");
        bookTitles.put("2Thess", "THE SECOND EPISTLE OF PAUL THE APOSTLE TO THE THESSALONIANS");
        bookTitles.put("1Tim", "THE FIRST EPISTLE OF PAUL THE APOSTLE TO TIMOTHY");
        bookTitles.put("2Tim", "THE SECOND EPISTLE OF PAUL THE APOSTLE TO TIMOTHY");
        bookTitles.put("Titus", "THE EPISTLE OF PAUL THE APOSTLE TO TITUS");
        bookTitles.put("Phlm", "THE EPISTLE OF PAUL THE APOSTLE TO PHILEMON");
        bookTitles.put("Heb", "THE EPISTLE OF PAUL THE APOSTLE TO THE HEBREWS");
        bookTitles.put("Jas", "THE GENERAL EPISTLE OF JAMES");
        bookTitles.put("1Pet", "THE FIRST EPISTLE GENERAL OF PETER");
        bookTitles.put("2Pet", "THE SECOND EPISTLE GENERAL OF PETER");
        bookTitles.put("1John", "THE FIRST EPISTLE GENERAL OF JOHN");
        bookTitles.put("2John", "THE SECOND EPISTLE OF JOHN");
        bookTitles.put("3John", "THE THIRD EPISTLE OF JOHN");
        bookTitles.put("Jude", "THE GENERAL EPISTLE OF JUDE");
        bookTitles.put("Rev", "THE REVELATION OF <abbr expansion=\"Saint\">ST.</abbr> JOHN THE DIVINE");
        colophons = new HashMap();
        colophons.put("Rom", "<div type=\"colophon\" osisID=\"Rom.c\">Written to the Romans from Corinthus, <transChange type=\"added\">and sent</transChange> by Phebe servant of the church at Cenchrea.</div>\n");
        colophons.put("1Cor", "<div type=\"colophon\" osisID=\"1Cor.c\">The first <transChange type=\"added\">epistle</transChange> to the Corinthians was written from Philippi by Stephanas, and Fortunatus, and Achaicus, and Timotheus.</div>\n");
        colophons.put("2Cor", "<div type=\"colophon\" osisID=\"2Cor.c\">The second <transChange type=\"added\">epistle</transChange> to the Corinthians was written from Philippi, <transChange type=\"added\">a city</transChange> of Macedonia, by Titus and Lucas.</div>\n");
        colophons.put("Gal", "<div type=\"colophon\" osisID=\"Gal.c\">Unto the Galatians written from Rome.</div>\n");
        colophons.put("Eph", "<div type=\"colophon\" osisID=\"Eph.c\">Written from Rome unto the Ephesians by Tychicus.</div>\n");
        colophons.put("Phil", "<div type=\"colophon\" osisID=\"Phil.c\">It was written to the Philippians from Rome by Epaphroditus.</div>\n");
        colophons.put("Col", "<div type=\"colophon\" osisID=\"Col.c\">Written from Rome to the Colossians by Tychicus and Onesimus.</div>\n");
        colophons.put("1Thess", "<div type=\"colophon\" osisID=\"1Thess.c\">The first <transChange type=\"added\">epistle</transChange> unto the Thessalonians was written from Athens.</div>\n");
        colophons.put("2Thess", "<div type=\"colophon\" osisID=\"2Thess.c\">The second <transChange type=\"added\">epistle</transChange> to the Thessalonians was written from Athens.</div>\n");
        colophons.put("1Tim", "<div type=\"colophon\" osisID=\"1Tim.c\">The first to Timothy was written from Laodicea, which is the chiefest city of Phrygia Pacatiana.</div>\n");
        colophons.put("2Tim", "<div type=\"colophon\" osisID=\"2Tim.c\">The second <transChange type=\"added\">epistle</transChange> unto Timotheus, ordained the first bishop of the church of the Ephesians, was written from Rome, when Paul was brought before Nero the second time.</div>\n");
        colophons.put("Titus", "<div type=\"colophon\" osisID=\"Titus.c\">It was written to Titus, ordained the first bishop of the church of the Cretians, from Nicopolis of Macedonia.</div>\n");
        colophons.put("Phlm", "<div type=\"colophon\" osisID=\"Phlm.c\">Written from Rome to Philemon, by Onesimus, a servant.</div>\n");
        colophons.put("Heb", "<div type=\"colophon\" osisID=\"Heb.c\">Written to the Hebrews from Italy by Timothy.</div>\n");
        acrostics = new HashMap();
        hebLetters = new HashMap();
        acrostics.put("Ps.119.1", "<foreign n=\"\u05d0\">ALEPH.</foreign>");
        acrostics.put("Ps.119.9", "<foreign n=\"\u05d1\">BETH.</foreign>");
        acrostics.put("Ps.119.17", "<foreign n=\"\u05d2\">GIMEL.</foreign>");
        acrostics.put("Ps.119.25", "<foreign n=\"\u05d3\">DALETH.</foreign>");
        acrostics.put("Ps.119.33", "<foreign n=\"\u05d4\">HE.</foreign>");
        acrostics.put("Ps.119.41", "<foreign n=\"\u05d5\">VAU.</foreign>");
        acrostics.put("Ps.119.49", "<foreign n=\"\u05d6\">ZAIN.</foreign>");
        acrostics.put("Ps.119.57", "<foreign n=\"\u05d7\">CHETH.</foreign>");
        acrostics.put("Ps.119.65", "<foreign n=\"\u05d8\">TETH.</foreign>");
        acrostics.put("Ps.119.73", "<foreign n=\"\u05d9\">JOD.</foreign>");
        acrostics.put("Ps.119.81", "<foreign n=\"\u05db\">CAPH.</foreign>");
        acrostics.put("Ps.119.89", "<foreign n=\"\u05dc\">LAMED.</foreign>");
        acrostics.put("Ps.119.97", "<foreign n=\"\u05de\">MEM.</foreign>");
        acrostics.put("Ps.119.105", "<foreign n=\"\u05e0\">NUN.</foreign>");
        acrostics.put("Ps.119.113", "<foreign n=\"\u05e1\">SAMECH.</foreign>");
        acrostics.put("Ps.119.121", "<foreign n=\"\u05e2\">AIN.</foreign>");
        acrostics.put("Ps.119.129", "<foreign n=\"\u05e4\">PE.</foreign>");
        acrostics.put("Ps.119.137", "<foreign n=\"\u05e6\">TZADDI.</foreign>");
        acrostics.put("Ps.119.145", "<foreign n=\"\u05e7\">KOPH.</foreign>");
        acrostics.put("Ps.119.153", "<foreign n=\"\u05e8\">RESH.</foreign>");
        acrostics.put("Ps.119.161", "<foreign n=\"\u05e9\">SCHIN.</foreign>");
        acrostics.put("Ps.119.169", "<foreign n=\"\u05ea\">TAU.</foreign>");
        hebLetters.put("Ps.119.1", "ALEPH. ");
        hebLetters.put("Ps.119.9", "BETH. ");
        hebLetters.put("Ps.119.17", "GIMEL. ");
        hebLetters.put("Ps.119.25", "DALETH. ");
        hebLetters.put("Ps.119.33", "HE. ");
        hebLetters.put("Ps.119.41", "VAU. ");
        hebLetters.put("Ps.119.49", "ZAIN. ");
        hebLetters.put("Ps.119.57", "CHETH. ");
        hebLetters.put("Ps.119.65", "TETH. ");
        hebLetters.put("Ps.119.73", "JOD. ");
        hebLetters.put("Ps.119.81", "CAPH. ");
        hebLetters.put("Ps.119.89", "LAMED. ");
        hebLetters.put("Ps.119.97", "MEM. ");
        hebLetters.put("Ps.119.105", "NUN. ");
        hebLetters.put("Ps.119.113", "SAMECH. ");
        hebLetters.put("Ps.119.121", "AIN. ");
        hebLetters.put("Ps.119.129", "PE. ");
        hebLetters.put("Ps.119.137", "TZADDI. ");
        hebLetters.put("Ps.119.145", "KOPH. ");
        hebLetters.put("Ps.119.153", "RESH. ");
        hebLetters.put("Ps.119.161", "SCHIN. ");
        hebLetters.put("Ps.119.169", "TAU. ");
        paragraphs = new HashSet();
        paragraphs.add("Gen.1.6");
        paragraphs.add("Gen.1.9");
        paragraphs.add("Gen.1.14");
        paragraphs.add("Gen.1.24");
        paragraphs.add("Gen.1.26");
        paragraphs.add("Gen.1.29");
        paragraphs.add("Gen.2.4");
        paragraphs.add("Gen.2.8");
        paragraphs.add("Gen.2.18");
        paragraphs.add("Gen.3.22");
        paragraphs.add("Gen.4.9");
        paragraphs.add("Gen.4.16");
        paragraphs.add("Gen.4.19");
        paragraphs.add("Gen.4.25");
        paragraphs.add("Gen.5.3");
        paragraphs.add("Gen.5.9");
        paragraphs.add("Gen.5.12");
        paragraphs.add("Gen.5.15");
        paragraphs.add("Gen.5.18");
        paragraphs.add("Gen.5.21");
        paragraphs.add("Gen.5.28");
        paragraphs.add("Gen.6.5");
        paragraphs.add("Gen.6.9");
        paragraphs.add("Gen.6.14");
        paragraphs.add("Gen.7.7");
        paragraphs.add("Gen.7.11");
        paragraphs.add("Gen.8.6");
        paragraphs.add("Gen.8.13");
        paragraphs.add("Gen.8.15");
        paragraphs.add("Gen.8.20");
        paragraphs.add("Gen.9.8");
        paragraphs.add("Gen.9.18");
        paragraphs.add("Gen.9.28");
        paragraphs.add("Gen.10.6");
        paragraphs.add("Gen.10.15");
        paragraphs.add("Gen.10.21");
        paragraphs.add("Gen.11.10");
        paragraphs.add("Gen.11.27");
        paragraphs.add("Gen.12.6");
        paragraphs.add("Gen.12.10");
        paragraphs.add("Gen.12.14");
        paragraphs.add("Gen.13.5");
        paragraphs.add("Gen.13.14");
        paragraphs.add("Gen.14.13");
        paragraphs.add("Gen.14.17");
        paragraphs.add("Gen.16.4");
        paragraphs.add("Gen.16.7");
        paragraphs.add("Gen.16.15");
        paragraphs.add("Gen.17.9");
        paragraphs.add("Gen.17.15");
        paragraphs.add("Gen.17.23");
        paragraphs.add("Gen.18.9");
        paragraphs.add("Gen.18.16");
        paragraphs.add("Gen.18.23");
        paragraphs.add("Gen.19.4");
        paragraphs.add("Gen.19.12");
        paragraphs.add("Gen.19.15");
        paragraphs.add("Gen.19.17");
        paragraphs.add("Gen.19.23");
        paragraphs.add("Gen.19.26");
        paragraphs.add("Gen.19.27");
        paragraphs.add("Gen.19.29");
        paragraphs.add("Gen.19.30");
        paragraphs.add("Gen.20.17");
        paragraphs.add("Gen.21.6");
        paragraphs.add("Gen.21.9");
        paragraphs.add("Gen.21.12");
        paragraphs.add("Gen.21.22");
        paragraphs.add("Gen.21.33");
        paragraphs.add("Gen.22.3");
        paragraphs.add("Gen.22.15");
        paragraphs.add("Gen.22.20");
        paragraphs.add("Gen.23.3");
        paragraphs.add("Gen.23.17");
        paragraphs.add("Gen.24.7");
        paragraphs.add("Gen.24.10");
        paragraphs.add("Gen.24.15");
        paragraphs.add("Gen.24.29");
        paragraphs.add("Gen.24.32");
        paragraphs.add("Gen.24.61");
        paragraphs.add("Gen.25.5");
        paragraphs.add("Gen.25.11");
        paragraphs.add("Gen.25.12");
        paragraphs.add("Gen.25.19");
        paragraphs.add("Gen.25.24");
        paragraphs.add("Gen.25.29");
        paragraphs.add("Gen.26.6");
        paragraphs.add("Gen.26.17");
        paragraphs.add("Gen.26.26");
        paragraphs.add("Gen.26.34");
        paragraphs.add("Gen.27.6");
        paragraphs.add("Gen.27.18");
        paragraphs.add("Gen.27.30");
        paragraphs.add("Gen.27.41");
        paragraphs.add("Gen.28.6");
        paragraphs.add("Gen.28.10");
        paragraphs.add("Gen.28.16");
        paragraphs.add("Gen.29.9");
        paragraphs.add("Gen.29.15");
        paragraphs.add("Gen.29.21");
        paragraphs.add("Gen.29.31");
        paragraphs.add("Gen.30.14");
        paragraphs.add("Gen.30.22");
        paragraphs.add("Gen.30.25");
        paragraphs.add("Gen.30.37");
        paragraphs.add("Gen.31.17");
        paragraphs.add("Gen.31.25");
        paragraphs.add("Gen.31.36");
        paragraphs.add("Gen.31.43");
        paragraphs.add("Gen.32.6");
        paragraphs.add("Gen.32.9");
        paragraphs.add("Gen.32.13");
        paragraphs.add("Gen.32.24");
        paragraphs.add("Gen.33.16");
        paragraphs.add("Gen.33.18");
        paragraphs.add("Gen.34.6");
        paragraphs.add("Gen.34.20");
        paragraphs.add("Gen.34.25");
        paragraphs.add("Gen.35.6");
        paragraphs.add("Gen.35.9");
        paragraphs.add("Gen.35.16");
        paragraphs.add("Gen.35.21");
        paragraphs.add("Gen.35.27");
        paragraphs.add("Gen.36.9");
        paragraphs.add("Gen.36.14");
        paragraphs.add("Gen.36.15");
        paragraphs.add("Gen.36.17");
        paragraphs.add("Gen.36.18");
        paragraphs.add("Gen.36.20");
        paragraphs.add("Gen.36.31");
        paragraphs.add("Gen.37.5");
        paragraphs.add("Gen.37.9");
        paragraphs.add("Gen.37.12");
        paragraphs.add("Gen.37.15");
        paragraphs.add("Gen.37.23");
        paragraphs.add("Gen.37.29");
        paragraphs.add("Gen.38.12");
        paragraphs.add("Gen.38.24");
        paragraphs.add("Gen.38.27");
        paragraphs.add("Gen.39.7");
        paragraphs.add("Gen.39.21");
        paragraphs.add("Gen.40.5");
        paragraphs.add("Gen.40.20");
        paragraphs.add("Gen.41.9");
        paragraphs.add("Gen.41.14");
        paragraphs.add("Gen.41.25");
        paragraphs.add("Gen.41.37");
        paragraphs.add("Gen.41.46");
        paragraphs.add("Gen.41.53");
        paragraphs.add("Gen.42.3");
        paragraphs.add("Gen.42.21");
        paragraphs.add("Gen.42.25");
        paragraphs.add("Gen.42.29");
        paragraphs.add("Gen.42.35");
        paragraphs.add("Gen.43.15");
        paragraphs.add("Gen.43.26");
        paragraphs.add("Gen.44.6");
        paragraphs.add("Gen.44.14");
        paragraphs.add("Gen.44.18");
        paragraphs.add("Gen.45.16");
        paragraphs.add("Gen.45.25");
        paragraphs.add("Gen.46.8");
        paragraphs.add("Gen.46.10");
        paragraphs.add("Gen.46.11");
        paragraphs.add("Gen.46.12");
        paragraphs.add("Gen.46.13");
        paragraphs.add("Gen.46.14");
        paragraphs.add("Gen.46.16");
        paragraphs.add("Gen.46.17");
        paragraphs.add("Gen.46.20");
        paragraphs.add("Gen.46.21");
        paragraphs.add("Gen.46.23");
        paragraphs.add("Gen.46.24");
        paragraphs.add("Gen.46.28");
        paragraphs.add("Gen.47.11");
        paragraphs.add("Gen.47.13");
        paragraphs.add("Gen.47.27");
        paragraphs.add("Gen.48.5");
        paragraphs.add("Gen.48.15");
        paragraphs.add("Gen.49.3");
        paragraphs.add("Gen.49.5");
        paragraphs.add("Gen.49.8");
        paragraphs.add("Gen.49.13");
        paragraphs.add("Gen.49.14");
        paragraphs.add("Gen.49.16");
        paragraphs.add("Gen.49.19");
        paragraphs.add("Gen.49.20");
        paragraphs.add("Gen.49.21");
        paragraphs.add("Gen.49.22");
        paragraphs.add("Gen.49.27");
        paragraphs.add("Gen.49.28");
        paragraphs.add("Gen.50.7");
        paragraphs.add("Gen.50.14");
        paragraphs.add("Gen.50.15");
        paragraphs.add("Gen.50.22");
        paragraphs.add("Exod.1.7");
        paragraphs.add("Exod.1.15");
        paragraphs.add("Exod.2.5");
        paragraphs.add("Exod.2.11");
        paragraphs.add("Exod.2.23");
        paragraphs.add("Exod.3.7");
        paragraphs.add("Exod.3.11");
        paragraphs.add("Exod.3.19");
        paragraphs.add("Exod.4.6");
        paragraphs.add("Exod.4.10");
        paragraphs.add("Exod.4.18");
        paragraphs.add("Exod.4.24");
        paragraphs.add("Exod.4.27");
        paragraphs.add("Exod.4.29");
        paragraphs.add("Exod.5.10");
        paragraphs.add("Exod.5.15");
        paragraphs.add("Exod.5.20");
        paragraphs.add("Exod.6.9");
        paragraphs.add("Exod.6.14");
        paragraphs.add("Exod.6.16");
        paragraphs.add("Exod.6.21");
        paragraphs.add("Exod.6.28");
        paragraphs.add("Exod.7.8");
        paragraphs.add("Exod.7.10");
        paragraphs.add("Exod.7.14");
        paragraphs.add("Exod.7.19");
        paragraphs.add("Exod.8.5");
        paragraphs.add("Exod.8.8");
        paragraphs.add("Exod.8.16");
        paragraphs.add("Exod.8.20");
        paragraphs.add("Exod.8.25");
        paragraphs.add("Exod.9.8");
        paragraphs.add("Exod.9.13");
        paragraphs.add("Exod.9.22");
        paragraphs.add("Exod.9.27");
        paragraphs.add("Exod.10.12");
        paragraphs.add("Exod.10.16");
        paragraphs.add("Exod.10.21");
        paragraphs.add("Exod.10.24");
        paragraphs.add("Exod.10.27");
        paragraphs.add("Exod.12.3");
        paragraphs.add("Exod.12.11");
        paragraphs.add("Exod.12.18");
        paragraphs.add("Exod.12.21");
        paragraphs.add("Exod.12.29");
        paragraphs.add("Exod.12.31");
        paragraphs.add("Exod.12.37");
        paragraphs.add("Exod.12.40");
        paragraphs.add("Exod.12.43");
        paragraphs.add("Exod.13.3");
        paragraphs.add("Exod.13.5");
        paragraphs.add("Exod.13.8");
        paragraphs.add("Exod.13.11");
        paragraphs.add("Exod.13.14");
        paragraphs.add("Exod.13.17");
        paragraphs.add("Exod.13.20");
        paragraphs.add("Exod.14.5");
        paragraphs.add("Exod.14.10");
        paragraphs.add("Exod.14.13");
        paragraphs.add("Exod.14.15");
        paragraphs.add("Exod.14.19");
        paragraphs.add("Exod.14.23");
        paragraphs.add("Exod.14.26");
        paragraphs.add("Exod.15.20");
        paragraphs.add("Exod.15.23");
        paragraphs.add("Exod.15.27");
        paragraphs.add("Exod.16.4");
        paragraphs.add("Exod.16.9");
        paragraphs.add("Exod.16.11");
        paragraphs.add("Exod.16.16");
        paragraphs.add("Exod.16.22");
        paragraphs.add("Exod.16.27");
        paragraphs.add("Exod.16.32");
        paragraphs.add("Exod.17.8");
        paragraphs.add("Exod.18.7");
        paragraphs.add("Exod.18.13");
        paragraphs.add("Exod.18.27");
        paragraphs.add("Exod.19.7");
        paragraphs.add("Exod.19.10");
        paragraphs.add("Exod.19.14");
        paragraphs.add("Exod.19.16");
        paragraphs.add("Exod.20.12");
        paragraphs.add("Exod.20.18");
        paragraphs.add("Exod.20.22");
        paragraphs.add("Exod.20.24");
        paragraphs.add("Exod.21.7");
        paragraphs.add("Exod.21.12");
        paragraphs.add("Exod.21.15");
        paragraphs.add("Exod.21.16");
        paragraphs.add("Exod.21.17");
        paragraphs.add("Exod.21.18");
        paragraphs.add("Exod.21.20");
        paragraphs.add("Exod.21.22");
        paragraphs.add("Exod.21.26");
        paragraphs.add("Exod.21.28");
        paragraphs.add("Exod.21.33");
        paragraphs.add("Exod.21.35");
        paragraphs.add("Exod.22.2");
        paragraphs.add("Exod.22.5");
        paragraphs.add("Exod.22.6");
        paragraphs.add("Exod.22.7");
        paragraphs.add("Exod.22.14");
        paragraphs.add("Exod.22.16");
        paragraphs.add("Exod.22.18");
        paragraphs.add("Exod.22.19");
        paragraphs.add("Exod.22.20");
        paragraphs.add("Exod.22.21");
        paragraphs.add("Exod.22.22");
        paragraphs.add("Exod.22.25");
        paragraphs.add("Exod.22.28");
        paragraphs.add("Exod.22.29");
        paragraphs.add("Exod.22.31");
        paragraphs.add("Exod.23.2");
        paragraphs.add("Exod.23.3");
        paragraphs.add("Exod.23.4");
        paragraphs.add("Exod.23.8");
        paragraphs.add("Exod.23.9");
        paragraphs.add("Exod.23.14");
        paragraphs.add("Exod.23.20");
        paragraphs.add("Exod.23.26");
        paragraphs.add("Exod.24.3");
        paragraphs.add("Exod.24.9");
        paragraphs.add("Exod.24.12");
        paragraphs.add("Exod.25.10");
        paragraphs.add("Exod.25.23");
        paragraphs.add("Exod.25.31");
        paragraphs.add("Exod.26.7");
        paragraphs.add("Exod.26.15");
        paragraphs.add("Exod.26.26");
        paragraphs.add("Exod.26.31");
        paragraphs.add("Exod.26.33");
        paragraphs.add("Exod.27.9");
        paragraphs.add("Exod.27.12");
        paragraphs.add("Exod.27.16");
        paragraphs.add("Exod.27.18");
        paragraphs.add("Exod.27.20");
        paragraphs.add("Exod.28.6");
        paragraphs.add("Exod.28.13");
        paragraphs.add("Exod.28.15");
        paragraphs.add("Exod.28.22");
        paragraphs.add("Exod.28.26");
        paragraphs.add("Exod.28.30");
        paragraphs.add("Exod.28.31");
        paragraphs.add("Exod.28.33");
        paragraphs.add("Exod.28.36");
        paragraphs.add("Exod.28.39");
        paragraphs.add("Exod.28.40");
        paragraphs.add("Exod.29.15");
        paragraphs.add("Exod.29.19");
        paragraphs.add("Exod.29.29");
        paragraphs.add("Exod.29.31");
        paragraphs.add("Exod.29.38");
        paragraphs.add("Exod.29.45");
        paragraphs.add("Exod.30.11");
        paragraphs.add("Exod.30.17");
        paragraphs.add("Exod.30.22");
        paragraphs.add("Exod.30.34");
        paragraphs.add("Exod.31.12");
        paragraphs.add("Exod.31.18");
        paragraphs.add("Exod.32.7");
        paragraphs.add("Exod.32.15");
        paragraphs.add("Exod.32.19");
        paragraphs.add("Exod.32.25");
        paragraphs.add("Exod.32.30");
        paragraphs.add("Exod.33.4");
        paragraphs.add("Exod.33.12");
        paragraphs.add("Exod.34.4");
        paragraphs.add("Exod.34.10");
        paragraphs.add("Exod.34.18");
        paragraphs.add("Exod.34.21");
        paragraphs.add("Exod.34.22");
        paragraphs.add("Exod.34.23");
        paragraphs.add("Exod.34.29");
        paragraphs.add("Exod.35.4");
        paragraphs.add("Exod.35.20");
        paragraphs.add("Exod.35.30");
        paragraphs.add("Exod.36.5");
        paragraphs.add("Exod.36.8");
        paragraphs.add("Exod.36.14");
        paragraphs.add("Exod.36.20");
        paragraphs.add("Exod.36.31");
        paragraphs.add("Exod.36.35");
        paragraphs.add("Exod.36.37");
        paragraphs.add("Exod.37.6");
        paragraphs.add("Exod.37.10");
        paragraphs.add("Exod.37.17");
        paragraphs.add("Exod.37.25");
        paragraphs.add("Exod.37.29");
        paragraphs.add("Exod.38.8");
        paragraphs.add("Exod.38.9");
        paragraphs.add("Exod.38.21");
        paragraphs.add("Exod.39.6");
        paragraphs.add("Exod.39.8");
        paragraphs.add("Exod.39.22");
        paragraphs.add("Exod.39.27");
        paragraphs.add("Exod.39.30");
        paragraphs.add("Exod.39.32");
        paragraphs.add("Exod.39.33");
        paragraphs.add("Exod.40.17");
        paragraphs.add("Exod.40.20");
        paragraphs.add("Exod.40.22");
        paragraphs.add("Exod.40.24");
        paragraphs.add("Exod.40.26");
        paragraphs.add("Exod.40.28");
        paragraphs.add("Exod.40.30");
        paragraphs.add("Exod.40.34");
        paragraphs.add("Lev.1.10");
        paragraphs.add("Lev.1.14");
        paragraphs.add("Lev.2.4");
        paragraphs.add("Lev.2.5");
        paragraphs.add("Lev.2.7");
        paragraphs.add("Lev.2.12");
        paragraphs.add("Lev.3.6");
        paragraphs.add("Lev.3.12");
        paragraphs.add("Lev.4.13");
        paragraphs.add("Lev.4.22");
        paragraphs.add("Lev.4.27");
        paragraphs.add("Lev.5.11");
        paragraphs.add("Lev.5.14");
        paragraphs.add("Lev.5.17");
        paragraphs.add("Lev.6.8");
        paragraphs.add("Lev.6.14");
        paragraphs.add("Lev.6.19");
        paragraphs.add("Lev.6.24");
        paragraphs.add("Lev.7.22");
        paragraphs.add("Lev.7.28");
        paragraphs.add("Lev.7.35");
        paragraphs.add("Lev.8.18");
        paragraphs.add("Lev.8.22");
        paragraphs.add("Lev.8.31");
        paragraphs.add("Lev.9.5");
        paragraphs.add("Lev.9.8");
        paragraphs.add("Lev.9.15");
        paragraphs.add("Lev.10.8");
        paragraphs.add("Lev.10.12");
        paragraphs.add("Lev.10.16");
        paragraphs.add("Lev.11.9");
        paragraphs.add("Lev.11.13");
        paragraphs.add("Lev.11.29");
        paragraphs.add("Lev.13.9");
        paragraphs.add("Lev.13.18");
        paragraphs.add("Lev.13.24");
        paragraphs.add("Lev.13.29");
        paragraphs.add("Lev.13.38");
        paragraphs.add("Lev.13.47");
        paragraphs.add("Lev.14.33");
        paragraphs.add("Lev.15.19");
        paragraphs.add("Lev.16.15");
        paragraphs.add("Lev.16.20");
        paragraphs.add("Lev.16.29");
        paragraphs.add("Lev.17.8");
        paragraphs.add("Lev.17.10");
        paragraphs.add("Lev.18.6");
        paragraphs.add("Lev.19.3");
        paragraphs.add("Lev.19.4");
        paragraphs.add("Lev.19.5");
        paragraphs.add("Lev.19.9");
        paragraphs.add("Lev.19.11");
        paragraphs.add("Lev.19.12");
        paragraphs.add("Lev.19.13");
        paragraphs.add("Lev.19.14");
        paragraphs.add("Lev.19.15");
        paragraphs.add("Lev.19.16");
        paragraphs.add("Lev.19.17");
        paragraphs.add("Lev.19.18");
        paragraphs.add("Lev.19.19");
        paragraphs.add("Lev.19.20");
        paragraphs.add("Lev.19.23");
        paragraphs.add("Lev.19.26");
        paragraphs.add("Lev.19.29");
        paragraphs.add("Lev.19.30");
        paragraphs.add("Lev.19.31");
        paragraphs.add("Lev.19.32");
        paragraphs.add("Lev.19.33");
        paragraphs.add("Lev.19.35");
        paragraphs.add("Lev.20.6");
        paragraphs.add("Lev.20.7");
        paragraphs.add("Lev.20.9");
        paragraphs.add("Lev.20.10");
        paragraphs.add("Lev.20.22");
        paragraphs.add("Lev.20.27");
        paragraphs.add("Lev.21.9");
        paragraphs.add("Lev.21.16");
        paragraphs.add("Lev.22.14");
        paragraphs.add("Lev.22.17");
        paragraphs.add("Lev.22.26");
        paragraphs.add("Lev.23.4");
        paragraphs.add("Lev.23.9");
        paragraphs.add("Lev.23.15");
        paragraphs.add("Lev.23.22");
        paragraphs.add("Lev.23.23");
        paragraphs.add("Lev.23.26");
        paragraphs.add("Lev.23.33");
        paragraphs.add("Lev.24.5");
        paragraphs.add("Lev.24.10");
        paragraphs.add("Lev.24.17");
        paragraphs.add("Lev.24.23");
        paragraphs.add("Lev.25.8");
        paragraphs.add("Lev.25.18");
        paragraphs.add("Lev.25.23");
        paragraphs.add("Lev.25.25");
        paragraphs.add("Lev.25.35");
        paragraphs.add("Lev.25.39");
        paragraphs.add("Lev.25.47");
        paragraphs.add("Lev.26.2");
        paragraphs.add("Lev.26.3");
        paragraphs.add("Lev.26.14");
        paragraphs.add("Lev.26.21");
        paragraphs.add("Lev.27.14");
        paragraphs.add("Lev.27.26");
        paragraphs.add("Num.1.5");
        paragraphs.add("Num.1.17");
        paragraphs.add("Num.1.22");
        paragraphs.add("Num.1.24");
        paragraphs.add("Num.1.26");
        paragraphs.add("Num.1.28");
        paragraphs.add("Num.1.30");
        paragraphs.add("Num.1.32");
        paragraphs.add("Num.1.34");
        paragraphs.add("Num.1.36");
        paragraphs.add("Num.1.38");
        paragraphs.add("Num.1.40");
        paragraphs.add("Num.1.42");
        paragraphs.add("Num.1.47");
        paragraphs.add("Num.2.10");
        paragraphs.add("Num.2.17");
        paragraphs.add("Num.2.18");
        paragraphs.add("Num.2.25");
        paragraphs.add("Num.2.29");
        paragraphs.add("Num.2.32");
        paragraphs.add("Num.3.5");
        paragraphs.add("Num.3.14");
        paragraphs.add("Num.3.27");
        paragraphs.add("Num.3.33");
        paragraphs.add("Num.3.38");
        paragraphs.add("Num.3.40");
        paragraphs.add("Num.3.44");
        paragraphs.add("Num.4.5");
        paragraphs.add("Num.4.16");
        paragraphs.add("Num.4.17");
        paragraphs.add("Num.4.21");
        paragraphs.add("Num.4.29");
        paragraphs.add("Num.4.34");
        paragraphs.add("Num.4.42");
        paragraphs.add("Num.5.5");
        paragraphs.add("Num.5.11");
        paragraphs.add("Num.6.13");
        paragraphs.add("Num.6.22");
        paragraphs.add("Num.7.10");
        paragraphs.add("Num.7.12");
        paragraphs.add("Num.7.18");
        paragraphs.add("Num.7.24");
        paragraphs.add("Num.7.30");
        paragraphs.add("Num.7.36");
        paragraphs.add("Num.7.42");
        paragraphs.add("Num.7.48");
        paragraphs.add("Num.7.54");
        paragraphs.add("Num.7.60");
        paragraphs.add("Num.7.66");
        paragraphs.add("Num.7.72");
        paragraphs.add("Num.7.78");
        paragraphs.add("Num.8.5");
        paragraphs.add("Num.8.23");
        paragraphs.add("Num.9.6");
        paragraphs.add("Num.9.9");
        paragraphs.add("Num.9.15");
        paragraphs.add("Num.10.11");
        paragraphs.add("Num.10.14");
        paragraphs.add("Num.10.18");
        paragraphs.add("Num.10.22");
        paragraphs.add("Num.10.25");
        paragraphs.add("Num.10.29");
        paragraphs.add("Num.10.33");
        paragraphs.add("Num.11.4");
        paragraphs.add("Num.11.10");
        paragraphs.add("Num.11.16");
        paragraphs.add("Num.11.24");
        paragraphs.add("Num.11.31");
        paragraphs.add("Num.12.14");
        paragraphs.add("Num.13.17");
        paragraphs.add("Num.13.21");
        paragraphs.add("Num.13.26");
        paragraphs.add("Num.14.6");
        paragraphs.add("Num.14.11");
        paragraphs.add("Num.14.13");
        paragraphs.add("Num.14.15");
        paragraphs.add("Num.14.26");
        paragraphs.add("Num.14.40");
        paragraphs.add("Num.15.17");
        paragraphs.add("Num.15.22");
        paragraphs.add("Num.15.27");
        paragraphs.add("Num.15.30");
        paragraphs.add("Num.15.32");
        paragraphs.add("Num.15.37");
        paragraphs.add("Num.16.12");
        paragraphs.add("Num.16.23");
        paragraphs.add("Num.16.31");
        paragraphs.add("Num.16.36");
        paragraphs.add("Num.16.41");
        paragraphs.add("Num.16.44");
        paragraphs.add("Num.16.46");
        paragraphs.add("Num.17.6");
        paragraphs.add("Num.17.10");
        paragraphs.add("Num.18.8");
        paragraphs.add("Num.18.20");
        paragraphs.add("Num.18.25");
        paragraphs.add("Num.19.11");
        paragraphs.add("Num.20.7");
        paragraphs.add("Num.20.12");
        paragraphs.add("Num.20.14");
        paragraphs.add("Num.20.22");
        paragraphs.add("Num.21.4");
        paragraphs.add("Num.21.7");
        paragraphs.add("Num.21.10");
        paragraphs.add("Num.21.12");
        paragraphs.add("Num.21.17");
        paragraphs.add("Num.21.21");
        paragraphs.add("Num.21.31");
        paragraphs.add("Num.21.33");
        paragraphs.add("Num.22.2");
        paragraphs.add("Num.22.15");
        paragraphs.add("Num.22.22");
        paragraphs.add("Num.22.36");
        paragraphs.add("Num.23.14");
        paragraphs.add("Num.23.25");
        paragraphs.add("Num.23.27");
        paragraphs.add("Num.24.10");
        paragraphs.add("Num.24.15");
        paragraphs.add("Num.24.20");
        paragraphs.add("Num.25.6");
        paragraphs.add("Num.25.10");
        paragraphs.add("Num.25.16");
        paragraphs.add("Num.26.5");
        paragraphs.add("Num.26.12");
        paragraphs.add("Num.26.15");
        paragraphs.add("Num.26.19");
        paragraphs.add("Num.26.23");
        paragraphs.add("Num.26.26");
        paragraphs.add("Num.26.28");
        paragraphs.add("Num.26.33");
        paragraphs.add("Num.26.35");
        paragraphs.add("Num.26.38");
        paragraphs.add("Num.26.42");
        paragraphs.add("Num.26.44");
        paragraphs.add("Num.26.48");
        paragraphs.add("Num.26.52");
        paragraphs.add("Num.26.57");
        paragraphs.add("Num.26.63");
        paragraphs.add("Num.27.6");
        paragraphs.add("Num.27.12");
        paragraphs.add("Num.27.15");
        paragraphs.add("Num.27.18");
        paragraphs.add("Num.28.9");
        paragraphs.add("Num.28.11");
        paragraphs.add("Num.28.26");
        paragraphs.add("Num.29.7");
        paragraphs.add("Num.29.12");
        paragraphs.add("Num.29.17");
        paragraphs.add("Num.29.20");
        paragraphs.add("Num.29.23");
        paragraphs.add("Num.29.26");
        paragraphs.add("Num.29.29");
        paragraphs.add("Num.29.32");
        paragraphs.add("Num.29.35");
        paragraphs.add("Num.31.13");
        paragraphs.add("Num.31.21");
        paragraphs.add("Num.31.25");
        paragraphs.add("Num.31.48");
        paragraphs.add("Num.32.6");
        paragraphs.add("Num.32.16");
        paragraphs.add("Num.32.20");
        paragraphs.add("Num.32.34");
        paragraphs.add("Num.33.50");
        paragraphs.add("Num.34.9");
        paragraphs.add("Num.35.9");
        paragraphs.add("Deut.1.9");
        paragraphs.add("Deut.1.19");
        paragraphs.add("Deut.1.22");
        paragraphs.add("Deut.2.16");
        paragraphs.add("Deut.2.24");
        paragraphs.add("Deut.2.26");
        paragraphs.add("Deut.3.18");
        paragraphs.add("Deut.3.21");
        paragraphs.add("Deut.4.14");
        paragraphs.add("Deut.4.25");
        paragraphs.add("Deut.4.41");
        paragraphs.add("Deut.4.44");
        paragraphs.add("Deut.5.6");
        paragraphs.add("Deut.5.16");
        paragraphs.add("Deut.5.22");
        paragraphs.add("Deut.6.3");
        paragraphs.add("Deut.6.16");
        paragraphs.add("Deut.7.12");
        paragraphs.add("Deut.9.7");
        paragraphs.add("Deut.10.6");
        paragraphs.add("Deut.10.8");
        paragraphs.add("Deut.10.12");
        paragraphs.add("Deut.11.10");
        paragraphs.add("Deut.11.13");
        paragraphs.add("Deut.11.18");
        paragraphs.add("Deut.11.22");
        paragraphs.add("Deut.11.26");
        paragraphs.add("Deut.12.17");
        paragraphs.add("Deut.12.20");
        paragraphs.add("Deut.12.29");
        paragraphs.add("Deut.13.6");
        paragraphs.add("Deut.13.12");
        paragraphs.add("Deut.14.3");
        paragraphs.add("Deut.14.9");
        paragraphs.add("Deut.14.11");
        paragraphs.add("Deut.14.21");
        paragraphs.add("Deut.14.28");
        paragraphs.add("Deut.15.7");
        paragraphs.add("Deut.15.12");
        paragraphs.add("Deut.15.19");
        paragraphs.add("Deut.16.9");
        paragraphs.add("Deut.16.13");
        paragraphs.add("Deut.16.16");
        paragraphs.add("Deut.16.18");
        paragraphs.add("Deut.16.21");
        paragraphs.add("Deut.17.2");
        paragraphs.add("Deut.17.8");
        paragraphs.add("Deut.17.14");
        paragraphs.add("Deut.18.3");
        paragraphs.add("Deut.18.6");
        paragraphs.add("Deut.18.9");
        paragraphs.add("Deut.18.15");
        paragraphs.add("Deut.19.4");
        paragraphs.add("Deut.19.11");
        paragraphs.add("Deut.19.14");
        paragraphs.add("Deut.19.15");
        paragraphs.add("Deut.19.16");
        paragraphs.add("Deut.20.5");
        paragraphs.add("Deut.20.10");
        paragraphs.add("Deut.20.19");
        paragraphs.add("Deut.21.10");
        paragraphs.add("Deut.21.15");
        paragraphs.add("Deut.21.18");
        paragraphs.add("Deut.21.22");
        paragraphs.add("Deut.22.4");
        paragraphs.add("Deut.22.5");
        paragraphs.add("Deut.22.6");
        paragraphs.add("Deut.22.8");
        paragraphs.add("Deut.22.9");
        paragraphs.add("Deut.22.10");
        paragraphs.add("Deut.22.11");
        paragraphs.add("Deut.22.12");
        paragraphs.add("Deut.22.13");
        paragraphs.add("Deut.22.22");
        paragraphs.add("Deut.22.23");
        paragraphs.add("Deut.22.25");
        paragraphs.add("Deut.22.28");
        paragraphs.add("Deut.22.30");
        paragraphs.add("Deut.23.7");
        paragraphs.add("Deut.23.9");
        paragraphs.add("Deut.23.10");
        paragraphs.add("Deut.23.12");
        paragraphs.add("Deut.23.15");
        paragraphs.add("Deut.23.17");
        paragraphs.add("Deut.23.19");
        paragraphs.add("Deut.23.21");
        paragraphs.add("Deut.23.24");
        paragraphs.add("Deut.24.5");
        paragraphs.add("Deut.24.6");
        paragraphs.add("Deut.24.7");
        paragraphs.add("Deut.24.8");
        paragraphs.add("Deut.24.10");
        paragraphs.add("Deut.24.14");
        paragraphs.add("Deut.24.17");
        paragraphs.add("Deut.24.19");
        paragraphs.add("Deut.25.4");
        paragraphs.add("Deut.25.5");
        paragraphs.add("Deut.25.11");
        paragraphs.add("Deut.25.13");
        paragraphs.add("Deut.25.17");
        paragraphs.add("Deut.26.12");
        paragraphs.add("Deut.26.16");
        paragraphs.add("Deut.27.9");
        paragraphs.add("Deut.27.11");
        paragraphs.add("Deut.27.14");
        paragraphs.add("Deut.28.15");
        paragraphs.add("Deut.29.2");
        paragraphs.add("Deut.29.10");
        paragraphs.add("Deut.30.11");
        paragraphs.add("Deut.30.15");
        paragraphs.add("Deut.31.7");
        paragraphs.add("Deut.31.9");
        paragraphs.add("Deut.31.14");
        paragraphs.add("Deut.31.16");
        paragraphs.add("Deut.31.22");
        paragraphs.add("Deut.31.24");
        paragraphs.add("Deut.31.28");
        paragraphs.add("Deut.32.7");
        paragraphs.add("Deut.32.15");
        paragraphs.add("Deut.32.44");
        paragraphs.add("Deut.33.6");
        paragraphs.add("Deut.33.7");
        paragraphs.add("Deut.33.8");
        paragraphs.add("Deut.33.12");
        paragraphs.add("Deut.33.13");
        paragraphs.add("Deut.33.18");
        paragraphs.add("Deut.33.20");
        paragraphs.add("Deut.33.22");
        paragraphs.add("Deut.33.23");
        paragraphs.add("Deut.33.24");
        paragraphs.add("Deut.33.26");
        paragraphs.add("Deut.34.5");
        paragraphs.add("Deut.34.7");
        paragraphs.add("Deut.34.8");
        paragraphs.add("Deut.34.9");
        paragraphs.add("Deut.34.10");
        paragraphs.add("Josh.1.10");
        paragraphs.add("Josh.1.12");
        paragraphs.add("Josh.1.16");
        paragraphs.add("Josh.2.8");
        paragraphs.add("Josh.2.23");
        paragraphs.add("Josh.3.7");
        paragraphs.add("Josh.3.9");
        paragraphs.add("Josh.3.14");
        paragraphs.add("Josh.4.10");
        paragraphs.add("Josh.4.14");
        paragraphs.add("Josh.4.19");
        paragraphs.add("Josh.5.2");
        paragraphs.add("Josh.5.10");
        paragraphs.add("Josh.5.12");
        paragraphs.add("Josh.5.13");
        paragraphs.add("Josh.6.6");
        paragraphs.add("Josh.6.8");
        paragraphs.add("Josh.6.9");
        paragraphs.add("Josh.6.12");
        paragraphs.add("Josh.6.17");
        paragraphs.add("Josh.6.26");
        paragraphs.add("Josh.7.6");
        paragraphs.add("Josh.7.10");
        paragraphs.add("Josh.7.16");
        paragraphs.add("Josh.7.22");
        paragraphs.add("Josh.8.3");
        paragraphs.add("Josh.8.9");
        paragraphs.add("Josh.8.14");
        paragraphs.add("Josh.8.30");
        paragraphs.add("Josh.8.32");
        paragraphs.add("Josh.9.3");
        paragraphs.add("Josh.9.16");
        paragraphs.add("Josh.9.22");
        paragraphs.add("Josh.10.6");
        paragraphs.add("Josh.10.8");
        paragraphs.add("Josh.10.12");
        paragraphs.add("Josh.10.15");
        paragraphs.add("Josh.10.28");
        paragraphs.add("Josh.10.31");
        paragraphs.add("Josh.10.33");
        paragraphs.add("Josh.10.34");
        paragraphs.add("Josh.10.38");
        paragraphs.add("Josh.10.40");
        paragraphs.add("Josh.11.6");
        paragraphs.add("Josh.11.10");
        paragraphs.add("Josh.11.15");
        paragraphs.add("Josh.11.21");
        paragraphs.add("Josh.12.4");
        paragraphs.add("Josh.12.7");
        paragraphs.add("Josh.12.9");
        paragraphs.add("Josh.13.15");
        paragraphs.add("Josh.13.22");
        paragraphs.add("Josh.13.29");
        paragraphs.add("Josh.14.6");
        paragraphs.add("Josh.15.13");
        paragraphs.add("Josh.15.16");
        paragraphs.add("Josh.15.48");
        paragraphs.add("Josh.15.63");
        paragraphs.add("Josh.16.5");
        paragraphs.add("Josh.17.3");
        paragraphs.add("Josh.17.7");
        paragraphs.add("Josh.18.8");
        paragraphs.add("Josh.18.10");
        paragraphs.add("Josh.18.11");
        paragraphs.add("Josh.19.10");
        paragraphs.add("Josh.19.17");
        paragraphs.add("Josh.19.24");
        paragraphs.add("Josh.19.32");
        paragraphs.add("Josh.19.40");
        paragraphs.add("Josh.19.49");
        paragraphs.add("Josh.20.7");
        paragraphs.add("Josh.21.9");
        paragraphs.add("Josh.21.13");
        paragraphs.add("Josh.21.20");
        paragraphs.add("Josh.21.27");
        paragraphs.add("Josh.21.34");
        paragraphs.add("Josh.21.43");
        paragraphs.add("Josh.22.7");
        paragraphs.add("Josh.22.9");
        paragraphs.add("Josh.22.10");
        paragraphs.add("Josh.22.11");
        paragraphs.add("Josh.22.15");
        paragraphs.add("Josh.22.21");
        paragraphs.add("Josh.22.30");
        paragraphs.add("Josh.22.32");
        paragraphs.add("Josh.24.14");
        paragraphs.add("Josh.24.26");
        paragraphs.add("Josh.24.29");
        paragraphs.add("Josh.24.32");
        paragraphs.add("Judg.1.9");
        paragraphs.add("Judg.1.16");
        paragraphs.add("Judg.1.22");
        paragraphs.add("Judg.1.27");
        paragraphs.add("Judg.1.29");
        paragraphs.add("Judg.1.30");
        paragraphs.add("Judg.1.31");
        paragraphs.add("Judg.1.33");
        paragraphs.add("Judg.2.6");
        paragraphs.add("Judg.2.11");
        paragraphs.add("Judg.2.14");
        paragraphs.add("Judg.2.16");
        paragraphs.add("Judg.2.20");
        paragraphs.add("Judg.3.5");
        paragraphs.add("Judg.3.8");
        paragraphs.add("Judg.3.12");
        paragraphs.add("Judg.3.31");
        paragraphs.add("Judg.4.4");
        paragraphs.add("Judg.4.10");
        paragraphs.add("Judg.4.18");
        paragraphs.add("Judg.6.7");
        paragraphs.add("Judg.6.11");
        paragraphs.add("Judg.6.19");
        paragraphs.add("Judg.6.21");
        paragraphs.add("Judg.6.25");
        paragraphs.add("Judg.6.28");
        paragraphs.add("Judg.6.33");
        paragraphs.add("Judg.6.36");
        paragraphs.add("Judg.7.9");
        paragraphs.add("Judg.7.15");
        paragraphs.add("Judg.7.19");
        paragraphs.add("Judg.7.24");
        paragraphs.add("Judg.8.4");
        paragraphs.add("Judg.8.6");
        paragraphs.add("Judg.8.8");
        paragraphs.add("Judg.8.10");
        paragraphs.add("Judg.8.11");
        paragraphs.add("Judg.8.13");
        paragraphs.add("Judg.8.18");
        paragraphs.add("Judg.8.22");
        paragraphs.add("Judg.8.24");
        paragraphs.add("Judg.8.28");
        paragraphs.add("Judg.8.29");
        paragraphs.add("Judg.8.32");
        paragraphs.add("Judg.9.7");
        paragraphs.add("Judg.9.22");
        paragraphs.add("Judg.9.30");
        paragraphs.add("Judg.9.34");
        paragraphs.add("Judg.9.46");
        paragraphs.add("Judg.9.50");
        paragraphs.add("Judg.9.56");
        paragraphs.add("Judg.10.3");
        paragraphs.add("Judg.10.6");
        paragraphs.add("Judg.10.10");
        paragraphs.add("Judg.10.15");
        paragraphs.add("Judg.11.4");
        paragraphs.add("Judg.11.12");
        paragraphs.add("Judg.11.29");
        paragraphs.add("Judg.11.32");
        paragraphs.add("Judg.11.34");
        paragraphs.add("Judg.12.8");
        paragraphs.add("Judg.12.11");
        paragraphs.add("Judg.12.13");
        paragraphs.add("Judg.13.2");
        paragraphs.add("Judg.13.6");
        paragraphs.add("Judg.13.8");
        paragraphs.add("Judg.13.15");
        paragraphs.add("Judg.13.24");
        paragraphs.add("Judg.14.5");
        paragraphs.add("Judg.14.8");
        paragraphs.add("Judg.14.10");
        paragraphs.add("Judg.14.12");
        paragraphs.add("Judg.14.19");
        paragraphs.add("Judg.15.3");
        paragraphs.add("Judg.15.6");
        paragraphs.add("Judg.15.7");
        paragraphs.add("Judg.15.9");
        paragraphs.add("Judg.15.14");
        paragraphs.add("Judg.15.18");
        paragraphs.add("Judg.16.4");
        paragraphs.add("Judg.16.6");
        paragraphs.add("Judg.16.15");
        paragraphs.add("Judg.16.21");
        paragraphs.add("Judg.17.7");
        paragraphs.add("Judg.18.7");
        paragraphs.add("Judg.18.11");
        paragraphs.add("Judg.18.14");
        paragraphs.add("Judg.18.22");
        paragraphs.add("Judg.18.30");
        paragraphs.add("Judg.19.5");
        paragraphs.add("Judg.19.16");
        paragraphs.add("Judg.19.22");
        paragraphs.add("Judg.19.29");
        paragraphs.add("Judg.20.8");
        paragraphs.add("Judg.20.12");
        paragraphs.add("Judg.20.18");
        paragraphs.add("Judg.20.26");
        paragraphs.add("Judg.21.8");
        paragraphs.add("Judg.21.16");
        paragraphs.add("Ruth.1.6");
        paragraphs.add("Ruth.1.19");
        paragraphs.add("Ruth.2.4");
        paragraphs.add("Ruth.2.18");
        paragraphs.add("Ruth.3.6");
        paragraphs.add("Ruth.3.8");
        paragraphs.add("Ruth.3.14");
        paragraphs.add("Ruth.4.6");
        paragraphs.add("Ruth.4.9");
        paragraphs.add("Ruth.4.13");
        paragraphs.add("Ruth.4.18");
        paragraphs.add("1Sam.1.4");
        paragraphs.add("1Sam.1.9");
        paragraphs.add("1Sam.1.19");
        paragraphs.add("1Sam.1.24");
        paragraphs.add("1Sam.2.12");
        paragraphs.add("1Sam.2.18");
        paragraphs.add("1Sam.2.20");
        paragraphs.add("1Sam.2.22");
        paragraphs.add("1Sam.2.27");
        paragraphs.add("1Sam.3.11");
        paragraphs.add("1Sam.3.15");
        paragraphs.add("1Sam.3.19");
        paragraphs.add("1Sam.4.3");
        paragraphs.add("1Sam.4.10");
        paragraphs.add("1Sam.4.12");
        paragraphs.add("1Sam.4.19");
        paragraphs.add("1Sam.5.3");
        paragraphs.add("1Sam.5.10");
        paragraphs.add("1Sam.6.10");
        paragraphs.add("1Sam.6.19");
        paragraphs.add("1Sam.6.21");
        paragraphs.add("1Sam.7.3");
        paragraphs.add("1Sam.7.9");
        paragraphs.add("1Sam.7.13");
        paragraphs.add("1Sam.8.6");
        paragraphs.add("1Sam.8.10");
        paragraphs.add("1Sam.8.19");
        paragraphs.add("1Sam.9.11");
        paragraphs.add("1Sam.9.15");
        paragraphs.add("1Sam.9.25");
        paragraphs.add("1Sam.10.9");
        paragraphs.add("1Sam.10.14");
        paragraphs.add("1Sam.10.17");
        paragraphs.add("1Sam.10.26");
        paragraphs.add("1Sam.11.4");
        paragraphs.add("1Sam.11.12");
        paragraphs.add("1Sam.12.6");
        paragraphs.add("1Sam.12.16");
        paragraphs.add("1Sam.12.20");
        paragraphs.add("1Sam.13.5");
        paragraphs.add("1Sam.13.8");
        paragraphs.add("1Sam.13.11");
        paragraphs.add("1Sam.13.17");
        paragraphs.add("1Sam.13.19");
        paragraphs.add("1Sam.14.4");
        paragraphs.add("1Sam.14.19");
        paragraphs.add("1Sam.14.24");
        paragraphs.add("1Sam.14.33");
        paragraphs.add("1Sam.14.36");
        paragraphs.add("1Sam.14.47");
        paragraphs.add("1Sam.15.6");
        paragraphs.add("1Sam.15.10");
        paragraphs.add("1Sam.15.24");
        paragraphs.add("1Sam.15.32");
        paragraphs.add("1Sam.15.34");
        paragraphs.add("1Sam.16.6");
        paragraphs.add("1Sam.16.14");
        paragraphs.add("1Sam.16.19");
        paragraphs.add("1Sam.17.4");
        paragraphs.add("1Sam.17.12");
        paragraphs.add("1Sam.17.20");
        paragraphs.add("1Sam.17.28");
        paragraphs.add("1Sam.17.30");
        paragraphs.add("1Sam.17.32");
        paragraphs.add("1Sam.17.38");
        paragraphs.add("1Sam.17.55");
        paragraphs.add("1Sam.18.5");
        paragraphs.add("1Sam.18.10");
        paragraphs.add("1Sam.18.12");
        paragraphs.add("1Sam.18.17");
        paragraphs.add("1Sam.18.22");
        paragraphs.add("1Sam.18.28");
        paragraphs.add("1Sam.19.4");
        paragraphs.add("1Sam.19.8");
        paragraphs.add("1Sam.19.12");
        paragraphs.add("1Sam.19.18");
        paragraphs.add("1Sam.20.11");
        paragraphs.add("1Sam.20.24");
        paragraphs.add("1Sam.20.35");
        paragraphs.add("1Sam.20.41");
        paragraphs.add("1Sam.21.8");
        paragraphs.add("1Sam.21.10");
        paragraphs.add("1Sam.22.3");
        paragraphs.add("1Sam.22.5");
        paragraphs.add("1Sam.22.6");
        paragraphs.add("1Sam.22.9");
        paragraphs.add("1Sam.22.17");
        paragraphs.add("1Sam.22.20");
        paragraphs.add("1Sam.23.7");
        paragraphs.add("1Sam.23.9");
        paragraphs.add("1Sam.23.13");
        paragraphs.add("1Sam.23.16");
        paragraphs.add("1Sam.23.19");
        paragraphs.add("1Sam.23.27");
        paragraphs.add("1Sam.23.29");
        paragraphs.add("1Sam.24.9");
        paragraphs.add("1Sam.24.16");
        paragraphs.add("1Sam.25.4");
        paragraphs.add("1Sam.25.10");
        paragraphs.add("1Sam.25.14");
        paragraphs.add("1Sam.25.18");
        paragraphs.add("1Sam.25.32");
        paragraphs.add("1Sam.25.36");
        paragraphs.add("1Sam.25.39");
        paragraphs.add("1Sam.25.44");
        paragraphs.add("1Sam.26.5");
        paragraphs.add("1Sam.26.13");
        paragraphs.add("1Sam.26.21");
        paragraphs.add("1Sam.27.5");
        paragraphs.add("1Sam.27.8");
        paragraphs.add("1Sam.28.3");
        paragraphs.add("1Sam.28.7");
        paragraphs.add("1Sam.28.15");
        paragraphs.add("1Sam.28.21");
        paragraphs.add("1Sam.29.6");
        paragraphs.add("1Sam.29.8");
        paragraphs.add("1Sam.30.3");
        paragraphs.add("1Sam.30.11");
        paragraphs.add("1Sam.30.16");
        paragraphs.add("1Sam.30.21");
        paragraphs.add("1Sam.30.26");
        paragraphs.add("1Sam.31.7");
        paragraphs.add("1Sam.31.11");
        paragraphs.add("2Sam.1.13");
        paragraphs.add("2Sam.1.17");
        paragraphs.add("2Sam.2.5");
        paragraphs.add("2Sam.2.8");
        paragraphs.add("2Sam.2.12");
        paragraphs.add("2Sam.2.18");
        paragraphs.add("2Sam.2.25");
        paragraphs.add("2Sam.2.32");
        paragraphs.add("2Sam.3.2");
        paragraphs.add("2Sam.3.6");
        paragraphs.add("2Sam.3.12");
        paragraphs.add("2Sam.3.13");
        paragraphs.add("2Sam.3.17");
        paragraphs.add("2Sam.3.22");
        paragraphs.add("2Sam.3.28");
        paragraphs.add("2Sam.3.31");
        paragraphs.add("2Sam.4.9");
        paragraphs.add("2Sam.5.4");
        paragraphs.add("2Sam.5.6");
        paragraphs.add("2Sam.5.11");
        paragraphs.add("2Sam.5.13");
        paragraphs.add("2Sam.5.17");
        paragraphs.add("2Sam.5.22");
        paragraphs.add("2Sam.6.6");
        paragraphs.add("2Sam.6.12");
        paragraphs.add("2Sam.6.17");
        paragraphs.add("2Sam.6.20");
        paragraphs.add("2Sam.7.4");
        paragraphs.add("2Sam.7.12");
        paragraphs.add("2Sam.7.18");
        paragraphs.add("2Sam.8.3");
        paragraphs.add("2Sam.8.9");
        paragraphs.add("2Sam.8.14");
        paragraphs.add("2Sam.9.5");
        paragraphs.add("2Sam.9.7");
        paragraphs.add("2Sam.9.9");
        paragraphs.add("2Sam.10.6");
        paragraphs.add("2Sam.10.15");
        paragraphs.add("2Sam.11.2");
        paragraphs.add("2Sam.11.6");
        paragraphs.add("2Sam.11.14");
        paragraphs.add("2Sam.11.18");
        paragraphs.add("2Sam.11.22");
        paragraphs.add("2Sam.11.26");
        paragraphs.add("2Sam.12.7");
        paragraphs.add("2Sam.12.15");
        paragraphs.add("2Sam.12.24");
        paragraphs.add("2Sam.12.26");
        paragraphs.add("2Sam.13.6");
        paragraphs.add("2Sam.13.15");
        paragraphs.add("2Sam.13.19");
        paragraphs.add("2Sam.13.21");
        paragraphs.add("2Sam.13.23");
        paragraphs.add("2Sam.13.28");
        paragraphs.add("2Sam.13.30");
        paragraphs.add("2Sam.13.37");
        paragraphs.add("2Sam.14.4");
        paragraphs.add("2Sam.14.21");
        paragraphs.add("2Sam.14.25");
        paragraphs.add("2Sam.14.28");
        paragraphs.add("2Sam.15.7");
        paragraphs.add("2Sam.15.10");
        paragraphs.add("2Sam.15.13");
        paragraphs.add("2Sam.15.19");
        paragraphs.add("2Sam.15.24");
        paragraphs.add("2Sam.15.30");
        paragraphs.add("2Sam.15.31");
        paragraphs.add("2Sam.15.32");
        paragraphs.add("2Sam.16.5");
        paragraphs.add("2Sam.16.9");
        paragraphs.add("2Sam.16.15");
        paragraphs.add("2Sam.16.20");
        paragraphs.add("2Sam.17.15");
        paragraphs.add("2Sam.17.23");
        paragraphs.add("2Sam.17.25");
        paragraphs.add("2Sam.17.27");
        paragraphs.add("2Sam.18.6");
        paragraphs.add("2Sam.18.9");
        paragraphs.add("2Sam.18.18");
        paragraphs.add("2Sam.18.19");
        paragraphs.add("2Sam.18.33");
        paragraphs.add("2Sam.19.9");
        paragraphs.add("2Sam.19.11");
        paragraphs.add("2Sam.19.16");
        paragraphs.add("2Sam.19.24");
        paragraphs.add("2Sam.19.31");
        paragraphs.add("2Sam.19.41");
        paragraphs.add("2Sam.20.3");
        paragraphs.add("2Sam.20.4");
        paragraphs.add("2Sam.20.14");
        paragraphs.add("2Sam.20.16");
        paragraphs.add("2Sam.20.23");
        paragraphs.add("2Sam.21.10");
        paragraphs.add("2Sam.21.12");
        paragraphs.add("2Sam.21.15");
        paragraphs.add("2Sam.23.6");
        paragraphs.add("2Sam.23.8");
        paragraphs.add("2Sam.24.5");
        paragraphs.add("2Sam.24.10");
        paragraphs.add("2Sam.24.15");
        paragraphs.add("2Sam.24.18");
        paragraphs.add("1Kgs.1.5");
        paragraphs.add("1Kgs.1.11");
        paragraphs.add("1Kgs.1.15");
        paragraphs.add("1Kgs.1.22");
        paragraphs.add("1Kgs.1.28");
        paragraphs.add("1Kgs.1.32");
        paragraphs.add("1Kgs.1.41");
        paragraphs.add("1Kgs.1.50");
        paragraphs.add("1Kgs.2.12");
        paragraphs.add("1Kgs.2.13");
        paragraphs.add("1Kgs.2.19");
        paragraphs.add("1Kgs.2.26");
        paragraphs.add("1Kgs.2.28");
        paragraphs.add("1Kgs.2.35");
        paragraphs.add("1Kgs.2.36");
        paragraphs.add("1Kgs.3.5");
        paragraphs.add("1Kgs.3.16");
        paragraphs.add("1Kgs.4.7");
        paragraphs.add("1Kgs.4.20");
        paragraphs.add("1Kgs.4.22");
        paragraphs.add("1Kgs.4.26");
        paragraphs.add("1Kgs.4.29");
        paragraphs.add("1Kgs.5.7");
        paragraphs.add("1Kgs.5.13");
        paragraphs.add("1Kgs.6.5");
        paragraphs.add("1Kgs.6.11");
        paragraphs.add("1Kgs.6.23");
        paragraphs.add("1Kgs.6.31");
        paragraphs.add("1Kgs.6.36");
        paragraphs.add("1Kgs.6.37");
        paragraphs.add("1Kgs.7.2");
        paragraphs.add("1Kgs.7.6");
        paragraphs.add("1Kgs.7.7");
        paragraphs.add("1Kgs.7.8");
        paragraphs.add("1Kgs.7.13");
        paragraphs.add("1Kgs.7.23");
        paragraphs.add("1Kgs.7.27");
        paragraphs.add("1Kgs.7.38");
        paragraphs.add("1Kgs.7.40");
        paragraphs.add("1Kgs.8.12");
        paragraphs.add("1Kgs.8.22");
        paragraphs.add("1Kgs.8.31");
        paragraphs.add("1Kgs.8.33");
        paragraphs.add("1Kgs.8.35");
        paragraphs.add("1Kgs.8.37");
        paragraphs.add("1Kgs.8.44");
        paragraphs.add("1Kgs.8.62");
        paragraphs.add("1Kgs.9.10");
        paragraphs.add("1Kgs.9.15");
        paragraphs.add("1Kgs.9.24");
        paragraphs.add("1Kgs.9.25");
        paragraphs.add("1Kgs.9.26");
        paragraphs.add("1Kgs.10.14");
        paragraphs.add("1Kgs.10.16");
        paragraphs.add("1Kgs.10.18");
        paragraphs.add("1Kgs.10.21");
        paragraphs.add("1Kgs.10.24");
        paragraphs.add("1Kgs.10.26");
        paragraphs.add("1Kgs.10.28");
        paragraphs.add("1Kgs.11.9");
        paragraphs.add("1Kgs.11.14");
        paragraphs.add("1Kgs.11.23");
        paragraphs.add("1Kgs.11.26");
        paragraphs.add("1Kgs.11.41");
        paragraphs.add("1Kgs.12.6");
        paragraphs.add("1Kgs.12.12");
        paragraphs.add("1Kgs.12.16");
        paragraphs.add("1Kgs.12.21");
        paragraphs.add("1Kgs.12.25");
        paragraphs.add("1Kgs.13.11");
        paragraphs.add("1Kgs.13.20");
        paragraphs.add("1Kgs.13.23");
        paragraphs.add("1Kgs.13.33");
        paragraphs.add("1Kgs.14.5");
        paragraphs.add("1Kgs.14.17");
        paragraphs.add("1Kgs.14.21");
        paragraphs.add("1Kgs.14.25");
        paragraphs.add("1Kgs.14.29");
        paragraphs.add("1Kgs.15.9");
        paragraphs.add("1Kgs.15.16");
        paragraphs.add("1Kgs.15.25");
        paragraphs.add("1Kgs.15.27");
        paragraphs.add("1Kgs.15.31");
        paragraphs.add("1Kgs.16.8");
        paragraphs.add("1Kgs.16.11");
        paragraphs.add("1Kgs.16.15");
        paragraphs.add("1Kgs.16.21");
        paragraphs.add("1Kgs.16.23");
        paragraphs.add("1Kgs.16.25");
        paragraphs.add("1Kgs.16.29");
        paragraphs.add("1Kgs.16.34");
        paragraphs.add("1Kgs.17.8");
        paragraphs.add("1Kgs.17.17");
        paragraphs.add("1Kgs.17.24");
        paragraphs.add("1Kgs.18.7");
        paragraphs.add("1Kgs.18.17");
        paragraphs.add("1Kgs.18.41");
        paragraphs.add("1Kgs.19.4");
        paragraphs.add("1Kgs.19.9");
        paragraphs.add("1Kgs.19.19");
        paragraphs.add("1Kgs.20.13");
        paragraphs.add("1Kgs.20.22");
        paragraphs.add("1Kgs.20.28");
        paragraphs.add("1Kgs.20.31");
        paragraphs.add("1Kgs.20.35");
        paragraphs.add("1Kgs.21.5");
        paragraphs.add("1Kgs.21.15");
        paragraphs.add("1Kgs.21.17");
        paragraphs.add("1Kgs.21.25");
        paragraphs.add("1Kgs.22.15");
        paragraphs.add("1Kgs.22.37");
        paragraphs.add("1Kgs.22.41");
        paragraphs.add("1Kgs.22.50");
        paragraphs.add("1Kgs.22.51");
        paragraphs.add("2Kgs.1.5");
        paragraphs.add("2Kgs.1.13");
        paragraphs.add("2Kgs.1.17");
        paragraphs.add("2Kgs.2.9");
        paragraphs.add("2Kgs.2.12");
        paragraphs.add("2Kgs.2.16");
        paragraphs.add("2Kgs.2.19");
        paragraphs.add("2Kgs.2.23");
        paragraphs.add("2Kgs.3.4");
        paragraphs.add("2Kgs.3.6");
        paragraphs.add("2Kgs.3.21");
        paragraphs.add("2Kgs.3.26");
        paragraphs.add("2Kgs.4.8");
        paragraphs.add("2Kgs.4.18");
        paragraphs.add("2Kgs.4.38");
        paragraphs.add("2Kgs.4.42");
        paragraphs.add("2Kgs.5.8");
        paragraphs.add("2Kgs.5.15");
        paragraphs.add("2Kgs.5.20");
        paragraphs.add("2Kgs.6.8");
        paragraphs.add("2Kgs.6.13");
        paragraphs.add("2Kgs.6.19");
        paragraphs.add("2Kgs.6.24");
        paragraphs.add("2Kgs.6.30");
        paragraphs.add("2Kgs.7.3");
        paragraphs.add("2Kgs.7.12");
        paragraphs.add("2Kgs.7.17");
        paragraphs.add("2Kgs.8.7");
        paragraphs.add("2Kgs.8.16");
        paragraphs.add("2Kgs.8.20");
        paragraphs.add("2Kgs.8.25");
        paragraphs.add("2Kgs.8.28");
        paragraphs.add("2Kgs.9.4");
        paragraphs.add("2Kgs.9.11");
        paragraphs.add("2Kgs.9.27");
        paragraphs.add("2Kgs.9.30");
        paragraphs.add("2Kgs.10.8");
        paragraphs.add("2Kgs.10.12");
        paragraphs.add("2Kgs.10.15");
        paragraphs.add("2Kgs.10.18");
        paragraphs.add("2Kgs.10.29");
        paragraphs.add("2Kgs.10.32");
        paragraphs.add("2Kgs.11.4");
        paragraphs.add("2Kgs.11.13");
        paragraphs.add("2Kgs.11.17");
        paragraphs.add("2Kgs.12.4");
        paragraphs.add("2Kgs.12.17");
        paragraphs.add("2Kgs.12.19");
        paragraphs.add("2Kgs.13.3");
        paragraphs.add("2Kgs.13.8");
        paragraphs.add("2Kgs.13.10");
        paragraphs.add("2Kgs.13.14");
        paragraphs.add("2Kgs.13.20");
        paragraphs.add("2Kgs.13.22");
        paragraphs.add("2Kgs.14.5");
        paragraphs.add("2Kgs.14.8");
        paragraphs.add("2Kgs.14.15");
        paragraphs.add("2Kgs.14.17");
        paragraphs.add("2Kgs.14.21");
        paragraphs.add("2Kgs.14.23");
        paragraphs.add("2Kgs.14.28");
        paragraphs.add("2Kgs.15.5");
        paragraphs.add("2Kgs.15.8");
        paragraphs.add("2Kgs.15.13");
        paragraphs.add("2Kgs.15.16");
        paragraphs.add("2Kgs.15.21");
        paragraphs.add("2Kgs.15.23");
        paragraphs.add("2Kgs.15.27");
        paragraphs.add("2Kgs.15.32");
        paragraphs.add("2Kgs.15.35");
        paragraphs.add("2Kgs.15.36");
        paragraphs.add("2Kgs.16.5");
        paragraphs.add("2Kgs.16.10");
        paragraphs.add("2Kgs.16.17");
        paragraphs.add("2Kgs.16.19");
        paragraphs.add("2Kgs.17.3");
        paragraphs.add("2Kgs.17.5");
        paragraphs.add("2Kgs.17.6");
        paragraphs.add("2Kgs.17.24");
        paragraphs.add("2Kgs.18.4");
        paragraphs.add("2Kgs.18.9");
        paragraphs.add("2Kgs.18.13");
        paragraphs.add("2Kgs.18.17");
        paragraphs.add("2Kgs.19.6");
        paragraphs.add("2Kgs.19.8");
        paragraphs.add("2Kgs.19.14");
        paragraphs.add("2Kgs.19.20");
        paragraphs.add("2Kgs.19.35");
        paragraphs.add("2Kgs.20.8");
        paragraphs.add("2Kgs.20.12");
        paragraphs.add("2Kgs.20.14");
        paragraphs.add("2Kgs.20.20");
        paragraphs.add("2Kgs.21.10");
        paragraphs.add("2Kgs.21.17");
        paragraphs.add("2Kgs.21.19");
        paragraphs.add("2Kgs.21.23");
        paragraphs.add("2Kgs.22.3");
        paragraphs.add("2Kgs.22.8");
        paragraphs.add("2Kgs.22.15");
        paragraphs.add("2Kgs.23.3");
        paragraphs.add("2Kgs.23.15");
        paragraphs.add("2Kgs.23.21");
        paragraphs.add("2Kgs.23.24");
        paragraphs.add("2Kgs.23.26");
        paragraphs.add("2Kgs.23.29");
        paragraphs.add("2Kgs.23.31");
        paragraphs.add("2Kgs.23.36");
        paragraphs.add("2Kgs.24.5");
        paragraphs.add("2Kgs.24.8");
        paragraphs.add("2Kgs.24.10");
        paragraphs.add("2Kgs.24.17");
        paragraphs.add("2Kgs.25.4");
        paragraphs.add("2Kgs.25.8");
        paragraphs.add("2Kgs.25.18");
        paragraphs.add("2Kgs.25.22");
        paragraphs.add("2Kgs.25.27");
        paragraphs.add("1Chr.1.5");
        paragraphs.add("1Chr.1.8");
        paragraphs.add("1Chr.1.17");
        paragraphs.add("1Chr.1.24");
        paragraphs.add("1Chr.1.29");
        paragraphs.add("1Chr.1.32");
        paragraphs.add("1Chr.1.35");
        paragraphs.add("1Chr.1.43");
        paragraphs.add("1Chr.1.51");
        paragraphs.add("1Chr.2.3");
        paragraphs.add("1Chr.2.13");
        paragraphs.add("1Chr.2.18");
        paragraphs.add("1Chr.2.21");
        paragraphs.add("1Chr.2.25");
        paragraphs.add("1Chr.2.34");
        paragraphs.add("1Chr.2.42");
        paragraphs.add("1Chr.2.50");
        paragraphs.add("1Chr.3.10");
        paragraphs.add("1Chr.3.17");
        paragraphs.add("1Chr.4.5");
        paragraphs.add("1Chr.4.9");
        paragraphs.add("1Chr.4.11");
        paragraphs.add("1Chr.4.21");
        paragraphs.add("1Chr.4.24");
        paragraphs.add("1Chr.4.39");
        paragraphs.add("1Chr.5.11");
        paragraphs.add("1Chr.5.18");
        paragraphs.add("1Chr.5.23");
        paragraphs.add("1Chr.5.25");
        paragraphs.add("1Chr.6.4");
        paragraphs.add("1Chr.6.16");
        paragraphs.add("1Chr.6.49");
        paragraphs.add("1Chr.6.54");
        paragraphs.add("1Chr.7.6");
        paragraphs.add("1Chr.7.13");
        paragraphs.add("1Chr.7.14");
        paragraphs.add("1Chr.7.20");
        paragraphs.add("1Chr.7.21");
        paragraphs.add("1Chr.7.23");
        paragraphs.add("1Chr.7.28");
        paragraphs.add("1Chr.7.30");
        paragraphs.add("1Chr.8.33");
        paragraphs.add("1Chr.9.2");
        paragraphs.add("1Chr.9.10");
        paragraphs.add("1Chr.9.27");
        paragraphs.add("1Chr.9.35");
        paragraphs.add("1Chr.10.8");
        paragraphs.add("1Chr.10.11");
        paragraphs.add("1Chr.10.13");
        paragraphs.add("1Chr.11.4");
        paragraphs.add("1Chr.11.10");
        paragraphs.add("1Chr.11.15");
        paragraphs.add("1Chr.11.20");
        paragraphs.add("1Chr.11.26");
        paragraphs.add("1Chr.12.23");
        paragraphs.add("1Chr.13.9");
        paragraphs.add("1Chr.14.3");
        paragraphs.add("1Chr.14.8");
        paragraphs.add("1Chr.15.25");
        paragraphs.add("1Chr.15.29");
        paragraphs.add("1Chr.16.4");
        paragraphs.add("1Chr.16.7");
        paragraphs.add("1Chr.16.37");
        paragraphs.add("1Chr.17.3");
        paragraphs.add("1Chr.17.11");
        paragraphs.add("1Chr.17.16");
        paragraphs.add("1Chr.18.3");
        paragraphs.add("1Chr.18.9");
        paragraphs.add("1Chr.18.11");
        paragraphs.add("1Chr.18.13");
        paragraphs.add("1Chr.18.14");
        paragraphs.add("1Chr.19.6");
        paragraphs.add("1Chr.19.16");
        paragraphs.add("1Chr.20.4");
        paragraphs.add("1Chr.21.5");
        paragraphs.add("1Chr.21.9");
        paragraphs.add("1Chr.21.14");
        paragraphs.add("1Chr.21.18");
        paragraphs.add("1Chr.21.28");
        paragraphs.add("1Chr.22.6");
        paragraphs.add("1Chr.22.17");
        paragraphs.add("1Chr.23.2");
        paragraphs.add("1Chr.23.7");
        paragraphs.add("1Chr.23.12");
        paragraphs.add("1Chr.23.21");
        paragraphs.add("1Chr.23.24");
        paragraphs.add("1Chr.24.20");
        paragraphs.add("1Chr.24.27");
        paragraphs.add("1Chr.25.8");
        paragraphs.add("1Chr.26.13");
        paragraphs.add("1Chr.26.20");
        paragraphs.add("1Chr.26.29");
        paragraphs.add("1Chr.27.16");
        paragraphs.add("1Chr.27.23");
        paragraphs.add("1Chr.27.25");
        paragraphs.add("1Chr.28.9");
        paragraphs.add("1Chr.28.11");
        paragraphs.add("1Chr.29.6");
        paragraphs.add("1Chr.29.10");
        paragraphs.add("1Chr.29.20");
        paragraphs.add("1Chr.29.26");
        paragraphs.add("2Chr.1.7");
        paragraphs.add("2Chr.1.13");
        paragraphs.add("2Chr.2.3");
        paragraphs.add("2Chr.2.11");
        paragraphs.add("2Chr.2.17");
        paragraphs.add("2Chr.3.3");
        paragraphs.add("2Chr.3.11");
        paragraphs.add("2Chr.3.14");
        paragraphs.add("2Chr.4.2");
        paragraphs.add("2Chr.4.6");
        paragraphs.add("2Chr.4.9");
        paragraphs.add("2Chr.4.19");
        paragraphs.add("2Chr.5.2");
        paragraphs.add("2Chr.5.11");
        paragraphs.add("2Chr.6.12");
        paragraphs.add("2Chr.6.22");
        paragraphs.add("2Chr.6.24");
        paragraphs.add("2Chr.6.26");
        paragraphs.add("2Chr.6.28");
        paragraphs.add("2Chr.6.32");
        paragraphs.add("2Chr.7.4");
        paragraphs.add("2Chr.7.8");
        paragraphs.add("2Chr.7.12");
        paragraphs.add("2Chr.8.7");
        paragraphs.add("2Chr.8.11");
        paragraphs.add("2Chr.8.12");
        paragraphs.add("2Chr.8.14");
        paragraphs.add("2Chr.8.17");
        paragraphs.add("2Chr.9.13");
        paragraphs.add("2Chr.9.15");
        paragraphs.add("2Chr.9.20");
        paragraphs.add("2Chr.9.23");
        paragraphs.add("2Chr.9.25");
        paragraphs.add("2Chr.9.26");
        paragraphs.add("2Chr.9.29");
        paragraphs.add("2Chr.10.6");
        paragraphs.add("2Chr.10.16");
        paragraphs.add("2Chr.11.5");
        paragraphs.add("2Chr.11.13");
        paragraphs.add("2Chr.11.18");
        paragraphs.add("2Chr.12.5");
        paragraphs.add("2Chr.12.13");
        paragraphs.add("2Chr.13.4");
        paragraphs.add("2Chr.13.13");
        paragraphs.add("2Chr.13.21");
        paragraphs.add("2Chr.14.6");
        paragraphs.add("2Chr.14.9");
        paragraphs.add("2Chr.15.16");
        paragraphs.add("2Chr.15.18");
        paragraphs.add("2Chr.16.7");
        paragraphs.add("2Chr.16.11");
        paragraphs.add("2Chr.16.13");
        paragraphs.add("2Chr.17.7");
        paragraphs.add("2Chr.17.10");
        paragraphs.add("2Chr.17.12");
        paragraphs.add("2Chr.18.4");
        paragraphs.add("2Chr.19.5");
        paragraphs.add("2Chr.19.8");
        paragraphs.add("2Chr.20.5");
        paragraphs.add("2Chr.20.14");
        paragraphs.add("2Chr.20.20");
        paragraphs.add("2Chr.20.22");
        paragraphs.add("2Chr.20.26");
        paragraphs.add("2Chr.20.31");
        paragraphs.add("2Chr.20.35");
        paragraphs.add("2Chr.21.5");
        paragraphs.add("2Chr.21.8");
        paragraphs.add("2Chr.21.12");
        paragraphs.add("2Chr.21.16");
        paragraphs.add("2Chr.21.18");
        paragraphs.add("2Chr.22.5");
        paragraphs.add("2Chr.22.10");
        paragraphs.add("2Chr.23.12");
        paragraphs.add("2Chr.23.16");
        paragraphs.add("2Chr.24.4");
        paragraphs.add("2Chr.24.15");
        paragraphs.add("2Chr.24.23");
        paragraphs.add("2Chr.24.27");
        paragraphs.add("2Chr.25.3");
        paragraphs.add("2Chr.25.5");
        paragraphs.add("2Chr.25.11");
        paragraphs.add("2Chr.25.13");
        paragraphs.add("2Chr.25.14");
        paragraphs.add("2Chr.25.17");
        paragraphs.add("2Chr.25.25");
        paragraphs.add("2Chr.25.27");
        paragraphs.add("2Chr.26.16");
        paragraphs.add("2Chr.26.22");
        paragraphs.add("2Chr.27.5");
        paragraphs.add("2Chr.27.7");
        paragraphs.add("2Chr.27.9");
        paragraphs.add("2Chr.28.6");
        paragraphs.add("2Chr.28.16");
        paragraphs.add("2Chr.28.22");
        paragraphs.add("2Chr.28.26");
        paragraphs.add("2Chr.29.3");
        paragraphs.add("2Chr.29.12");
        paragraphs.add("2Chr.29.20");
        paragraphs.add("2Chr.30.13");
        paragraphs.add("2Chr.30.27");
        paragraphs.add("2Chr.31.2");
        paragraphs.add("2Chr.31.5");
        paragraphs.add("2Chr.31.11");
        paragraphs.add("2Chr.31.20");
        paragraphs.add("2Chr.32.9");
        paragraphs.add("2Chr.32.21");
        paragraphs.add("2Chr.32.24");
        paragraphs.add("2Chr.32.27");
        paragraphs.add("2Chr.32.31");
        paragraphs.add("2Chr.32.32");
        paragraphs.add("2Chr.33.3");
        paragraphs.add("2Chr.33.11");
        paragraphs.add("2Chr.33.18");
        paragraphs.add("2Chr.33.20");
        paragraphs.add("2Chr.33.21");
        paragraphs.add("2Chr.33.25");
        paragraphs.add("2Chr.34.3");
        paragraphs.add("2Chr.34.8");
        paragraphs.add("2Chr.34.14");
        paragraphs.add("2Chr.34.23");
        paragraphs.add("2Chr.34.29");
        paragraphs.add("2Chr.35.20");
        paragraphs.add("2Chr.35.25");
        paragraphs.add("2Chr.36.5");
        paragraphs.add("2Chr.36.9");
        paragraphs.add("2Chr.36.11");
        paragraphs.add("2Chr.36.14");
        paragraphs.add("2Chr.36.22");
        paragraphs.add("Ezra.1.5");
        paragraphs.add("Ezra.1.7");
        paragraphs.add("Ezra.2.36");
        paragraphs.add("Ezra.2.40");
        paragraphs.add("Ezra.2.41");
        paragraphs.add("Ezra.2.42");
        paragraphs.add("Ezra.2.43");
        paragraphs.add("Ezra.2.55");
        paragraphs.add("Ezra.2.61");
        paragraphs.add("Ezra.2.64");
        paragraphs.add("Ezra.2.68");
        paragraphs.add("Ezra.3.8");
        paragraphs.add("Ezra.4.7");
        paragraphs.add("Ezra.4.11");
        paragraphs.add("Ezra.4.17");
        paragraphs.add("Ezra.4.23");
        paragraphs.add("Ezra.5.3");
        paragraphs.add("Ezra.5.6");
        paragraphs.add("Ezra.6.13");
        paragraphs.add("Ezra.6.16");
        paragraphs.add("Ezra.7.11");
        paragraphs.add("Ezra.7.27");
        paragraphs.add("Ezra.8.15");
        paragraphs.add("Ezra.8.21");
        paragraphs.add("Ezra.8.24");
        paragraphs.add("Ezra.8.31");
        paragraphs.add("Ezra.8.33");
        paragraphs.add("Ezra.8.36");
        paragraphs.add("Ezra.9.5");
        paragraphs.add("Ezra.10.6");
        paragraphs.add("Ezra.10.9");
        paragraphs.add("Ezra.10.15");
        paragraphs.add("Ezra.10.18");
        paragraphs.add("Neh.1.4");
        paragraphs.add("Neh.2.9");
        paragraphs.add("Neh.2.12");
        paragraphs.add("Neh.2.17");
        paragraphs.add("Neh.4.7");
        paragraphs.add("Neh.4.13");
        paragraphs.add("Neh.4.19");
        paragraphs.add("Neh.5.6");
        paragraphs.add("Neh.5.14");
        paragraphs.add("Neh.6.15");
        paragraphs.add("Neh.6.17");
        paragraphs.add("Neh.7.5");
        paragraphs.add("Neh.7.39");
        paragraphs.add("Neh.7.43");
        paragraphs.add("Neh.7.44");
        paragraphs.add("Neh.7.45");
        paragraphs.add("Neh.7.46");
        paragraphs.add("Neh.7.57");
        paragraphs.add("Neh.7.63");
        paragraphs.add("Neh.7.66");
        paragraphs.add("Neh.7.70");
        paragraphs.add("Neh.8.9");
        paragraphs.add("Neh.8.13");
        paragraphs.add("Neh.8.16");
        paragraphs.add("Neh.9.4");
        paragraphs.add("Neh.10.28");
        paragraphs.add("Neh.11.3");
        paragraphs.add("Neh.11.20");
        paragraphs.add("Neh.12.10");
        paragraphs.add("Neh.12.22");
        paragraphs.add("Neh.12.27");
        paragraphs.add("Neh.12.44");
        paragraphs.add("Neh.13.4");
        paragraphs.add("Neh.13.10");
        paragraphs.add("Neh.13.15");
        paragraphs.add("Neh.13.23");
        paragraphs.add("Esth.1.10");
        paragraphs.add("Esth.1.13");
        paragraphs.add("Esth.2.5");
        paragraphs.add("Esth.2.8");
        paragraphs.add("Esth.2.12");
        paragraphs.add("Esth.2.15");
        paragraphs.add("Esth.2.21");
        paragraphs.add("Esth.3.7");
        paragraphs.add("Esth.3.8");
        paragraphs.add("Esth.4.4");
        paragraphs.add("Esth.4.10");
        paragraphs.add("Esth.4.15");
        paragraphs.add("Esth.5.6");
        paragraphs.add("Esth.5.9");
        paragraphs.add("Esth.5.14");
        paragraphs.add("Esth.6.4");
        paragraphs.add("Esth.6.12");
        paragraphs.add("Esth.7.5");
        paragraphs.add("Esth.7.7");
        paragraphs.add("Esth.8.3");
        paragraphs.add("Esth.8.7");
        paragraphs.add("Esth.8.15");
        paragraphs.add("Esth.9.12");
        paragraphs.add("Esth.9.20");
        paragraphs.add("Job.1.6");
        paragraphs.add("Job.1.13");
        paragraphs.add("Job.2.7");
        paragraphs.add("Job.2.9");
        paragraphs.add("Job.2.11");
        paragraphs.add("Job.40.3");
        paragraphs.add("Job.40.6");
        paragraphs.add("Job.40.15");
        paragraphs.add("Job.42.7");
        paragraphs.add("Prov.1.7");
        paragraphs.add("Prov.1.10");
        paragraphs.add("Prov.1.20");
        paragraphs.add("Prov.1.24");
        paragraphs.add("Prov.2.10");
        paragraphs.add("Prov.3.5");
        paragraphs.add("Prov.3.7");
        paragraphs.add("Prov.3.11");
        paragraphs.add("Prov.3.13");
        paragraphs.add("Prov.3.21");
        paragraphs.add("Prov.3.27");
        paragraphs.add("Prov.3.30");
        paragraphs.add("Prov.3.31");
        paragraphs.add("Prov.3.33");
        paragraphs.add("Prov.4.14");
        paragraphs.add("Prov.4.20");
        paragraphs.add("Prov.4.23");
        paragraphs.add("Prov.5.3");
        paragraphs.add("Prov.5.15");
        paragraphs.add("Prov.5.22");
        paragraphs.add("Prov.6.6");
        paragraphs.add("Prov.6.12");
        paragraphs.add("Prov.6.16");
        paragraphs.add("Prov.6.20");
        paragraphs.add("Prov.7.6");
        paragraphs.add("Prov.7.24");
        paragraphs.add("Prov.9.13");
        paragraphs.add("Prov.31.10");
        paragraphs.add("Eccl.1.12");
        paragraphs.add("Eccl.2.12");
        paragraphs.add("Eccl.2.18");
        paragraphs.add("Eccl.2.24");
        paragraphs.add("Eccl.3.16");
        paragraphs.add("Eccl.4.4");
        paragraphs.add("Eccl.4.7");
        paragraphs.add("Eccl.4.9");
        paragraphs.add("Eccl.4.13");
        paragraphs.add("Eccl.5.8");
        paragraphs.add("Eccl.5.9");
        paragraphs.add("Eccl.5.18");
        paragraphs.add("Eccl.6.3");
        paragraphs.add("Eccl.6.6");
        paragraphs.add("Eccl.6.9");
        paragraphs.add("Eccl.6.11");
        paragraphs.add("Eccl.7.2");
        paragraphs.add("Eccl.7.7");
        paragraphs.add("Eccl.7.11");
        paragraphs.add("Eccl.7.23");
        paragraphs.add("Eccl.8.6");
        paragraphs.add("Eccl.8.12");
        paragraphs.add("Eccl.8.16");
        paragraphs.add("Eccl.9.4");
        paragraphs.add("Eccl.9.7");
        paragraphs.add("Eccl.9.11");
        paragraphs.add("Eccl.9.13");
        paragraphs.add("Eccl.10.16");
        paragraphs.add("Eccl.10.18");
        paragraphs.add("Eccl.10.19");
        paragraphs.add("Eccl.10.20");
        paragraphs.add("Eccl.11.7");
        paragraphs.add("Eccl.11.9");
        paragraphs.add("Eccl.12.8");
        paragraphs.add("Eccl.12.13");
        paragraphs.add("Song.1.8");
        paragraphs.add("Song.1.12");
        paragraphs.add("Song.2.8");
        paragraphs.add("Song.2.14");
        paragraphs.add("Song.2.16");
        paragraphs.add("Song.3.6");
        paragraphs.add("Song.4.8");
        paragraphs.add("Song.4.16");
        paragraphs.add("Song.5.2");
        paragraphs.add("Song.5.9");
        paragraphs.add("Song.6.4");
        paragraphs.add("Song.6.10");
        paragraphs.add("Song.7.10");
        paragraphs.add("Song.8.6");
        paragraphs.add("Song.8.8");
        paragraphs.add("Song.8.14");
        paragraphs.add("Isa.1.5");
        paragraphs.add("Isa.1.10");
        paragraphs.add("Isa.1.16");
        paragraphs.add("Isa.1.21");
        paragraphs.add("Isa.1.25");
        paragraphs.add("Isa.1.28");
        paragraphs.add("Isa.2.6");
        paragraphs.add("Isa.2.10");
        paragraphs.add("Isa.3.9");
        paragraphs.add("Isa.3.12");
        paragraphs.add("Isa.3.16");
        paragraphs.add("Isa.5.8");
        paragraphs.add("Isa.5.11");
        paragraphs.add("Isa.5.13");
        paragraphs.add("Isa.5.20");
        paragraphs.add("Isa.5.26");
        paragraphs.add("Isa.6.5");
        paragraphs.add("Isa.6.9");
        paragraphs.add("Isa.6.13");
        paragraphs.add("Isa.7.10");
        paragraphs.add("Isa.7.17");
        paragraphs.add("Isa.8.5");
        paragraphs.add("Isa.8.9");
        paragraphs.add("Isa.8.11");
        paragraphs.add("Isa.8.19");
        paragraphs.add("Isa.9.8");
        paragraphs.add("Isa.9.13");
        paragraphs.add("Isa.9.18");
        paragraphs.add("Isa.10.5");
        paragraphs.add("Isa.10.20");
        paragraphs.add("Isa.10.24");
        paragraphs.add("Isa.11.10");
        paragraphs.add("Isa.13.6");
        paragraphs.add("Isa.13.19");
        paragraphs.add("Isa.14.4");
        paragraphs.add("Isa.14.24");
        paragraphs.add("Isa.14.29");
        paragraphs.add("Isa.16.6");
        paragraphs.add("Isa.16.9");
        paragraphs.add("Isa.16.12");
        paragraphs.add("Isa.17.6");
        paragraphs.add("Isa.17.9");
        paragraphs.add("Isa.17.12");
        paragraphs.add("Isa.18.7");
        paragraphs.add("Isa.19.11");
        paragraphs.add("Isa.19.18");
        paragraphs.add("Isa.19.23");
        paragraphs.add("Isa.21.11");
        paragraphs.add("Isa.21.13");
        paragraphs.add("Isa.22.8");
        paragraphs.add("Isa.22.15");
        paragraphs.add("Isa.22.20");
        paragraphs.add("Isa.23.17");
        paragraphs.add("Isa.24.13");
        paragraphs.add("Isa.24.16");
        paragraphs.add("Isa.25.6");
        paragraphs.add("Isa.25.9");
        paragraphs.add("Isa.26.5");
        paragraphs.add("Isa.26.12");
        paragraphs.add("Isa.26.20");
        paragraphs.add("Isa.27.7");
        paragraphs.add("Isa.27.12");
        paragraphs.add("Isa.28.5");
        paragraphs.add("Isa.28.7");
        paragraphs.add("Isa.28.9");
        paragraphs.add("Isa.28.14");
        paragraphs.add("Isa.28.16");
        paragraphs.add("Isa.28.18");
        paragraphs.add("Isa.28.23");
        paragraphs.add("Isa.29.7");
        paragraphs.add("Isa.29.9");
        paragraphs.add("Isa.29.13");
        paragraphs.add("Isa.29.18");
        paragraphs.add("Isa.30.8");
        paragraphs.add("Isa.30.18");
        paragraphs.add("Isa.30.27");
        paragraphs.add("Isa.31.6");
        paragraphs.add("Isa.31.8");
        paragraphs.add("Isa.32.9");
        paragraphs.add("Isa.33.13");
        paragraphs.add("Isa.34.11");
        paragraphs.add("Isa.34.16");
        paragraphs.add("Isa.35.3");
        paragraphs.add("Isa.36.4");
        paragraphs.add("Isa.36.11");
        paragraphs.add("Isa.36.12");
        paragraphs.add("Isa.36.22");
        paragraphs.add("Isa.37.6");
        paragraphs.add("Isa.37.8");
        paragraphs.add("Isa.37.14");
        paragraphs.add("Isa.37.21");
        paragraphs.add("Isa.37.37");
        paragraphs.add("Isa.38.4");
        paragraphs.add("Isa.38.9");
        paragraphs.add("Isa.39.3");
        paragraphs.add("Isa.40.3");
        paragraphs.add("Isa.40.9");
        paragraphs.add("Isa.40.12");
        paragraphs.add("Isa.40.18");
        paragraphs.add("Isa.40.28");
        paragraphs.add("Isa.41.10");
        paragraphs.add("Isa.42.5");
        paragraphs.add("Isa.42.17");
        paragraphs.add("Isa.43.8");
        paragraphs.add("Isa.43.14");
        paragraphs.add("Isa.43.18");
        paragraphs.add("Isa.43.22");
        paragraphs.add("Isa.44.9");
        paragraphs.add("Isa.44.21");
        paragraphs.add("Isa.45.5");
        paragraphs.add("Isa.45.20");
        paragraphs.add("Isa.46.3");
        paragraphs.add("Isa.46.5");
        paragraphs.add("Isa.46.12");
        paragraphs.add("Isa.47.6");
        paragraphs.add("Isa.47.7");
        paragraphs.add("Isa.47.10");
        paragraphs.add("Isa.47.11");
        paragraphs.add("Isa.48.9");
        paragraphs.add("Isa.48.12");
        paragraphs.add("Isa.48.16");
        paragraphs.add("Isa.48.20");
        paragraphs.add("Isa.49.5");
        paragraphs.add("Isa.49.13");
        paragraphs.add("Isa.49.18");
        paragraphs.add("Isa.49.24");
        paragraphs.add("Isa.50.5");
        paragraphs.add("Isa.50.7");
        paragraphs.add("Isa.50.10");
        paragraphs.add("Isa.51.4");
        paragraphs.add("Isa.51.7");
        paragraphs.add("Isa.51.9");
        paragraphs.add("Isa.51.17");
        paragraphs.add("Isa.51.21");
        paragraphs.add("Isa.52.7");
        paragraphs.add("Isa.52.9");
        paragraphs.add("Isa.52.11");
        paragraphs.add("Isa.52.13");
        paragraphs.add("Isa.53.4");
        paragraphs.add("Isa.53.10");
        paragraphs.add("Isa.54.11");
        paragraphs.add("Isa.54.17");
        paragraphs.add("Isa.55.6");
        paragraphs.add("Isa.55.8");
        paragraphs.add("Isa.56.3");
        paragraphs.add("Isa.56.9");
        paragraphs.add("Isa.57.3");
        paragraphs.add("Isa.57.13");
        paragraphs.add("Isa.58.3");
        paragraphs.add("Isa.58.8");
        paragraphs.add("Isa.58.13");
        paragraphs.add("Isa.59.9");
        paragraphs.add("Isa.59.16");
        paragraphs.add("Isa.59.20");
        paragraphs.add("Isa.61.4");
        paragraphs.add("Isa.61.7");
        paragraphs.add("Isa.62.5");
        paragraphs.add("Isa.62.10");
        paragraphs.add("Isa.63.7");
        paragraphs.add("Isa.63.10");
        paragraphs.add("Isa.63.15");
        paragraphs.add("Isa.63.17");
        paragraphs.add("Isa.64.9");
        paragraphs.add("Isa.65.8");
        paragraphs.add("Isa.65.11");
        paragraphs.add("Isa.65.17");
        paragraphs.add("Isa.66.5");
        paragraphs.add("Jer.1.7");
        paragraphs.add("Jer.1.11");
        paragraphs.add("Jer.1.17");
        paragraphs.add("Jer.2.5");
        paragraphs.add("Jer.2.9");
        paragraphs.add("Jer.2.14");
        paragraphs.add("Jer.2.20");
        paragraphs.add("Jer.2.31");
        paragraphs.add("Jer.3.6");
        paragraphs.add("Jer.3.12");
        paragraphs.add("Jer.3.20");
        paragraphs.add("Jer.4.3");
        paragraphs.add("Jer.4.19");
        paragraphs.add("Jer.5.7");
        paragraphs.add("Jer.5.10");
        paragraphs.add("Jer.5.19");
        paragraphs.add("Jer.5.25");
        paragraphs.add("Jer.5.30");
        paragraphs.add("Jer.6.6");
        paragraphs.add("Jer.6.9");
        paragraphs.add("Jer.6.18");
        paragraphs.add("Jer.6.26");
        paragraphs.add("Jer.7.8");
        paragraphs.add("Jer.7.17");
        paragraphs.add("Jer.7.21");
        paragraphs.add("Jer.7.29");
        paragraphs.add("Jer.7.32");
        paragraphs.add("Jer.8.4");
        paragraphs.add("Jer.8.13");
        paragraphs.add("Jer.8.18");
        paragraphs.add("Jer.9.9");
        paragraphs.add("Jer.9.12");
        paragraphs.add("Jer.9.17");
        paragraphs.add("Jer.9.23");
        paragraphs.add("Jer.9.25");
        paragraphs.add("Jer.10.17");
        paragraphs.add("Jer.10.19");
        paragraphs.add("Jer.10.23");
        paragraphs.add("Jer.11.11");
        paragraphs.add("Jer.11.18");
        paragraphs.add("Jer.12.5");
        paragraphs.add("Jer.12.7");
        paragraphs.add("Jer.12.14");
        paragraphs.add("Jer.13.12");
        paragraphs.add("Jer.13.15");
        paragraphs.add("Jer.13.22");
        paragraphs.add("Jer.14.7");
        paragraphs.add("Jer.14.10");
        paragraphs.add("Jer.14.13");
        paragraphs.add("Jer.14.17");
        paragraphs.add("Jer.15.10");
        paragraphs.add("Jer.15.15");
        paragraphs.add("Jer.15.19");
        paragraphs.add("Jer.16.10");
        paragraphs.add("Jer.16.14");
        paragraphs.add("Jer.16.16");
        paragraphs.add("Jer.17.5");
        paragraphs.add("Jer.17.9");
        paragraphs.add("Jer.17.12");
        paragraphs.add("Jer.17.15");
        paragraphs.add("Jer.17.19");
        paragraphs.add("Jer.18.11");
        paragraphs.add("Jer.18.18");
        paragraphs.add("Jer.20.7");
        paragraphs.add("Jer.20.10");
        paragraphs.add("Jer.20.14");
        paragraphs.add("Jer.21.3");
        paragraphs.add("Jer.21.8");
        paragraphs.add("Jer.21.11");
        paragraphs.add("Jer.22.10");
        paragraphs.add("Jer.22.13");
        paragraphs.add("Jer.22.20");
        paragraphs.add("Jer.23.5");
        paragraphs.add("Jer.23.9");
        paragraphs.add("Jer.23.33");
        paragraphs.add("Jer.24.4");
        paragraphs.add("Jer.24.8");
        paragraphs.add("Jer.25.8");
        paragraphs.add("Jer.25.12");
        paragraphs.add("Jer.25.15");
        paragraphs.add("Jer.25.34");
        paragraphs.add("Jer.26.8");
        paragraphs.add("Jer.26.10");
        paragraphs.add("Jer.26.12");
        paragraphs.add("Jer.26.16");
        paragraphs.add("Jer.27.12");
        paragraphs.add("Jer.27.19");
        paragraphs.add("Jer.28.5");
        paragraphs.add("Jer.28.10");
        paragraphs.add("Jer.28.12");
        paragraphs.add("Jer.28.15");
        paragraphs.add("Jer.29.8");
        paragraphs.add("Jer.29.10");
        paragraphs.add("Jer.29.15");
        paragraphs.add("Jer.29.20");
        paragraphs.add("Jer.29.24");
        paragraphs.add("Jer.29.30");
        paragraphs.add("Jer.30.4");
        paragraphs.add("Jer.30.10");
        paragraphs.add("Jer.30.18");
        paragraphs.add("Jer.31.10");
        paragraphs.add("Jer.31.15");
        paragraphs.add("Jer.31.18");
        paragraphs.add("Jer.31.22");
        paragraphs.add("Jer.31.27");
        paragraphs.add("Jer.31.31");
        paragraphs.add("Jer.31.35");
        paragraphs.add("Jer.31.38");
        paragraphs.add("Jer.32.6");
        paragraphs.add("Jer.32.13");
        paragraphs.add("Jer.32.16");
        paragraphs.add("Jer.32.26");
        paragraphs.add("Jer.32.36");
        paragraphs.add("Jer.33.9");
        paragraphs.add("Jer.33.15");
        paragraphs.add("Jer.33.17");
        paragraphs.add("Jer.33.19");
        paragraphs.add("Jer.34.8");
        paragraphs.add("Jer.34.12");
        paragraphs.add("Jer.35.12");
        paragraphs.add("Jer.35.18");
        paragraphs.add("Jer.36.11");
        paragraphs.add("Jer.36.20");
        paragraphs.add("Jer.36.27");
        paragraphs.add("Jer.36.32");
        paragraphs.add("Jer.37.6");
        paragraphs.add("Jer.37.11");
        paragraphs.add("Jer.37.16");
        paragraphs.add("Jer.38.7");
        paragraphs.add("Jer.38.14");
        paragraphs.add("Jer.38.24");
        paragraphs.add("Jer.39.4");
        paragraphs.add("Jer.39.8");
        paragraphs.add("Jer.39.11");
        paragraphs.add("Jer.39.15");
        paragraphs.add("Jer.40.7");
        paragraphs.add("Jer.40.13");
        paragraphs.add("Jer.41.11");
        paragraphs.add("Jer.42.7");
        paragraphs.add("Jer.42.13");
        paragraphs.add("Jer.42.19");
        paragraphs.add("Jer.43.8");
        paragraphs.add("Jer.44.11");
        paragraphs.add("Jer.44.15");
        paragraphs.add("Jer.44.20");
        paragraphs.add("Jer.44.29");
        paragraphs.add("Jer.45.4");
        paragraphs.add("Jer.46.13");
        paragraphs.add("Jer.46.27");
        paragraphs.add("Jer.48.7");
        paragraphs.add("Jer.48.11");
        paragraphs.add("Jer.48.14");
        paragraphs.add("Jer.48.26");
        paragraphs.add("Jer.48.47");
        paragraphs.add("Jer.49.7");
        paragraphs.add("Jer.49.23");
        paragraphs.add("Jer.49.28");
        paragraphs.add("Jer.49.30");
        paragraphs.add("Jer.49.34");
        paragraphs.add("Jer.49.39");
        paragraphs.add("Jer.50.4");
        paragraphs.add("Jer.50.9");
        paragraphs.add("Jer.50.17");
        paragraphs.add("Jer.50.21");
        paragraphs.add("Jer.50.33");
        paragraphs.add("Jer.50.35");
        paragraphs.add("Jer.51.59");
        paragraphs.add("Jer.52.4");
        paragraphs.add("Jer.52.8");
        paragraphs.add("Jer.52.12");
        paragraphs.add("Jer.52.24");
        paragraphs.add("Jer.52.31");
        paragraphs.add("Lam.1.12");
        paragraphs.add("Lam.1.18");
        paragraphs.add("Lam.2.20");
        paragraphs.add("Lam.3.22");
        paragraphs.add("Lam.3.37");
        paragraphs.add("Lam.3.55");
        paragraphs.add("Lam.3.64");
        paragraphs.add("Lam.4.13");
        paragraphs.add("Lam.4.21");
        paragraphs.add("Lam.4.22");
        paragraphs.add("Ezek.1.4");
        paragraphs.add("Ezek.1.15");
        paragraphs.add("Ezek.1.26");
        paragraphs.add("Ezek.2.6");
        paragraphs.add("Ezek.2.9");
        paragraphs.add("Ezek.3.4");
        paragraphs.add("Ezek.3.15");
        paragraphs.add("Ezek.3.22");
        paragraphs.add("Ezek.4.9");
        paragraphs.add("Ezek.5.5");
        paragraphs.add("Ezek.5.12");
        paragraphs.add("Ezek.6.8");
        paragraphs.add("Ezek.6.11");
        paragraphs.add("Ezek.7.16");
        paragraphs.add("Ezek.7.20");
        paragraphs.add("Ezek.7.23");
        paragraphs.add("Ezek.8.5");
        paragraphs.add("Ezek.8.7");
        paragraphs.add("Ezek.8.13");
        paragraphs.add("Ezek.8.15");
        paragraphs.add("Ezek.8.17");
        paragraphs.add("Ezek.9.5");
        paragraphs.add("Ezek.9.8");
        paragraphs.add("Ezek.10.8");
        paragraphs.add("Ezek.11.4");
        paragraphs.add("Ezek.11.13");
        paragraphs.add("Ezek.11.22");
        paragraphs.add("Ezek.11.24");
        paragraphs.add("Ezek.12.8");
        paragraphs.add("Ezek.12.17");
        paragraphs.add("Ezek.12.21");
        paragraphs.add("Ezek.12.26");
        paragraphs.add("Ezek.13.10");
        paragraphs.add("Ezek.13.17");
        paragraphs.add("Ezek.14.6");
        paragraphs.add("Ezek.14.12");
        paragraphs.add("Ezek.14.15");
        paragraphs.add("Ezek.14.17");
        paragraphs.add("Ezek.14.19");
        paragraphs.add("Ezek.14.22");
        paragraphs.add("Ezek.15.6");
        paragraphs.add("Ezek.16.6");
        paragraphs.add("Ezek.16.15");
        paragraphs.add("Ezek.16.35");
        paragraphs.add("Ezek.16.44");
        paragraphs.add("Ezek.16.60");
        paragraphs.add("Ezek.17.11");
        paragraphs.add("Ezek.17.22");
        paragraphs.add("Ezek.18.5");
        paragraphs.add("Ezek.18.10");
        paragraphs.add("Ezek.18.14");
        paragraphs.add("Ezek.18.19");
        paragraphs.add("Ezek.18.24");
        paragraphs.add("Ezek.18.25");
        paragraphs.add("Ezek.18.31");
        paragraphs.add("Ezek.19.10");
        paragraphs.add("Ezek.20.5");
        paragraphs.add("Ezek.20.10");
        paragraphs.add("Ezek.20.27");
        paragraphs.add("Ezek.20.33");
        paragraphs.add("Ezek.20.45");
        paragraphs.add("Ezek.21.8");
        paragraphs.add("Ezek.21.18");
        paragraphs.add("Ezek.21.25");
        paragraphs.add("Ezek.21.28");
        paragraphs.add("Ezek.22.13");
        paragraphs.add("Ezek.22.23");
        paragraphs.add("Ezek.23.22");
        paragraphs.add("Ezek.23.36");
        paragraphs.add("Ezek.23.45");
        paragraphs.add("Ezek.24.6");
        paragraphs.add("Ezek.24.15");
        paragraphs.add("Ezek.24.19");
        paragraphs.add("Ezek.25.8");
        paragraphs.add("Ezek.25.12");
        paragraphs.add("Ezek.25.15");
        paragraphs.add("Ezek.26.7");
        paragraphs.add("Ezek.26.15");
        paragraphs.add("Ezek.27.26");
        paragraphs.add("Ezek.28.11");
        paragraphs.add("Ezek.28.20");
        paragraphs.add("Ezek.28.24");
        paragraphs.add("Ezek.29.8");
        paragraphs.add("Ezek.29.13");
        paragraphs.add("Ezek.29.17");
        paragraphs.add("Ezek.29.21");
        paragraphs.add("Ezek.30.20");
        paragraphs.add("Ezek.31.3");
        paragraphs.add("Ezek.31.10");
        paragraphs.add("Ezek.31.18");
        paragraphs.add("Ezek.32.11");
        paragraphs.add("Ezek.32.17");
        paragraphs.add("Ezek.33.7");
        paragraphs.add("Ezek.33.17");
        paragraphs.add("Ezek.33.20");
        paragraphs.add("Ezek.33.21");
        paragraphs.add("Ezek.33.30");
        paragraphs.add("Ezek.34.7");
        paragraphs.add("Ezek.34.11");
        paragraphs.add("Ezek.34.20");
        paragraphs.add("Ezek.36.8");
        paragraphs.add("Ezek.36.16");
        paragraphs.add("Ezek.36.21");
        paragraphs.add("Ezek.36.25");
        paragraphs.add("Ezek.37.11");
        paragraphs.add("Ezek.37.15");
        paragraphs.add("Ezek.37.18");
        paragraphs.add("Ezek.37.20");
        paragraphs.add("Ezek.38.8");
        paragraphs.add("Ezek.38.14");
        paragraphs.add("Ezek.39.8");
        paragraphs.add("Ezek.39.11");
        paragraphs.add("Ezek.39.17");
        paragraphs.add("Ezek.39.23");
        paragraphs.add("Ezek.40.6");
        paragraphs.add("Ezek.40.20");
        paragraphs.add("Ezek.40.24");
        paragraphs.add("Ezek.40.32");
        paragraphs.add("Ezek.40.35");
        paragraphs.add("Ezek.40.39");
        paragraphs.add("Ezek.40.44");
        paragraphs.add("Ezek.40.48");
        paragraphs.add("Ezek.42.13");
        paragraphs.add("Ezek.42.19");
        paragraphs.add("Ezek.43.7");
        paragraphs.add("Ezek.43.10");
        paragraphs.add("Ezek.43.13");
        paragraphs.add("Ezek.43.18");
        paragraphs.add("Ezek.44.4");
        paragraphs.add("Ezek.44.9");
        paragraphs.add("Ezek.44.15");
        paragraphs.add("Ezek.44.17");
        paragraphs.add("Ezek.45.6");
        paragraphs.add("Ezek.45.7");
        paragraphs.add("Ezek.45.9");
        paragraphs.add("Ezek.46.9");
        paragraphs.add("Ezek.46.16");
        paragraphs.add("Ezek.46.19");
        paragraphs.add("Ezek.47.6");
        paragraphs.add("Ezek.47.13");
        paragraphs.add("Ezek.47.22");
        paragraphs.add("Ezek.48.8");
        paragraphs.add("Ezek.48.15");
        paragraphs.add("Ezek.48.21");
        paragraphs.add("Ezek.48.30");
        paragraphs.add("Dan.1.3");
        paragraphs.add("Dan.1.8");
        paragraphs.add("Dan.1.17");
        paragraphs.add("Dan.2.10");
        paragraphs.add("Dan.2.14");
        paragraphs.add("Dan.2.19");
        paragraphs.add("Dan.2.24");
        paragraphs.add("Dan.2.31");
        paragraphs.add("Dan.2.36");
        paragraphs.add("Dan.2.46");
        paragraphs.add("Dan.3.8");
        paragraphs.add("Dan.3.13");
        paragraphs.add("Dan.3.19");
        paragraphs.add("Dan.3.26");
        paragraphs.add("Dan.4.4");
        paragraphs.add("Dan.4.8");
        paragraphs.add("Dan.4.19");
        paragraphs.add("Dan.4.28");
        paragraphs.add("Dan.5.5");
        paragraphs.add("Dan.5.10");
        paragraphs.add("Dan.5.17");
        paragraphs.add("Dan.5.25");
        paragraphs.add("Dan.5.30");
        paragraphs.add("Dan.6.4");
        paragraphs.add("Dan.6.10");
        paragraphs.add("Dan.6.18");
        paragraphs.add("Dan.6.24");
        paragraphs.add("Dan.6.25");
        paragraphs.add("Dan.7.9");
        paragraphs.add("Dan.7.15");
        paragraphs.add("Dan.8.13");
        paragraphs.add("Dan.8.15");
        paragraphs.add("Dan.9.3");
        paragraphs.add("Dan.9.16");
        paragraphs.add("Dan.9.20");
        paragraphs.add("Dan.10.10");
        paragraphs.add("Dan.11.5");
        paragraphs.add("Dan.11.30");
        paragraphs.add("Dan.12.5");
        paragraphs.add("Hos.1.6");
        paragraphs.add("Hos.1.8");
        paragraphs.add("Hos.1.10");
        paragraphs.add("Hos.2.6");
        paragraphs.add("Hos.2.14");
        paragraphs.add("Hos.4.6");
        paragraphs.add("Hos.4.12");
        paragraphs.add("Hos.4.15");
        paragraphs.add("Hos.5.15");
        paragraphs.add("Hos.6.4");
        paragraphs.add("Hos.7.11");
        paragraphs.add("Hos.8.5");
        paragraphs.add("Hos.11.5");
        paragraphs.add("Hos.12.3");
        paragraphs.add("Hos.12.7");
        paragraphs.add("Hos.13.5");
        paragraphs.add("Hos.13.9");
        paragraphs.add("Hos.13.15");
        paragraphs.add("Hos.14.4");
        paragraphs.add("Joel.1.8");
        paragraphs.add("Joel.1.14");
        paragraphs.add("Joel.2.12");
        paragraphs.add("Joel.2.15");
        paragraphs.add("Joel.2.18");
        paragraphs.add("Joel.2.21");
        paragraphs.add("Joel.2.28");
        paragraphs.add("Joel.3.9");
        paragraphs.add("Joel.3.18");
        paragraphs.add("Amos.1.6");
        paragraphs.add("Amos.1.9");
        paragraphs.add("Amos.1.11");
        paragraphs.add("Amos.1.13");
        paragraphs.add("Amos.2.4");
        paragraphs.add("Amos.2.6");
        paragraphs.add("Amos.2.9");
        paragraphs.add("Amos.3.9");
        paragraphs.add("Amos.4.4");
        paragraphs.add("Amos.4.6");
        paragraphs.add("Amos.5.4");
        paragraphs.add("Amos.5.21");
        paragraphs.add("Amos.6.7");
        paragraphs.add("Amos.6.12");
        paragraphs.add("Amos.7.4");
        paragraphs.add("Amos.7.7");
        paragraphs.add("Amos.7.10");
        paragraphs.add("Amos.7.14");
        paragraphs.add("Amos.7.16");
        paragraphs.add("Amos.8.4");
        paragraphs.add("Amos.8.11");
        paragraphs.add("Amos.9.11");
        paragraphs.add("Obad.1.3");
        paragraphs.add("Obad.1.10");
        paragraphs.add("Obad.1.17");
        paragraphs.add("Jonah.1.4");
        paragraphs.add("Jonah.1.11");
        paragraphs.add("Jonah.1.17");
        paragraphs.add("Jonah.2.10");
        paragraphs.add("Jonah.3.5");
        paragraphs.add("Jonah.3.10");
        paragraphs.add("Jonah.4.4");
        paragraphs.add("Mic.1.10");
        paragraphs.add("Mic.2.4");
        paragraphs.add("Mic.2.7");
        paragraphs.add("Mic.2.12");
        paragraphs.add("Mic.3.5");
        paragraphs.add("Mic.3.8");
        paragraphs.add("Mic.4.3");
        paragraphs.add("Mic.4.8");
        paragraphs.add("Mic.4.11");
        paragraphs.add("Mic.5.4");
        paragraphs.add("Mic.5.8");
        paragraphs.add("Mic.6.6");
        paragraphs.add("Mic.6.10");
        paragraphs.add("Mic.6.16");
        paragraphs.add("Mic.7.3");
        paragraphs.add("Mic.7.5");
        paragraphs.add("Mic.7.8");
        paragraphs.add("Mic.7.14");
        paragraphs.add("Mic.7.16");
        paragraphs.add("Hab.1.5");
        paragraphs.add("Hab.1.12");
        paragraphs.add("Hab.2.5");
        paragraphs.add("Hab.2.9");
        paragraphs.add("Hab.2.12");
        paragraphs.add("Hab.2.15");
        paragraphs.add("Hab.2.18");
        paragraphs.add("Hab.3.17");
        paragraphs.add("Zeph.2.4");
        paragraphs.add("Zeph.2.8");
        paragraphs.add("Zeph.2.12");
        paragraphs.add("Zeph.3.8");
        paragraphs.add("Zeph.3.14");
        paragraphs.add("Hag.1.7");
        paragraphs.add("Hag.1.12");
        paragraphs.add("Hag.2.10");
        paragraphs.add("Hag.2.20");
        paragraphs.add("Zech.1.7");
        paragraphs.add("Zech.1.12");
        paragraphs.add("Zech.1.18");
        paragraphs.add("Zech.2.6");
        paragraphs.add("Zech.2.10");
        paragraphs.add("Zech.4.11");
        paragraphs.add("Zech.5.5");
        paragraphs.add("Zech.6.9");
        paragraphs.add("Zech.7.4");
        paragraphs.add("Zech.7.8");
        paragraphs.add("Zech.8.9");
        paragraphs.add("Zech.8.16");
        paragraphs.add("Zech.8.18");
        paragraphs.add("Zech.9.9");
        paragraphs.add("Zech.9.12");
        paragraphs.add("Zech.10.5");
        paragraphs.add("Zech.11.3");
        paragraphs.add("Zech.11.10");
        paragraphs.add("Zech.11.15");
        paragraphs.add("Zech.12.3");
        paragraphs.add("Zech.12.6");
        paragraphs.add("Zech.12.9");
        paragraphs.add("Zech.13.2");
        paragraphs.add("Zech.13.7");
        paragraphs.add("Zech.14.4");
        paragraphs.add("Zech.14.12");
        paragraphs.add("Zech.14.16");
        paragraphs.add("Zech.14.20");
        paragraphs.add("Mal.1.6");
        paragraphs.add("Mal.1.12");
        paragraphs.add("Mal.2.11");
        paragraphs.add("Mal.2.14");
        paragraphs.add("Mal.2.17");
        paragraphs.add("Mal.3.7");
        paragraphs.add("Mal.3.8");
        paragraphs.add("Mal.3.13");
        paragraphs.add("Mal.3.16");
        paragraphs.add("Mal.4.2");
        paragraphs.add("Mal.4.4");
        paragraphs.add("Mal.4.5");
        paragraphs.add("Matt.1.18");
        paragraphs.add("Matt.2.11");
        paragraphs.add("Matt.2.16");
        paragraphs.add("Matt.2.19");
        paragraphs.add("Matt.3.7");
        paragraphs.add("Matt.3.13");
        paragraphs.add("Matt.4.12");
        paragraphs.add("Matt.4.17");
        paragraphs.add("Matt.4.18");
        paragraphs.add("Matt.4.23");
        paragraphs.add("Matt.5.13");
        paragraphs.add("Matt.5.17");
        paragraphs.add("Matt.5.21");
        paragraphs.add("Matt.5.27");
        paragraphs.add("Matt.5.33");
        paragraphs.add("Matt.5.38");
        paragraphs.add("Matt.5.43");
        paragraphs.add("Matt.6.5");
        paragraphs.add("Matt.6.16");
        paragraphs.add("Matt.6.19");
        paragraphs.add("Matt.6.24");
        paragraphs.add("Matt.7.6");
        paragraphs.add("Matt.7.7");
        paragraphs.add("Matt.7.13");
        paragraphs.add("Matt.7.15");
        paragraphs.add("Matt.7.21");
        paragraphs.add("Matt.7.24");
        paragraphs.add("Matt.8.5");
        paragraphs.add("Matt.8.14");
        paragraphs.add("Matt.8.16");
        paragraphs.add("Matt.8.18");
        paragraphs.add("Matt.8.23");
        paragraphs.add("Matt.8.28");
        paragraphs.add("Matt.9.9");
        paragraphs.add("Matt.9.10");
        paragraphs.add("Matt.9.14");
        paragraphs.add("Matt.9.18");
        paragraphs.add("Matt.9.20");
        paragraphs.add("Matt.9.27");
        paragraphs.add("Matt.9.32");
        paragraphs.add("Matt.9.36");
        paragraphs.add("Matt.10.16");
        paragraphs.add("Matt.10.40");
        paragraphs.add("Matt.11.7");
        paragraphs.add("Matt.11.16");
        paragraphs.add("Matt.11.20");
        paragraphs.add("Matt.11.25");
        paragraphs.add("Matt.11.28");
        paragraphs.add("Matt.12.10");
        paragraphs.add("Matt.12.14");
        paragraphs.add("Matt.12.22");
        paragraphs.add("Matt.12.31");
        paragraphs.add("Matt.12.38");
        paragraphs.add("Matt.12.46");
        paragraphs.add("Matt.13.18");
        paragraphs.add("Matt.13.24");
        paragraphs.add("Matt.13.31");
        paragraphs.add("Matt.13.33");
        paragraphs.add("Matt.13.44");
        paragraphs.add("Matt.13.45");
        paragraphs.add("Matt.13.47");
        paragraphs.add("Matt.13.53");
        paragraphs.add("Matt.14.3");
        paragraphs.add("Matt.14.13");
        paragraphs.add("Matt.14.15");
        paragraphs.add("Matt.14.22");
        paragraphs.add("Matt.14.34");
        paragraphs.add("Matt.15.10");
        paragraphs.add("Matt.15.21");
        paragraphs.add("Matt.15.32");
        paragraphs.add("Matt.16.6");
        paragraphs.add("Matt.16.13");
        paragraphs.add("Matt.16.21");
        paragraphs.add("Matt.16.24");
        paragraphs.add("Matt.17.14");
        paragraphs.add("Matt.17.22");
        paragraphs.add("Matt.17.24");
        paragraphs.add("Matt.18.7");
        paragraphs.add("Matt.18.15");
        paragraphs.add("Matt.18.21");
        paragraphs.add("Matt.18.23");
        paragraphs.add("Matt.19.3");
        paragraphs.add("Matt.19.10");
        paragraphs.add("Matt.19.13");
        paragraphs.add("Matt.19.16");
        paragraphs.add("Matt.19.23");
        paragraphs.add("Matt.19.27");
        paragraphs.add("Matt.20.17");
        paragraphs.add("Matt.20.20");
        paragraphs.add("Matt.20.30");
        paragraphs.add("Matt.21.12");
        paragraphs.add("Matt.21.17");
        paragraphs.add("Matt.21.23");
        paragraphs.add("Matt.21.28");
        paragraphs.add("Matt.21.33");
        paragraphs.add("Matt.22.11");
        paragraphs.add("Matt.22.15");
        paragraphs.add("Matt.22.23");
        paragraphs.add("Matt.22.34");
        paragraphs.add("Matt.22.41");
        paragraphs.add("Matt.23.13");
        paragraphs.add("Matt.23.34");
        paragraphs.add("Matt.24.3");
        paragraphs.add("Matt.24.29");
        paragraphs.add("Matt.24.36");
        paragraphs.add("Matt.24.42");
        paragraphs.add("Matt.25.14");
        paragraphs.add("Matt.25.31");
        paragraphs.add("Matt.26.6");
        paragraphs.add("Matt.26.14");
        paragraphs.add("Matt.26.17");
        paragraphs.add("Matt.26.26");
        paragraphs.add("Matt.26.36");
        paragraphs.add("Matt.26.47");
        paragraphs.add("Matt.26.57");
        paragraphs.add("Matt.26.69");
        paragraphs.add("Matt.27.3");
        paragraphs.add("Matt.27.19");
        paragraphs.add("Matt.27.24");
        paragraphs.add("Matt.27.26");
        paragraphs.add("Matt.27.29");
        paragraphs.add("Matt.27.34");
        paragraphs.add("Matt.27.39");
        paragraphs.add("Matt.27.50");
        paragraphs.add("Matt.27.62");
        paragraphs.add("Matt.28.9");
        paragraphs.add("Matt.28.11");
        paragraphs.add("Matt.28.16");
        paragraphs.add("Matt.28.19");
        paragraphs.add("Mark.3.22");
        paragraphs.add("Mark.3.31");
        paragraphs.add("Mark.4.14");
        paragraphs.add("Mark.4.21");
        paragraphs.add("Mark.4.26");
        paragraphs.add("Mark.4.30");
        paragraphs.add("Mark.6.7");
        paragraphs.add("Mark.7.14");
        paragraphs.add("Mark.7.24");
        paragraphs.add("Mark.7.31");
        paragraphs.add("Mark.8.10");
        paragraphs.add("Mark.8.14");
        paragraphs.add("Mark.8.22");
        paragraphs.add("Mark.8.27");
        paragraphs.add("Mark.8.34");
        paragraphs.add("Mark.9.2");
        paragraphs.add("Mark.9.11");
        paragraphs.add("Mark.9.14");
        paragraphs.add("Mark.9.30");
        paragraphs.add("Mark.9.33");
        paragraphs.add("Mark.9.38");
        paragraphs.add("Mark.10.2");
        paragraphs.add("Mark.10.13");
        paragraphs.add("Mark.10.17");
        paragraphs.add("Mark.10.23");
        paragraphs.add("Mark.10.28");
        paragraphs.add("Mark.10.32");
        paragraphs.add("Mark.10.35");
        paragraphs.add("Mark.10.46");
        paragraphs.add("Mark.11.12");
        paragraphs.add("Mark.11.15");
        paragraphs.add("Mark.11.20");
        paragraphs.add("Mark.11.27");
        paragraphs.add("Mark.12.13");
        paragraphs.add("Mark.12.18");
        paragraphs.add("Mark.12.28");
        paragraphs.add("Mark.12.35");
        paragraphs.add("Mark.12.38");
        paragraphs.add("Mark.12.41");
        paragraphs.add("Mark.13.9");
        paragraphs.add("Mark.13.14");
        paragraphs.add("Mark.13.24");
        paragraphs.add("Mark.13.32");
        paragraphs.add("Mark.14.3");
        paragraphs.add("Mark.14.10");
        paragraphs.add("Mark.14.12");
        paragraphs.add("Mark.14.22");
        paragraphs.add("Mark.14.26");
        paragraphs.add("Mark.14.43");
        paragraphs.add("Mark.14.46");
        paragraphs.add("Mark.14.53");
        paragraphs.add("Mark.14.66");
        paragraphs.add("Mark.15.15");
        paragraphs.add("Mark.15.39");
        paragraphs.add("Mark.15.42");
        paragraphs.add("Mark.16.9");
        paragraphs.add("Mark.16.12");
        paragraphs.add("Mark.16.14");
        paragraphs.add("Mark.16.19");
        paragraphs.add("Luke.1.5");
        paragraphs.add("Luke.4.14");
        paragraphs.add("Luke.4.16");
        paragraphs.add("Luke.4.33");
        paragraphs.add("Luke.4.38");
        paragraphs.add("Luke.4.40");
        paragraphs.add("Luke.5.12");
        paragraphs.add("Luke.5.16");
        paragraphs.add("Luke.5.18");
        paragraphs.add("Luke.5.27");
        paragraphs.add("Luke.5.33");
        paragraphs.add("Luke.5.36");
        paragraphs.add("Luke.6.13");
        paragraphs.add("Luke.6.17");
        paragraphs.add("Luke.6.20");
        paragraphs.add("Luke.6.27");
        paragraphs.add("Luke.6.46");
        paragraphs.add("Luke.7.11");
        paragraphs.add("Luke.7.19");
        paragraphs.add("Luke.7.24");
        paragraphs.add("Luke.7.31");
        paragraphs.add("Luke.7.36");
        paragraphs.add("Luke.8.4");
        paragraphs.add("Luke.8.16");
        paragraphs.add("Luke.8.19");
        paragraphs.add("Luke.8.22");
        paragraphs.add("Luke.8.26");
        paragraphs.add("Luke.8.37");
        paragraphs.add("Luke.8.41");
        paragraphs.add("Luke.8.43");
        paragraphs.add("Luke.8.49");
        paragraphs.add("Luke.9.7");
        paragraphs.add("Luke.9.10");
        paragraphs.add("Luke.9.18");
        paragraphs.add("Luke.9.23");
        paragraphs.add("Luke.9.28");
        paragraphs.add("Luke.9.37");
        paragraphs.add("Luke.9.43");
        paragraphs.add("Luke.9.46");
        paragraphs.add("Luke.9.49");
        paragraphs.add("Luke.9.51");
        paragraphs.add("Luke.9.57");
        paragraphs.add("Luke.10.17");
        paragraphs.add("Luke.10.21");
        paragraphs.add("Luke.10.23");
        paragraphs.add("Luke.10.25");
        paragraphs.add("Luke.10.38");
        paragraphs.add("Luke.11.14");
        paragraphs.add("Luke.11.27");
        paragraphs.add("Luke.11.29");
        paragraphs.add("Luke.11.37");
        paragraphs.add("Luke.11.45");
        paragraphs.add("Luke.12.13");
        paragraphs.add("Luke.12.22");
        paragraphs.add("Luke.12.31");
        paragraphs.add("Luke.12.41");
        paragraphs.add("Luke.12.49");
        paragraphs.add("Luke.12.54");
        paragraphs.add("Luke.12.58");
        paragraphs.add("Luke.13.6");
        paragraphs.add("Luke.13.11");
        paragraphs.add("Luke.13.18");
        paragraphs.add("Luke.13.24");
        paragraphs.add("Luke.13.31");
        paragraphs.add("Luke.14.7");
        paragraphs.add("Luke.14.12");
        paragraphs.add("Luke.14.15");
        paragraphs.add("Luke.14.25");
        paragraphs.add("Luke.14.34");
        paragraphs.add("Luke.15.3");
        paragraphs.add("Luke.15.8");
        paragraphs.add("Luke.15.11");
        paragraphs.add("Luke.16.13");
        paragraphs.add("Luke.16.19");
        paragraphs.add("Luke.17.3");
        paragraphs.add("Luke.17.11");
        paragraphs.add("Luke.17.20");
        paragraphs.add("Luke.18.31");
        paragraphs.add("Luke.18.35");
        paragraphs.add("Luke.19.28");
        paragraphs.add("Luke.19.41");
        paragraphs.add("Luke.20.19");
        paragraphs.add("Luke.20.27");
        paragraphs.add("Luke.20.39");
        paragraphs.add("Luke.20.45");
        paragraphs.add("Luke.21.5");
        paragraphs.add("Luke.21.25");
        paragraphs.add("Luke.21.34");
        paragraphs.add("Luke.22.3");
        paragraphs.add("Luke.22.7");
        paragraphs.add("Luke.22.19");
        paragraphs.add("Luke.22.21");
        paragraphs.add("Luke.22.24");
        paragraphs.add("Luke.22.31");
        paragraphs.add("Luke.22.39");
        paragraphs.add("Luke.22.47");
        paragraphs.add("Luke.22.50");
        paragraphs.add("Luke.22.54");
        paragraphs.add("Luke.22.63");
        paragraphs.add("Luke.22.66");
        paragraphs.add("Luke.23.8");
        paragraphs.add("Luke.23.12");
        paragraphs.add("Luke.23.13");
        paragraphs.add("Luke.23.27");
        paragraphs.add("Luke.23.34");
        paragraphs.add("Luke.23.39");
        paragraphs.add("Luke.23.46");
        paragraphs.add("Luke.23.50");
        paragraphs.add("Luke.24.13");
        paragraphs.add("Luke.24.36");
        paragraphs.add("Luke.24.49");
        paragraphs.add("Luke.24.50");
        paragraphs.add("John.1.6");
        paragraphs.add("John.1.15");
        paragraphs.add("John.1.19");
        paragraphs.add("John.1.29");
        paragraphs.add("John.1.35");
        paragraphs.add("John.1.43");
        paragraphs.add("John.2.12");
        paragraphs.add("John.2.13");
        paragraphs.add("John.2.18");
        paragraphs.add("John.2.23");
        paragraphs.add("John.3.14");
        paragraphs.add("John.3.16");
        paragraphs.add("John.3.18");
        paragraphs.add("John.3.22");
        paragraphs.add("John.3.23");
        paragraphs.add("John.3.25");
        paragraphs.add("John.4.27");
        paragraphs.add("John.4.31");
        paragraphs.add("John.4.39");
        paragraphs.add("John.4.43");
        paragraphs.add("John.5.10");
        paragraphs.add("John.5.17");
        paragraphs.add("John.5.32");
        paragraphs.add("John.5.36");
        paragraphs.add("John.5.39");
        paragraphs.add("John.6.5");
        paragraphs.add("John.6.15");
        paragraphs.add("John.6.22");
        paragraphs.add("John.6.66");
        paragraphs.add("John.7.10");
        paragraphs.add("John.7.14");
        paragraphs.add("John.7.32");
        paragraphs.add("John.7.40");
        paragraphs.add("John.7.45");
        paragraphs.add("John.8.12");
        paragraphs.add("John.8.33");
        paragraphs.add("John.9.8");
        paragraphs.add("John.9.13");
        paragraphs.add("John.9.39");
        paragraphs.add("John.10.19");
        paragraphs.add("John.10.22");
        paragraphs.add("John.11.47");
        paragraphs.add("John.11.55");
        paragraphs.add("John.12.10");
        paragraphs.add("John.12.12");
        paragraphs.add("John.12.20");
        paragraphs.add("John.12.23");
        paragraphs.add("John.12.37");
        paragraphs.add("John.12.42");
        paragraphs.add("John.12.44");
        paragraphs.add("John.13.18");
        paragraphs.add("John.13.31");
        paragraphs.add("John.13.36");
        paragraphs.add("John.14.15");
        paragraphs.add("John.18.15");
        paragraphs.add("John.18.19");
        paragraphs.add("John.18.28");
        paragraphs.add("John.19.8");
        paragraphs.add("John.19.13");
        paragraphs.add("John.19.19");
        paragraphs.add("John.19.23");
        paragraphs.add("John.19.25");
        paragraphs.add("John.19.28");
        paragraphs.add("John.19.38");
        paragraphs.add("John.20.11");
        paragraphs.add("John.20.19");
        paragraphs.add("John.20.24");
        paragraphs.add("John.20.26");
        paragraphs.add("John.20.30");
        paragraphs.add("John.21.15");
        paragraphs.add("Acts.1.15");
        paragraphs.add("Acts.2.14");
        paragraphs.add("Acts.2.37");
        paragraphs.add("Acts.2.41");
        paragraphs.add("Acts.3.12");
        paragraphs.add("Acts.3.19");
        paragraphs.add("Acts.4.5");
        paragraphs.add("Acts.4.13");
        paragraphs.add("Acts.4.23");
        paragraphs.add("Acts.4.31");
        paragraphs.add("Acts.5.12");
        paragraphs.add("Acts.5.17");
        paragraphs.add("Acts.5.29");
        paragraphs.add("Acts.5.33");
        paragraphs.add("Acts.5.41");
        paragraphs.add("Acts.6.5");
        paragraphs.add("Acts.6.9");
        paragraphs.add("Acts.7.37");
        paragraphs.add("Acts.7.51");
        paragraphs.add("Acts.7.54");
        paragraphs.add("Acts.9.10");
        paragraphs.add("Acts.9.23");
        paragraphs.add("Acts.9.32");
        paragraphs.add("Acts.9.36");
        paragraphs.add("Acts.10.9");
        paragraphs.add("Acts.10.19");
        paragraphs.add("Acts.10.34");
        paragraphs.add("Acts.10.44");
        paragraphs.add("Acts.11.19");
        paragraphs.add("Acts.11.22");
        paragraphs.add("Acts.11.27");
        paragraphs.add("Acts.12.20");
        paragraphs.add("Acts.12.24");
        paragraphs.add("Acts.13.4");
        paragraphs.add("Acts.13.14");
        paragraphs.add("Acts.13.38");
        paragraphs.add("Acts.13.44");
        paragraphs.add("Acts.14.8");
        paragraphs.add("Acts.14.19");
        paragraphs.add("Acts.15.6");
        paragraphs.add("Acts.15.12");
        paragraphs.add("Acts.15.13");
        paragraphs.add("Acts.15.36");
        paragraphs.add("Acts.16.14");
        paragraphs.add("Acts.16.16");
        paragraphs.add("Acts.16.19");
        paragraphs.add("Acts.16.25");
        paragraphs.add("Acts.17.5");
        paragraphs.add("Acts.17.10");
        paragraphs.add("Acts.17.16");
        paragraphs.add("Acts.17.22");
        paragraphs.add("Acts.17.32");
        paragraphs.add("Acts.18.7");
        paragraphs.add("Acts.18.12");
        paragraphs.add("Acts.18.18");
        paragraphs.add("Acts.18.24");
        paragraphs.add("Acts.19.13");
        paragraphs.add("Acts.19.21");
        paragraphs.add("Acts.20.13");
        paragraphs.add("Acts.20.17");
        paragraphs.add("Acts.20.28");
        paragraphs.add("Acts.20.36");
    }
}

