/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.ArrayList;
import java.util.Iterator;
import org.crosswire.common.util.StringUtil;

public final class SentenceUtil {
    private SentenceUtil() {
    }

    public static String[] tokenize(String sentence) {
        ArrayList<String> tokens = new ArrayList<String>();
        int pos = 0;
        boolean alive = true;
        while (alive) {
            String temp;
            int nextDDash;
            int nextSpace = sentence.indexOf(" ", pos);
            if (nextSpace == (nextDDash = sentence.indexOf("--", pos)) + 2) {
                nextDDash = -1;
            }
            if (nextDDash == nextSpace + 1) {
                nextSpace = -1;
            }
            if (nextSpace == -1 && nextDDash == -1) {
                temp = sentence.substring(pos);
                alive = false;
            } else if (nextSpace != -1 && nextSpace < nextDDash || nextDDash == -1) {
                temp = sentence.substring(pos, nextSpace) + ' ';
                pos = nextSpace + 1;
            } else {
                temp = sentence.substring(pos, nextDDash) + "--";
                pos = nextDDash + 2;
            }
            if (temp == null || temp.trim().equals("")) continue;
            tokens.add(temp);
        }
        String[] retcode = new String[tokens.size()];
        int i = 0;
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            retcode[i++] = (String)iter.next();
        }
        return retcode;
    }

    public static String[] stripPunctuation(String[] words) {
        String[] retcode = new String[words.length];
        for (int i = 0; i < words.length; ++i) {
            retcode[i] = SentenceUtil.stripPunctuationWord(words[i]);
        }
        return retcode;
    }

    public static String[] stripWords(String[] words) {
        if (words.length == 0) {
            return new String[0];
        }
        String[] retcode = new String[words.length + 1];
        int first = SentenceUtil.firstLetter(words[0]);
        retcode[0] = first == 0 ? "" : words[0].substring(0, first);
        for (int i = 1; i < words.length; ++i) {
            retcode[i] = SentenceUtil.stripWords(words[i - 1], words[i]);
        }
        int last = SentenceUtil.lastLetter(words[words.length - 1]);
        retcode[words.length] = last == words[words.length - 1].length() ? "" : words[words.length - 1].substring(last + 1);
        return retcode;
    }

    public static String[] getWords(String aSentence) {
        String sentence = aSentence;
        sentence = sentence.replaceAll("--", " ");
        sentence = sentence.replace('.', ' ');
        sentence = sentence.replace('!', ' ');
        sentence = sentence.replace('?', ' ');
        sentence = sentence.replace(':', ' ');
        sentence = sentence.replace(';', ' ');
        sentence = sentence.replace('\"', ' ');
        sentence = sentence.replace('\'', ' ');
        sentence = sentence.replace('(', ' ');
        sentence = sentence.replace(')', ' ');
        String[] words = StringUtil.split((String)sentence, (String)" ");
        String[] retcode = new String[words.length];
        for (int i = 0; i < words.length; ++i) {
            retcode[i] = SentenceUtil.stripPunctuationWord(words[i]).toLowerCase();
        }
        return retcode;
    }

    public static String stripPunctuationWord(String word) {
        int last;
        int first = SentenceUtil.firstLetter(word);
        if (first > (last = SentenceUtil.lastLetter(word) + 1)) {
            return word;
        }
        return word.substring(first, last);
    }

    public static String stripWords(String first, String last) {
        String init1 = first.substring(SentenceUtil.lastLetter(first) + 1);
        String init2 = last.substring(0, SentenceUtil.firstLetter(last));
        return init1 + init2;
    }

    public static int firstLetter(String word) {
        char c;
        int first;
        for (first = 0; first < word.length() && !Character.isLetterOrDigit(c = word.charAt(first)); ++first) {
        }
        return first;
    }

    public static int lastLetter(String word) {
        char c;
        int last;
        for (last = word.length() - 1; last >= 0 && !Character.isLetterOrDigit(c = word.charAt(last)); --last) {
        }
        return last;
    }
}

